<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Particles extends \Bricks\Element {
  public $category     = 'Next Bricks - Backgrounds';
  public $name         = 'next_particles';
  public $icon         = 'fa-brands fa-medium fa-rotate-90';
  public $tag      = 'div';
  public $scripts      = ['next_particles'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Particles', 'bricks' );
  }

  public function set_control_groups() {
    $this->control_groups['particlesGroup'] = [
        'title' => esc_html__( 'Particles', 'bricks' ),
        'tab'   => 'content',
    ];
    $this->control_groups['interactivityGroup'] = [
        'title' => esc_html__( 'Interactivity', 'bricks' ),
        'tab'   => 'content',
    ];
  }

  public function set_controls() {
    $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'div' => 'div',
            'section' => 'section',
            'article' => 'article',
            'aside' => 'aside',
            'header' => 'header',
            'footer' => 'footer',
            'main' => 'main',
            'nav' => 'nav',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'div',
        'default'     => 'div',
    ];
    $this->controls['customTag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Custom tag', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'placeholder' => 'div',
        'required'    => [ 'tag', '=', 'custom' ],
    ];
    $this->controls['note'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Particles is a nestable block element. You can put any elements at it and edit its display settings at the Style tab.', 'bricks' )))
    ];
    $this->controls['disablebuilder'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
        'type'     => 'checkbox',
        'default' => false,
    ];


    //wrapper style section
    $this->controls['wrapperStyleSeparator'] = [
        'label'      => esc_html__( 'Block Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['width'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type' => 'number',
        'units' => true,
        'css' => [
            [
                'property' => 'width',
                'selector' => '',
            ]
        ],
        'placeholder' => '100%',
        'rerender' => true,
        'default' => '100%',
    ];
    $this->controls['height'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type' => 'number',
        'units' => true,
        'css' => [
            [
                'property' => 'height',
                'selector' => '',
            ]
        ],
        'placeholder' => '500px',
        'rerender' => true,
        'default' => '500px',
    ];

    //number section
    $this->controls['number'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Number', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '80',
    ];
    $this->controls['numberEnableDensity'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Enable density', 'bricks' ),
        'type' => 'checkbox',
        'default' => true,
    ];
    $this->controls['numberDensityValueArea'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Density value area', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '800',
        'required' => [ 'numberEnableDensity', '=', true],
    ];

    //particle style section
    $this->controls['particleStyleSeparator'] = [
        'group' => 'particlesGroup',
        'label'      => esc_html__( 'Particle Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['styleColor'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Color', 'bricks' ),
        'type' => 'color',
        'css' => [
            [
                'property' => '--style-color',
                'selector' => '',
            ]
        ],
        'inline' => true,
        'clearable' => false,
        'default' => [
            'hex' => '#ffffff',
        ],
        'rerender' => true,
    ];
    $this->controls['shapeStrokeWidth'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Stroke width', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '0',
    ];
    $this->controls['shapeStrokeColor'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Stroke color', 'bricks' ),
        'type' => 'color',
        'css' => [
            [
                'property' => '--stroke-color',
                'selector' => '',
            ]
        ],
        'inline' => true,
        'clearable' => false,
        'default' => [
            'hex' => '#000000',
        ],
        'rerender' => true,
    ];

    //shape section
    $this->controls['shapeSeparator'] = [
        'group' => 'particlesGroup',
        'label'      => esc_html__( 'Shape', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['circleType'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Circles', 'bricks' ),
        'type' => 'checkbox',
        'default' => true,
    ];
    $this->controls['edgeType'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Edges', 'bricks' ),
        'type' => 'checkbox',
        'default' => false,
    ];
    $this->controls['triangleType'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Triangles', 'bricks' ),
        'type' => 'checkbox',
        'default' => false,
    ];
    $this->controls['starType'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Stars', 'bricks' ),
        'type' => 'checkbox',
        'default' => false,
    ];
    $this->controls['polygonType'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Polygons', 'bricks' ),
        'type' => 'checkbox',
        'default' => false,
    ];
    $this->controls['shapePolygonSides'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Polygons sides', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '5',
        'required' => [ 'polygonType', '=', true],
    ];
    $this->controls['imageType'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Image', 'bricks' ),
        'type' => 'checkbox',
        'default' => false,
    ];
    $this->controls['imageSource'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Source', 'bricks' ),
        'type' => 'image',
        'required' => [ 'imageType', '=', true],
    ];
    $this->controls['imageWidth'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Image Width', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '100',
        'required' => [ 'imageType', '=', true],
    ];
    $this->controls['imageHeight'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Image Height', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '100',
        'required' => [ 'imageType', '=', true],
    ];

    //opacity section
    $this->controls['opacitySeparator'] = [
        'group' => 'particlesGroup',
        'label'      => esc_html__( 'Opacity', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['opacityValue'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Value', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '0.5',
    ];
    $this->controls['opacityRandom'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Random', 'bricks' ),
        'type' => 'checkbox',
    ];
    $this->controls['opacityEnableRandom'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Enable animation', 'bricks' ),
        'type' => 'checkbox',
    ];
    $this->controls['opacitySpeed'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Speed', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '1',
        'required' => [ 'opacityEnableRandom', '=', true],
    ];
    $this->controls['opacityMinimumOpacity'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Minimum opacity', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '0.1',
        'required' => [ 'opacityEnableRandom', '=', true],
    ];
    $this->controls['opacitySync'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Sync', 'bricks' ),
        'type' => 'checkbox',
        'required' => [ 'opacityEnableRandom', '=', true],
    ];

    //size section
    $this->controls['sizeSeparator'] = [
        'group' => 'particlesGroup',
        'label'      => esc_html__( 'Size', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['sizeValue'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Size', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '3',
    ];
    $this->controls['sizeRandom'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Random', 'bricks' ),
        'type' => 'checkbox',
        'default' => true,
    ];
    $this->controls['sizeEnableRandom'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Enable animation', 'bricks' ),
        'type' => 'checkbox',
    ];
    $this->controls['sizeSpeed'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Speed', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '40',
        'required' => [ 'sizeEnableRandom', '=', true],
    ];
    $this->controls['sizeMinimumOpacity'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Minimum opacity', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '0.1',
        'required' => [ 'sizeEnableRandom', '=', true],
    ];
    $this->controls['sizeSync'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Sync', 'bricks' ),
        'type' => 'checkbox',
        'required' => [ 'sizeEnableRandom', '=', true],
    ];

    //line linked section
    $this->controls['lineLinkedSeparator'] = [
        'group' => 'particlesGroup',
        'label'      => esc_html__( 'Line linked', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['lineLinkedEnableAnimation'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Enable', 'bricks' ),
        'type' => 'checkbox',
        'default' => true,
    ];
    $this->controls['lineLinkedDistance'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Distance', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '150',
        'required' => [ 'lineLinkedEnableAnimation', '=', true],
    ];
    $this->controls['lineLinkedColor'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Color', 'bricks' ),
        'type' => 'color',
        'css' => [
            [
              'property' => '--line-linked-color',
              'selector' => '',
            ]
        ],
        'inline' => true,
        'clearable' => false,
        'default' => [
            'hex' => '#ffffff',
        ],
        'rerender' => true,
        'required' => [ 'lineLinkedEnableAnimation', '=', true],
    ];
    $this->controls['lineLinkedOpacity'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Opacity', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '0.4',
        'required' => [ 'lineLinkedEnableAnimation', '=', true],
    ];
    $this->controls['lineLinkedWidth'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '1',
        'required' => [ 'lineLinkedEnableAnimation', '=', true],
    ];

    //move section
    $this->controls['moveSeparator'] = [
        'group' => 'particlesGroup',
        'label'      => esc_html__( 'Move', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['moveEnable'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Enable', 'bricks' ),
        'type' => 'checkbox',
        'default' => true,
    ];
    $this->controls['moveSpeed'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Speed', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '6',
        'required' => [ 'moveEnable', '=', true],
    ];
    $this->controls['moveDirection'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Move direction', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'none' => 'none',
            'top' => 'top',
            'top-right' => 'top-right',
            'right' => 'right',
            'bottom-right' => 'bottom-right',
            'bottom' => 'bottom',
            'bottom-left' => 'bottom-left',
            'left' => 'left',
            'top-left' => 'top-left',
        ],
        'inline' => true,
        'placeholder' => 'none',
        'required' => [ 'moveEnable', '=', true],
    ];
    $this->controls['moveRandom'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Random', 'bricks' ),
        'type' => 'checkbox',
        'required' => [ 'moveEnable', '=', true],
    ];
    $this->controls['moveStraight'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Straight', 'bricks' ),
        'type' => 'checkbox',
        'required' => [ 'moveEnable', '=', true],
    ];
    $this->controls['moveOutMode'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Move out', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'out' => 'out',
            'bounce' => 'bounce',
        ],
        'inline' => true,
        'placeholder' => 'out',
        'required' => [ 'moveEnable', '=', true],
    ];
    $this->controls['moveBounce'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Bounce', 'bricks' ),
        'type' => 'checkbox',
        'required' => [ 'moveEnable', '=', true],
    ];
    $this->controls['moveEnableAttract'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Enable attract', 'bricks' ),
        'type' => 'checkbox',
        'required' => [ 'moveEnable', '=', true],
    ];
    $this->controls['moveRotateX'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Rotate X', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '600',
        'required'    => [ ['moveEnable', '=', true] , [ 'moveEnableAttract', '=', true ] ],
    ];
    $this->controls['moveRotateY'] = [
        'group' => 'particlesGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Rotate Y', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '1200',
        'required'    => [ ['moveEnable', '=', true] , [ 'moveEnableAttract', '=', true ] ],
    ];

    //interactivity section
    $this->controls['interactivityDetectOn'] = [
        'group' => 'interactivityGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Detect on', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'canvas' => 'canvas',
            'window' => 'window',
        ],
        'inline' => true,
        'placeholder' => 'canvas',
    ];
    $this->controls['interactivityResize'] = [
        'group' => 'interactivityGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Resize', 'bricks' ),
        'type' => 'checkbox',
        'default' => true,
    ];
    $this->controls['interactivityEnableHover'] = [
        'group' => 'interactivityGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Enable hover', 'bricks' ),
        'type' => 'checkbox',
        'default' => true,
    ];
    $this->controls['interactivityHoverMode'] = [
        'group' => 'interactivityGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Hover animation', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'repulse' => 'repulse',
            'grab' => 'grab',
            'bubble' => 'bubble',
        ],
        'inline' => true,
        'placeholder' => 'repulse',
        'required' => [ 'interactivityEnableHover', '=', true],
    ];
    $this->controls['interactivityEnableClick'] = [
        'group' => 'interactivityGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Enable click', 'bricks' ),
        'type' => 'checkbox',
        'default' => true,
    ];
    $this->controls['interactivityClickMode'] = [
        'group' => 'interactivityGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Click animation', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'push' => 'push',
            'remove' => 'remove',
            'bubble' => 'bubble',
            'repulse' => 'repulse',
        ],
        'inline' => true,
        'placeholder' => 'push',
        'required' => [ 'interactivityEnableClick', '=', true],
    ];
    $this->controls['noteAnimations'] = [
        'group' => 'interactivityGroup',
        'tab' => 'content',
        'description' => sprintf(html_entity_decode(esc_html__( 'Hover and click animations settings can be edited at the following sections:', 'bricks' )))
      ];

    //grab mode section
    $this->controls['grabModeSeparator'] = [
        'group' => 'interactivityGroup',
        'label'      => esc_html__( 'Grab animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['grabDistance'] = [
        'group' => 'interactivityGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Distance', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '400',
    ];
    $this->controls['grabLineLinked'] = [
        'group' => 'interactivityGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Line linked', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '1',
    ];

    //bubble mode section
    $this->controls['bubbleModeSeparator'] = [
        'group' => 'interactivityGroup',
        'label'      => esc_html__( 'Bubble animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['bubbleDistance'] = [
        'group' => 'interactivityGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Distance', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '400',
    ];
    $this->controls['bubbleSize'] = [
        'group' => 'interactivityGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Size', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '40',
    ];
    $this->controls['bubbleDuration'] = [
        'group' => 'interactivityGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '2',
    ];
    $this->controls['bubbleOpacity'] = [
        'group' => 'interactivityGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Opacity', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '8',
    ];
    $this->controls['bubbleSpeed'] = [
        'group' => 'interactivityGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Speed', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '3',
    ];

    //repulse mode section
    $this->controls['repulseModeSeparator'] = [
        'group' => 'interactivityGroup',
        'label'      => esc_html__( 'Repulse animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['repulseDistance'] = [
        'group' => 'interactivityGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Distance', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '200',
    ];
    $this->controls['repulseDuration'] = [
        'group' => 'interactivityGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '0.4',
    ];

    //push mode section
    $this->controls['pushModeSeparator'] = [
        'group' => 'interactivityGroup',
        'label'      => esc_html__( 'Push animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['pushNumber'] = [
        'group' => 'interactivityGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Number', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '4',
    ];

    //remove mode section
    $this->controls['removeModeSeparator'] = [
        'group' => 'interactivityGroup',
        'label'      => esc_html__( 'Remove animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['removeNumber'] = [
        'group' => 'interactivityGroup',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Number', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => '2',
    ];
  }

  public function enqueue_scripts() {
    wp_enqueue_script( 'next_particles', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_particles.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);

    wp_enqueue_script( 'next_particles_library', NEXTBRICKS_PLUGIN_URL . 'local_assets/next_particles_library.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;

    //number section
    $number = ! empty( $settings['number'] ) ? $settings['number'] : 80;
    $numberEnableDensity = ! empty( $settings['numberEnableDensity'] ) ? $settings['numberEnableDensity'] : false;
    $numberDensityValueArea = ! empty( $settings['numberDensityValueArea'] ) ? $settings['numberDensityValueArea'] : 800;

    //style section

    //shape section
    $circleType = ! empty( $settings['circleType'] ) ? $settings['circleType'] : false;
    $edgeType = ! empty( $settings['edgeType'] ) ? $settings['edgeType'] : false;
    $triangleType = ! empty( $settings['triangleType'] ) ? $settings['triangleType'] : false;
    $polygonType = ! empty( $settings['polygonType'] ) ? $settings['polygonType'] : false;
    $starType = ! empty( $settings['starType'] ) ? $settings['starType'] : false;

    /* Shape image type */
    $imageUrl = '';

    if(!isset($settings['imageType'])){

    }else if ( isset($settings['imageSource']['mediaData']['url'])) {
        $imageUrl .= $settings['imageSource']['mediaData']['url'];
    }else if ( isset($settings['imageSource']['url'])) {
        $imageUrl .= $settings['imageSource']['url'];
    }
    $imageWidth = ! empty( $settings['imageWidth'] ) ? $settings['imageWidth'] : 100;
    $imageHeight = ! empty( $settings['imageHeight'] ) ? $settings['imageHeight'] : 100;

    $shapeType = [];
    if ($circleType) {
        $shapeType[] = 'circle';
    }
    if ($edgeType) {
        $shapeType[] = 'edge';
    }
    if ($triangleType) {
        $shapeType[] = 'triangle';
    }
    if ($polygonType) {
        $shapeType[] = 'polygon';
    }
    if ($starType) {
        $shapeType[] = 'star';
    }
    if ($imageUrl != ''){
        $shapeType[] = 'image';
    }

    $shapeStrokeWidth = ! empty( $settings['shapeStrokeWidth'] ) ? $settings['shapeStrokeWidth'] : 0;
    $shapePolygonSides = ! empty( $settings['shapePolygonSides'] ) ? $settings['shapePolygonSides'] : 5;

    //opacity section
    $opacityValue = ! empty( $settings['opacityValue'] ) ? $settings['opacityValue'] : 0.5;
    $opacityRandom = ! empty( $settings['opacityRandom'] ) ? $settings['opacityRandom'] : false;
    $opacityEnableRandom = ! empty( $settings['opacityEnableRandom'] ) ? $settings['opacityEnableRandom'] : false;
    $opacitySpeed = ! empty( $settings['opacitySpeed'] ) ? $settings['opacitySpeed'] : 1;
    $opacityMinimumOpacity = ! empty( $settings['opacityMinimumOpacity'] ) ? $settings['opacityMinimumOpacity'] : 0.1;
    $opacitySync = ! empty( $settings['opacitySync'] ) ? $settings['opacitySync'] : false;

    //size section
    $sizeValue = ! empty( $settings['sizeValue'] ) ? $settings['sizeValue'] : 3;
    $sizeRandom = ! empty( $settings['sizeRandom'] ) ? $settings['sizeRandom'] : false;
    $sizeEnableRandom = ! empty( $settings['sizeEnableRandom'] ) ? $settings['sizeEnableRandom'] : false;
    $sizeSpeed = ! empty( $settings['sizeSpeed'] ) ? $settings['sizeSpeed'] : 40;
    $sizeMinimumOpacity = ! empty( $settings['sizeMinimumOpacity'] ) ? $settings['sizeMinimumOpacity'] : 0.1;
    $sizeSync = ! empty( $settings['sizeSync'] ) ? $settings['sizeSync'] : false;

    //line linked section
    $lineLinkedEnableAnimation = ! empty( $settings['lineLinkedEnableAnimation'] ) ? $settings['lineLinkedEnableAnimation'] : false;
    $lineLinkedDistance = ! empty( $settings['lineLinkedDistance'] ) ? $settings['lineLinkedDistance'] : 150;
    $lineLinkedOpacity = ! empty( $settings['lineLinkedOpacity'] ) ? $settings['lineLinkedOpacity'] : 0.4;
    $lineLinkedWidth = ! empty( $settings['lineLinkedWidth'] ) ? $settings['lineLinkedWidth'] : 1;

    //move section
    $moveEnable = ! empty( $settings['moveEnable'] ) ? $settings['moveEnable'] : false;
    $moveSpeed = ! empty( $settings['moveSpeed'] ) ? $settings['moveSpeed'] : 6;
    $moveDirection = ! empty( $settings['moveDirection'] ) ? $settings['moveDirection'] : 'none';
    $moveRandom = ! empty( $settings['moveRandom'] ) ? $settings['moveRandom'] : false;
    $moveStraight = ! empty( $settings['moveStraight'] ) ? $settings['moveStraight'] : false;
    $moveOutMode = ! empty( $settings['moveOutMode'] ) ? $settings['moveOutMode'] : 'out';
    $moveBounce = ! empty( $settings['moveBounce'] ) ? $settings['moveBounce'] : false;
    $moveEnableAttract = ! empty( $settings['moveEnableAttract'] ) ? $settings['moveEnableAttract'] : false;
    $moveRotateX = ! empty( $settings['moveRotateX'] ) ? $settings['moveRotateX'] : 600;
    $moveRotateY = ! empty( $settings['moveRotateY'] ) ? $settings['moveRotateY'] : 1200;

    //interactivity section
    $interactivityDetectOn = ! empty( $settings['interactivityDetectOn'] ) ? $settings['interactivityDetectOn'] : 'canvas';
    $interactivityResize = ! empty( $settings['interactivityResize'] ) ? $settings['interactivityResize'] : false;
    $interactivityEnableHover = ! empty( $settings['interactivityEnableHover'] ) ? $settings['interactivityEnableHover'] : false;
    $interactivityHoverMode = ! empty( $settings['interactivityHoverMode'] ) ? $settings['interactivityHoverMode'] : 'repulse';
    $interactivityEnableClick = ! empty( $settings['interactivityEnableClick'] ) ? $settings['interactivityEnableClick'] : false;
    $interactivityClickMode = ! empty( $settings['interactivityClickMode'] ) ? $settings['interactivityClickMode'] : 'push';

    //grab mode section
    $grabDistance = ! empty( $settings['grabDistance'] ) ? $settings['grabDistance'] : 400;
    $grabLineLinked = ! empty( $settings['grabLineLinked'] ) ? $settings['grabLineLinked'] : 1;

    //bubble mode section
    $bubbleDistance = ! empty( $settings['bubbleDistance'] ) ? $settings['bubbleDistance'] : 400;
    $bubbleSize = ! empty( $settings['bubbleSize'] ) ? $settings['bubbleSize'] : 40;
    $bubbleDuration = ! empty( $settings['bubbleDuration'] ) ? $settings['bubbleDuration'] : 2;
    $bubbleOpacity = ! empty( $settings['bubbleOpacity'] ) ? $settings['bubbleOpacity'] : 8;
    $bubbleSpeed = ! empty( $settings['bubbleSpeed'] ) ? $settings['bubbleSpeed'] : 3;

    //repulse mode section
    $repulseDistance = ! empty( $settings['repulseDistance'] ) ? $settings['repulseDistance'] : 200;
    $repulseDuration = ! empty( $settings['repulseDuration'] ) ? $settings['repulseDuration'] : 0.4;

    //push mode section
    $pushNumber = ! empty( $settings['pushNumber'] ) ? $settings['pushNumber'] : 4;

    //remove mode section
    $removeNumber = ! empty( $settings['removeNumber'] ) ? $settings['removeNumber'] : 2;

    //number section
    $this->set_attribute( '_root', 'class', "next-particles");
    $this->set_attribute( '_root', 'data-number', $number);
    $this->set_attribute( '_root', 'data-number-enable-density', $numberEnableDensity);
    $this->set_attribute( '_root', 'data-number-density-value-area', $numberDensityValueArea);

    //style section

    //shape section
    $this->set_attribute( '_root', 'data-shape-type', $shapeType);
    $this->set_attribute( '_root', 'data-shape-stroke-width', $shapeStrokeWidth);
    $this->set_attribute( '_root', 'data-shape-polygon-sides', $shapePolygonSides);
    $this->set_attribute( '_root', 'data-image-url', $imageUrl);
    $this->set_attribute( '_root', 'data-image-width', $imageWidth);
    $this->set_attribute( '_root', 'data-image-height', $imageHeight);

    //opacity section
    $this->set_attribute( '_root', 'data-opacity-value', $opacityValue);
    $this->set_attribute( '_root', 'data-opacity-random', $opacityRandom);
    $this->set_attribute( '_root', 'data-opacity-enable-random', $opacityEnableRandom);
    $this->set_attribute( '_root', 'data-opacity-speed', $opacitySpeed);
    $this->set_attribute( '_root', 'data-opacity-minimum-opacity', $opacityMinimumOpacity);
    $this->set_attribute( '_root', 'data-opacity-sync', $opacitySync);

    //size section
    $this->set_attribute( '_root', 'data-size-value', $sizeValue);
    $this->set_attribute( '_root', 'data-size-random', $sizeRandom);
    $this->set_attribute( '_root', 'data-size-enable-random', $sizeEnableRandom);
    $this->set_attribute( '_root', 'data-size-speed', $sizeSpeed);
    $this->set_attribute( '_root', 'data-size-minimum-opacity', $sizeMinimumOpacity);
    $this->set_attribute( '_root', 'data-size-sync', $sizeSync);

    //line linked section
    $this->set_attribute( '_root', 'data-line-linked-enable-animation', $lineLinkedEnableAnimation);
    $this->set_attribute( '_root', 'data-line-linked-distance', $lineLinkedDistance);
    $this->set_attribute( '_root', 'data-line-linked-opacity', $lineLinkedOpacity);
    $this->set_attribute( '_root', 'data-line-linked-width', $lineLinkedWidth);

    //move section
    $this->set_attribute( '_root', 'data-move-enable', $moveEnable);
    $this->set_attribute( '_root', 'data-move-speed', $moveSpeed);
    $this->set_attribute( '_root', 'data-move-direction', $moveDirection);
    $this->set_attribute( '_root', 'data-move-random', $moveRandom);
    $this->set_attribute( '_root', 'data-move-straight', $moveStraight);
    $this->set_attribute( '_root', 'data-move-out-mode', $moveOutMode);
    $this->set_attribute( '_root', 'data-move-bounce', $moveBounce);
    $this->set_attribute( '_root', 'data-move-enable-attract', $moveEnableAttract);
    $this->set_attribute( '_root', 'data-move-rotate-x', $moveRotateX);
    $this->set_attribute( '_root', 'data-move-rotate-y', $moveRotateY);

    //interactivity section
    $this->set_attribute( '_root', 'data-interactivity-detect-on', $interactivityDetectOn);
    $this->set_attribute( '_root', 'data-interactivity-resize', $interactivityResize);
    $this->set_attribute( '_root', 'data-interactivity-enableHover', $interactivityEnableHover);
    $this->set_attribute( '_root', 'data-interactivity-hoverMode', $interactivityHoverMode);
    $this->set_attribute( '_root', 'data-interactivity-enableClick', $interactivityEnableClick);
    $this->set_attribute( '_root', 'data-interactivity-clickMode', $interactivityClickMode);

    //grab mode section
    $this->set_attribute( '_root', 'data-grab-distance', $grabDistance);
    $this->set_attribute( '_root', 'data-grab-line-linked', $grabLineLinked);

    //bubble mode section
    $this->set_attribute( '_root', 'data-bubble-distance', $bubbleDistance);
    $this->set_attribute( '_root', 'data-bubble-size', $bubbleSize);
    $this->set_attribute( '_root', 'data-bubble-duration', $bubbleDuration);
    $this->set_attribute( '_root', 'data-bubble-opacity', $bubbleOpacity);
    $this->set_attribute( '_root', 'data-bubble-speed', $bubbleSpeed);

    //repulse mode section
    $this->set_attribute( '_root', 'data-repulse-distance', $repulseDistance);
    $this->set_attribute( '_root', 'data-repulse-duration', $repulseDuration);

    //push mode section
    $this->set_attribute( '_root', 'data-push-number', $pushNumber);

    //remove mode section
    $this->set_attribute( '_root', 'data-remove-number', $removeNumber);

    $this->set_attribute( '_root', 'data-disable-builder', $disablebuilder);

    $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
    $output .= Frontend::render_children( $this );
    $output .= "</{$this->tag}>";

	echo $output;
  }
}