<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Looping_Nav_Item extends \Bricks\Element {
    public $name         = 'next_looping_nav_item';
    public $icon         = 'ti-layout-tab';
    public $tag      = 'div';
    public $scripts      = ['next_looping_tabs'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Nav Item', 'bricks' );
    }

    public function set_controls(){
        $this->controls['gradient'] = [
            'tab' => 'content',
            'type' => 'gradient',
            'css' => [
              [
                'property' => 'background-image',
                'selector' => '.nb-looping-tabs__loop-progress',
              ],
            ],
            'default' => [
                "applyTo" => "background",
                "gradientType" => "linear",
                "colors" => [
                    ["id" => "yapkvw", "color" => ["hex" => "#ff0000"]],
                    ["id" => "seeqqu", "color" => ["hex" => "#ffa500"]]
                ],
                "angle" => "90"
            ],
        ];
    }

    public function render() {
        $settings = $this->settings;

        $this->set_attribute( '_root', 'class', "nb-looping-tabs__nav-item");
        $this->set_attribute( '_root', 'tabindex', '0');

        $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
        $output .= Frontend::render_children( $this );
        $output .= "
        <div class='nb-looping-tabs__loop'>
            <div class='nb-looping-tabs__loop-progress'></div>
            <div class='nb-looping-tabs__loop-mask'></div>
        </div>
        ";
        $output .= "</{$this->tag}>";

        echo $output;
    }
}