<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Interactive_Lines_v3 extends \Bricks\Element {
  public $category     = 'Next Bricks - Backgrounds';
  public $name         = 'next_interactive_lines_v3';
  public $icon         = 'fas fa-slash';
  public $tag      = 'div';
  public $scripts      = ['next_interactive_lines_v3'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Interactive Lines v3', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
        'div' => 'div',
        'section' => 'section',
        'article' => 'article',
        'aside' => 'aside',
        'header' => 'header',
        'footer' => 'footer',
        'main' => 'main',
        'nav' => 'nav',
        'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];

    /*css*/
    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Block Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['width'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'width',
            'selector' => '',
          ]
        ],
        'default' => '100%',
    ];
    $this->controls['height'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'height',
            'selector' => '',
          ]
        ],
        'default' => '500px',
    ];
    $this->controls['background'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Background', 'bricks' ),
        'type'  => 'color',
        'inline' => true,
        'css' => [
          [
            'property' => 'background',
            'selector' => '',
          ]
        ],
        'default' => [
            'hex' => '#e3e3e3',
        ],
    ];

    $this->controls['linesSeparator'] = [
        'label'      => esc_html__( 'Lines Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['strokeWidth'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'inline' => true,
        'css' => [
            [
              'property' => 'width',
              'selector' => '.nb-interactive-lines-v3__magnet span',
            ]
        ],
        'default' => '0.5vmin',
    ];
    $this->controls['strokeLength'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type'  => 'number',
        'inline' => true,
        'css' => [
            [
              'property' => 'height',
              'selector' => '.nb-interactive-lines-v3__magnet span',
            ]
        ],
        'default' => '4vmin',
    ];
    $this->controls['linesColor'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Color', 'bricks' ),
        'type'  => 'color',
        'inline' => true,
        'css' => [
          [
            'property' => 'background-color',
            'selector' => '.nb-interactive-lines-v3__magnet span',
          ]
        ],
        'default' => [
            'hex' => '#6366f1',
        ],
    ];

    /*js settings*/
    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Interactive Lines Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['disablebuilder'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Disable in the Builder', 'bricks' ),
        'type' => 'checkbox',
        'inline' => true,
        'default' => false,
    ];
    $this->controls['gridSeparator'] = [
        'label'      => esc_html__( 'Grid Settings', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['rows'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Rows', 'bricks' ),
        'type'  => 'number',
        'inline' => true,
        'default' => 12,
    ];
    $this->controls['columns'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Columns', 'bricks' ),
        'type'  => 'number',
        'inline' => true,
        'default' => 12,
    ];
  }

  public function get_nestable_children() {
    return [
        [
            'name'     => 'block',
            'label'    => esc_html__( 'Content', 'bricks' ),
            'settings' => [
                '_hidden'  => [
                    '_cssClasses' => 'nb-interactive-lines-v3__content',
                ],
            ],
            'children' => [
                [
                    'name'     => 'heading',
                    'label'    => esc_html__( 'Heading', 'bricks' ),
                    'settings' => [
                        'text' => esc_html__( 'Interactive Lines v3', 'bricks' ),
                        'tag'  => 'h3',
                    ],
                ]
            ]
        ],
    ];
}

  public function enqueue_scripts() {
    wp_enqueue_script( 'next_interactive_lines_v3', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_interactive_lines_v3.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;
    $rows = ! empty( $settings['rows'] ) ? $settings['rows'] : 12;
    $columns = ! empty( $settings['columns'] ) ? $settings['columns'] : 12;

    $this->set_attribute( '_root', 'class', "nb-interactive-lines-v3");

    $output = "<{$this->tag} {$this->render_attributes( '_root' )}
        data-disable-builder='{$disablebuilder}'
        data-rows='{$rows}'
        data-columns='{$columns}'
    >";
    $output .= '<div class="nb-interactive-lines-v3__magnet"></div>';
    $output .= Frontend::render_children( $this );
    $output .= "</{$this->tag}>";

	echo $output;
  }
}