<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Infinite_Slider extends \Bricks\Element {
    public $category     = 'Next Bricks - Sliders';
    public $name         = 'next_infinite_slider';
    public $icon         = 'ti-layout-list-large-image';
    public $scripts      = ['next_infinite_slider'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Infinite Slider', 'bricks' );
    }

    public function set_controls() {
        $this->controls['sliderSeparator'] = [
            'label'      => esc_html__( 'Slider Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['width'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'width',
                    'selector' => '',
                ]
            ],
            'default' => '100%',
        ];

        $this->controls['noteSlider'] = [
            'tab' => 'content',
            'description' => esc_html__( 'The slider will automatically adjust its height to the items height.', 'bricks' ),
        ];

        $this->controls['itemsSeparator'] = [
            'label'      => esc_html__( 'Items Style', 'bricks' ),
            'type'       => 'separator',
        ];

        $this->controls['noteItems'] = [
            'tab' => 'content',
            'description' => esc_html__( 'Slider items must have defined dimensions.', 'bricks' ),
        ];

        $this->controls['itemsWidth'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => '--items-width',
                    'selector' => '',
                ]
            ],
            'default' => '40vw',
        ];

        $this->controls['itemsHeight'] = [
            'tab' => 'content', 
            'label' => esc_html__( 'Height', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => '--items-height',
                    'selector' => '',
                ]
            ],
            'default' => '500px',
        ];

        $this->controls['gap'] = [
            'tab' => 'content',
            'label' => esc_html__( 'Viewport Gap (vw)', 'bricks' ),
            'type' => 'number',
            'unit' => 'vw',
            'css' => [
                [
                    'property' => '--gap',
                    'selector' => '',
                ]
            ],
            'default' => '5vw',
        ];
    }

    public function get_nestable_children() {
        return [
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Slider Item', 'bricks' ),
                'settings' => [
                    'text' => esc_html__( 'Bricks', 'bricks' ),
                    '_cssClasses' => 'nb-infinite-slider__item',
                ],
                'children' => [
                    [
                        'name'     => 'image',
                        'label'    => esc_html__( 'Image', 'bricks' ),
                        'settings' => [
                            'image'  => [
                                'url' => 'https://nextbricks.io/wp-content/uploads/2024/09/cursor_slide_1.webp',
                            ],
                        ],
                    ]
                ]
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Slider Item', 'bricks' ),
                'settings' => [
                    'text' => esc_html__( 'Bricks', 'bricks' ),
                    '_cssClasses' => 'nb-infinite-slider__item',
                ],
                'children' => [
                    [
                        'name'     => 'image',
                        'label'    => esc_html__( 'Image', 'bricks' ),
                        'settings' => [
                            'image'  => [
                                'url' => 'https://nextbricks.io/wp-content/uploads/2024/09/cursor_slide_2.webp',
                            ],
                        ],
                    ]
                ]
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Slider Item', 'bricks' ),
                'settings' => [
                    'text' => esc_html__( 'Bricks', 'bricks' ),
                    '_cssClasses' => 'nb-infinite-slider__item',
                ],
                'children' => [
                    [
                        'name'     => 'image',
                        'label'    => esc_html__( 'Image', 'bricks' ),
                        'settings' => [
                            'image'  => [
                                'url' => 'https://nextbricks.io/wp-content/uploads/2024/09/cursor_slide_3.webp',
                            ],
                        ],
                    ]
                ]
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Slider Item', 'bricks' ),
                'settings' => [
                    'text' => esc_html__( 'Bricks', 'bricks' ),
                    '_cssClasses' => 'nb-infinite-slider__item',
                ],
                'children' => [
                    [
                        'name'     => 'image',
                        'label'    => esc_html__( 'Image', 'bricks' ),
                        'settings' => [
                            'image'  => [
                                'url' => 'https://nextbricks.io/wp-content/uploads/2024/09/cursor_slide_4.webp',
                            ],
                        ],
                    ]
                ]
            ]
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'nb_infinite_slider', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_infinite_slider.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $is_builder = bricks_is_builder();

        $this->set_attribute( '_root', 'class', "nb-infinite-slider");

        if ( ! $is_builder ) {
            $this->set_attribute( '_root', 'data-flickering', "1");
        }

        $output = "<div {$this->render_attributes( '_root' )}>";
        $output .= '<div class="nb-infinite-slider__wrapper">';
        $output .= Frontend::render_children( $this );
        $output .= '</div>';
        $output .= '</div>';

        echo $output;
    }
}
