<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Horizontal_Scroll extends \Bricks\Element {
    public $category     = 'Next Bricks - Cores';
    public $name         = 'next_horizontal_scroll';
    public $icon         = 'ti-layout-media-right';
    public $scripts      = ['next_horizontal_scroll'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Horizontal Scroll', 'bricks' );
    }

    public function set_controls() {
        $this->controls['note0'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Horizontal Scroll is only scrollable at the front.', 'bricks' )))
        ];
        $this->controls['note1'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Horizontal Scroll is a nestable block element. You can put any elements at it and edit its display settings at the Style tab.', 'bricks' )))
        ];
        $this->controls['note2'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'You must generate a default horizontal scroll at the element, otherwise there wont be any content to scroll horizontally.', 'bricks' )))
        ];
        $this->controls['note3'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Animations from Next Bricks elements and Animator inside Horizontal Scroll will be triggered automatically when scrolling it.', 'bricks' )))
        ];

        /*Animation*/
        $this->controls['animationSeparator'] = [
            'label'      => esc_html__( 'Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['amountToScroll'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Amount to scroll', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'placeholder' => 'auto',
        ];

        /*ScrollTrigger*/
        $this->controls['scrollTriggerSeparator'] = [
            'label'      => esc_html__( 'ScrollTrigger', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['scrub'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Scrub', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'placeholder' => '0.1',
        ];
        $this->controls['start'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Start', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'placeholder' => 'center center',
        ];
        $this->controls['end'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'End', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'placeholder' => '+=1800',
        ];

        /*Breakpoint remove*/
        $this->controls['breakpointSeparator'] = [
            'label'      => esc_html__( 'Remove at breakpoint', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['note'] = [
            'description' => sprintf(html_entity_decode(esc_html__( 'Select a breakpoint to determine at which pixel Horizontal Scroll animation should be removed.', 'bricks' ))),
        ];

        $breakpoints        = Breakpoints::$breakpoints;
        $breakpoint_options = [];
        foreach ( $breakpoints as $index => $breakpoint ) {
            $breakpoint_options[ $breakpoint['key'] ] = $breakpoint['label'];
        }
        $this->controls['removeAtBreakpoint'] = [
            'type'        => 'select',
            'options'     => $breakpoint_options,
            'rerender'    => true,
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_horizontal_scroll', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_horizontal_scroll.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $direction = ! empty( $settings['direction'] ) ? $settings['direction'] : 'right';
        $amountToScroll = ! empty( $settings['amountToScroll'] ) ? $settings['amountToScroll'] : 'auto';
        $scrub = ! empty( $settings['scrub'] ) ? $settings['scrub'] : 0.1;
        $start = ! empty( $settings['start'] ) ? $settings['start'] : 'center center';
        $end = ! empty( $settings['end'] ) ? $settings['end'] : '+=1800';

        $removeAtBreakpoint = ! empty( $settings['removeAtBreakpoint'] ) ? $settings['removeAtBreakpoint'] : 'none';
        $breakpoint = Breakpoints::get_breakpoint_by( 'key', $removeAtBreakpoint );
        $breakpoint_width    = ! empty( $breakpoint['width'] ) ? intval( $breakpoint['width'] ) : 0;

        $this->set_attribute( '_root', 'class', "next-horizontal-scroll");
        $this->set_attribute( '_root', 'data-amount-to-scroll', $amountToScroll);
        $this->set_attribute( '_root', 'data-scrub', $scrub);
        $this->set_attribute( '_root', 'data-start', $start);
        $this->set_attribute( '_root', 'data-end', $end);
        $this->set_attribute( '_root', 'data-breakpoint', $breakpoint_width);

        $output = "<div {$this->render_attributes( '_root' )}>";
        $output .= Frontend::render_children( $this );
        $output .= "</div>";

        echo $output;
    }
}