<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Highlight_Mark extends \Bricks\Element {
  public $name         = 'next_highlight_mark';
  public $icon         = 'fas fa-text-height';
  public $scripts      = ['next_highlight'];

  public function get_label() {
    return esc_html__( 'Highlight Mark', 'bricks' );
  }

  public function set_controls() {
    $this->controls['inner_title'] = [
      'tab'            => 'content',
      'type'           => 'textarea',
	    'hasDynamicData' => 'text',
      'label' => esc_html__( 'Mark Title', 'bricks' ),
      'default'        => esc_html__( 'Next Bricks', 'bricks' ),
      'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['markTypography'] = [
      'tab' => 'content',
      'label' => esc_html__('Typography', 'bricks'),
      'type' => 'typography',
      'css' => [
        [
          'property' => 'typography',
          'selector' => '',
        ],
      ],
      'default' => [
        'color' => [
            'hex' => '#ffffff',
        ],
        'font-size' => '48px',
        'line-height' => '1.2',
      ],
    ];

    $this->controls['selectorsStyle'] = [
      'label'      => esc_html__( 'Selectors Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['selectorsWidth'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Initial Width', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline' => true,
      'css' => [
        [
          'property' => '--select-width',
          'selector' => '',
        ]
      ],
      'default' => '0%',
    ];
    $this->controls['selectorsWidthFinal'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Final Width', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline' => true,
      'css' => [
        [
          'property' => '--select-width-final',
          'selector' => '',
        ]
      ],
      'default' => '103.5%',
    ];
    $this->controls['selectorsHeight'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Height', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline' => true,
      'css' => [
        [
          'property' => 'height',
          'selector' => '.nb-highlight__selectors',
        ]
      ],
      'default' => '100%',
    ];
    $this->controls['selectorsLeft'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Left', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline' => true,
      'css' => [
        [
          'property' => 'left',
          'selector' => '.nb-highlight__selectors',
        ]
      ],
      'default' => '-1%',
    ];
    $this->controls['selectorsTop'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Top', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'inline' => true,
      'css' => [
        [
          'property' => 'top',
          'selector' => '.nb-highlight__selectors',
        ]
      ],
      'default' => '0',
    ];
    $this->controls['selectorsBackground'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Background', 'bricks' ),
      'type' => 'color',
      'inline' => true,
      'css' => [
        [
          'property' => 'background',
          'selector' => '.nb-highlight__selectors',
        ]
      ],
      'default' => [
        'hex' => '#186edf54',
      ],
    ];
    $this->controls['blendmode'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Mix blend mode', 'bricks' ),
      'type'        => 'select',
      'options'     => [
        'difference' => 'difference',
        'exclusion' => 'exclusion',
        'normal' => 'normal',
        'screen' => 'screen',
        'lighten' => 'lighten',
        'hard-light' => 'hard-light',
        'luminosity' => 'luminosity',
        'plus-lighter' => 'plus-lighter',
      ],
      'inline'      => true,
      'css'     => [
          [
            'property' => 'mix-blend-mode',
            'selector' => '.nb-highlight__selectors',
          ],
        ],
      'default' => 'plus-lighter',
  ];

  $this->controls['selectorsLine'] = [
    'label'      => esc_html__( 'Selectors Line', 'bricks' ),
    'type'       => 'separator',
  ];
    $this->controls['selectorsLineColor'] = [
      'tab' => 'content',
      'label' => esc_html__('Color', 'bricks'),
      'type' => 'color',
      'inline' => true,
      'css' => [
        [
          'property' => 'stroke',
          'selector' => '.nb-highlight__selector--left line, .nb-highlight__selector--right line',
        ],
      ],
      'default' => [
        'hex' => '#0386ff',
      ],
    ];
    $this->controls['selectorsLineWidth'] = [
      'tab' => 'content',
      'label' => esc_html__('Width', 'bricks'),
      'type' => 'number',
      'units' => true,
      'inline' => true,
      'css' => [
        [
          'property' => 'stroke-width',
          'selector' => '.nb-highlight__selector--left line, .nb-highlight__selector--right line',
        ],
      ],
      'default' => '2',
    ];

    $this->controls['selectorsCircle'] = [
      'label'      => esc_html__( 'Selectors Circle', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['selectorsCircleColor'] = [
      'tab' => 'content',
      'label' => esc_html__('Color', 'bricks'),
      'type' => 'color',
      'inline' => true,
      'css' => [
        [
          'property' => 'fill',
          'selector' => '.nb-highlight__selector--left circle, .nb-highlight__selector--right circle',
        ],
      ],
      'default' => [
        'hex' => '#0386ff',
      ],
    ];
    $this->controls['selectorsCircleScale'] = [
      'tab' => 'content',
      'label' => esc_html__('Scale', 'bricks'),
      'type' => 'number',
      'inline' => true,
      'css' => [
        [
          'property' => '--scale',
          'selector' => '.nb-highlight__selector--left circle, .nb-highlight__selector--right circle',
        ],
      ],
      'default' => '1.25',
    ];

    $this->controls['animation'] = [
      'label'      => esc_html__( 'Animation', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['disablebuilder'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
      'type'     => 'checkbox',
      'default' => false,
    ];
    $this->controls['duration'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Duration', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'default' => '0.8',
  ];
  $this->controls['delay'] = [
    'hasDynamicData' => false,
    'tab' => 'content',
    'label' => esc_html__( 'Delay', 'bricks' ),
    'type' => 'text',
    'inline' => true,
    'default' => '0.2',
];
  $this->controls['ease'] = [
    'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'GSAP Easing', 'bricks' ),
      'type' => 'select',
      'options'     => [
        'none' => 'none',
        'power1' => 'power1',
        'power2' => 'power2',
        'power3' => 'power3',
        'power4' => 'power4',
        'back' => 'back',
        'bounce' => 'bounce',
        'circ' => 'circ',
        'elastic' => 'elastic',
        'expo' => 'expo',
        'sine' => 'sine',
        'steps' => 'steps',
        'custom' => 'custom'
      ],
      'inline' => true,
      'default' => 'expo',
  ];
    $this->controls['customEase'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'ease', '=', 'custom' ],
    ];




  $this->controls['scrolltrigger'] = [
    'label'      => esc_html__( 'ScrollTrigger', 'bricks' ),
    'type'       => 'separator',
    'description' => sprintf(esc_html__( 'Scrolltrigger %s', 'bricks' ), '<a href="https://greensock.com/docs/v3/Plugins/ScrollTrigger" target="_blank">documentation</a>'),
  ];
  
    $this->controls['start'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Start', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'default' => 'top bottom',
    ];
    $this->controls['toggleActions'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'toggleActions', 'bricks' ),
      'type' => 'text',
      'default' => 'play none none none',
    ];
  }

  public function enqueue_scripts() {
    wp_enqueue_script( 'next_highlight', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_highlight.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $is_builder = bricks_is_builder();
    $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';
    $duration    = ! empty( $settings['duration'] ) ? $settings['duration'] : '0.8';
    $delay    = ! empty( $settings['delay'] ) ? $settings['delay'] : '0.2';
    $ease    = ! empty( $settings['ease'] ) ? $settings['ease'] : 'expo';
    if ($ease === 'custom') {
      $ease = ! empty( $settings['customEase'] ) ? $settings['customEase'] : 'expo';
    }
    $start    = ! empty( $settings['start'] ) ? $settings['start'] : 'top bottom';
    $toggleActions    = ! empty( $settings['toggleActions'] ) ? $settings['toggleActions'] : 'play none none none';

    $this->set_attribute( '_root', 'class', "nb-highlight__mark");

    if ( ! $is_builder ) {
      $this->set_attribute( '_root', 'data-flickering', '1');
    }
    $this->set_attribute( '_root', 'data-disable-builder', $disablebuilder);
    $this->set_attribute( '_root', 'data-duration', $duration);
    $this->set_attribute( '_root', 'data-delay', $delay);
    $this->set_attribute( '_root', 'data-ease', $ease);
    $this->set_attribute( '_root', 'data-start', $start);
    $this->set_attribute( '_root', 'data-toggleActions', $toggleActions);

    $output = "<mark {$this->render_attributes( '_root' )}>";
    $output .= "
                <span class='nb-highlight__selectors'>
                  <svg class='nb-highlight__selector--left' xmlns='http://www.w3.org/2000/svg' width='9' height='88' viewBox='0 0 9 88'>
                      <circle cx='4.5' cy='4.5' r='4.5'></circle> 
                      <line x1='4.5' y1='8' x2='4.5' y2='88'></line>
                  </svg>
                  <svg class='nb-highlight__selector--right' xmlns='http://www.w3.org/2000/svg' width='9' height='88' viewBox='0 0 9 88'>
                      <circle cx='4.5' cy='4.5' r='4.5'></circle>
                      <line x1='4.5' y1='8' x2='4.5' y2='88'></line>
                  </svg>
                </span>
                $inner_title
    ";
    $output .= "</mark>";

	echo $output;
  }
}
