<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Gooey_Nav extends \Bricks\Element {
    public $category     = 'Next Bricks - Menus';
    public $name         = 'next-gooey-nav';
    public $icon         = 'ti-menu-alt';
    public $tag      = 'nav';
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Gooey Nav', 'bricks' );
    }

    public function set_controls() {
        $this->controls['tag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'HTML tag', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'div' => 'div',
                'section' => 'section',
                'nav' => 'nav',
                'aside' => 'aside',
                'header' => 'header',
                'footer' => 'footer',
                'custom' => 'custom',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'nav',
            'default'     => 'nav',
        ];
        $this->controls['customTag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Custom tag', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'placeholder' => 'nav',
            'required'    => [ 'tag', '=', 'custom' ],
        ];
        $this->controls['_padding'] = [
            'tab'   => 'style',
            'group' => '_layout',
            'label' => esc_html__( 'Padding', 'bricks' ),
            'type'  => 'spacing',
            'css'   => [
                [
                    'property' => 'padding',
                    'selector' => '',
                ]
            ],
            'default' => [
                'top' => 20,
                'right' => 20,
                'bottom' => 20,
                'left' => 20,
            ]
        ];
        /* Nav Style */
        $this->controls['navStyleSeparator'] = [
            'label'      => esc_html__( 'Nav Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['navDirection'] = [
            'label'       => esc_html__( 'Direction', 'bricks' ),
            'type'        => 'select',
            'inline'      => true,
            'options'     => [
                'row' => 'row',
                'column' => 'column',
            ],
            'default' => 'row',
            'rerender' => true,
        ];

        $this->controls['enableMobileDirection'] = [
            'label' => esc_html__( 'Enable Mobile Direction', 'bricks' ),
            'type' => 'checkbox',
            'inline' => true,
            'small' => true,
            'default' => false,
        ];
        $this->controls['note'] = [
            'description' => sprintf(html_entity_decode(esc_html__( 'Select a breakpoint to determine at which pixel to switch direction.', 'bricks' ))),
            'required' => [ 'enableMobileDirection', '=', true],
        ];
        //Breakpoints control
		$breakpoints        = Breakpoints::$breakpoints;
		$breakpoint_options = [];

		foreach ( $breakpoints as $index => $breakpoint ) {
			$breakpoint_options[ $breakpoint['key'] ] = $breakpoint['label'];
		}
		$this->controls['mobileDirection'] = [
			'type'        => 'select',
			'options'     => $breakpoint_options,
			'rerender'    => true,
            'required' => [ 'enableMobileDirection', '=', true],
		];

        $this->controls['gap'] = [
            'label'       => esc_html__( 'Gap', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'css'     => [
                [
                    'property' => 'gap',
                    'selector' => '',
                ],
            ],
            'default' => 12,
        ];

        /* Nav Items Style */
        $this->controls['navItemsStyleSeparator'] = [
            'label'      => esc_html__( 'Nav Items Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['navItemsPadding'] = [
            'label'       => esc_html__( 'Padding', 'bricks' ),
            'type'        => 'spacing',
            'css'     => [
                [
                    'property' => 'padding',
                    'selector' => '.nb-gooey-nav__item',
                ],
            ],
            'default' => [
                'top' => 10,
                'right' => 20,
                'bottom' => 10,
                'left' => 20,
            ] 
        ];
        $this->controls['navItemsBackground'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Background', 'bricks' ),
            'type'    => 'color',
            'css'     => [
                [
                    'property' => 'background',
                    'selector' => '.nb-gooey-nav__item',
                ],
            ],
            'default' => [
                'hex' => '#333333',
            ],
        ];
        $this->controls['navItemsBorder'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Border', 'bricks' ),
            'type'    => 'border',
            'units'   => true,
            'css'     => [
                [
                    'property' => 'border',
                    'selector' => '.nb-gooey-nav__item',
                ],
            ],
            'default' => [
                'radius' => [
                  'top' => 12,
                  'right' => 12,
                  'bottom' => 12,
                  'left' => 12,
                ],
            ],
        ];
        $this->controls['navItemsTypography'] = [
            'label'      => esc_html__( 'Typography', 'bricks' ),
            'type'       => 'typography',
            'css'     => [
                [
                    'property' => 'typography',
                    'selector' => '.nb-gooey-nav__item',
                ],
            ],
            'default' => [
                'font-size' => '16px',
                'font-weight' => '500',
                'color' => [
                    'hex' => '#fff',
                ],
            ],
        ];

        /* Gooey Animation */
        $this->controls['gooeyAnimationSeparator'] = [
            'label'      => esc_html__( 'Gooey Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['gooeyMergeDistance'] = [
            'label'       => esc_html__( 'Merge Distance', 'bricks' ),
            'type'        => 'number',
            'inline'      => true,
            'units'       => true,
            'css' => [
                [
                    'property' => '--gooey-merge-distance',
                    'selector' => '',
                ],
            ],
            'default' => 20,
        ];
        $this->controls['gooeyDuration'] = [
            'label'       => esc_html__( 'Duration', 'bricks' ),
            'type'        => 'number',
            'unit'      => 's',
            'inline'      => true,
            'css' => [
                [
                    'property' => '--gooey-duration',
                    'selector' => '',
                ],
            ],
            'default' => '0.5s',
        ];
        $this->controls['gooeyEase'] = [
            'label'       => esc_html__( 'Ease', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'css' => [
                [
                    'property' => '--gooey-ease',
                    'selector' => '',
                ],
            ],
            'default' => 'ease',
        ];
    }

    public function get_nestable_children() {
        return [
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Gooey Item', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'nb-gooey-nav__item',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                        'label'    => esc_html__( 'Heading', 'bricks' ),
                        'settings' => [
                            'text' => esc_html__( 'Home', 'bricks' ),
                            'tag'  => 'span',
                        ],
                    ],
                ],
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Gooey Item', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'nb-gooey-nav__item',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                        'label'    => esc_html__( 'Heading', 'bricks' ),
                        'settings' => [
                            'text' => esc_html__( 'Portfolio', 'bricks' ),
                            'tag'  => 'span',
                        ],
                    ],
                ],
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Gooey Item', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'nb-gooey-nav__item',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                        'label'    => esc_html__( 'Heading', 'bricks' ),
                        'settings' => [
                            'text' => esc_html__( 'Insights', 'bricks' ),
                            'tag'  => 'span',
                        ],
                    ],
                ],
            ],
        ];
    }

    public function render() {
        $settings = $this->settings;
        $direction = $settings['navDirection'] ? $settings['navDirection'] : 'row';

        $this->set_attribute( '_root', 'class', 'nb-gooey-nav' );
        if($direction === 'column') {
            $this->set_attribute( '_root', 'class', 'nb-gooey-nav--vertical' );
        } else {
            $this->set_attribute( '_root', 'class', 'nb-gooey-nav--horizontal' );
        }

        $enablemobiledirection = ! empty( $settings['enableMobileDirection'] ) ? $settings['enableMobileDirection'] : false;
        $switch_direction_at = ! empty( $settings['mobileDirection'] ) ? $settings['mobileDirection'] : 'mobile_landscape';
        $breakpoint = Breakpoints::get_breakpoint_by( 'key', $switch_direction_at );
        $breakpoint_width    = ! empty( $breakpoint['width'] ) ? intval( $breakpoint['width'] ) : 0;

        $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
        $output .= '<svg xmlns="http://www.w3.org/2000/svg" version="1.1">
                        <defs>
                        <filter id="nb-gooey-nav__filter">
                            <feGaussianBlur in="SourceGraphic" stdDeviation="5" result="blur" />
                            <feColorMatrix in="blur" mode="matrix" values="1 0 0 0 0  0 1 0 0 0  0 0 1 0 0  0 0 0 19 -9" result="goo" />
                            <feComposite in="SourceGraphic" in2="goo" operator="atop" />
                        </filter>
                        </defs>
                    </svg>';
        $output .= Frontend::render_children( $this );
        $output .= "</{$this->tag}>";

        if($enablemobiledirection){
            $direction_inline_css = '';
            $direction_inline_css .= "@media (max-width: {$breakpoint_width}px) {";
            $direction_inline_css .= ".nb-gooey-nav--horizontal { flex-direction: column;}";
            $direction_inline_css .= ".nb-gooey-nav--horizontal .nb-gooey-nav__item:hover { margin-top: calc(-1 * var(--gooey-merge-distance)); margin-bottom: calc(-1 * var(--gooey-merge-distance));}";
            $direction_inline_css .= ".nb-gooey-nav--vertical { flex-direction: row;}";
            $direction_inline_css .= ".nb-gooey-nav--vertical .nb-gooey-nav__item:hover { margin-left: calc(-1 * var(--gooey-merge-distance)); margin-right: calc(-1 * var(--gooey-merge-distance));}";
            $direction_inline_css .= '}';
        
            $output .= "<style>$direction_inline_css</style>";
        }

        echo $output;
    }
}