<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Flipflop_Button_v3 extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'next-flipflop-button-v3';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';

  public function get_label() {
    return esc_html__( 'FlipFlop Button v3', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
  $this->controls['flip_text'] = [
    'tab'            => 'content',
    'type'           => 'text',
    'hasDynamicData' => 'text',
    'label'       => esc_html__( 'Flip Text', 'bricks' ),
    'default'        => esc_html__( 'Flip', 'bricks' ),
    'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
];
$this->controls['flop_text'] = [
    'tab'            => 'content',
    'type'           => 'text',
    'hasDynamicData' => 'text',
    'label'       => esc_html__( 'Flop Text', 'bricks' ),
    'default'        => esc_html__( 'Flop', 'bricks' ),
    'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['padding'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => 'padding',
                'selector' => '&{pseudo} .nb-flipflop-button-v3__text',
            ],
        ],
        'default' => [
            'top'    => 10,
            'right'  => 15, 
            'bottom' => 10,
            'left'   => 15,
        ],
    ];
    $this->controls['flipTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Flip Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '',
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'color' => [
                'hex' => '#000000',
              ]
        ],
    ];
    $this->controls['flopTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Flop Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '&::after',
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'color' => [
                'hex' => '#ffffff',
              ]
        ],
    ];
    $this->controls['flipBackground'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Flip Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&{pseudo} .nb-flipflop-button-v3__background',
            ],
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
    ];
    $this->controls['flopBackground'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Flop Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&::after',
            ],
        ],
        'default' => [
            'hex' => '#000000',
        ],
    ];
    $this->controls['flipBorder'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Flip Border', 'bricks'),
        'type'    => 'border',
        'css'     => [
          [
            'property' => 'border',
            'selector' => '&{pseudo} .nb-flipflop-button-v3__background',
          ],
        ],
        'default' => [
            'radius' => [
                'top' => 10,
                'right' => 10,
                'bottom' => 10,
                'left' => 10,
            ],
        ]
    ];
    $this->controls['flopBorder'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Flop Border', 'bricks'),
        'type'    => 'border',
        'css'     => [
          [
            'property' => 'border',
            'selector' => '&::after',
          ],
        ],
        'default' => [
            'radius' => [
                'top' => 10,
                'right' => 10,
                'bottom' => 10,
                'left' => 10,
            ],
        ]
    ];

    $this->controls['flipflopAnimationSeparator'] = [
        'label'      => esc_html__( 'Flipflop Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['perspective'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Perspective', 'bricks' ),
        'type'    => 'number',
        'units'    => true,
        'css'     => [
            [
                'property' => '--perspective',
                'selector' => '',
            ],
        ],
        'default' => '560px',
    ];
    $this->controls['rotation'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Rotation', 'bricks' ),
        'type'    => 'number',
        'unit'    => 'deg',
        'css'     => [
            [
                'property' => '--rotation',
                'selector' => '',
            ],
        ],
        'default' => '35deg',
    ];
    $this->controls['flipflopDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Duration', 'bricks' ),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
            [
                'property' => '--flipflop-duration',
                'selector' => '',
            ],
        ],
        'default' => '0.75s',
    ];
  }

  public function render() {
    $settings = $this->settings;
    $flip_text = ! empty( $settings['flip_text'] ) ? $settings['flip_text'] : 'Flip';
    $flop_text = ! empty( $settings['flop_text'] ) ? $settings['flop_text'] : 'Flop';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $this->set_attribute( '_root', 'class', 'nb-flipflop-button-v3' );
    $this->set_attribute( '_root', 'data-text', $flop_text );

    $output = "
    <$root_tag  {$this->render_attributes( '_root' )}>
        <span class='nb-flipflop-button-v3__container'>
            <span class='nb-flipflop-button-v3__text'>$flip_text</span>
            <span class='nb-flipflop-button-v3__background'></span>
        </span>
    </$root_tag>
    ";

	echo $output;
  }
}