<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Expanding_Nav extends \Bricks\Element {
    public $category     = 'Next Bricks - Menus';
    public $name         = 'next_expanding_nav';
    public $icon         = 'ti-menu-alt';
    public $tag          = 'nav';
    public $scripts      = [ 'next_expanding_nav' ];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Expanding Nav', 'bricks' );
    }

    public function set_controls() {
        $this->controls['tag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'HTML tag', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'nav'    => 'nav',
                'div'    => 'div',
                'section'=> 'section',
                'header' => 'header',
                'custom' => 'custom',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'nav',
            'default'     => 'nav',
        ];
        $this->controls['customTag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Custom tag', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'placeholder' => 'nav',
            'required'    => [ 'tag', '=', 'custom' ],
        ];
        $this->controls['openInBuilder'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Open in Bricks', 'bricks' ),
            'type'    => 'checkbox',
            'default' => false,
        ];
        $this->controls['note'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Each element can be customized at its own Style tab or use the following controls.', 'bricks' )))
        ];

        $this->controls['navSeparator'] = [
            'label' => esc_html__( 'Nav', 'bricks' ),
            'type'  => 'separator',
        ];
        $this->controls['navPadding'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Padding', 'bricks' ),
            'type'  => 'spacing',
            'default' => [
                'top' => 12,
                'right' => 12,
                'bottom' => 12,
                'left' => 12,
            ],
            'css'   => [
                [
                    'property' => 'padding',
                    'selector' => '',
                ],
            ],
        ];
        $this->controls['navGap'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Gap', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'default' => '12px',
            'css'   => [
                [
                    'property' => 'gap',
                    'selector' => '',
                ],
            ],
        ];
        $this->controls['navBackground'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type'  => 'background',
            'css'   => [
                [
                    'property' => 'background',
                    'selector' => '.nb-expanding-nav__expanding-content',
                ],
            ],
            'default' => [
                'color' => [
                    'hex' => '#000',
                ],
            ],
        ];
        $this->controls['navBorder'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type'  => 'border',
            'css'   => [
                [
                    'property' => 'border',
                    'selector' => '.nb-expanding-nav__expanding-content',
                ],
            ],
            'default' => [  
                'radius' => [
                    'top' => 12,
                    'right' => 12,
                    'bottom' => 12,
                    'left' => 12,
                ],
            ],
        ];
        $this->controls['navBoxShadow'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Box Shadow', 'bricks' ),
            'type'  => 'box-shadow',
            'css'   => [
                [
                    'property' => 'box-shadow',
                    'selector' => '.nb-expanding-nav__expanding-content',
                ],
            ],
        ];

        $this->controls['navItemsSeparator'] = [
            'label' => esc_html__( 'Nav Items', 'bricks' ),
            'type'  => 'separator',
        ];
        $this->controls['navItemPadding'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Padding', 'bricks' ),
            'type'  => 'spacing',
            'css'   => [
                [
                    'property' => 'padding',
                    'selector' => '.nb-expanding-nav__nav-item',
                ],
            ],
            'default' => [
                'top' => 8,
                'right' => 12,
                'bottom' => 8,
                'left' => 12,
            ],
        ];
        $this->controls['navItemBorder'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type'  => 'border',
            'css'   => [
                [
                    'property' => 'border',
                    'selector' => '.nb-expanding-nav__nav-item',
                ],
            ],
            'default' => [
                'radius' => [
                    'top' => 8,
                    'right' => 8,
                    'bottom' => 8,
                    'left' => 8,
                ],
            ],
        ];
        $this->controls['navItemBoxShadow'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Box Shadow', 'bricks' ),
            'type'  => 'box-shadow',
            'css'   => [
                [
                    'property' => 'box-shadow',
                    'selector' => '.nb-expanding-nav__nav-item',
                ],
            ],
        ];
        $this->controls['navItemTypography'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Typography', 'bricks' ),
            'type'  => 'typography',
            'css'   => [
                [
                    'property' => 'typography',
                    'selector' => '.nb-expanding-nav__nav-item',
                ],
            ],
            'default' => [
                'font-size' => '16px',
                'font-weight' => '500',
                'color' => [
                    'hex' => '#fff',
                ],
            ],
        ];
        $this->controls['navItemActiveColor'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Active Color', 'bricks' ),
            'type'  => 'color',
            'css'   => [
                [
                    'property' => 'color',
                    'selector' => '.nb-expanding-nav__nav-item[data-active="true"]',
                ],
            ],
            'default' => [
                'hex' => '#000000',
            ],
        ];
        $this->controls['navItemActiveBackground'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Active Background', 'bricks' ),
            'type'  => 'background',
            'css'   => [
                [
                    'property' => 'background',
                    'selector' => '.nb-expanding-nav__nav-item[data-active="true"]',
                ],
            ],
            'default' => [
                'color' => [
                    'hex' => '#fff',
                ],
            ],
        ];
        $this->controls['navItemTransitionDuration'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Active Duration', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'css'   => [
                [
                    'property' => '--nav-item-transition-duration',
                    'selector' => '',
                ],
            ],
            'default' => '0.3s',
        ];
        $this->controls['navItemTransitionEasing'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Active CSS Easing', 'bricks' ),
            'type'  => 'text',
            'css'   => [
                [
                    'property' => '--nav-item-transition-easing',
                    'selector' => '',
                ],
            ],
            'default' => 'ease',
        ];

        $this->controls['expandingItemSeparator'] = [
            'label' => esc_html__( 'Expanding Items', 'bricks' ),
            'type'  => 'separator',
        ];
        $this->controls['expandingItemPadding'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Padding', 'bricks' ),
            'type'  => 'spacing',
            'css'   => [
                [
                    'property' => 'padding',
                    'selector' => '.nb-expanding-nav__expanding-content-item',
                ],
            ],
        ];

        $this->controls['navAnimationSeparator'] = [
            'label' => esc_html__( 'Nav Animation', 'bricks' ),
            'type'  => 'separator',
        ];
        $this->controls['expandingFrom'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Expanding From', 'bricks' ),
            'type'  => 'select',
            'options' => [
                'top'    => esc_html__( 'Top', 'bricks' ),
                'bottom' => esc_html__( 'Bottom', 'bricks' ),
            ],
            'inline'      => true,
            'default'     => 'top',
        ];
        $this->controls['expandingHorizontalExpand'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Horizontal Offset', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'css'   => [
                [
                    'property' => '--expanding-horizontal-expand',
                    'selector' => '',
                ],
            ],
            'default' => '0px',
            'clearable' => false,
        ];
        $this->controls['expandingDuration'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Expanding Duration', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'css'   => [
                [
                    'property' => '--expanding-duration',
                    'selector' => '',
                ],
            ],
            'default' => '0.6s',
        ];
        $this->controls['expandingEasing'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Expanding CSS Easing', 'bricks' ),
            'type'  => 'text',
            'css'   => [
                [
                    'property' => '--expanding-easing',
                    'selector' => '',
                ],
            ],
            'default' => 'cubic-bezier(0.34, 1.56, 0.64, 1)',
        ];
        $this->controls['expandingFadeDuration'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Fade Duration', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'css'   => [
                [
                    'property' => '--expanding-fade-duration',
                    'selector' => '',
                ],
            ],
            'default' => '0.3s',
        ];
        $this->controls['expandingFadeEasing'] = [
            'tab'   => 'content',
            'label' => esc_html__( 'Fade CSS Easing', 'bricks' ),
            'type'  => 'text',
            'css'   => [
                [
                    'property' => '--expanding-fade-easing',
                    'selector' => '',
                ],
            ],
            'default' => 'ease',
        ];
    }

    public function get_nestable_children() {
        return [
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Nav Item', 'bricks' ),
                'settings' => [
                    '_cssClasses' => 'nb-expanding-nav__nav-item',
                    '_attributes' => [
                        [
                            'name'  => 'tabindex',
                            'value' => '0',
                        ],
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                        'label'    => esc_html__( 'Heading', 'bricks' ),
                        'settings' => [
                            'text' => esc_html__( 'Home', 'bricks' ),
                            'tag'  => 'span',
                        ],
                    ],
                ],
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Nav Item', 'bricks' ),
                'settings' => [
                    '_cssClasses' => 'nb-expanding-nav__nav-item',
                    '_attributes' => [
                        [
                            'name'  => 'tabindex',
                            'value' => '0',
                        ],
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                        'label'    => esc_html__( 'Heading', 'bricks' ),
                        'settings' => [
                            'text' => esc_html__( 'About', 'bricks' ),
                            'tag'  => 'span',
                        ],
                    ],
                ],
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Nav Item', 'bricks' ),
                'settings' => [
                    '_cssClasses' => 'nb-expanding-nav__nav-item',
                    '_attributes' => [
                        [
                            'name'  => 'tabindex',
                            'value' => '0',
                        ],
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                        'label'    => esc_html__( 'Heading', 'bricks' ),
                        'settings' => [
                            'text' => esc_html__( 'Contact', 'bricks' ),
                            'tag'  => 'span',
                        ],
                    ],
                ],
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Nav Item', 'bricks' ),
                'settings' => [
                    '_cssClasses' => 'nb-expanding-nav__nav-item',
                    '_attributes' => [
                        [
                            'name'  => 'tabindex',
                            'value' => '0',
                        ],
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                        'label'    => esc_html__( 'Heading', 'bricks' ),
                        'settings' => [
                            'text' => esc_html__( 'Services', 'bricks' ),
                            'tag'  => 'span',
                        ],
                    ],
                ],
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Expanding Content', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'nb-expanding-nav__expanding-content',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Expanding Item', 'bricks' ),
                        'settings' => [
                            '_cssClasses' => 'nb-expanding-nav__expanding-content-item',
                        ],
                        'children' => [
                            [
                                'name'     => 'heading',
                                'label'    => esc_html__( 'Heading', 'bricks' ),
                                'settings' => [
                                    'text' => esc_html__( 'Home', 'bricks' ),
                                    'tag'  => 'span',
                                    '_typography' => [
                                        'color' => [
                                            'hex' => '#ffffff',
                                        ],
                                    ],
                                ],
                            ],
                        ],
                    ],
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Expanding Item', 'bricks' ),
                        'settings' => [
                            '_cssClasses' => 'nb-expanding-nav__expanding-content-item',
                        ],
                        'children' => [
                            [
                                'name'     => 'heading',
                                'label'    => esc_html__( 'Heading', 'bricks' ),
                                'settings' => [
                                    'text' => esc_html__( 'About', 'bricks' ),
                                    'tag'  => 'span',
                                    '_typography' => [
                                        'color' => [
                                            'hex' => '#ffffff',
                                        ],
                                    ],
                                ],
                            ],
                        ],
                    ],
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Expanding Item', 'bricks' ),
                        'settings' => [
                            '_cssClasses' => 'nb-expanding-nav__expanding-content-item',
                        ],
                        'children' => [
                            [
                                'name'     => 'heading',
                                'label'    => esc_html__( 'Heading', 'bricks' ),
                                'settings' => [
                                    'text' => esc_html__( 'Contact', 'bricks' ),
                                    'tag'  => 'span',
                                    '_typography' => [
                                        'color' => [
                                            'hex' => '#ffffff',
                                        ],
                                    ],
                                ],
                            ],
                        ],
                    ],
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Expanding Item', 'bricks' ),
                        'settings' => [
                            '_cssClasses' => 'nb-expanding-nav__expanding-content-item',
                        ],
                        'children' => [
                            [
                                'name'     => 'heading',
                                'label'    => esc_html__( 'Heading', 'bricks' ),
                                'settings' => [
                                    'text' => esc_html__( 'Services', 'bricks' ),
                                    'tag'  => 'span',
                                    '_typography' => [
                                        'color' => [
                                            'hex' => '#ffffff',
                                        ],
                                    ],
                                ],
                            ],
                        ],
                    ],
                ],
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_expanding_nav', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_expanding_nav.min.js', array( 'bricks-scripts' ), NEXTBRICKS_VERSION, false );
    }

    public function render() {
        $settings   = $this->settings;
        $expandingFrom = ! empty( $settings['expandingFrom'] ) ? $settings['expandingFrom'] : 'bottom';
        $openInBuilder = ! empty( $settings['openInBuilder'] ) ? $settings['openInBuilder'] : false;

        if ( ! bricks_is_builder() ) {
            $this->set_attribute( '_root', 'data-flickering', 'true' );
        }
        $this->set_attribute( '_root', 'data-open-in-builder', $openInBuilder );

        $this->set_attribute( '_root', 'class', 'nb-expanding-nav' );
        $this->set_attribute( '_root', 'data-from', $expandingFrom );

        $output  = "<{$this->tag} {$this->render_attributes( '_root' )}>";
        $output .= Frontend::render_children( $this );
        $output .= "</{$this->tag}>";

        echo $output;
    }
}
