<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Dropdown_Wrapper extends \Bricks\Element {
    public $category     = 'Next Bricks - Menus';
    public $name         = 'nextdropdownwrapper';
    public $icon         = 'ion-ios-arrow-dropdown-circle';
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Dropdown', 'bricks' );
    }

    public function set_controls() {
        $this->controls['noteToggle'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( "If Dropdown element and Arrow Icon are inside Dropdown then
            the Dropdown will be taken as the Toggle selector at both of them.", 'bricks' )))
        ];
        /*Flex style*/
        $this->controls['flexSeparator'] = [
            'label'      => esc_html__( 'Toggle flex style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['flexdirection'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Direction', 'bricks' ),
            'type'    => 'direction',
            'css'     => [
                [
                'property' => 'flex-direction',
                'selector' => '.next-dropdown-toggle',
                ],
            ],
        ];
        $this->controls['flexjustify'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Justify content', 'bricks' ),
            'type'    => 'justify-content',
            'css'     => [
                [
                'property' => 'justify-content',
                'selector' => '.next-dropdown-toggle',
                ],
            ],
        ];
        $this->controls['flexalign'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Align items', 'bricks' ),
            'type'    => 'align-items',
            'css'     => [
                [
                'property' => 'align-items',
                'selector' => '.next-dropdown-toggle',
                ],
            ],
        ];
        $this->controls['flexgap'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Gap', 'bricks' ),
            'type'    => 'number',
            'units'    => true,
            'css'     => [
            [
                'property' => 'gap',
                'selector' => '.next-dropdown-toggle',
            ],
            ],
            'placeholder' => '10px',
        ];
    }
    
    /*Render children*/
    public function get_nestable_children() {
        return [
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Toggle', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-dropdown-toggle',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                        'label'    => esc_html__( 'Heading', 'bricks' ),
                        'settings' => [
                            'text' => esc_html__( 'Great Toggle', 'bricks' ),
                            'tag'  => 'span',
                        ],
                    ],
                    [
                        'name'     => 'nextarrowicon',
                    ],
                ],
            ],
            [
                'name'     => 'nextdropdown',
                'children' => [
                    [
                        'name'     => 'heading',
                    ],
                    [
                        'name'     => 'heading',
                    ],
                    [
                        'name'     => 'heading',
                    ],
                ],
            ],
        ];
    }

  public function render() {
    $settings = $this->settings;

    $this->set_attribute( '_root', 'class', 'next-dropdown-wrapper' );

    $output = "<div {$this->render_attributes( '_root' )}>";
    $output .= Frontend::render_children( $this );
    $output .= '</div>';

    echo $output;
  }
}