<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Dropdown_megaMenu extends \Bricks\Element {
    public $category     = 'Next Bricks - Menus';
    public $name         = 'nextdropdownmegamenu';
    public $icon         = 'ti-menu-alt';
    public $tag      = 'div';
    public $scripts      = ['next_dropdown_mega_menu'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Dropdown megaMenu', 'bricks' );
    }

    public function set_controls() {
        $this->controls['tag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'HTML tag', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'div' => 'div',
                'section' => 'section',
                'nav' => 'nav',
                'aside' => 'aside',
                'header' => 'header',
                'footer' => 'footer',
                'custom' => 'custom',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'div',
            'default'     => 'div',
        ];
        $this->controls['customTag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Custom tag', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'placeholder' => 'div',
            'required'    => [ 'tag', '=', 'custom' ],
        ];
        /*Flex style*/
        $this->controls['flexSeparator'] = [
            'label'      => esc_html__( 'Flex Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['flexdirection'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Direction', 'bricks' ),
            'type'    => 'direction',
            'css'     => [
                [
                'property' => 'flex-direction',
                'selector' => '',
                ],
            ],
            'default' => 'row',
        ];
        $this->controls['flexjustify'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Justify content', 'bricks' ),
            'type'    => 'justify-content',
            'css'     => [
                [
                'property' => 'justify-content',
                'selector' => '',
                ],
            ],
            'default' => 'center',
        ];
        $this->controls['flexalign'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Align items', 'bricks' ),
            'type'    => 'align-items',
            'css'     => [
                [
                'property' => 'align-items',
                'selector' => '',
                ],
            ],
            'default' => 'center',
        ];
        $this->controls['flexgap'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Gap', 'bricks' ),
            'type'    => 'number',
            'units'    => true,
            'css'     => [
            [
                'property' => 'gap',
                'selector' => '',
            ],
            ],
            'default' => '10px',
        ];

        //Responsive
        $this->controls['responsiveSeparator'] = [
            'label'      => esc_html__( 'Responsive', 'bricks' ),
            'type'       => 'separator',
        ];

        $this->controls['enablemobilemenu'] = [
            'label' => esc_html__( 'Enable Mobile Menu', 'bricks' ),
            'type' => 'checkbox',
            'inline' => true,
            'small' => true,
            'default' => false,
        ];

        $this->controls['note'] = [
            'description' => sprintf(html_entity_decode(esc_html__( 'Select a breakpoint to determine at which pixel to display Mobile Wrapper and hide Dropdowns Wrapper.', 'bricks' ))),
            'required' => [ 'enablemobilemenu', '=', true],
        ];

        //Breakpoints control
        $breakpoints        = Breakpoints::$breakpoints;
        $breakpoint_options = [];

        foreach ( $breakpoints as $index => $breakpoint ) {
            $breakpoint_options[ $breakpoint['key'] ] = $breakpoint['label'];
        }

        $this->controls['mobileMenu'] = [
            'type'        => 'select',
            'options'     => $breakpoint_options,
            'rerender'    => true,
            'placeholder' => esc_html__( 'Mobile landscape', 'bricks' ),
            'required' => [ 'enablemobilemenu', '=', true],
        ];

        $this->controls['displaybuilderresponsive'] = [
            'label' => esc_html__( 'Display Dropdowns Wrapper at the builder', 'bricks' ),
            'type' => 'checkbox',
            'inline' => true,
            'small' => true,
            'required' => [ 'enablemobilemenu', '=', true],
        ];

        /*Responsive style separator*/
        $this->controls['responsiveStyleSeparator'] = [
            'label'      => esc_html__( 'Responsive Dropdowns Wrapper style', 'bricks' ),
            'type'       => 'separator',
            'required' => [ 'enablemobilemenu', '=', true],
        ];
        $this->controls['noteResponsive'] = [
            'description' => sprintf(html_entity_decode(esc_html__( 'The following styles are applied to Dropdowns Wrapper at the breakpoint selected. Any breakpoint style can also be set directly at Dropdowns Wrapper element.', 'bricks' ))),
            'required' => [ 'enablemobilemenu', '=', true],
        ];
        $this->controls['positioningResponsive'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Position', 'bricks' ),
            'type'        => 'select',
            'options'     => [
              'absolute' => 'absolute',
              'relative' => 'relative',
              'sticky' => 'sticky',
              'fixed' => 'fixed',
            ],
            'css'     => [
              [
                  'property' => 'position',
                  'selector' => '&[data-toggled-enable-mobile-menu] .next-dropdown-mega-menu__dropdowns-wrapper',
              ],
            ],
            'inline'      => true,
            'placeholder' => 'absolute',
            'required' => [ 'enablemobilemenu', '=', true],
        ];
        $this->controls['topPosition'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Top', 'bricks' ),
            'type'        => 'number',
            'units'      => true,
            'css'     => [
              [
                  'property' => 'top',
                  'selector' => '&[data-toggled-enable-mobile-menu] .next-dropdown-mega-menu__dropdowns-wrapper',
              ],
            ],
            'inline'      => true,
            'required' => [ 'enablemobilemenu', '=', true],
        ];
        $this->controls['zIndex'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'zIndex', 'bricks' ),
            'type'        => 'text',
            'css'     => [
              [
                  'property' => 'z-index',
                  'selector' => '&[data-toggled-enable-mobile-menu] .next-dropdown-mega-menu__dropdowns-wrapper',
              ],
            ],
            'inline'      => true,
            'placeholder' => '99',
            'required' => [ 'enablemobilemenu', '=', true],
        ];

        /*Fade animation separator*/
        $this->controls['fadeAnimationSeparator'] = [
            'label'      => esc_html__( 'Responsive Dropdowns Wrapper Fade Animation', 'bricks' ),
            'type'       => 'separator',
            'required' => [ 'enablemobilemenu', '=', true],
        ];
        $this->controls['fadeDuration'] = [
            'hasDynamicData' => false,
            'inline'      => true,
            'tab' => 'content',
            'label' => esc_html__( 'Duration', 'bricks' ),
            'type'  => 'number',
            'unit' => 's',
            'css'     => [
                [
                    'property' => '--opacity-duration',
                    'selector' => '.next-dropdown-mega-menu__dropdowns-wrapper',
                ],
            ],
            'placeholder' => '0.2s',
            'required' => [ 'enablemobilemenu', '=', true],
        ];
        $this->controls['fadeDelay'] = [
            'hasDynamicData' => false,
            'inline'      => true,
            'tab' => 'content',
            'label' => esc_html__( 'Delay', 'bricks' ),
            'type'  => 'number',
            'unit' => 's',
            'css'     => [
                [
                    'property' => '--opacity-delay',
                    'selector' => '.next-dropdown-mega-menu__dropdowns-wrapper',
                ],
            ],
            'placeholder' => '0s',
            'required' => [ 'enablemobilemenu', '=', true],
        ];
        $this->controls['fadeEasing'] = [
            'hasDynamicData' => false,
            'inline'      => true,
            'tab' => 'content',
            'label' => esc_html__( 'CSS Easing', 'bricks' ),
            'type'  => 'text',
            'css'     => [
                [
                    'property' => '--opacity-easing',
                    'selector' => '.next-dropdown-mega-menu__dropdowns-wrapper',
                ],
            ],
            'placeholder' => 'ease',
            'required' => [ 'enablemobilemenu', '=', true],
        ];
        /*Transform animation separator*/
        $this->controls['transformAnimationSeparator'] = [
            'label'      => esc_html__( 'Responsive Dropdowns Wrapper Transform Animation', 'bricks' ),
            'type'       => 'separator',
            'required' => [ 'enablemobilemenu', '=', true],
        ];
        $this->controls['scale'] = [
            'hasDynamicData' => false,
            'inline'      => true,
            'tab' => 'content',
            'label' => esc_html__( 'Scale', 'bricks' ),
            'type'  => 'text',
            'css'     => [
              [
                  'property' => '--scale',
                  'selector' => '.next-dropdown-mega-menu__dropdowns-wrapper',
              ],
            ],
            'placeholder' => '0.7',
            'required' => [ 'enablemobilemenu', '=', true],
        ];
        $this->controls['x'] = [
            'hasDynamicData' => false,
            'inline'      => true,
            'tab' => 'content',
            'label' => esc_html__( 'Transform X', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'css'     => [
                [
                    'property' => '--x',
                    'selector' => '.next-dropdown-mega-menu__dropdowns-wrapper',
                ],
            ],
            'placeholder' => '0px',
            'required' => [ 'enablemobilemenu', '=', true],
        ];
        $this->controls['y'] = [
            'hasDynamicData' => false,
            'inline'      => true,
            'tab' => 'content',
            'label' => esc_html__( 'Transform Y', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'css'     => [
                [
                    'property' => '--y',
                    'selector' => '.next-dropdown-mega-menu__dropdowns-wrapper',
                ],
            ],
            'placeholder' => '-30px',
            'required' => [ 'enablemobilemenu', '=', true],
        ];
        $this->controls['transformDuration'] = [
            'hasDynamicData' => false,
            'inline'      => true,
            'tab' => 'content',
            'label' => esc_html__( 'Duration', 'bricks' ),
            'type'  => 'number',
            'unit' => 's',
            'css'     => [
                [
                    'property' => '--transform-duration',
                    'selector' => '.next-dropdown-mega-menu__dropdowns-wrapper',
                ],
            ],
            'placeholder' => '0.2s',
            'required' => [ 'enablemobilemenu', '=', true],
        ];
        $this->controls['transformDelay'] = [
            'hasDynamicData' => false,
            'inline'      => true,
            'tab' => 'content',
            'label' => esc_html__( 'Delay', 'bricks' ),
            'type'  => 'number',
            'unit' => 's',
            'css'     => [
                [
                    'property' => '--transform-delay',
                    'selector' => '.next-dropdown-mega-menu__dropdowns-wrapper',
                ],
            ],
            'placeholder' => '0s',
            'required' => [ 'enablemobilemenu', '=', true],
        ];
        $this->controls['transformEasing'] = [
            'hasDynamicData' => false,
            'inline'      => true,
            'tab' => 'content',
            'label' => esc_html__( 'CSS Easing', 'bricks' ),
            'type'  => 'text',
            'css'     => [
                [
                    'property' => '--transform-easing',
                    'selector' => '.next-dropdown-mega-menu__dropdowns-wrapper',
                ],
            ],
            'placeholder' => 'ease',
            'required' => [ 'enablemobilemenu', '=', true],
        ];
    }
    
    /*Render children*/
    public function get_nestable_children() {
        return [
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Mobile Wrapper', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-dropdown-mega-menu__mobile-wrapper',
                    ],
                ],
                'children' => [
                    /*Dropdown*/
                    [
                        'name'     => 'coreburguer',
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'next-dropdown-mega-menu__coreburguer',
                            ],
                        ],
                    ],
                ],
            ],

            [
                'name'     => 'block',
                'label'    => esc_html__( 'Dropdowns Wrapper', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-dropdown-mega-menu__dropdowns-wrapper',
                    ],
                ],
                'children' => [
                    /*Dropdown*/
                    [
                        'name'     => 'nextdropdownwrapper',
                        'children' => [
                            [
                                'name'     => 'block',
                                'label'    => esc_html__( 'Toggle', 'bricks' ),
                                'settings' => [
                                    '_hidden'  => [
                                        '_cssClasses' => 'next-dropdown-toggle',
                                    ],
                                ],
                                'children' => [
                                    [
                                        'name'     => 'heading',
                                        'label'    => esc_html__( 'Heading', 'bricks' ),
                                        'settings' => [
                                            'text' => esc_html__( 'Great Toggle', 'bricks' ),
                                            'tag'  => 'span',
                                        ],
                                    ],
                                    [
                                        'name'     => 'nextarrowicon',
                                    ],
                                ],
                            ],
                            [
                                'name'     => 'nextdropdown',
                                'children' => [
                                    [
                                        'name'     => 'heading',
                                    ],
                                    [
                                        'name'     => 'heading',
                                    ],
                                    [
                                        'name'     => 'heading',
                                    ],
                                ],
                            ],
                        ],
                    ],
                    /*Dropdown*/
                    [
                        'name'     => 'nextdropdownwrapper',
                        'children' => [
                            [
                                'name'     => 'block',
                                'label'    => esc_html__( 'Toggle', 'bricks' ),
                                'settings' => [
                                    '_hidden'  => [
                                        '_cssClasses' => 'next-dropdown-toggle',
                                    ],
                                ],
                                'children' => [
                                    [
                                        'name'     => 'heading',
                                        'label'    => esc_html__( 'Heading', 'bricks' ),
                                        'settings' => [
                                            'text' => esc_html__( 'Great Toggle', 'bricks' ),
                                            'tag'  => 'span',
                                        ],
                                    ],
                                    [
                                        'name'     => 'nextarrowicon',
                                    ],
                                ],
                            ],
                            [
                                'name'     => 'nextdropdown',
                                'children' => [
                                    [
                                        'name'     => 'heading',
                                    ],
                                    [
                                        'name'     => 'heading',
                                    ],
                                    [
                                        'name'     => 'heading',
                                    ],
                                ],
                            ],
                        ],
                    ],
                    /*Dropdown*/
                    [
                        'name'     => 'nextdropdownwrapper',
                        'children' => [
                            [
                                'name'     => 'block',
                                'label'    => esc_html__( 'Toggle', 'bricks' ),
                                'settings' => [
                                    '_hidden'  => [
                                        '_cssClasses' => 'next-dropdown-toggle',
                                    ],
                                ],
                                'children' => [
                                    [
                                        'name'     => 'heading',
                                        'label'    => esc_html__( 'Heading', 'bricks' ),
                                        'settings' => [
                                            'text' => esc_html__( 'Great Toggle', 'bricks' ),
                                            'tag'  => 'span',
                                        ],
                                    ],
                                    [
                                        'name'     => 'nextarrowicon',
                                    ],
                                ],
                            ],
                            [
                                'name'     => 'nextdropdown',
                                'children' => [
                                    [
                                        'name'     => 'heading',
                                    ],
                                    [
                                        'name'     => 'heading',
                                    ],
                                    [
                                        'name'     => 'heading',
                                    ],
                                ],
                            ],
                        ],
                    ],
                ],
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next-dropdown-megamenu', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_dropdown_mega_menu.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        //Responsive
        $enablemobilemenu = ! empty( $settings['enablemobilemenu'] ) ? $settings['enablemobilemenu'] : false;
        $displaybuilderresponsive = ! empty( $settings['displaybuilderresponsive'] ) ? $settings['displaybuilderresponsive'] : false;
        $show_nav_button_at = ! empty( $settings['mobileMenu'] ) ? $settings['mobileMenu'] : 'mobile_landscape';
        $breakpoint = Breakpoints::get_breakpoint_by( 'key', $show_nav_button_at );
        $breakpoint_width    = ! empty( $breakpoint['width'] ) ? intval( $breakpoint['width'] ) : 0;
        $positioningResponsive = ! empty( $settings['positioningResponsive'] ) ? $settings['positioningResponsive'] : 'absolute';
        $topPosition = ! empty( $settings['topPosition'] ) ? $settings['topPosition'] : 'unset';
        $zIndex = ! empty( $settings['zIndex'] ) ? $settings['zIndex'] : '99';

        $this->set_attribute( '_root', 'class', 'next-dropdown-mega-menu' );
        //Responsive
        $this->set_attribute( '_root', 'data-enablemobilemenu', $enablemobilemenu );
        $this->set_attribute( '_root', 'data-displaybuilderresponsive', $displaybuilderresponsive );
        $this->set_attribute( '_root', 'data-breakpoint', $breakpoint_width );

        $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
        $output .= Frontend::render_children( $this );
        $output .= "</{$this->tag}>";

        $nav_menu_inline_css = '';
        if($enablemobilemenu){
            $nav_menu_inline_css .= "@media (max-width: {$breakpoint_width}px) {";
            $nav_menu_inline_css .= "
                .next-dropdown-mega-menu__mobile-wrapper{
                    display: flex;
                }
                .next-dropdown-mega-menu__dropdowns-wrapper{
                    position: $positioningResponsive;
                    top: $topPosition;
                    z-index: $zIndex;

                    pointer-events: none;
                    opacity: 0;

                    --scale: .7;
                    --x: 0px;
                    --y: -30px;
                    transform: scale(var(--scale)) translateX(var(--x)) translateY(var(--y));

                    --opacity-easing: ease;
                    --opacity-duration: .2s;
                    --opacity-delay: 0s;
                    --transform-easing: ease;
                    --transform-duration: .2s;
                    --transform-delay: 0s;
                
                    transition: 
                    opacity var(--opacity-duration) var(--opacity-easing) var(--opacity-delay),
                    transform var(--transform-duration) var(--transform-easing) var(--transform-delay);
                }
                .next-dropdown-mega-menu__dropdowns-wrapper[data-toggle]{
                    opacity: 1;
                    pointer-events: all;
                    transform: scale(1) translateX(0) translateY(0);
                }
            ";
            $nav_menu_inline_css .= '}';
        
            $output .= "<style>$nav_menu_inline_css</style>";
        }

        echo $output;
    }
}