<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Dot_Button extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'next-dot-button';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';

  public function get_label() {
    return esc_html__( 'Dot Button', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['inner_title'] = [
        'label'       => esc_html__( 'Title', 'bricks' ),
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Dot Button', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['swap_title'] = [
        'label'       => esc_html__( 'Swap Title', 'bricks' ),
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Dot Button', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['padding'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => 'padding',
                'selector' => '&{pseudo} .nb-dot-button__inner',
            ],
        ],
        'default' => [
            'top'    => 10,
            'right'  => 10, 
            'bottom' => 10,
            'left'   => 10,
        ],
    ];
    $this->controls['gap'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Gap', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'grid-gap',
                'selector' => '&{pseudo} .nb-dot-button__inner',
            ],
        ],
        'default' => 10,
    ];
    $this->controls['titleTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '',
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'font-weight' => '500',
            'color' => [
                'hex' => '#000000',
              ]
        ],
    ];
    $this->controls['swapTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Swap Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '&{pseudo} .nb-dot-button__inner::after',
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'font-weight' => '500',
            'color' => [
                'hex' => '#000000',
              ]
        ],
    ];
    $this->controls['background'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&{pseudo} .nb-dot-button__bg',
            ],
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
    ];
    $this->controls['border'] = [
        'tab'     => 'content',
        'label'   => esc_html__('Border', 'bricks'),
        'type'    => 'border',
        'css'     => [
          [
            'property' => 'border',
            'selector' => '&{pseudo} .nb-dot-button__bg',
          ],
        ],
        'default' => [
            'radius' => [
                'top' => 8,
                'right' => 8,
                'bottom' => 8,
                'left' => 8,
            ],
        ]
    ];

    $this->controls['dotsSeparator'] = [
        'label'      => esc_html__( 'Dots', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['dotSize'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Size', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => '--btn-color-tunes-dot-size',
                'selector' => '',
            ],
        ],
        'default' => 10,
    ];
    $this->controls['firstDotColor'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'First Dot Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background-color',
                'selector' => '&{pseudo} .nb-dot-button__dot',
            ],
        ],
        'default' => [
            'hex' => '#009dff',
        ],
    ];
    $this->controls['secondDotColor'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Second Dot Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background-color',
                'selector' => '&{pseudo} .nb-dot-button__dot--second',
            ],
        ],
        'default' => [
            'hex' => '#ff7300',
        ],
    ];
    $this->controls['thirdDotColor'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Third Dot Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background-color',
                'selector' => '&{pseudo} .nb-dot-button__dot--third',
            ],
        ],
        'default' => [
            'hex' => '#ff0000',
        ],
    ];

    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['dotOrigin'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Dot Origin', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'transform-origin',
                'selector' => '&{pseudo} .nb-dot-button__dot',
            ],
        ],
        'default' => '-.75em',
    ];
    $this->controls['dotDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Dot Duration', 'bricks' ),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
            [
                'property' => '--dot-duration',
                'selector' => '',
            ],
        ],
        'default' => '0.45s',
    ];
    $this->controls['textDuration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Text Duration', 'bricks' ),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
            [
                'property' => '--text-duration',
                'selector' => '',
            ],
        ],
        'default' => '0.45s',
    ];
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Dot Button';
    $swap_title     = ! empty( $settings['swap_title'] ) ? $settings['swap_title'] : 'Dot Button';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $this->set_attribute( '_root', 'class', 'nb-dot-button' );

    $output = "
    <$root_tag  {$this->render_attributes( '_root' )}>
        <span class='nb-dot-button__bg'></span>
        <span data-text='$swap_title' class='nb-dot-button__inner'>
            <span class='nb-dot-button__dot-wrap'>
                <span class='nb-dot-button__dot'></span>
                <span style='--index: 2;' class='nb-dot-button__dot nb-dot-button__dot--third'></span>
                <span style='--index: 1;' class='nb-dot-button__dot nb-dot-button__dot--second'></span>
                <span style='--index: 0;' class='nb-dot-button__dot nb-dot-button__dot--first'></span>
            </span>
            <span class='nb-dot-button__text'>$inner_title</span>
        </span>
    </$root_tag>
    ";

	echo $output;
  }
}