<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Distorsion_Tabs extends \Bricks\Element {
    public $category     = 'Next Bricks - Cores';
    public $name         = 'next_distorsion_tabs';
    public $icon         = 'ti-layout-tab';
    public $scripts      = ['next_distorsion_tabs'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Distorsion Tabs', 'bricks' );
    }

    public function set_controls() {
        $this->controls['activetab'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Active Tab', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'small'       => true,
            'default' => '1',
        ];
        $this->controls['event'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Event', 'bricks' ),
            'type' => 'select',
            'options' => [
                'hover' => esc_html__( 'Hover', 'bricks' ),
                'click' => esc_html__( 'Click', 'bricks' ),
            ],
            'inline' => true,
            'default' => 'hover',
        ];

        $this->controls['style'] = [
            'label' => esc_html__( 'Tabs element dimensions', 'bricks' ),
            'type' => 'separator',
        ];
        $this->controls['note'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Each Tab has an absolute position required for the distorsion animation to work properly. So you should give defined dimensions to Tabs.', 'bricks' )))
        ];
        $this->controls['width'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type' => 'number',
            'unit' => 'px',
            'inline' => true,
            'css' => [
                [
                    'property' => 'width',
                    'selector' => '.next-distorsion-tabs__tabs',
                ]
            ],
            'default' => '250px',
        ];

        $this->controls['height'] = [
            'hasDynamicData' => false,
            'tab' => 'content', 
            'label' => esc_html__( 'Height', 'bricks' ),
            'type' => 'number',
            'unit' => 'px',
            'inline' => true,
            'css' => [
                [
                    'property' => 'height',
                    'selector' => '.next-distorsion-tabs__tabs',
                ]
            ],
            'default' => '250px',
        ];

        $this->controls['animation'] = [
            'label' => esc_html__( 'Distorsion Animation', 'bricks' ),
            'type' => 'separator',
        ];
        $this->controls['duration'] = [
            'hasDynamicData' => false,
              'tab' => 'content',
              'label' => esc_html__( 'Duration', 'bricks' ),
              'type' => 'number',
              'unit' => 's',
              'inline' => true,
              'default' => '1.2s',
          ];
      
          $this->controls['ease'] = [
            'hasDynamicData' => false,
              'tab' => 'content',
              'label' => esc_html__( 'GSAP easing', 'bricks' ),
              'type' => 'select',
              'options'     => [
                'none' => 'none',
                'power1' => 'power1',
                'power2' => 'power2',
                'power3' => 'power3',
                'power4' => 'power4',
                'back' => 'back',
                'bounce' => 'bounce',
                'circ' => 'circ',
                'elastic' => 'elastic',
                'expo' => 'expo',
                'sine' => 'sine',
                'steps' => 'steps',
                'custom' => 'custom'
              ],
              'inline' => true,
              'default' => 'expo',
          ];
    $this->controls['customEase'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'ease', '=', 'custom' ],
    ];




          $this->controls['itemsFade'] = [
            'label' => esc_html__( 'Nav Items Fade Animation', 'bricks' ),
            'type' => 'separator',
        ];
        $this->controls['opacity'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Opacity', 'bricks' ),
            'type' => 'text',
            'small' => true,
            'css' => [
                [
                    'property' => 'opacity',
                    'selector' => '.next-distorsion-tabs__nav-item',
                ]
            ],
            'inline' => true,
            'default' => '0.3',
        ];

        $this->controls['opacity_duration'] = [
            'hasDynamicData' => false,
            'tab' => 'content', 
            'label' => esc_html__( 'Opacity Duration', 'bricks' ),
            'type' => 'number',
            'unit' => 's',
            'css' => [
                [
                    'property' => '--opacity-duration',
                    'selector' => '.next-distorsion-tabs__nav-item',
                ]
            ],
            'inline' => true,
            'default' => '0.3s',
        ];

        $this->controls['opacity_easing'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Opacity Easing', 'bricks' ),
            'type' => 'text',
            'css' => [
                [
                    'property' => '--opacity-easing',
                    'selector' => '.next-distorsion-tabs__nav-item',
                ]
            ],
            'inline' => true,
            'default' => 'ease',
        ];
    }

    public function get_nestable_children() {
        return [
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Nav', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-distorsion-tabs__nav',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Nav Item', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'next-distorsion-tabs__nav-item',
                            ],
                            '_attributes' => [
                                [
                                'name' => 'tabindex',
                                'value' => '0',
                                ],
                            ]
                        ],
                        'children' => [
                            [
                                'name'     => 'heading',
                                'label'    => esc_html__( 'Heading', 'bricks' ),
                                'settings' => [
                                    'text' => esc_html__( 'Fast', 'bricks' ),
                                ],
                            ],
                        ],
                    ],
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Nav Item', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'next-distorsion-tabs__nav-item',
                            ],
                            '_attributes' => [
                                [
                                'name' => 'tabindex',
                                'value' => '0',
                                ],
                            ]
                        ],
                        'children' => [
                            [
                                'name'     => 'heading',
                                'label'    => esc_html__( 'Heading', 'bricks' ),
                                'settings' => [
                                    'text' => esc_html__( 'Easy', 'bricks' ),
                                ],
                            ],
                        ],
                    ],
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Nav Item', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'next-distorsion-tabs__nav-item',
                            ],
                            '_attributes' => [
                                [
                                'name' => 'tabindex',
                                'value' => '0',
                                ],
                            ]
                        ],
                        'children' => [
                            [
                                'name'     => 'heading',
                                'label'    => esc_html__( 'Heading', 'bricks' ),
                                'settings' => [
                                    'text' => esc_html__( 'Nice', 'bricks' ),
                                ],
                            ],
                        ],
                    ],
                ]
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Tabs', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-distorsion-tabs__tabs',
                    ],
                    '_attributes' => [
                        [
                        'name' => 'style',
                        'value' => 'filter:url(#svg-distortion-filter)',
                        ],
                    ]
                ],
                'children' => [
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Tab', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'next-distorsion-tabs__tab',
                            ],
                        ],
                        'children' => [
                            [
                                'name'     => 'image',
                                'label'    => esc_html__( 'Image', 'bricks' ),
                                'settings' => [
                                    'image'  => [
                                        'url' => 'https://nextbricks.io/wp-content/uploads/2024/09/cursor_slide_1.webp',
                                    ],
                                ],
                            ],
                        ],
                    ],
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Tab', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'next-distorsion-tabs__tab',
                            ],
                        ],
                        'children' => [
                            [
                                'name'     => 'image',
                                'label'    => esc_html__( 'Image', 'bricks' ),
                                'settings' => [
                                    'image'  => [
                                        'url' => 'https://nextbricks.io/wp-content/uploads/2024/09/cursor_slide_2.webp',
                                    ],
                                ],
                            ],
                        ],
                    ],
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Tab', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'next-distorsion-tabs__tab',
                            ],
                        ],
                        'children' => [
                            [
                                'name'     => 'image',
                                'label'    => esc_html__( 'Image', 'bricks' ),
                                'settings' => [
                                    'image'  => [
                                        'url' => 'https://nextbricks.io/wp-content/uploads/2024/09/cursor_slide_3.webp',
                                    ],
                                ],
                            ],
                        ],
                    ],
                ]
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_distorsion_tabs', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_distorsion_tabs.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $activetab = ! empty( $settings['activetab'] ) ? $settings['activetab'] : 1;
        $event = ! empty( $settings['event'] ) ? $settings['event'] : 'hover';
        $duration = ! empty( $settings['duration'] ) ? $settings['duration'] : 1.2;
        $ease = ! empty( $settings['ease'] ) ? $settings['ease'] : 'expo';
        if ($ease === 'custom') {
      $ease = ! empty( $settings['customEase'] ) ? $settings['customEase'] : 'expo';
    }

        $this->set_attribute( '_root', 'class', "next-distorsion-tabs");
        $this->set_attribute( '_root', 'data-activetab', $activetab);
        $this->set_attribute( '_root', 'data-event', $event);
        $this->set_attribute( '_root', 'data-duration', $duration);
        $this->set_attribute( '_root', 'data-ease', $ease);

        $output = "<div {$this->render_attributes( '_root' )}>";
        $output .= "
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 463 463' style='position:absolute;top:-1px;left:-1px;height:0;width:0;'>
            <defs>
                <filter id='svg-distortion-filter'>
                    <feTurbulence type='fractalNoise' baseFrequency='0.01 0.003' stitchTiles='noStitch' numOctaves='1' seed='2' result='warp'/>
                    <feDisplacementMap xChannelSelector='R' yChannelSelector='G' scale='1' in='SourceGraphic' in2='warp'/>
                </filter>
            </defs>
        </svg>
        ";
        $output .= Frontend::render_children( $this );
        $output .= '</div>';

        echo $output;
    }
}