<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Cursor_Slide extends \Bricks\Element {
    public $category     = 'Next Bricks - Cursors';
    public $name         = 'next_cursor_slide';
    public $icon         = 'ion-ios-apps';
    public $scripts      = ['next_cursor_slide'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Cursor Slide', 'bricks' );
    }

    public function set_controls() {
        $this->controls['disablebuilder'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
            'type'     => 'checkbox',
            'default' => false,
        ];
        $this->controls['disableTouchDevices'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label'    => esc_html__( 'Disable at touch devices', 'bricks' ),
            'type'     => 'checkbox',
            'default' => false,
        ];
        $this->controls['note1'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'The number of elements with the target class should be equal to the number of Slide Items.', 'bricks' )))
        ];
        $this->controls['note2'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'The first element targeted will be linked with the first image, the second element targeted will be linked with the second image, and so on.', 'bricks' )))
        ];
        $this->controls['target'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Target', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'placeholder' => '.className',
        ];
        $this->controls['note3'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Slide Items can wrap any element and receive custom styles. Cursor width and height is shared by all Slide Items.', 'bricks' )))
        ];
        $this->controls['width'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Cursor width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => '--width',
                'selector' => '',
              ]
            ],
            'placeholder' => '300px',
            'default' => '300px',
        ];
        $this->controls['height'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Cursor height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => '--height',
                'selector' => '',
              ]
            ],
            'placeholder' => '300px',
            'default' => '300px',
        ];

        /*Slide*/
        $this->controls['slideSeparator'] = [
            'label'      => esc_html__( 'Slide Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['slideDuration'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Duration', 'bricks' ),
            'type'  => 'number',
            'unit' => 's',
            'inline' => true,
            'css' => [
              [
                'property' => '--slide-duration',
                'selector' => '',
              ]
            ],
            'placeholder' => '0.4s',
            'default' => '.4s',
        ];
        $this->controls['slideEasing'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'CSS easing', 'bricks' ),
            'type' => 'text',
            'css' => [
                [
                  'property' => '--slide-easing',
                  'selector' => '',
                ]
              ], 
            'placeholder' => 'cubic-bezier(.76,0,.24,1)',
            'default' => 'cubic-bezier(.76,0,.24,1)',
        ];

        /*Cursor*/
        $this->controls['cursorSeparator'] = [
            'label'      => esc_html__( 'Cursor Display', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['cursorDuration'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Duration', 'bricks' ),
            'type'  => 'number',
            'unit' => 's',
            'inline' => true,
            'css' => [
                [
                'property' => '--cursor-duration',
                'selector' => '',
                ]
            ],
            'placeholder' => '0.5s',
            'default' => '.5s',
        ];
        $this->controls['cursorEasing'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'CSS easing', 'bricks' ),
            'type' => 'text',
            'css' => [
                [
                    'property' => '--cursor-easing',
                    'selector' => '',
                ]
                ], 
            'placeholder' => 'cubic-bezier(.76,0,.24,1)',
            'default' => 'cubic-bezier(.76,0,.24,1)',
        ];

        /*Movement*/
        $this->controls['movementSeparator'] = [
            'label'      => esc_html__( 'Cursor Movement', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['movementDuration'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Duration', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'small' => true,
            'placeholder' => '0.8',
        ];
        $this->controls['movementEase'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'GSAP easing', 'bricks' ),
            'type' => 'select',
            'options'     => [
                'none' => 'none',
                'power1' => 'power1',
                'power2' => 'power2',
                'power3' => 'power3',
                'power4' => 'power4',
                'back' => 'back',
                'bounce' => 'bounce',
                'circ' => 'circ',
                'elastic' => 'elastic',
                'expo' => 'expo',
                'sine' => 'sine',
                'steps' => 'steps',
                'custom' => 'custom'
            ],
            'inline' => true,
            'placeholder' => 'power3',
        ];
        $this->controls['customMovementEase'] = [
          'hasDynamicData' => false,
          'tab' => 'content',
          'label' => esc_html__( 'Custom easing', 'bricks' ),
          'type' => 'text',
          'inline' => true,
          'placeholder' => 'back.out(1.7)',
          'default' => 'back.out(1.7)',
          'required' => [ 'movementEase', '=', 'custom' ],
        ];
      
    }

    public function get_nestable_children() {
        return [
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Slide Item', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-cursor-slide__item',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'image',
                        'label'    => esc_html__( 'Image', 'bricks' ),
                        'settings' => [
                            'image'  => [
                                'url' => 'https://nextbricks.io/wp-content/uploads/2024/09/cursor_slide_1.webp',
                            ],
                        ],
                    ]
                ]
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Slide Item', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-cursor-slide__item',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'image',
                        'label'    => esc_html__( 'Image', 'bricks' ),
                        'settings' => [
                            'image'  => [
                                'url' => 'https://nextbricks.io/wp-content/uploads/2024/09/cursor_slide_2.webp',
                            ],
                        ],
                    ]
                ]
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Slide Item', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-cursor-slide__item',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'image',
                        'label'    => esc_html__( 'Image', 'bricks' ),
                        'settings' => [
                            'image'  => [
                                'url' => 'https://nextbricks.io/wp-content/uploads/2024/09/cursor_slide_3.webp',
                            ],
                        ],
                    ]
                ]
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Slide Item', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-cursor-slide__item',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'image',
                        'label'    => esc_html__( 'Image', 'bricks' ),
                        'settings' => [
                            'image'  => [
                                'url' => 'https://nextbricks.io/wp-content/uploads/2024/09/cursor_slide_4.webp',
                            ],
                        ],
                    ]
                ]
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_cursor_slide', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_cursor_slide.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;
        $disableTouchDevices    = ! empty( $settings['disableTouchDevices'] ) ? $settings['disableTouchDevices'] : 0;
        $target = ! empty( $settings['target'] ) ? $settings['target'] : '';
        $movementDuration = ! empty( $settings['movementDuration'] ) ? $settings['movementDuration'] : 0.8;
        $movementEase = ! empty( $settings['movementEase'] ) ? $settings['movementEase'] : 'power3';
        if ($movementEase === 'custom') {
      $movementEase = ! empty( $settings['customMovementEase'] ) ? $settings['customMovementEase'] : 'power3';
    }

        $this->set_attribute( '_root', 'class', "next-cursor-slide");
        $this->set_attribute( '_root', 'class', "next-cursor-slide--closed");
        $this->set_attribute( '_root', 'data-disable-builder', $disablebuilder);
        $this->set_attribute( '_root', 'data-disable-touch-devices', $disableTouchDevices);
        $this->set_attribute( '_root', 'data-target', $target);
        $this->set_attribute( '_root', 'data-movement-duration', $movementDuration);
        $this->set_attribute( '_root', 'data-movement-ease', $movementEase);

        $output = "<div {$this->render_attributes( '_root' )}>";
        $output .= "<div class='next-cursor-slide__transform'>";
        $output .= Frontend::render_children( $this );
        $output .= '</div>';
        $output .= '</div>';

        echo $output;
    }
}