<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_BeforeAfter_Image_V2 extends \Bricks\Element {
  public $category     = 'Next Bricks - Medias';
  public $name         = 'next_beforeafter_image_v2';
  public $icon         = 'ti-split-h';
  public $tag      = 'div';
  public $scripts      = ['next_beforeafter_image_v2'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Before/After Image v2', 'bricks' );
  }

  public function set_controls() {
    /*css*/
    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Block Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['width'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'width',
            'selector' => '',
          ]
        ],
        'default' => '500px',
    ];
    $this->controls['height'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline' => true,
        'css' => [
          [
            'property' => 'height',
            'selector' => '',
          ]
        ],
        'default' => '500px',
    ];
    $this->controls['border'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Border', 'bricks' ),
        'type'        => 'border',
        'css'         => [
            [
                'property' => 'border',
                'selector' => '',
            ],
        ],
        'default' => [
            'radius' => [
                'top' => '12',
                'right' => '12',
                'bottom' => '12',
                'left' => '12',
            ]
        ]
    ];
    $this->controls['cursor'] = [
        'tab'         => 'style',
        'group'       => '_layout',
        'label'       => esc_html__( 'Cursor', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'generalGroupTitle'   => esc_html__( 'General', 'bricks' ),
            'auto'                => 'auto',
            'default'             => 'default',
            'none'                => 'none',

            'linkGroupTitle'      => esc_html__( 'Link & status', 'bricks' ),
            'pointer'             => 'pointer',
            'context-menu'        => 'context-menu',
            'help'                => 'help',
            'progress'            => 'progress',
            'wait'                => 'wait',

            'selectionGroupTitle' => esc_html__( 'Selection', 'bricks' ),
            'cell'                => 'cell',
            'crosshair'           => 'crosshair',
            'text'                => 'text',
            'vertical-text'       => 'vertical-text',

            'dndGroupTitle'       => esc_html__( 'Drag & drop', 'bricks' ),
            'alias'               => 'alias',
            'copy'                => 'copy',
            'move'                => 'move',
            'no-drop'             => 'no-drop',
            'not-allowed'         => 'not-allowed',
            'grab'                => 'grab',
            'grabbing'            => 'grabbing',

            'zoomGroupTitle'      => esc_html__( 'Zoom', 'bricks' ),
            'zoom-in'             => 'zoom-in',
            'zoom-out'            => 'zoom-out',

            'scrollGroupTitle'    => esc_html__( 'Resize', 'bricks' ),
            'col-resize'          => 'col-resize',
            'row-resize'          => 'row-resize',
            'n-resize'            => 'n-resize',
            'e-resize'            => 'e-resize',
            's-resize'            => 's-resize',
            'w-resize'            => 'w-resize',
            'ne-resize'           => 'ne-resize',
            'nw-resize'           => 'nw-resize',
            'se-resize'           => 'se-resize',
            'sw-resize'           => 'sw-resize',
            'ew-resize'           => 'ew-resize',
            'ns-resize'           => 'ns-resize',
            'nesw-resize'         => 'nesw-resize',
            'nwse-resize'         => 'nwse-resize',
            'all-scroll'          => 'all-scroll',
        ],
        'css'         => [
            [
                'selector' => '',
                'property' => 'cursor',
            ]
        ],
        'inline'      => true,
        'default' => 'col-resize',
    ];

    $this->controls['sliderSeparator'] = [
        'label'      => esc_html__( 'Slider', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['sliderMode'] = [
        'label' => esc_html__( 'Mode', 'bricks' ),
        'type'  => 'select',
        'inline' => true,
        'options' => [
            'hover' => esc_html__( 'Hover', 'bricks' ),
            'drag' => esc_html__( 'Drag', 'bricks' ),
        ],
        'default' => 'drag',
    ];
    $this->controls['sliderPercentage'] = [
        'label' => esc_html__( 'Percentage', 'bricks' ),
        'type' => 'slider',
        'units'    => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
        ],
        'default' => 25,
    ];
    $this->controls['sliderWidth'] = [
        'label' => esc_html__( 'Width', 'bricks' ),
        'type' => 'number',
        'units' => true,
        'css' => [
            [
                'property' => 'width',
                'selector' => '.nb-before-after-image-v2__slider',
            ],
        ],
        'default' => '1px',
    ];
    
    $this->controls['sliderColor'] = [
        'label' => esc_html__( 'Color', 'bricks' ),
        'type' => 'color',
        'css' => [
            [
                'property' => '--slider-color',
                'selector' => '.nb-before-after-image-v2__slider',
            ],
        ],
        'default' => [
            'hex' => '#e3e3e3',
        ],
    ];
  $this->controls['handlebarSeparator'] = [
      'label'      => esc_html__( 'Handlebar', 'bricks' ),
      'type'       => 'separator',
  ];
  $this->controls['handlebarWidth'] = [
      'label' => esc_html__( 'Width', 'bricks' ),
      'type' => 'number',
      'units' => true,
      'css' => [
          [
              'property' => '--handlebar-width',
              'selector' => '.nb-before-after-image-v2__slider',
          ],
      ],
      'default' => '20px',
  ];
  $this->controls['handlebarHeight'] = [
      'label' => esc_html__( 'Height', 'bricks' ),
      'type' => 'number',
      'units' => true,
      'css' => [
          [
              'property' => '--handlebar-height',
              'selector' => '.nb-before-after-image-v2__slider',
          ],
      ],
      'default' => '20px',
  ];
  $this->controls['handlebarColor'] = [
      'label' => esc_html__( 'Color', 'bricks' ),
      'type' => 'color',
      'css' => [
          [
              'property' => 'background',
              'selector' => '.nb-before-after-image-v2__handlebar',
          ],
      ],
      'default' => [
          'hex' => '#ffffff',
      ],
  ];
  
  $this->controls['handlebarBorder'] = [
      'label' => esc_html__( 'Border', 'bricks' ),
      'type' => 'border',
      'units' => true,
      'css' => [
          [
              'property' => 'border',
              'selector' => '.nb-before-after-image-v2__handlebar',
          ],
      ],
      'default' => [
        'radius' => [
          'top' => '6',
          'right' => '6',
          'bottom' => '6',
          'left' => '6',
        ]
      ]
  ];
  
  $this->controls['handlebarBoxShadow'] = [
      'label' => esc_html__( 'Box Shadow', 'bricks' ),
      'type' => 'box-shadow',
      'css' => [
          [
              'property' => 'box-shadow',
              'selector' => '.nb-before-after-image-v2__handlebar',
          ],
      ],
      'default' => [
          'values' => [
              'offsetX' => 0,
              'offsetY' => -1,
              'blur' => 0,
              'spread' => 0,
          ],
          'color' => [
            'hex' => '#FFFFFF40',
        ],
      ],
  ];
  $this->controls['handlebarDotsColor'] = [
      'label'   => esc_html__( 'Dots Color', 'bricks' ),
      'type'    => 'color',
      'css'     => [
          [
              'property' => 'fill',
              'selector' => '.nb-before-after-image-v2__handlebar-dots',
          ],
      ],
      'default' => [
          'hex' => '#000000',
      ],
  ];
  
  $this->controls['handlebarDotsSize'] = [
      'label'   => esc_html__( 'Dots Size', 'bricks' ),
      'type'    => 'number',
      'units'   => true,
      'css'     => [
          [
              'property' => '--dimensions',
              'selector' => '.nb-before-after-image-v2__handlebar-dots',
          ],
      ],
      'default' => '14px',
    ];

    $this->controls['glowEffectSeparator'] = [
        'label'      => esc_html__( 'Glow', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['outerGlowWidth'] = [
        'label'   => esc_html__( 'Outer Width', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'width',
                'selector' => '.nb-before-after-image-v2__glow-effect',
            ],
        ],
        'default' => '144px',
    ];
    $this->controls['outerGlowOpacity'] = [
        'label'   => esc_html__( 'Outer Opacity', 'bricks' ),
        'type'    => 'slider',
        'units'    => [
            'px' => [
              'min' => 0,
              'max' => 1,
              'step' => 0.1,
            ],
        ],
        'css'     => [
            [
                'property' => 'opacity',
                'selector' => '.nb-before-after-image-v2__glow-effect',
            ],
        ],
        'default' => 0.5,
    ];
    $this->controls['outerGlowColor'] = [
        'label'   => esc_html__( 'Outer Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => '--outer-glow-color',
                'selector' => '.nb-before-after-image-v2__glow-effect',
            ],
        ],
        'default' => [
            'rgb' => 'rgba(169, 169, 169, 0.5)',
        ],
    ];
    $this->controls['innerGlowWidth'] = [
        'label'   => esc_html__( 'Inner Width', 'bricks' ),
        'type'    => 'number',
        'units'   => true,
        'css'     => [
            [
                'property' => 'width',
                'selector' => '.nb-before-after-image-v2__glow-effect-2',
            ],
        ],
        'default' => '40px',
    ];
    $this->controls['innerGlowColor'] = [
        'label'   => esc_html__( 'Inner Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => '--inner-glow-color',
                'selector' => '.nb-before-after-image-v2__glow-effect-2',
            ],
        ],
        'default' => [
            'rgb' => 'rgb(126, 127, 127)',
        ],
    ];

    $this->controls['sparklesSeparator'] = [
        'label'      => esc_html__( 'Particles Container', 'bricks' ),
        'type'       => 'separator',
    ];
  $this->controls['sparklesWidth'] = [
      'label'   => esc_html__( 'Width', 'bricks' ),
      'type'    => 'number',
      'units'   => true,
      'css'     => [
          [
              'property' => '--sparkles-width',
              'selector' => '.nb-before-after-image-v2__sparkles-container',
          ],
      ],
      'default' => '40px',
  ];
  $this->controls['sparklesColor'] = [
      'label'   => esc_html__( 'Mask Color', 'bricks' ),
      'type'    => 'color',
      'css'     => [
          [
              'property' => '--sparkles-color',
              'selector' => '.nb-before-after-image-v2__sparkles-container',
          ],
      ],
      'default' => [
          'hex' => '#ffffff',
      ],
    ];
  $this->controls['particlesSeparator'] = [
      'label'      => esc_html__( 'Particles', 'bricks' ),
      'type'       => 'separator',
  ];
  $this->controls['disablebuilder'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Disable at the builder', 'bricks' ),
      'type' => 'checkbox',
      'default' => true,
  ];
  $this->controls['particlesNumber'] = [
      'label'   => esc_html__( 'Number', 'bricks' ),
      'type'    => 'number',
      'inline'  => true,
      'default' => 150,
      'min'     => 0,
      'max'     => 1000,
  ];
  $this->controls['particlesColor'] = [
      'label'   => esc_html__( 'Color', 'bricks' ),
      'type'    => 'color',
      'css'     => [
          [
              'property' => 'background',
              'selector' => '.nb-before-after-image-v2__particle',
          ],
      ],
      'default' => [
          'hex' => '#ffffff',
      ],
  ];
  $this->controls['particlesDuration'] = [
      'label'   => esc_html__( 'Animation Duration', 'bricks' ),
      'type'    => 'number',
      'unit'   => 's',
      'css'     => [
          [
              'property' => '--duration',
              'selector' => '.nb-before-after-image-v2__particle',
          ],
      ],
      'default' => '4s',
  ];
  $this->controls['particlesEasing'] = [
      'label'   => esc_html__( 'Animation CSS Easing', 'bricks' ),
      'type'    => 'text',
      'inline'  => true,
      'css'     => [
          [
              'property' => '--easing',
              'selector' => '.nb-before-after-image-v2__particle',
          ],
      ],
      'default' => 'ease-in-out',
  ];
  }

  public function get_nestable_children() {
    return [
        [
            'name'     => 'block',
            'label'    => esc_html__( 'Before Container', 'bricks' ),
            'settings' => [
                '_hidden'  => [
                    '_cssClasses' => 'nb-before-after-image-v2__first-image-container',
                ],
            ],
            'children' => [
                [
                    'name'     => 'image',
                    'label'    => esc_html__( 'Before Image', 'bricks' ),
                    'settings' => [
                        'image'  => [
                            'url' => 'https://oxyfolio.com/wp-content/uploads/2025/04/14-2-scaled.jpg',
                        ],
                        '_hidden'  => [
                            '_cssClasses' => 'nb-before-after-image-v2__first-image',
                        ],
                    ],
                ],
                [
                    'name'     => 'block',
                    'label'    => esc_html__( 'Before Content', 'bricks' ),
                    'settings' => [
                        '_hidden'  => [
                            '_cssClasses' => 'nb-before-after-image-v2__first-image-content',
                        ],
                    ],
                    'children' => [
                        [
                            'name'     => 'heading',
                            'label'    => esc_html__( 'Heading', 'bricks' ),
                            'settings' => [
                                'text' => esc_html__( 'Before', 'bricks' ),
                                'tag'  => 'h3',
                                '_typography' => [
                                    'fontSize' => '24px',
                                    'color' => [
                                        'hex' => '#ffffff',
                                    ],
                                ],
                            ],
                        ],
                    ]
                ],
            ],
        ],
        [
            'name'     => 'block',
            'label'    => esc_html__( 'After Container', 'bricks' ),
            'settings' => [
                '_hidden'  => [
                    '_cssClasses' => 'nb-before-after-image-v2__second-image-container',
                ],
            ],
            'children' => [
                [
                    'name'     => 'image',
                    'label'    => esc_html__( 'After Image', 'bricks' ),
                    'settings' => [
                        'image'  => [
                            'url' => 'https://oxyfolio.com/wp-content/uploads/2025/04/13-scaled.jpg',
                        ],
                        '_hidden'  => [
                            '_cssClasses' => 'nb-before-after-image-v2__second-image',
                        ],
                    ],
                ],
                [
                    'name'     => 'block',
                    'label'    => esc_html__( 'After Content', 'bricks' ),
                    'settings' => [
                        '_hidden'  => [
                            '_cssClasses' => 'nb-before-after-image-v2__second-image-content',
                        ],
                    ],
                    'children' => [
                        [
                            'name'     => 'heading',
                            'label'    => esc_html__( 'Heading', 'bricks' ),
                            'settings' => [
                                'text' => esc_html__( 'After', 'bricks' ),
                                'tag'  => 'h3',
                                '_typography' => [
                                    'fontSize' => '24px',
                                    'color' => [
                                        'hex' => '#ffffff',
                                    ],
                                ],
                            ],
                        ],
                    ]
                ],
            ],
        ],
    ];
}

  public function enqueue_scripts() {
    wp_enqueue_script( 'next_beforeafter_image_v2', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_beforeafter_image_v2.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $is_builder = bricks_is_builder();
    $disablebuilder = !empty($settings['disablebuilder']) ? $settings['disablebuilder'] : 0;
    $sliderMode = !empty($settings['sliderMode']) ? $settings['sliderMode'] : 'drag'; /*hover or drag*/
    $sliderPercentage = !empty($settings['sliderPercentage']) ? $settings['sliderPercentage'] : 25; /*percentage of the slider*/
    $particlesNumber = isset($settings['particlesNumber']) ? $settings['particlesNumber'] : 50; /*number of particles*/

    $this->set_attribute( '_root', 'class', "nb-before-after-image-v2");
    $this->set_attribute( '_root', 'data-slider-mode', $sliderMode);
    $this->set_attribute( '_root', 'data-slider-percentage', $sliderPercentage);
    $this->set_attribute( '_root', 'data-particles-number', $particlesNumber);

    if($disablebuilder != 0) {
      $this->set_attribute( '_root', 'data-disable-builder', 'true');
    }

    if ( ! $is_builder ) {
      $this->set_attribute( '_root', 'data-flickering', '1');
    }

    $output = "<div {$this->render_attributes( '_root' )}>";
    $output .= '<div class="nb-before-after-image-v2__slider">
                    <div class="nb-before-after-image-v2__glow-effect"></div>
                    <div class="nb-before-after-image-v2__glow-effect-2"></div>
                    <div class="nb-before-after-image-v2__sparkles-container"></div>
                    <div class="nb-before-after-image-v2__handlebar">
                        <svg class="nb-before-after-image-v2__handlebar-dots" width="16" height="16" viewBox="0 0 16 16">
                            <circle cx="8" cy="4" r="1.5" />
                            <circle cx="8" cy="8" r="1.5" />
                            <circle cx="8" cy="12" r="1.5" />
                        </svg>
                    </div>
                </div>
                <div class="nb-before-after-image-v2__images">';
    $output .= Frontend::render_children( $this );
    $output .= "</div>
    </div>";

	echo $output;
  }
}
