<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Arrow_Button_V3 extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'next-arrow-button-v3';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';

  public function get_label() {
    return esc_html__( 'Arrow Button v3', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'div' => 'div',
            'span' => 'span',
            'button' => 'button',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'div',
        'default'     => 'div',
    ];
    $this->controls['customTag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Custom tag', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'placeholder' => 'div',
        'required'    => [ 'tag', '=', 'custom' ],
    ];
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Arrow Button v3', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['direction'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Direction from', 'bricks' ),
        'type'    => 'select',
        'options' => [
            'left' => 'Left',
            'right' => 'Right',
        ],
        'default' => 'right',
        'rerender' => true,
        'inline' => true,
    ];
    $this->controls['note'] = [
        'tab' => 'content',
        'description' => sprintf(html_entity_decode(esc_html__( 'If "Direction from" is set to right and a Padding right of 2px is applied, the arrow will expand to the left but will leave a 2px on the other side, so that it is symmetric.<br> Same happens if the direction is set to left with the Padding Left property.', 'bricks' )))
    ];
     $this->controls['padding'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => '--padding',
                'selector' => '',
            ],
        ],
        'default' => [
            'top'    => 2,
            'right'  => 2, 
            'bottom' => 2,
            'left'   => 25,
        ],
    ];
    $this->controls['titleTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
            [
                'property' => 'typography',
                'selector' => '&{pseudo} .nb-arrow-button-v3__text',
            ],
        ],
        'default' => [
            'font-size' => '16px',
            'font-weight' => '500',
            'color' => [
                'hex' => '#000',
              ]
        ],
    ];
    $this->controls['background'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '',
            ],
        ],
        'default' => [
            'rgb' => 'rgba(255, 255, 255, 0.5)',
        ],
    ];

    $this->controls['border'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Border', 'bricks' ),
        'type'    => 'border',
        'units'   => true,
        'css'     => [
            [
                'property' => 'border',
                'selector' => '',
            ],
        ],
        'default' => [
            'radius' => [
              'top' => 100,
              'right' => 100,
              'bottom' => 100,
              'left' => 100,
            ],
        ],
    ];
    $this->controls['gap'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Gap', 'bricks' ),
        'type'    => 'number',
        'units'    =>  true,
        'css'     => [
            [
                'property' => '--gap',
                'selector' => '',
            ],
        ],
        'default' => 20,
    ];


    //Arrow style
    $this->controls['arrowStyleSeparator'] = [
        'label'       => esc_html__( 'Arrow style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['arrowtype'] = [
        'tab' => 'content',
        'label' => esc_html__( 'Icon', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'type1' => 'Arrow 1',
            'type2' => 'Arrow 2',
            'type3' => 'Angle',
            'type4' => 'Angles',
            'type5' => 'Fancy',
        ],
        'inline' => true,
        'placeholder' => 'Arrow 2',
        'default' => 'type2',
    ];
    $this->controls['arrowPadding'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Arrow padding', 'bricks' ),
        'type'    => 'spacing',
        'css'     => [
            [
                'property' => 'padding',
                'selector' => '&{pseudo} .nb-arrow-button-v3__arrow',
            ],
        ],
        'default' => [
            'top'    => 12,
            'right'  => 12, 
            'bottom' => 12,
            'left'   => 12,
        ],
    ];
    $this->controls['arrowweight'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Weight', 'bricks' ),
        'type' => 'number',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'stroke-width',
              'selector' => '&{pseudo} .nb-arrow-button-v3__arrow',
            ],
        ],
        'placeholder'        => '1',
        'default'        => '1',
    ];
    $this->controls['dimensions'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Dimensions', 'bricks' ),
        'type'    => 'number',
        'units'    =>  true,
        'css'     => [
            [
                'property' => '--dimensions',
                'selector' => '',
            ],
        ],
        'default' => 40,
    ];
    $this->controls['arrowRotation'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Rotation', 'bricks' ),
        'type'    => 'number',
        'unit'    => 'deg',
        'css'     => [
            [
                'property' => '--arrow-default-rotation',
                'selector' => '&{pseudo} .nb-arrow-button-v3__arrow',
            ],
        ],
        'default' => '0',
    ];
    $this->controls['arrowColor'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Arrow color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => '--stroke',
                'selector' => '&{pseudo} .nb-arrow-button-v3__arrow',
            ],
        ],
        'default' => [
            'hex' => '#000',
        ],
    ];
    $this->controls['arrowBackground'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Background', 'bricks' ),
        'type'    => 'color',
        'css'     => [
            [
                'property' => 'background',
                'selector' => '&{pseudo} .nb-arrow-button-v3__arrow-wrapper',
            ],
        ],
        'default' => [
            'hex' => '#fff',
        ],
    ];
    $this->controls['arrowBorder'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Border', 'bricks' ),
        'type'    => 'border',
        'units'   => true,
        'css'     => [
            [
                'property' => 'border',
                'selector' => '&{pseudo} .nb-arrow-button-v3__arrow-wrapper',
            ],
        ],
        'default' => [
            'radius' => [
              'top' => 100,
              'right' => 100,
              'bottom' => 100,
              'left' => 100,
            ],
        ],
    ];

    //Arrow animation
    $this->controls['arrowAnimationSeparator'] = [
        'label'       => esc_html__( 'Arrow animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['rotation'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Rotation', 'bricks' ),
        'type'    => 'number',
        'unit'    =>  'deg',
        'css'     => [
            [
                'property' => '--arrow-rotation',
                'selector' => '',
            ],
        ],
        'default' => 45,
    ];
    $this->controls['duration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Duration', 'bricks' ),
        'type'    => 'number',
        'unit'    =>  's',
        'css'     => [
            [
                'property' => '--duration',
                'selector' => '',
            ],
        ],
        'default' => '0.6s',
    ];
    $this->controls['ease'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Ease', 'bricks' ),
        'type'    => 'text',
        'css'     => [
            [
                'property' => '--ease',
                'selector' => '',
            ],
        ],
        'default' => 'cubic-bezier(0.22, 1, 0.36, 1)',
    ];
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';
    $direction = ! empty( $settings['direction'] ) ? $settings['direction'] : 'right';

    /*Arrow Icons*/
    $arrowtype = ! empty( $settings['arrowtype'] ) ? $settings['arrowtype'] : 'type2';
    if($arrowtype == 'type1'){
        $arrow = 
        "<svg class='nb-arrow-button-v3__arrow' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 25 25'>
        <path d='m17.5 5.999-.707.707 5.293 5.293H1v1h21.086l-5.294 5.295.707.707L24 12.499l-6.5-6.5z'/>
        </svg>";
    }
    if($arrowtype == 'type2'){
        $arrow = 
        "<svg class='nb-arrow-button-v3__arrow' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24'>
        <path d='M11.293 4.707 17.586 11H4v2h13.586l-6.293 6.293 1.414 1.414L21.414 12l-8.707-8.707-1.414 1.414z'/>
        </svg>";
    }
    if($arrowtype == 'type3'){
        $arrow = 
        "<svg class='nb-arrow-button-v3__arrow' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 320 512'>
        <path d='M310.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-192 192c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L242.7 256 73.4 86.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l192 192z'/>
        </svg>";
    }
    if($arrowtype == 'type4'){
        $arrow = 
        "<svg class='nb-arrow-button-v3__arrow' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 512 512'>
        <path d='M470.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L402.7 256 265.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160zm-352 160l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L210.7 256 73.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0z'/>
        </svg>";
    }
    if($arrowtype == 'type5'){
        $arrow = 
        "<svg class='nb-arrow-button-v3__arrow' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20' style='fill: none !important'>
          <path d='M0.985771 9.98158L19.9713 9.98162' stroke-miterlimit='10'/>
          <path d='M19.6589 9.97797C15.1624 9.978 11.5176 6.33315 11.5176 1.83661' stroke-miterlimit='10'/>
          <path d='M11.5174 18.1213C11.5175 13.6248 15.1623 9.97997 19.6588 9.97995' stroke-miterlimit='10'/>
        </svg>";
    }

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $this->set_attribute( '_root', 'class', 'nb-arrow-button-v3' );

    $output = "
    <$root_tag {$this->render_attributes( '_root' )}
    data-direction=\"$direction\">
      <span class='nb-arrow-button-v3__text'>$inner_title</span>
      <div class='nb-arrow-button-v3__arrow-wrapper'>
          <div class='nb-arrow-button-v3__arrow-container'>
              $arrow
          </div>
      </div>
    </$root_tag>
    ";

	echo $output;
  }
}