function next_meteors(){class Meteor{constructor(options){const that=this
    this.canvas=options.element
    this.easing=options.easing
    this.options=options
    this.context=this.canvas.getContext('2d')
    this.canvas.height=this.canvas.offsetHeight*window.devicePixelRatio
    this.canvas.width=this.canvas.offsetWidth*window.devicePixelRatio
    this.meteorWidth=that.options.width
    this.meteorSpeed=gsap.utils.mapRange(4,12,6,12,that.meteorWidth)
    this.meteorLength=gsap.utils.mapRange(4,12,50,80,that.meteorWidth)
    that.gradient=that.context.createLinearGradient(that.canvas.width*0.5,that.canvas.height*0.5,that.canvas.width*0.5,0)
    this.hue=options.hue
    this.saturation=options.saturation
    that.gradient.addColorStop(0,`hsl(${this.hue}, ${this.saturation}%, 100%)`)
    that.gradient.addColorStop(0.025,`hsl(${this.hue}, ${this.saturation}%, 70%)`)
    that.gradient.addColorStop(0.15,`hsl(${this.hue}, ${this.saturation}%, 40%)`)
    that.gradient.addColorStop(0.55,`hsl(${this.hue}, ${this.saturation}%, 20%)`)
    that.gradient.addColorStop(1,'transparent')
    this.particles=that.genParticles(gsap.utils.random(50,100,1))
    this.setParticlesMotion()
    gsap.ticker.add(this.draw.bind(that))}
    genParticles(amount){const that=this
    const particles=[]
    for(let p=0;p<amount;p++){const particle={
        size:gsap.utils.random(1,that.options.width*1.25,1)*window.devicePixelRatio,
    }
    particles.push(particle)}
    return particles.slice(0, window.innerWidth < 768 ? amount/2 : amount)}
    draw(){const that=this
    that.context.clearRect(0,0,that.canvas.width,that.canvas.height)
    that.context.shadowBlur=5*window.devicePixelRatio
    that.context.shadowColor=`hsl(${this.hue}, ${this.saturation}%, 40%)`
    const visibleParticles = that.particles.filter(p=>!p.dead && p.size > 0.5)
    for(const particle of visibleParticles){
        that.context.beginPath()
        that.context.fillStyle=that.gradient
        that.context.arc(particle.x,particle.y,particle.size/2,0,2*Math.PI)
        that.context.fill()
    }
    that.context.beginPath()
    const radius=(that.meteorWidth/2)*window.devicePixelRatio
    that.context.arc(that.canvas.width*0.5,that.canvas.height*0.5-radius,radius,0,1*Math.PI)
    that.context.fill()
    that.context.fillStyle=that.gradient
    that.context.moveTo(that.canvas.width*0.5-radius,that.canvas.height*0.5-radius)
    that.context.lineTo(that.canvas.width*0.5,that.canvas.height*0.5-that.meteorLength*window.devicePixelRatio)
    that.context.lineTo(that.canvas.width*0.5+radius,that.canvas.height*0.5-radius)
    that.context.fill()}
    setParticlesMotion(){const that=this
    for(const particle of that.particles){particle.x=that.canvas.width*0.5
    particle.y=that.canvas.height*0.5
    particle.speed=gsap.utils.mapRange(4,12,2,1,that.meteorWidth)
    particle.dead=!1
    if(particle.size===0)
    particle.size=gsap.utils.random(1,that.options.width*1.25,1)*window.devicePixelRatio
    if(particle.tl)particle.tl.kill()
    particle.tl=gsap.timeline().to(particle,{x:()=>gsap.utils.random(that.canvas.width*0.5-that.meteorWidth*2.5,that.canvas.width*0.5+that.meteorWidth*2.5,1),y:()=>gsap.utils.random(0,0,1),size:0,repeat:-1,ease:that.easing,repeatDelay:Math.random(),delay:particle.speed*-1,duration:particle.speed,})}}}
    var isBricks=window.location.href.includes("brickspreview");document.querySelectorAll(".next-meteors").forEach((meteors)=>{if(isBricks&&meteors.dataset.disableBuilder==="1")return;function createMeteor(meteor){var meteorWidth=meteor.getAttribute("data-width");var hue=meteor.getAttribute("data-hue");var saturation=meteor.getAttribute("data-saturation");new Meteor({element:meteor,width:parseFloat(meteorWidth),hue:parseFloat(hue),saturation:parseFloat(saturation)})}
    if(isBricks){const observer=new MutationObserver((mutations)=>{mutations.forEach((mutation)=>{if(mutation.type==='childList'){mutation.addedNodes.forEach((node)=>{if(node.nodeType===Node.ELEMENT_NODE&&node.classList.contains('next-meteors__meteor')){createMeteor(node)}})}})});const config={childList:!0,subtree:!0};observer.observe(meteors,config)}else{meteors.querySelectorAll(".next-meteors__meteor").forEach(createMeteor)}})}
    document.addEventListener("DOMContentLoaded",function(t){bricksIsFrontend&&next_meteors()})