import{Renderer,Program,Mesh,Triangle}from 'https://cdn.skypack.dev/ogl';function next_iridescence(){document.querySelectorAll('.nb-iridescence').forEach(iridescence=>{var canvas=iridescence.querySelector('.nb-iridescence__canvas');var renderer=new Renderer({canvas,dpr:2});var gl=renderer.gl;function resize(){renderer.setSize(iridescence.clientWidth,iridescence.clientHeight)}
window.addEventListener('resize',resize);resize();var vertexShader=`
            attribute vec2 uv;
            attribute vec2 position;
            varying vec2 vUv;
            void main() {
            vUv = uv;
            gl_Position = vec4(position, 0, 1);
            }
        `;var fragmentShader=`
            precision highp float;
            uniform float uTime;
            uniform vec3 uColor;
            uniform vec3 uResolution;
            uniform vec2 uMouse;
            uniform float uAmplitude;
            uniform float uSpeed;
            varying vec2 vUv;

            void main() {
            float mr = min(uResolution.x, uResolution.y);
            vec2 uv = (vUv.xy * 2.0 - 1.0) * uResolution.xy / mr;
            uv += (uMouse - vec2(0.5)) * uAmplitude;

            float d = -uTime * 0.5 * uSpeed;
            float a = 0.0;
            for (float i = 0.0; i < 8.0; ++i) {
                a += cos(i - d - a * uv.x);
                d += sin(uv.y * i + a);
            }
            d += uTime * 0.5 * uSpeed;

            vec3 col = vec3(cos(uv * vec2(d, a)) * 0.6 + 0.4, cos(a + d) * 0.5 + 0.5);
            col = cos(col * cos(vec3(d, a, 2.5)) * 0.5 + 0.5) * uColor;
            gl_FragColor = vec4(col, 1.0);
            }
        `;var r=parseFloat(iridescence.getAttribute('data-r'));var g=parseFloat(iridescence.getAttribute('data-g'));var b=parseFloat(iridescence.getAttribute('data-b'));var speed=parseFloat(iridescence.getAttribute('data-speed'));var amplitude=parseFloat(iridescence.getAttribute('data-amplitude'));var program=new Program(gl,{vertex:vertexShader,fragment:fragmentShader,uniforms:{uTime:{value:0},uMouse:{value:[0.5,0.5]},uResolution:{value:[canvas.width,canvas.height,0]},uAmplitude:{value:amplitude},uSpeed:{value:speed},uColor:{value:[r,g,b]}}});var mesh=new Mesh(gl,{geometry:new Triangle(gl),program});var interactivity=iridescence.getAttribute('data-interactivity');if(interactivity==='enabled'){canvas.addEventListener('mousemove',(event)=>{const rect=canvas.getBoundingClientRect();const mouseX=(event.clientX-rect.left)/rect.width;const mouseY=(event.clientY-rect.top)/rect.height;program.uniforms.uMouse.value=[mouseX,mouseY]})}
let t=0;requestAnimationFrame(function update(){requestAnimationFrame(update);program.uniforms.uTime.value=t;program.uniforms.uResolution.value=[iridescence.clientWidth,iridescence.clientHeight,0];renderer.render({scene:mesh});t+=0.01});iridescence.removeAttribute('data-iridescence-flickering')})}
document.addEventListener("DOMContentLoaded",function(t){bricksIsFrontend&&next_iridescence()})