<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Video_Sequence extends \Bricks\Element {
  public $category     = 'Next Bricks - Medias';
  public $name         = 'videosequence';
  public $icon         = 'fa-solid fa-film';
  public $scripts      = ['videosequence'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Video Sequence', 'bricks' );
  }

  public function set_controls() {
    $this->controls['note'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Video Sequence is a nestable element.<br>Drag & Drop elements inside to scroll them while Video Sequence is pinned.', 'bricks' )))
    ];

    $this->controls['videoType'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Source', 'bricks' ),
			'type'      => 'select',
			'options'   => [
				'media'   => esc_html__( 'Media', 'bricks' ),
				'file'    => esc_html__( 'File URL', 'bricks' ),
			],
			'default'   => 'media',
			'inline'    => true,
			'clearable' => false,
		];
    $this->controls['video'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Video file', 'bricks' ),
      'type' => 'video',
      'required' => [ 'videoType', '=', 'media' ],
    ];
    $this->controls['fileUrl'] = [
			'tab'      => 'content',
			'label'    => esc_html__( 'Video file URL', 'bricks' ),
			'type'     => 'text',
			'required' => [ 'videoType', '=', 'file' ],
		];

    $this->controls['settingsseparator'] = [
			'type'  => 'separator',
			'label' => esc_html__( 'Dimensions', 'bricks' ),
		];
    $this->controls['videoheight'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Scrolling height', 'bricks' ),
      'type'    => 'number',
      'units'    => true,
      'css'     => [
        [
          'property' => 'height',
          'selector' => '',
        ],
      ],
      'placeholder' => '600vh',
      'default' => '600vh',
  ];
    $this->controls['full'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Full', 'bricks' ),
      'type'        => 'checkbox',
      'default'        => true,
    ];
    $this->controls['dimensions'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Dimensions', 'bricks' ),
      'type'    => 'number',
      'units'    => true,
      'css'     => [
        [
          'property' => '--dimensions',
          'selector' => '.bc-video-sequence__generator',
        ],
      ],
      'placeholder' => '500px',
      'required' => [ 'full', '!=', true],
    ];


    $this->controls['animationseparator'] = [
			'type'  => 'separator',
      'label' => esc_html__( 'Animation', 'bricks' ),
		];
    $this->controls['transitionspeed'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Transition speed', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 8,
    ];
    $this->controls['framethreshold'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Frame threshold', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 0.1,
    ];
  }

  public function enqueue_scripts() {
    wp_enqueue_script( 'scrollyvideo-js', NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_scrollyvideo.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);

    wp_enqueue_script( 'videosequence', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_video_sequence.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $transitionspeed = ! empty( $settings['transitionspeed'] ) ? $settings['transitionspeed'] : 8;
    $framethreshold = ! empty( $settings['framethreshold'] ) ? $settings['framethreshold'] : 0.1;
    $cover = ! empty( $settings['cover'] ) ? $settings['cover'] : false;
    $sticky = ! empty( $settings['sticky'] ) ? $settings['sticky'] : false;
    $full = ! empty( $settings['full'] ) ? $settings['full'] : false;

    if (isset($settings['video'])) {
      $last_image = $settings['video']['url'];
    }else if((isset($settings['fileUrl']))){
      $last_image = $settings['fileUrl'];
    }else{
      $last_image = 'https://player.vimeo.com/external/329570595.sd.mp4?s=5e5489760375704845f39856afee9f56755873f0&profile_id=164&oauth2_token_id=57447761/';
    }

    if($full != 1){
      $this->set_attribute( '_root', 'data-no-full' );
    }

    $this->set_attribute( '_root', 'class', 'bc-video-sequence' );
    $this->set_attribute( '_root', 'data-src', $last_image );
    $this->set_attribute( '_root', 'data-transitionspeed', $transitionspeed );
    $this->set_attribute( '_root', 'data-framethreshold', $framethreshold );
    $this->set_attribute( '_root', 'data-cover', $cover );
    $this->set_attribute( '_root', 'data-sticky', $sticky );
    $this->set_attribute( '_root', 'data-full', $full );

    $output = "<div {$this->render_attributes( '_root' )}>";
    $output .= "<div class='bc-video-sequence__generator'></div>";
    $output .= Frontend::render_children( $this );
    $output .= "</div>";

	echo $output;
  }
}