<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class bc_unfold_hover extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'bc_unfold_hover';
  public $icon         = 'ti-text';
  public $tag      = 'h3';
  public $scripts      = ['bc_unfold_hover'];

  public function get_label() {
    return esc_html__( 'Unfold Hover', 'bricks' );
  }

  public function set_control_groups() {
    $this->control_groups['gradient'] = [
      'title' => esc_html__( 'Gradient', 'bricks' ),
      'tab'   => 'content',
    ];
  }

  public function set_controls() {
    $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'h1' => 'h1',
            'h2' => 'h2',
            'h3' => 'h3',
            'h4' => 'h4',
            'h5' => 'h5',
            'h6' => 'h6',
            'p' => 'p',
            'span' => 'span',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'h3',
        'default'     => 'h3',
    ];
    $this->controls['customTag'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Custom tag', 'bricks' ),
			'type'        => 'text',
			'inline'      => true,
			'placeholder' => 'h3',
			'required'    => [ 'tag', '=', 'custom' ],
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
	];

    //Fold
    $this->controls['foldSeparator'] = [
        'label'      => esc_html__( 'Fold', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['fold_title'] = [
        'label'       => esc_html__( 'Title', 'bricks' ),
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Fold', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['foldTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
		'css'     => [
        [
          'property' => 'typography',
          'selector' => '.bc-unfold-hover__text:nth-child(1)',
        ],
      ],
    ];
    //Unfold
    $this->controls['unfoldSeparator'] = [
        'label'      => esc_html__( 'Unfold', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['unfold_title'] = [
        'label'       => esc_html__( 'Title', 'bricks' ),
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Unfold', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['unfoldTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
        [
            'property' => 'typography',
            'selector' => '.bc-unfold-hover__text:nth-child(2)',
        ],
        ],
    ];

    //Animation
    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['intensity'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Intensity', 'bricks' ),
        'type'    => 'number',
        'units'    => true,
        'css'     => [
          [
            'property' => '--intensity',
            'selector' => '',
          ],
        ],
        'placeholder' => '7px',
        'default' => '7px',
    ];
    $this->controls['translate'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Translate', 'bricks' ),
        'type'    => 'number',
        'units'    => true,
        'css'     => [
          [
            'property' => '--link-translate-x',
            'selector' => '',
          ],
        ],
        'placeholder' => '32px',
        'default' => '32px',
    ];
    $this->controls['delayLetters'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Delay between letters', 'bricks' ),
        'type'    => 'number',
        'unit'    => 'ms',
        'css'     => [
          [
            'property' => '--delay-between-letters',
            'selector' => '',
          ],
        ],
        'placeholder' => '25ms',
        'default' => '25ms',
    ];
    $this->controls['duration'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Duration', 'bricks' ),
        'type'    => 'number',
        'unit'    => 's',
        'css'     => [
          [
            'property' => '--transition-duration',
            'selector' => '',
          ],
        ],
        'placeholder' => '0.4s',
        'default' => '0.4s',
    ];
    $this->controls['easing'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'CSS Easing', 'bricks' ),
        'type'    => 'text',
        'css'     => [
          [
            'property' => '--transition-easing',
            'selector' => '',
          ],
        ],
        'placeholder' => 'cubic-bezier(0.445, 0.05, 0.55, 0.95)',
        'default' => 'cubic-bezier(0.445, 0.05, 0.55, 0.95)',
    ];

    //Gradient
    $this->controls['titleGradient'] = [
        'group' => 'gradient',
        'tab' => 'content',
        'type' => 'gradient',
        'css' => [
            [
            'property' => 'background-image',
            'selector' => '.char',
            ],
        ],
    ];

    //Padding from style tab applied to the root without link and to the link if exists
    $this->controls['_padding'] = [
      'tab'   => 'style',
      'group' => '_layout',
      'label' => esc_html__( 'Padding', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'padding',
          'selector' => '&:not(:has(> a)), > a',
        ]
      ],
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'bc_unfold_hover', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_unfold_hover.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $is_builder = bricks_is_builder();
    $fold_title    = ! empty( $settings['fold_title'] ) ? $settings['fold_title'] : 'Fold';
    $unfold_title    = ! empty( $settings['unfold_title'] ) ? $settings['unfold_title'] : 'Unfold';
    
    $this->set_attribute( '_root', 'class', 'bc-unfold-hover' );

    if ( ! $is_builder ) {
      $this->set_attribute( '_root', 'data-hide-unfold-hover', '' );
    }
    $this->set_attribute( '_inner', 'class', 'bc-unfold-hover__wrapper' );

    if ( ! empty( $settings['link'] ) ) {
			$this->set_link_attributes( '_link', $settings['link'] );
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}>
        <a class='bc-unfold-hover__anchor' {$this->render_attributes( '_link' )}>
          <span {$this->render_attributes( '_inner' )}>
            <span class='bc-unfold-hover__text'>$fold_title</span>
            <span class='bc-unfold-hover__text'>$unfold_title</span>
          </span>
        </a>
      </{$this->tag}>
      ";
		}else{
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}>
        <span {$this->render_attributes( '_inner' )}>
          <span class='bc-unfold-hover__text'>$fold_title</span>
          <span class='bc-unfold-hover__text'>$unfold_title</span>
        </span>
      </{$this->tag}>
      ";
    }

	echo $output;
  }
}
