<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Tippy extends \Bricks\Element {
  public $category     = 'Next Bricks - Cores';
  public $name         = 'tippy';
  public $icon         = 'fa-solid fa-message';
  public $scripts      = ['tippys'];

  public function get_label() {
    return esc_html__( 'Tippy', 'bricks' );
  }

  public function set_controls() {
    $this->controls['apply'] = [
        'tab' => 'content',
        'type' => 'apply',
        'reload' => true,
        'label' => esc_html__( 'Reload tippy changes', 'bricks' ),
    ];
    $this->controls['tippyelements'] = [
        'tab'           => 'content',
        'type'          => 'repeater',
        'label'         => esc_html__( 'Tippy elements', 'bricks' ),
        'placeholder'   => esc_html__( 'Tippy element', 'bricks' ),
        'titleProperty' => 'title',
        'fields'        => [
            'class'       => [
                'type'    => 'text',
                'label'   => esc_html__( 'Element', 'bricks' ),
                'placeholder' => 'className',
            ],
            'content'       => [
                'type'    => 'text',
                'label'   => esc_html__( 'Text', 'bricks' ),
                'placeholder' => 'My Tooltip',
            ],
            'background'       => [
                'hasDynamicData' => false,
                'tab' => 'content',
                'label' => esc_html__( 'Background', 'bricks' ),
                'type' => 'background',
                'inline' => true,
            ],
            'fontcolor'       => [
                'hasDynamicData' => false,
                'tab' => 'content',
                'label' => esc_html__( 'Color', 'bricks' ),
                'type' => 'color',
                'inline' => true,
            ],
            'fontsize'       => [
                'hasDynamicData' => false,
                'tab'           => 'content',
                'type' => 'number',
                'label' => esc_html__( 'Font size', 'bricks' ),
                'units' => true,
                'placeholder' => '16px',
            ],
            'fontfamily'       => [
                'hasDynamicData' => false,
                'tab'           => 'content',
                'type' => 'typography',
                'exclude' => [
                 'text-align',
                 'text-shadow',
                 'font-weight',
                 'font-style',
                 'text-align',
                 'text-transform',
                 'text-decoration',
                 'font-size',
                 'line-height',
                 'letter-spacing',
                 'color',
                 'text-shadow',
                 'font-variation-settings',
                ],
                'popup' => false,
            ],
            'padding'       => [
                'hasDynamicData' => false,
                'tab' => 'content',
                'label' => esc_html__( 'Padding', 'bricks' ),
                'type' => 'spacing',
            ],
            'bordercolor'       => [
                'hasDynamicData' => false,
                'tab' => 'content',
                'label' => esc_html__( 'Border color', 'bricks' ),
                'type' => 'background',
                'inline' => true,
            ],
            'borderradius'       => [
                'hasDynamicData' => false,
                'tab' => 'content',
                'label' => esc_html__( 'Border radius', 'bricks' ),
                'type' => 'text',
                'inline' => true,
                'placeholder' => '100px',
            ],
            'borderwidth'       => [
                'hasDynamicData' => false,
                'tab' => 'content',
                'label' => esc_html__( 'Border width', 'bricks' ),
                'type' => 'text',
                'inline' => true,
                'placeholder' => '1px',
            ],



          'showduration'       => [
            'type'    => 'text',
            'label'   => esc_html__( 'Show duration', 'bricks' ),
            'placeholder' => '100',
            'inline' => true,
            'hasDynamicData' => false,
          ],
          'hideduration'       => [
            'type'    => 'text',
            'label'   => esc_html__( 'Hide duration', 'bricks' ),
            'placeholder' => '50',
            'inline' => true,
            'hasDynamicData' => false,
          ],
          'arrow'       => [
            'label'   => esc_html__( 'Arrow', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'true' => 'true',
                'false' => 'false',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'true',
          ],
          'arrowcolor'       => [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Arrow color', 'bricks' ),
            'type' => 'background',
            'inline' => true,
        ],
          'showdelay'       => [
            'type'    => 'text',
            'label'   => esc_html__( 'Show Delay', 'bricks' ),
            'placeholder' => '100',
            'inline' => true,
            'hasDynamicData' => false,
          ],
          'hidedelay'       => [
            'type'    => 'text',
            'label'   => esc_html__( 'Hide Delay', 'bricks' ),
            'placeholder' => '50',
            'inline' => true,
            'hasDynamicData' => false,
          ],
          'triggeranimation'       => [
            'label'   => esc_html__( 'Trigger animation', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'mouseenter' => 'mouseenter',
                'click' => 'click',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'mouseenter',
          ],
          'animation'       => [
            'label'       => esc_html__( 'Animation', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'fade' => 'fade',
                'scale' => 'scale',
                'shift-toward' => 'shift-toward',
                'shift-away' => 'shift-away',
                'perspective' => 'perspective',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'fade',
          ],
          'inertia'       => [
            'label'   => esc_html__( 'Inertia', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'true' => 'true',
                'false' => 'false',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'true',
          ],
          'followcursor'       => [
            'label'       => esc_html__( 'Follow cursor', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'false' => 'false',
                'true' => 'true',
                'horizontal' => 'horizontal',
                'vertical' => 'vertical',
                'initial' => 'initial',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'false',
          ],
          'hideonclick'       => [
            'label'   => esc_html__( 'Hide on click', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'true' => 'true',
                'false' => 'false',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'true',
          ],
          'interactive'       => [
            'label'   => esc_html__( 'Interactive', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'true' => 'true',
                'false' => 'false',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'true',
          ],
          'maxwidth'       => [
            'type'    => 'text',
            'label'   => esc_html__( 'Max width', 'bricks' ),
            'placeholder' => 'none',
            'inline' => true,
            'hasDynamicData' => false,
          ],
          'placement'       => [
            'label'       => esc_html__( 'Placement', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'top' => 'top',
                'left' => 'left',
                'right' => 'right',
                'bottom' => 'bottom',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'top',
          ],
          'zindex'       => [
            'type'    => 'text',
            'label'   => esc_html__( 'zIndex', 'bricks' ),
            'placeholder' => '9999',
            'inline' => true,
            'hasDynamicData' => false,
          ],
          'touch'       => [
            'label'   => esc_html__( 'Touch', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'true' => 'true',
                'false' => 'false',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'false',
          ],
        ],
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'tippy-brickscore', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_tippy.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);

    wp_enqueue_script( 'popper-js', NEXTBRICKS_PLUGIN_URL . 'local_assets/tippy/bc_popper.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    wp_enqueue_script( 'tippy-js', NEXTBRICKS_PLUGIN_URL . 'local_assets/tippy/bc_tippy.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    wp_enqueue_style( 'tippy-scale-core', NEXTBRICKS_PLUGIN_URL . 'local_assets/tippy/bc_scale.min.css', array(), NEXTBRICKS_VERSION, false);
    wp_enqueue_style( 'tippy-shift-away-core', NEXTBRICKS_PLUGIN_URL . 'local_assets/tippy/bc_shiftaway.min.css', array(), NEXTBRICKS_VERSION, false);
    wp_enqueue_style( 'tippy-shift-toward-core', NEXTBRICKS_PLUGIN_URL . 'local_assets/tippy/bc_shifttoward.min.css', array(), NEXTBRICKS_VERSION, false);
    wp_enqueue_style( 'tippy-perspective-core', NEXTBRICKS_PLUGIN_URL . 'local_assets/tippy/bc_perspective.min.css', array(), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $tippyelements = ! empty( $settings['tippyelements'] ) ? $settings['tippyelements'] : false;

    if ($tippyelements) {
        echo '<div class="bc-list-tippys" data-clases="';
        foreach ( $tippyelements as $tippyelement ) {
            if ( isset($tippyelement['class'])) {
                echo $tippyelement['class'] . 'd4511782';
            }
            else{
                echo 'unset' . 'd4511782';
            }
        }
        echo '" data-content="';
        foreach ( $tippyelements as $tippyelement ) {
            if ( isset($tippyelement['content'])) {
                echo $tippyelement['content'] . 'd4511782';
            }
            else{
                echo 'My Tooltip' . 'd4511782';
            }
        }
        echo '" data-showduration="';
        foreach ( $tippyelements as $tippyelement ) {
            if ( isset($tippyelement['showduration'])) {
                echo $tippyelement['showduration'] . 'd4511782';
            }
            else{
                echo '100' . 'd4511782';
            }
        }
        echo '" data-hideduration="';
        foreach ( $tippyelements as $tippyelement ) {
            if ( isset($tippyelement['hideduration'])) {
                echo $tippyelement['hideduration'] . 'd4511782';
            }
            else{
                echo '50' . 'd4511782';
            }
        }
        echo '" data-arrow="';
        foreach ( $tippyelements as $tippyelement ) {
            if ( isset($tippyelement['arrow'])) {
                echo $tippyelement['arrow'] . 'd4511782';
            }
            else{
                echo 'true' . 'd4511782';
            }
        }
        echo '" data-showdelay="';
        foreach ( $tippyelements as $tippyelement ) {
            if ( isset($tippyelement['showdelay'])) {
                echo $tippyelement['showdelay'] . 'd4511782';
            }
            else{
                echo '100' . 'd4511782';
            }
        }
        echo '" data-hidedelay="';
        foreach ( $tippyelements as $tippyelement ) {
            if ( isset($tippyelement['hidedelay'])) {
                echo $tippyelement['hidedelay'] . 'd4511782';
            }
            else{
                echo '50' . 'd4511782';
            }
        }
        echo '" data-triggeranimation="';
        foreach ( $tippyelements as $tippyelement ) {
            if ( isset($tippyelement['triggeranimation'])) {
                echo $tippyelement['triggeranimation'] . 'd4511782';
            }
            else{
                echo 'mouseenter' . 'd4511782';
            }
        }
        echo '" data-animation="';
        foreach ( $tippyelements as $tippyelement ) {
            if ( isset($tippyelement['animation'])) {
                echo $tippyelement['animation'] . 'd4511782';
            }
            else{
                echo 'fade' . 'd4511782';
            }
        }
        echo '" data-inertia="';
        foreach ( $tippyelements as $tippyelement ) {
            if ( isset($tippyelement['inertia'])) {
                echo $tippyelement['inertia'] . 'd4511782';
            }
            else{
                echo 'true' . 'd4511782';
            }
        }
        echo '" data-followcursor="';
        foreach ( $tippyelements as $tippyelement ) {
            if ( isset($tippyelement['followcursor'])) {
                echo $tippyelement['followcursor'] . 'd4511782';
            }
            else{
                echo 'false' . 'd4511782';
            }
        }
        echo '" data-hideonclick="';
        foreach ( $tippyelements as $tippyelement ) {
            if ( isset($tippyelement['hideonclick'])) {
                echo $tippyelement['hideonclick'] . 'd4511782';
            }
            else{
                echo 'true' . 'd4511782';
            }
        }
        echo '" data-interactive="';
        foreach ( $tippyelements as $tippyelement ) {
            if ( isset($tippyelement['interactive'])) {
                echo $tippyelement['interactive'] . 'd4511782';
            }
            else{
                echo 'true' . 'd4511782';
            }
        }
        echo '" data-maxwidth="';
        foreach ( $tippyelements as $tippyelement ) {
            if ( isset($tippyelement['maxwidth'])) {
                echo $tippyelement['maxwidth'] . 'd4511782';
            }
            else{
                echo 'none' . ' ';
            }
        }
        echo '" data-placement="';
        foreach ( $tippyelements as $tippyelement ) {
            if ( isset($tippyelement['placement'])) {
                echo $tippyelement['placement'] . 'd4511782';
            }
            else{
                echo 'top' . 'd4511782';
            }
        }
        echo '" data-zindex="';
        foreach ( $tippyelements as $tippyelement ) {
            if ( isset($tippyelement['zindex'])) {
                echo $tippyelement['zindex'] . 'd4511782';
            }
            else{
                echo '9999' . 'd4511782';
            }
        }
        echo '" data-touch="';
        foreach ( $tippyelements as $tippyelement ) {
            if ( isset($tippyelement['touch'])) {
                echo $tippyelement['touch'] . 'd4511782';
            }
            else{
                echo 'false' . 'd4511782';
            }
        }
        echo '" data-fontfamilys="';
        foreach ( $tippyelements as $tippyelement ) {
            if ( isset($tippyelement['fontfamily'])) {
                $tippyelement['fontfamily'] = implode(',', array_slice($tippyelement['fontfamily'], 0, 1));
                echo $tippyelement['fontfamily'] . 'd4511782';
            }
            else{
                echo 'Helvetica' . 'd4511782';
            }
        }
        echo '" data-fontcolors="';
        foreach ( $tippyelements as $tippyelement ) {
            if ( isset($tippyelement['fontcolor'])) {
                if (isset($tippyelement['fontcolor']['rgb'])) {
                  $tippyelement = $tippyelement['fontcolor']['rgb'];
                }else if(isset($tippyelement['fontcolor']['raw'])){
                  $tippyelement = $tippyelement['fontcolor']['raw'];
                }else if(isset($tippyelement['fontcolor']['hex'])){
                  $tippyelement = $tippyelement['fontcolor']['hex'];
                }
                echo $tippyelement . 'd4511782';
            }else{
                echo 'black' . 'd4511782';
            }
        }
        echo '" data-fontsizes="';
        foreach ( $tippyelements as $tippyelement ) {
            if ( isset($tippyelement['fontsize'])) {
                echo $tippyelement['fontsize'] . 'd4511782';
            }
            else{
                echo '16px' . 'd4511782';
            }
        }
        echo '" data-backgrounds="';
        foreach ( $tippyelements as $tippyelement ) {
            if (isset($tippyelement['background']) && is_array($tippyelement['background'])) {
                if (isset($tippyelement['background']['color']['rgb'])) {
                  $tippyelement = $tippyelement['background']['color']['rgb'];
                }else if(isset($tippyelement['background']['color']['raw'])){
                  $tippyelement = $tippyelement['background']['color']['raw'];
                }else if(isset($tippyelement['background']['color']['hex'])){
                  $tippyelement = $tippyelement['background']['color']['hex'];
                }
                echo $tippyelement . 'd4511782';
            }else{
                echo 'lightblue' . 'd4511782';
            }
        }
        echo '" data-paddings="';
        foreach ( $tippyelements as $tippyelement ) {
            if (isset($tippyelement['padding']) && is_array($tippyelement['padding'])) {
                $padding = $tippyelement['padding'];

                if (!isset($padding[0])) {
                    $padding[0] = 10;
                }
                if (!isset($padding[1])) {
                    $padding[1] = 30;
                }
                if (!isset($padding[2])) {
                    $padding[2] = 10;
                }
                if (!isset($padding[3])) {
                    $padding[3] = 30;
                }

                $tippyelement['padding'] = implode(',', array_slice($padding, 0, 4));
                echo $tippyelement['padding'] . 'd4511782';
            }else{
                $padding;

                if (!isset($padding[0])) {
                    $padding[0] = 10;
                }
                if (!isset($padding[1])) {
                    $padding[1] = 30;
                }
                if (!isset($padding[2])) {
                    $padding[2] = 10;
                }
                if (!isset($padding[3])) {
                    $padding[3] = 30;
                }

                $tippyelement['padding'] = implode(',', array_slice($padding, 0, 4));
                echo $tippyelement['padding'] . 'd4511782';
            }
        }
        echo '" data-bordercolors="';
        foreach ( $tippyelements as $tippyelement ) {
            if (isset($tippyelement['bordercolor']) && is_array($tippyelement['bordercolor'])) {
                if (isset($tippyelement['bordercolor']['color']['rgb'])) {
                  $tippyelement = $tippyelement['bordercolor']['color']['rgb'];
                }else if(isset($tippyelement['bordercolor']['color']['raw'])){
                  $tippyelement = $tippyelement['bordercolor']['color']['raw'];
                }else if(isset($tippyelement['bordercolor']['color']['hex'])){
                  $tippyelement = $tippyelement['bordercolor']['color']['hex'];
                }
                echo $tippyelement . 'd4511782';
            }else{
                echo 'lightblue' . 'd4511782';
            }
        }
        echo '" data-borderradius="';
        foreach ( $tippyelements as $tippyelement ) {
            if ( isset($tippyelement['borderradius'])) {
                echo $tippyelement['borderradius'] . 'd4511782';
            }
            else{
                echo '100px' . 'd4511782';
            }
        }
        echo '" data-borderwidth="';
        foreach ( $tippyelements as $tippyelement ) {
            if ( isset($tippyelement['borderwidth'])) {
                echo $tippyelement['borderwidth'] . 'd4511782';
            }
            else{
                echo '1px' . 'd4511782';
            }
        }
        echo '" data-arrowcolors="';
        foreach ( $tippyelements as $tippyelement ) {
            if (isset($tippyelement['arrowcolor']) && is_array($tippyelement['arrowcolor'])) {
                if (isset($tippyelement['arrowcolor']['color']['rgb'])) {
                  $tippyelement = $tippyelement['arrowcolor']['color']['rgb'];
                }else if(isset($tippyelement['arrowcolor']['color']['raw'])){
                  $tippyelement = $tippyelement['arrowcolor']['color']['raw'];
                }else if(isset($tippyelement['arrowcolor']['color']['hex'])){
                  $tippyelement = $tippyelement['arrowcolor']['color']['hex'];
                }
                echo $tippyelement . 'd4511782';
            }else{
                echo 'lightblue' . 'd4511782';
            }
        }
        echo '"></div>';
    }
  }
}

