<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Sub_Offcanvas extends \Bricks\Element {
  public $name         = 'suboffcanvas';
  public $icon         = 'ti-layout-width-full';
  public $tag      = 'div';
  public $scripts      = ['multioffcanvasmenu'];
  public $nestable     = true;

  public function get_label() {
    return esc_html__( 'Sub OffCanvas', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'section' => 'section',
          'nav' => 'nav',
          'aside' => 'aside',
          'header' => 'header',
          'footer' => 'footer',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['note'] = [
      'tab' => 'content',
      'description' => sprintf(html_entity_decode(esc_html__( 'Toggles will Open/Close the Sub OffCanvas. The same class can be used for both opening and closing.', 'bricks' )))
    ];    
    $this->controls['opentoggle'] = [
        'label'       => esc_html__( 'Open toggle', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'placeholder' => '.className',
    ];
    $this->controls['closetoggle'] = [
        'label'       => esc_html__( 'Close toggle', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'placeholder' => '.className',
    ];
    $this->controls['openbuilder'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Open at the builder', 'bricks' ),
      'type'     => 'checkbox',
    ];
    $this->controls['openbuilder'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Open at the builder', 'bricks' ),
      'type'     => 'checkbox',
    ];

    $this->controls['styleSeparator'] = [
        'label'      => esc_html__( 'Style', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['padding'] = [
      'label'       => esc_html__( 'Padding', 'bricks' ),
      'type'        => 'spacing',
      'css'     => [
          [
            'property' => 'padding',
            'selector' => '',
          ],
      ],
  ];
    $this->controls['width'] = [
        'label'       => esc_html__( 'Width', 'bricks' ),
        'type'        => 'number',
        'units'      => true,
        'inline'      => true,
        'css'     => [
            [
              'property' => 'width',
              'selector' => '',
            ],
        ],
        'placeholder' => '50vw',
    ];
    $this->controls['height'] = [
        'label'       => esc_html__( 'Height', 'bricks' ),
        'type'        => 'number',
        'units'      => true,
        'inline'      => true,
        'css'     => [
            [
              'property' => 'height',
              'selector' => '',
            ],
        ],
        'placeholder' => '100vh',
    ];
    $this->controls['background'] = [
        'label'       => esc_html__( 'Background', 'bricks' ),
        'type'        => 'background',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'background',
              'selector' => '',
            ],
        ],
    ];
    $this->controls['border'] = [
        'label'       => esc_html__( 'Border', 'bricks' ),
        'type'        => 'border',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'border',
              'selector' => '',
            ],
        ],
    ];
    $this->controls['boxShadow'] = [
        'label'       => esc_html__( 'Box shadow', 'bricks' ),
        'type'        => 'box-shadow',
        'inline'      => true,
        'css'     => [
            [
              'property' => 'box-shadow',
              'selector' => '',
            ],
        ],
    ];

    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['subcanvasduration'] = [
        'label'       => esc_html__( 'Duration', 'bricks' ),
        'type'        => 'number',
        'unit'        => 's',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--subcanvas-duration',
              'selector' => '',
            ],
          ],
        'placeholder' => '1s',
    ];
    $this->controls['subcanvaseasing'] = [
        'label'       => esc_html__( 'CSS Easing', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'css'     => [
            [
              'property' => '--subcanvas-easing',
              'selector' => '',
            ],
          ],
        'placeholder' => 'cubic-bezier(.33,1,.68,1)',
    ];
  }

  public function enqueue_scripts() {
    wp_enqueue_script( 'multioffcanvas-menu-js', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_multioffcanvas.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $openbuilder = ! empty( $settings['openbuilder'] ) ? $settings['openbuilder'] : 0;
    $opentoggle = ! empty( $settings['opentoggle'] ) ? $settings['opentoggle'] : '';
    $closetoggle = ! empty( $settings['closetoggle'] ) ? $settings['closetoggle'] : '';

    $this->set_attribute( '_root', 'class', 'bc-multi-offcanvas-menu__subcanvas' );
    $this->set_attribute( '_root', 'tabindex', '0' );

    $output = "<{$this->tag} {$this->render_attributes( '_root' )}
        data-opentoggle='{$opentoggle}'
        data-closetoggle='{$closetoggle}'
        data-open-builder='{$openbuilder}'>";
    $output .= Frontend::render_children( $this ); //Menu items
    $output .= "</{$this->tag}>";

    echo $output;
  }
}