<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Mousefill_Title extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'bc_mousefill_title';
  public $icon         = 'ti-text';
  public $tag      = 'h3';
  public $scripts      = ['bc_mousefill_title'];

  public function get_label() {
    return esc_html__( 'Mousefill Title', 'bricks' );
  }

  public function set_control_groups() {
    $this->control_groups['gradient'] = [
      'title' => esc_html__( 'Gradient', 'bricks' ),
      'tab'   => 'content',
    ];
  }

  public function set_controls() {
    $this->controls['inner_title'] = [
      'tab'            => 'content',
      'type'           => 'text',
	    'hasDynamicData' => 'text',
      'default'        => esc_html__( 'Mousefill Title', 'bricks' ),
      'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];

    $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'h1' => 'h1',
            'h2' => 'h2',
            'h3' => 'h3',
            'h4' => 'h4',
            'h5' => 'h5',
            'h6' => 'h6',
            'p' => 'p',
            'span' => 'span',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'h3',
        'default'     => 'h3',
    ];
    $this->controls['customTag'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Custom tag', 'bricks' ),
			'type'        => 'text',
			'inline'      => true,
			'placeholder' => 'h3',
			'required'    => [ 'tag', '=', 'custom' ],
    ];

    $this->controls['link'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Link to', 'bricks' ),
      'type'  => 'link',
    ];

    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['titleTypography'] = [
        'tab'     => 'content',
        'label'   => esc_html__( 'Typography', 'bricks' ),
        'type'    => 'typography',
        'css'     => [
          [
            'property' => 'typography',
            'selector' => '',
          ],
        ],
        'exclude' => [
            [
              'color'
            ],
        ],
        'default' => [
          'font-size'      => '64px',
          'font-weight'    => '700',
          'text-transform' => 'uppercase',
        ],
    ];
    $this->controls['fillColor'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Fill color', 'bricks' ),
        'type'     => 'color',
        'css'     => [
            [
                'property' => '--fill-color',
                'selector' => '',
            ],
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
    ];
    $this->controls['strokeColor'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Stroke color', 'bricks' ),
        'type'     => 'color',
        'css'     => [
            [
                'property' => '--stroke-color',
                'selector' => '',
            ],
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
    ];
    $this->controls['strokeWidth'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Stroke width', 'bricks' ),
        'type'     => 'number',
        'units'     => true,
        'css'     => [
            [
                'property' => '--stroke-width',
                'selector' => '',
            ],
        ],
        'placeholder' => '3px',
        'default' => '2px',
    ];
    $this->controls['enableshadow'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label'    => esc_html__( 'Enable shadow', 'bricks' ),
        'type'     => 'checkbox',
        'default' => false,
    ];

    /*animation*/
    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];
    $this->controls['trigger'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Trigger', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'this',
    ];
    $this->controls['duration'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'placeholder' => '0.3s',
    ];
    $this->controls['easing'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'GSAP easing', 'bricks' ),
        'type' => 'select',
        'options'     => [
            'none' => 'none',
            'power1' => 'power1',
            'power2' => 'power2',
            'power3' => 'power3',
            'power4' => 'power4',
            'back' => 'back',
            'bounce' => 'bounce',
            'circ' => 'circ',
            'elastic' => 'elastic',
            'expo' => 'expo',
            'sine' => 'sine',
            'steps' => 'steps',
            'custom' => 'custom'
        ],
        'inline' => true,
        'placeholder' => 'power2',
    ];
    $this->controls['customEasing'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Custom easing', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'back.out(1.7)',
      'default' => 'back.out(1.7)',
      'required' => [ 'easing', '=', 'custom' ],
    ];


    //Padding from style tab applied to the root without link and to the link if exists
    $this->controls['_padding'] = [
      'tab'   => 'style',
      'group' => '_layout',
      'label' => esc_html__( 'Padding', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'padding',
          'selector' => '&:not(:has(> a)), > a',
        ]
      ],
      'default' => [
        'top'    => 0,
        'right'  => 0,
        'bottom' => 0,
        'left'   => 0,
      ],
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'bc_mousefill_title', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_mousefill_title.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';
    $enableshadow    = ! empty( $settings['enableshadow'] ) ? $settings['enableshadow'] : 0;
    $trigger    = ! empty( $settings['trigger'] ) ? $settings['trigger'] : 'this';
    $duration    = ! empty( $settings['duration'] ) ? $settings['duration'] : '0.3s';
    $easing    = ! empty( $settings['easing'] ) ? $settings['easing'] : 'power2';
    if ($easing === 'custom') {
      $easing = ! empty( $settings['customEasing'] ) ? $settings['customEasing'] : 'power2';
    }

    if($enableshadow != 0){
        $this->set_attribute( '_root', 'data-shadow', 'true' );
    }

    $this->set_attribute( '_root', 'class', 'bc-mousefill-title' );
    $this->set_attribute( '_root', 'data-trigger', $trigger);
    $this->set_attribute( '_root', 'data-duration', $duration);
    $this->set_attribute( '_root', 'data-easing', $easing);

    if ( ! empty( $settings['link'] ) ) {
			$this->set_link_attributes( '_link', $settings['link'] );
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}>
        <a class='bc-mousefill-title__anchor' {$this->render_attributes( '_link' )}>
          <span>$inner_title</span>
        </a>
      </{$this->tag}>
      ";
		}else{
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}>
        <span>$inner_title</span>
      </{$this->tag}>
      ";
    }

	echo $output;
  }
}
