<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_Glowing_Button extends \Bricks\Element {
  public $category     = 'Next Bricks - Buttons';
  public $name         = 'glowingbutton';
  public $icon         = 'fa-solid fa-square-minus';
  public $tag      = 'div';
  public $scripts      = ['glowing_button'];

  public function get_label() {
    return esc_html__( 'Glowing Button', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'div' => 'div',
          'span' => 'span',
          'button' => 'button',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'div',
      'default'     => 'div',
  ];
  $this->controls['customTag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Custom tag', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => 'div',
      'required'    => [ 'tag', '=', 'custom' ],
  ];
    $this->controls['inner_title'] = [
        'tab'            => 'content',
        'type'           => 'text',
        'hasDynamicData' => 'text',
        'default'        => esc_html__( 'Glowing Button', 'bricks' ),
        'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];

    $this->controls['iconsSeparator'] = [
      'label'      => esc_html__( 'Icons', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['includeLeftIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Left Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['leftIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .bc-glowing-button__left-icon',
        ],
      ],
      'required'   => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .bc-glowing-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .bc-glowing-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
    ];
    $this->controls['leftIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .bc-glowing-button__left-icon',
        ],
      ],
      'required' => [ 'includeLeftIcon', '=', true ],
      'default' => [
        'hex' => '#000000',
      ],
    ];
    $this->controls['includeRightIcon'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Right Icon', 'bricks' ),
      'type' => 'checkbox',
      'default' => false,
    ];
    $this->controls['rightIcon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type' => 'icon',
      'css' => [
        [
          'selector' => '&{pseudo} .bc-glowing-button__right-icon',
        ],
      ],
      'required'   => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconMargin'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Margin', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'margin',
          'selector' => '&{pseudo} .bc-glowing-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconSize'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Size', 'bricks' ),
      'type'  => 'number',
      'units' => true,
      'css'   => [
        [
          'property' => 'font-size',
          'selector' => '&{pseudo} .bc-glowing-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
    ];
    $this->controls['rightIconColor'] = [
      'tab'   => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'  => 'color',
      'css'   => [
        [
          'property' => 'color',
          'selector' => '&{pseudo} .bc-glowing-button__right-icon',
        ],
      ],
      'required' => [ 'includeRightIcon', '=', true ],
      'default' => [
        'hex' => '#000000',
      ],
    ];

    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['padding'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Padding', 'bricks' ),
      'type'        => 'spacing',
      'css'     => [
          [
            'property' => 'padding',
            'selector' => '&{pseudo} .bc-glowing-button__background',
          ],
      ],
      'placeholder' => [
        'top' => 20,
        'right' => 40,
        'bottom' => 20,
        'left' => 40,
      ],
      'default' => [
        'top' => '15px',
        'right' => '30px',
        'bottom' => '15px',
        'left' => '30px',
      ],
    ];
    $this->controls['typography'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Typography', 'bricks' ),
        'type'        => 'typography',
        'css'     => [
            [
              'property' => 'typography',
              'selector' => '&{pseudo} .bc-glowing-button__title',
            ],
        ],
        'exclude' => [
          'color'
        ],
    ];
    $this->controls['textcolor'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Color', 'bricks' ),
      'type'        => 'color',
      'css'     => [
          [
            'property' => '--color',
            'selector' => '&{pseudo} .bc-glowing-button__title',
          ],
      ],
  ];
    $this->controls['background'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Background', 'bricks' ),
        'type'        => 'background',
        'css'     => [
            [
              'property' => 'background',
              'selector' => '&{pseudo} .bc-glowing-button__background',
            ],
        ],
      'default' => [
        'color' => [
          'hex' => '#ffffff',
        ],
      ],
    ];
    $this->controls['border'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Border', 'bricks' ),
      'type'        => 'border',
      'css'     => [
          [
            'property' => 'border',
            'selector' => '',
          ],
      ],
      'exclude' => [
        'radius',
      ],
    ];
    $this->controls['borderradius'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Border radius', 'bricks' ),
      'type'  => 'border',
      'css'     => [
          [
            'property' => 'border-radius',
            'selector' => '&{pseudo}',
          ],
          [
            'property' => 'border-radius',
            'selector' => '&{pseudo} .bc-glowing-button__background',
          ],
      ],
      'exclude' => [
        'width',
        'style',
        'color',
      ],
      'default' => [
          'width' => [
              'top' => '15px',
              'right' => '15px',
              'bottom' => '15px',
              'left' => '15px',
          ],
      ],
  ];

  $this->controls['sparkSeparator'] = [
    'label'      => esc_html__( 'Spark', 'bricks' ),
    'type'       => 'separator',
  ];
    $this->controls['sparkdimensions'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Dimensions', 'bricks' ),
        'type'  => 'number',
        'units' => true,
        'inline'        => true,
        'small'        => true,
        'css'     => [
            [
              'property' => '--dimensions',
              'selector' => '',
            ],
        ],
        'placeholder' => '1px',
        'default' => '1px',
    ];
    $this->controls['sparkduration'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Animation duration', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline'        => true,
        'small'        => true,
        'css'     => [
            [
              'property' => '--animation-duration',
              'selector' => '&{pseudo} .bc-glowing-button__border-gradient',
            ],
        ],
        'placeholder' => '3s',
    ];
    $this->controls['sparkfirstcolor'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Color', 'bricks' ),
        'type'        => 'color',
        'css'     => [
            [
              'property' => '--first-color',
              'selector' => '&{pseudo} .bc-glowing-button__border-gradient',
            ],
        ],
    ];
    $this->controls['sparksecondcolor'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Path color', 'bricks' ),
        'type'        => 'color',
        'css'     => [
            [
              'property' => '--second-color',
              'selector' => '&{pseudo} .bc-glowing-button__border-gradient',
            ],
        ],
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'bcglowingbutton', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_glowing_button.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';

    if ( ! empty( $settings['link'] ) ) {
      $this->set_link_attributes( '_root', $settings['link'] );
      $root_tag = 'a';
    }else{
      $root_tag = $this->tag;
    }

    $includeLeftIcon = ! empty( $settings['includeLeftIcon'] ) ? $settings['includeLeftIcon'] : 0;
    $includeRightIcon = ! empty( $settings['includeRightIcon'] ) ? $settings['includeRightIcon'] : 0;
    if ( $includeLeftIcon !== 0 ) {
      $leftIcon = self::render_icon( $settings['leftIcon'], [ 'bc-glowing-button__left-icon' ] );
    }else{
      $leftIcon = '';
    }
    if ( $includeRightIcon !== 0 ) {
      $rightIcon = self::render_icon( $settings['rightIcon'], [ 'bc-glowing-button__right-icon' ] );
    }else{
      $rightIcon = '';
    }

    $this->set_attribute( '_root', 'class', 'bc-glowing-button' );

    $output = "<$root_tag {$this->render_attributes( '_root' )}>
    <div class='bc-glowing-button__background'>
        <span class='bc-glowing-button__title'>$leftIcon$inner_title$rightIcon</span>
    </div>
    <div class='bc-glowing-button__border-gradient'></div>
    ";

    $output .= "</$root_tag>";

	echo $output;
  }
}



