<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Decode_Reveal extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'decode-reveal';
  public $icon         = 'ti-text';
  public $tag      = 'h3';
  public $css_selector = '';
  public $scripts      = ['decode_reveal'];

  public function get_label() {
    return esc_html__( 'Decode Reveal', 'bricks' );
  }

  public function set_control_groups() {
    $this->control_groups['gradient'] = [
      'title' => esc_html__( 'Gradient', 'bricks' ),
      'tab'   => 'content',
    ];
  }

  public function set_controls() {
    $this->controls['inner_title'] = [
      'tab'            => 'content',
      'type'           => 'text',
	    'hasDynamicData' => 'text',
      'default'        => esc_html__( 'Decode Reveal', 'bricks' ),
      'placeholder'    => esc_html__( 'Title goes here ..', 'bricks' ),
    ];
    $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
            'h1' => 'h1',
            'h2' => 'h2',
            'h3' => 'h3',
            'h4' => 'h4',
            'h5' => 'h5',
            'h6' => 'h6',
            'p' => 'p',
            'span' => 'span',
            'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'h3',
        'default'     => 'h3',
    ];
    $this->controls['customTag'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Custom tag', 'bricks' ),
			'type'        => 'text',
			'inline'      => true,
			'placeholder' => 'h3',
			'required'    => [ 'tag', '=', 'custom' ],
    ];
    $this->controls['link'] = [
        'tab'   => 'content',
        'label' => esc_html__( 'Link to', 'bricks' ),
        'type'  => 'link',
    ];
    $this->controls['styleSeparator'] = [
      'label'      => esc_html__( 'Style', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['titleTypography'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Typography', 'bricks' ),
      'type'    => 'typography',
            'css'     => [
        [
          'property' => 'typography',
          'selector' => '.bc-decode-reveal__element',
        ],
      ],
      'default' => [],
    ];

    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];

    $this->controls['disablebuilder'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
      'type'     => 'checkbox',
      'default' => false,
    ];

    $this->controls['decodealphabet'] = [
        'hasDynamicData' => false,
        'tab'         => 'content',
        'label'       => esc_html__( 'Decode alphabet', 'bricks' ),
        'type' => 'textarea',
        'placeholder' => 'abcdefghijklmnopqrstuvwxyz1234567890!@#$^&*()…æ_+-=;[]/~`',
    ];
    $this->controls['from'] = [
          'hasDynamicData' => false,
          'tab'         => 'content',
          'label'       => esc_html__( 'From', 'bricks' ),
          'type'        => 'select',
          'options'     => [
              '-1' => 'left',
              '1' => 'right',
          ],
          'clearable'   => false,
          'inline'      => true,
          'placeholder' => 'left',
    ];
    $this->controls['delay'] = [
          'hasDynamicData' => false,
          'tab' => 'content',
          'label' => esc_html__( 'Delay', 'bricks' ),
          'type' => 'number',
          'unit' => 's',
          'inline' => true,
          'placeholder' => '0s',
    ];
    $this->controls['delayletters'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Delay letters', 'bricks' ),
        'type' => 'number',
        'unit' => 's',
        'inline' => true,
        'placeholder' => '0.07s',
    ];

    $this->controls['scrolltrigger'] = [
        'label'      => esc_html__( 'ScrollTrigger', 'bricks' ),
        'type'       => 'separator',
        'description' => sprintf(esc_html__( 'Scrolltrigger %s', 'bricks' ), '<a href="https://greensock.com/docs/v3/Plugins/ScrollTrigger" target="_blank">documentation</a>'),
    ];
  
    $this->controls['trigger'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Trigger', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'this',
    ];
  
    $this->controls['start'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Start', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder' => 'top bottom',
    ];

    $this->controls['triggerSeparator'] = [
      'label'      => esc_html__( 'Additional Triggers', 'bricks' ),
      'type'       => 'separator',
    ];
  
  $this->controls['animationType'] = [
    'tab' => 'content',
    'label' => esc_html__( 'Trigger on', 'bricks' ),
    'type' => 'select',
    'options'     => [
      'Click' => 'Click',
      'Hover' => 'Hover',
    ],
    'inline' => true,
    'placeholder' => ' ',
  ];

  $this->controls['classTriggerClick'] = [
    'hasDynamicData' => false,
    'tab' => 'content',
    'label' => esc_html__( 'Element', 'bricks' ),
    'type' => 'text',
    'placeholder' => '.className',
    'inline' => true,
    'required' => [ 'animationType', '=', 'Click'],
  ];
    $this->controls['classTriggerHover'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Element', 'bricks' ),
      'type' => 'text',
      'placeholder' => '.className',
      'inline' => true,
      'required' => [ 'animationType', '=', 'Hover'],
    ];

    //Gradient
  $this->controls['titleGradient'] = [
    'group' => 'gradient',
    'tab' => 'content',
    'type' => 'gradient',
    'css' => [
      [
        'property' => 'background-image',
        'selector' => '.char',
      ],
    ],
    'default' => [
      'applyTo' => 'background',
      'gradientType' => 'linear',
      'colors' => [],
      'angle' => '0',
    ],
  ];

    //Padding from style tab applied to the root without link and to the link if exists
    $this->controls['_padding'] = [
      'tab'   => 'style',
      'group' => '_layout',
      'label' => esc_html__( 'Padding', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'padding',
          'selector' => '&:not(:has(> a)), > a',
        ]
      ],
      'default' => [
        'top'    => 0,
        'right'  => 0,
        'bottom' => 0,
        'left'   => 0,
      ],
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'bc-decode-reveal', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_decode_reveal.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $is_builder = bricks_is_builder();
    $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;
    $animationType    = ! empty( $settings['animationType'] ) ? $settings['animationType'] : '';
    $classTriggerClick    = ! empty( $settings['classTriggerClick'] ) ? $settings['classTriggerClick'] : 0;
    $classTriggerHover    = ! empty( $settings['classTriggerHover'] ) ? $settings['classTriggerHover'] : 0;

    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : 'Next Bricks';
    $delay    = ! empty( $settings['delay'] ) ? $settings['delay'] : 0;
    $delayletters    = ! empty( $settings['delayletters'] ) ? $settings['delayletters'] : 0.07;
    $from    = ! empty( $settings['from'] ) ? $settings['from'] : -1;
    $decodealphabet    = ! empty( $settings['decodealphabet'] ) ? $settings['decodealphabet'] : 'abcdefghijklmnopqrstuvwxyz1234567890!@#$^&*()…æ_+-=;[]/~`';
    $trigger    = ! empty( $settings['trigger'] ) ? $settings['trigger'] : 'this';
    $start    = ! empty( $settings['start'] ) ? $settings['start'] : 'top bottom';

    $this->set_attribute( '_root', 'class', 'bc-decode-reveal' );
    $this->set_attribute( '_inner', 'class', 'bc-decode-reveal__element' );

    $hide_attribute = $is_builder ? '' : "\r\n            data-hide=''";

    if ( ! empty( $settings['link'] ) ) {
			$this->set_link_attributes( '_link', $settings['link'] );
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}>
        <a class='bc-decode-reveal__anchor' {$this->render_attributes( '_link' )}>
          <span {$this->render_attributes( '_inner' )}
            " . ($from == -1 ? 'data-from-left' : 'data-from-right') . "=''
            {$hide_attribute}
            data-delay='{$delay}'
            data-delayletters='{$delayletters}'
            data-decodealphabet='{$decodealphabet}'
            data-trigger='{$trigger}'
            data-start='{$start}'
            data-disable-builder='{$disablebuilder}'
            data-animationType='{$animationType}'
            data-classTriggerClick='{$classTriggerClick}'
            data-classTriggerHover='{$classTriggerHover}'
          >$inner_title</span>
        </a>
      </{$this->tag}>
      ";
		}else{
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}>
        <span {$this->render_attributes( '_inner' )}
          " . ($from == -1 ? 'data-from-left' : 'data-from-right') . "=''
          {$hide_attribute}
          data-delay='{$delay}'
          data-delayletters='{$delayletters}'
          data-decodealphabet='{$decodealphabet}'
          data-trigger='{$trigger}'
          data-start='{$start}'
          data-disable-builder='{$disablebuilder}'
          data-animationType='{$animationType}'
          data-classTriggerClick='{$classTriggerClick}'
          data-classTriggerHover='{$classTriggerHover}'
        >$inner_title</span>
      </{$this->tag}>
      ";
    }

    echo $output;
  }
}
