<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Bc_Counter extends \Bricks\Element {
  public $category     = 'Next Bricks - Texts';
  public $name         = 'bc-counter';
  public $icon         = 'ion-ios-timer';
  public $tag      = 'h3';
  public $scripts      = ['bc_counter'];

  public function get_label() {
    return esc_html__( 'Counter', 'bricks' );
  }

  public function set_controls() {
    $this->controls['tag'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'HTML tag', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'h1' => 'h1',
          'h2' => 'h2',
          'h3' => 'h3',
          'h4' => 'h4',
          'h5' => 'h5',
          'h6' => 'h6',
          'p' => 'p',
          'span' => 'span',
          'custom' => 'custom',
      ],
      'clearable'   => false,
      'inline'      => true,
      'placeholder' => 'h3',
      'default'     => 'h3',
  ];
  $this->controls['customTag'] = [
    'tab'         => 'content',
    'label'       => esc_html__( 'Custom tag', 'bricks' ),
    'type'        => 'text',
    'inline'      => true,
    'placeholder' => 'h3',
    'required'    => [ 'tag', '=', 'custom' ],
  ];
  $this->controls['link'] = [
    'tab'   => 'content',
    'label' => esc_html__( 'Link to', 'bricks' ),
    'type'  => 'link',
  ];
  $this->controls['styleSeparator'] = [
    'label'      => esc_html__( 'Style', 'bricks' ),
    'type'       => 'separator',
  ];
    $this->controls['titleTypography'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Typography', 'bricks' ),
      'type'    => 'typography',
        'css'     => [
        [
          'property' => 'typography',
          'selector' => '.bc-counter__counter',
        ],
      ],
    ];

    $this->controls['counterSeparator'] = [
      'label'      => esc_html__( 'Counter', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['startfrom'] = [
      'label'   => esc_html__( 'Count from', 'bricks' ),
      'tab'            => 'content',
      'type'           => 'number',
	    'hasDynamicData' => true,
      'placeholder'    => esc_html__( '0', 'bricks' ),
    ];
    $this->controls['inner_title'] = [
      'label'   => esc_html__( 'Count to', 'bricks' ),
      'tab'            => 'content',
      'type'           => 'number',
	    'hasDynamicData' => true,
      'default' => '5000',
      'placeholder'    => esc_html__( '0', 'bricks' ),
    ];
    $this->controls['enableseparator'] = [
      'label' => esc_html__( 'Enable thousands', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => false,
  ];
    $this->controls['separator'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Thousands Separator', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => ',',
      'required' => [ 'enableseparator', '=', true],
    ];

    $this->controls['enableDecimals'] = [
      'label' => esc_html__( 'Enable decimals', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => false,
  ];
  $this->controls['noteDecimals'] = [
    'tab' => 'content',
    'description' => sprintf(html_entity_decode(esc_html__( 'Decimals separator must match your decimals at "Count from" and "Count to"', 'bricks' ))),
    'required' => [ 'enableDecimals', '=', true],
  ];
    $this->controls['decimalSeparator'] = [
      'tab'         => 'content',
      'label'       => esc_html__( 'Decimals Separator', 'bricks' ),
      'type'        => 'text',
      'inline'      => true,
      'placeholder' => '.',
      'required' => [ 'enableDecimals', '=', true],
    ];

    $this->controls['prefixsufixSeparator'] = [
      'label'      => esc_html__( 'Prefix & Sufix', 'bricks' ),
      'type'       => 'separator',
  ];
    $this->controls['prefix'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Prefix', 'bricks' ),
      'type' => 'text',
      'inline'      => true,
      'hasDynamicData' => true,
      'placeholder' => '',
    ];
    $this->controls['prefixTypography'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Prefix typography', 'bricks' ),
      'type'    => 'typography',
        'css'     => [
        [
          'property' => 'typography',
          'selector' => '.bc-counter__prefix',
        ],
      ],
    ];
    $this->controls['sufix'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Sufix', 'bricks' ),
      'type' => 'text',
      'inline'      => true,
      'hasDynamicData' => true,
      'placeholder' => '',
    ];
    $this->controls['sufixTypography'] = [
      'tab'     => 'content',
      'label'   => esc_html__( 'Sufix typography', 'bricks' ),
      'type'    => 'typography',
        'css'     => [
        [
          'property' => 'typography',
          'selector' => '.bc-counter__sufix',
        ],
      ],
    ];

    $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
    ];

    $this->controls['disablebuilder'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label'    => esc_html__( 'Disable at the builder', 'bricks' ),
      'type'     => 'checkbox',
      'default' => false,
    ];
    
    $this->controls['trigger'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Trigger', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'this',
    ];
    $this->controls['start'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Start', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'top bottom',
    ];
    $this->controls['end'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'End', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'false',
    ];
    $this->controls['trigger'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Trigger', 'bricks' ),
      'type' => 'text',
      'inline' => true,
      'placeholder' => 'this',
    ];
    $this->controls['easing'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Easing', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'Default' => 'Default',
          'outQuintic' => 'outQuintic',
          'outCubic' => 'outCubic',
      ],
      'placeholder' => 'Default',
      'inline' => true,
    ];
    $this->controls['duration'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Duration', 'bricks' ),
      'type' => 'number',
      'unit' => 's',
      'inline' => true,
      'placeholder' => '1s',
    ];
    $this->controls['replay'] = [
      'label' => esc_html__( 'Replay on enter back', 'bricks' ),
      'type' => 'checkbox',
      'inline' => true,
      'small' => true,
      'default' => false,
    ];

    $this->controls['triggerSeparator'] = [
      'label'      => esc_html__( 'Additional Triggers', 'bricks' ),
      'type'       => 'separator',
    ];
  
  $this->controls['animationType'] = [
    'tab' => 'content',
    'label' => esc_html__( 'Trigger on', 'bricks' ),
    'type' => 'select',
    'options'     => [
      'Click' => 'Click',
      'Hover' => 'Hover',
    ],
    'inline' => true,
    'placeholder' => ' ',
  ];

  $this->controls['classTriggerClick'] = [
    'hasDynamicData' => false,
    'tab' => 'content',
    'label' => esc_html__( 'Element', 'bricks' ),
    'type' => 'text',
    'placeholder' => '.className',
    'inline' => true,
    'required' => [ 'animationType', '=', 'Click'],
  ];
    $this->controls['classTriggerHover'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Element', 'bricks' ),
      'type' => 'text',
      'placeholder' => '.className',
      'inline' => true,
      'required' => [ 'animationType', '=', 'Hover'],
    ];

    //Padding from style tab applied to the root without link and to the link if exists
    $this->controls['_padding'] = [
      'tab'   => 'style',
      'group' => '_layout',
      'label' => esc_html__( 'Padding', 'bricks' ),
      'type'  => 'spacing',
      'css'   => [
        [
          'property' => 'padding',
          'selector' => '&:not(:has(> a)), > a',
        ]
      ],
    ];
  }

  public function enqueue_scripts() {
    wp_enqueue_script( 'bc-counter', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_counter.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);

    wp_enqueue_script( 'bc-countup', NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_countup.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $disablebuilder    = ! empty( $settings['disablebuilder'] ) ? $settings['disablebuilder'] : 0;
    $animationType    = ! empty( $settings['animationType'] ) ? $settings['animationType'] : '';
    $classTriggerClick    = ! empty( $settings['classTriggerClick'] ) ? $settings['classTriggerClick'] : 0;
    $classTriggerHover    = ! empty( $settings['classTriggerHover'] ) ? $settings['classTriggerHover'] : 0;

    $startfrom    = ! empty( $settings['startfrom'] ) ? $settings['startfrom'] : '0';
    $inner_title    = ! empty( $settings['inner_title'] ) ? $settings['inner_title'] : '0';
    $enableseparator    = ! empty( $settings['enableseparator'] ) ? $settings['enableseparator'] : 0;
    $separator    = ! empty( $settings['separator'] ) ? $settings['separator'] : ',';
    $prefix    = ! empty( $settings['prefix'] ) ? $settings['prefix'] : '';
    $sufix    = ! empty( $settings['sufix'] ) ? $settings['sufix'] : '';

    $trigger    = ! empty( $settings['trigger'] ) ? $settings['trigger'] : 'this';
    $start    = ! empty( $settings['start'] ) ? $settings['start'] : 'top bottom';
    $end    = ! empty( $settings['end'] ) ? $settings['end'] : 'false';
    $duration    = ! empty( $settings['duration'] ) ? $settings['duration'] : 1;
    $easing    = ! empty( $settings['easing'] ) ? $settings['easing'] : 'Default';
    $replay    = ! empty( $settings['replay'] ) ? $settings['replay'] : 0;

    //decimals
    $enableDecimals = ! empty( $settings['enableDecimals'] ) ? $settings['enableDecimals'] : 0;
    $decimalSeparator = ! empty( $settings['decimalSeparator'] ) ? $settings['decimalSeparator'] : '.';

    $this->set_attribute( '_root', 'class', 'bc-counter' );
    $this->set_attribute( '_root_class', 'class', 'bc-counter__wrapper' );
    $this->set_attribute( '_inner', 'class', 'bc-counter__counter' );
    
    // Data attributes will be added inline to avoid Bricks bug

    if ( ! empty( $settings['link'] ) ) {
			$this->set_link_attributes( '_link', $settings['link'] );
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}>
        <a class='bc-counter__anchor' {$this->render_attributes( '_link' )}>
          <span {$this->render_attributes( '_root_class' )}>";
          if($prefix != ''){
            $output .= "<span class='bc-counter__prefix'>$prefix</span>";
          }
          $output .= "<span {$this->render_attributes( '_inner' )}
          data-enable-decimals='{$enableDecimals}'
          data-decimal-separator='{$decimalSeparator}'
          data-value='{$inner_title}'
          data-startfrom='{$startfrom}'
          data-enableseparator='{$enableseparator}'
          data-separator='{$separator}'
          data-prefix='{$prefix}'
          data-sufix='{$sufix}'
          data-trigger='{$trigger}'
          data-start='{$start}'
          data-end='{$end}'
          data-duration='{$duration}'
          data-easing='{$easing}'
          data-replay='{$replay}'
          data-disable-builder='{$disablebuilder}'
          data-animationType='{$animationType}'
          data-classTriggerClick='{$classTriggerClick}'
          data-classTriggerHover='{$classTriggerHover}'>$startfrom</span>";
          if($sufix != ''){
            $output .= "<span class='bc-counter__sufix'>$sufix</span>";
          }
          $output .= "</span> 
        </a>
      </{$this->tag}>
      ";
		}else{
      $output ="
      <{$this->tag} {$this->render_attributes( '_root' )}>
        <span {$this->render_attributes( '_root_class' )}>";
        if($prefix != ''){
          $output .= "<span class='bc-counter__prefix'>$prefix</span>";
        }
        $output .= "<span {$this->render_attributes( '_inner' )}
        data-enable-decimals='{$enableDecimals}'
        data-decimal-separator='{$decimalSeparator}'
        data-value='{$inner_title}'
        data-startfrom='{$startfrom}'
        data-enableseparator='{$enableseparator}'
        data-separator='{$separator}'
        data-prefix='{$prefix}'
        data-sufix='{$sufix}'
        data-trigger='{$trigger}'
        data-start='{$start}'
        data-end='{$end}'
        data-duration='{$duration}'
        data-easing='{$easing}'
        data-replay='{$replay}'
        data-disable-builder='{$disablebuilder}'
        data-animationType='{$animationType}'
        data-classTriggerClick='{$classTriggerClick}'
        data-classTriggerHover='{$classTriggerHover}'>$startfrom</span>";
        if($sufix != ''){
          $output .= "<span class='bc-counter__sufix'>$sufix</span>";
        }
        $output .= "</span> 
      </{$this->tag}>
      ";
    }

    echo $output;
  }
}

