<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class B_BeforeAfter_Image extends \Bricks\Element {
  public $category     = 'Next Bricks - Medias';
  public $name         = 'beforeafte-image';
  public $icon         = 'ti-split-h';
  public $css_selector = '';
  public $scripts      = ['beforeafter_image'];

  public function get_label() {
    return esc_html__( 'Before/After Image', 'bricks' );
  }

  public function set_control_groups() {
    $this->control_groups['beforeimage'] = [
        'title' => esc_html__( 'Before Image', 'bricks' ),
        'tab'   => 'content',
    ];
    $this->control_groups['afterimage'] = [
        'title' => esc_html__( 'After Image', 'bricks' ),
        'tab'   => 'content',
    ];
  }

  public function set_controls() {
    $this->controls['width'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'    => 'number',
        'units'    => true,
        'css'     => [
          [
            'property' => 'width',
            'selector' => '',
          ],
        ],
        'placeholder'    => 'auto',
        'inline' => true,
        'rerender'    => true,
        'default' => '100%',
    ];
    $this->controls['height'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Height', 'bricks' ),
        'type'    => 'number',
        'units'    => true,
        'css'     => [
          [
            'property' => 'height',
            'selector' => '',
          ],
        ],
        'placeholder'    => 'auto',
        'inline' => true,
        'rerender'    => true,
        'default' => '100%',
    ];
    $this->controls['showafter'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Show Distance', 'bricks' ),
        'type' => 'text',
        'inline' => true,
        'placeholder'    => '150',
        'small' => true,
    ];




    $this->controls['iconSeparator'] = [
      'label'      => esc_html__( 'Arrows', 'bricks' ),
      'type'       => 'separator',
    ];
    $this->controls['icon'] = [
      'tab' => 'content',
      'label' => esc_html__( 'Icon', 'bricks' ),
      'type'        => 'select',
      'options'     => [
          'type1' => 'Chevron',
          'type2' => 'Caret',
          'type3' => 'Angles',
          'type4' => 'Square Caret',
          'type5' => 'Arrows',
      ],
      'inline' => true,
      'placeholder' => 'Chevron',
    ];
    $this->controls['arrowcolor'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Color', 'bricks' ),
      'type'    => 'color',
      'css'     => [
        [
          'property' => 'fill',
          'selector' => '.bc-before-after-image__scroller--thumb svg',
        ],
      ],
    ];
    $this->controls['dimensions'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Dimensions', 'bricks' ),
      'type'    => 'number',
      'units' => true,
      'css'     => [
        [
          'property' => '--dimensions',
          'selector' => '.bc-before-after-image__scroller--thumb',
        ],
      ],
      'placeholder'    => '15px',
      'inline' => true,
      'default' => '15px',
    ];
    $this->controls['distancebetweenarrows'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Gap between arrows', 'bricks' ),
      'type'    => 'number',
      'units' => true,
      'css'     => [
        [
          'property' => 'column-gap',
          'selector' => '.bc-before-after-image__scroller--thumb',
        ],
      ],
      'placeholder'    => '5px',
      'inline' => true,
      'default' => '5px',
    ];

      $this->controls['thumbSeparator'] = [
        'label'      => esc_html__( 'Thumb', 'bricks' ),
        'type'       => 'separator',
      ];
      $this->controls['thumbwidth'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'    => 'number',
        'css'     => [
          [
            'property' => 'width',
            'selector' => '.bc-before-after-image__scroller',
          ],
        ],
        'placeholder'    => '50px',
        'inline' => true,
        'units' => true,
        'default' => '50px',
      ];
    $this->controls['thumbheight'] = [
      'hasDynamicData' => false,
      'tab' => 'content',
      'label' => esc_html__( 'Height', 'bricks' ),
      'type'    => 'number',
      'css'     => [
        [
          'property' => 'height',
          'selector' => '.bc-before-after-image__scroller',
        ],
        ],
        'placeholder'    => '50px',
        'inline' => true,
        'units' => true,
        'default' => '50px',
    ];
      $this->controls['thumbborder'] = [
          'hasDynamicData' => false,
          'tab' => 'content',
          'label' => esc_html__( 'Border', 'bricks' ),
          'type'    => 'border',
          'css'     => [
            [
              'property' => 'border',
              'selector' => '.bc-before-after-image__scroller',
            ],
          ],
          'inline' => true,
          'default' => [
              'width' => [
                  'top' => '2px',
                  'right' => '2px',
                  'bottom' => '2px',
                  'left' => '2px',
              ],
              'style' => 'solid',
              'color' => [
                  'hex' => '#ffffff',
              ],
          ],
      ];
      $this->controls['thumbbackground'] = [
          'hasDynamicData' => false,
          'tab' => 'content',
          'label' => esc_html__( 'Background', 'bricks' ),
          'type'    => 'background',
          'css'     => [
            [
              'property' => 'background',
              'selector' => '.bc-before-after-image__scroller',
            ],
          ],
          'default' => [
              'color' => [
                  'hex' => '#000000',
                  'alpha' => 0,
              ],
          ],
      ];

      $this->controls['lineSeparator'] = [
        'label'      => esc_html__( 'Line', 'bricks' ),
        'type'       => 'separator',
      ];
      $this->controls['linecolor'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Color', 'bricks' ),
        'type'    => 'color',
        'css'     => [
          [
            'property' => '--color-line',
            'selector' => '.bc-before-after-image__scroller',
          ],
        ],
        'default' => [
            'hex' => '#ffffff',
        ],
    ];
    $this->controls['linewidth'] = [
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Width', 'bricks' ),
        'type'    => 'number',
        'units'    => true,
        'css'     => [
          [
            'property' => '--width',
            'selector' => '.bc-before-after-image__scroller',
          ],
        ],
        'placeholder'    => '5px',
        'inline' => true,
        'default' => '2px',
    ];
  
      $this->controls['animationSeparator'] = [
        'label'      => esc_html__( 'Animation', 'bricks' ),
        'type'       => 'separator',
      ];
      $this->controls['opacity'] = [
          'hasDynamicData' => false,
          'tab' => 'content',
          'label' => esc_html__( 'Opacity', 'bricks' ),
          'type'    => 'text',
          'css'     => [
            [
              'property' => 'opacity',
              'selector' => '.bc-before-after-image__scroller',
            ],
          ],
          'placeholder'    => '0.8',
          'inline' => true,
          'small' => true,
          'default' => '0.8',
      ];
      $this->controls['opacityduration'] = [
          'tab' => 'content',
          'label' => esc_html__( 'Duration', 'bricks' ),
          'type'    => 'text',
          'css'     => [
            [
              'property' => '--transition-duration',
              'selector' => '.bc-before-after-image__scroller',
            ],
          ],
          'placeholder'    => '0.2s',
          'inline' => true,
          'small' => true,
          'default' => '0.2s',
      ];

    /*Before image*/
    $this->controls['beforeimage'] = [
        'group' => 'beforeimage',
        'hasDynamicData' => true,
        'tab' => 'content',
        'label' => esc_html__( 'Image', 'bricks' ),
        'type' => 'image',
    ];
    $this->controls['beforeimagealt'] = [
        'group' => 'beforeimage',
        'tab' => 'content',
        'label' => esc_html__( 'Alt text', 'bricks' ),
        'type' => 'text',
        'inline' => true,
    ];
    $this->controls['_objectFitBefore'] = [
      'group' => 'beforeimage',
			'label'   => esc_html__( 'Object fit', 'bricks' ),
			'type'    => 'select',
			'inline'  => true,
			'options' => $this->control_options['objectFit'],
      'css' => [
        [
          'property' => 'object-fit',
          'selector' => '.bc-before-after-image__content-image--before',
        ],
      ],
		];
    $this->controls['_objectPositionBefore'] = [
      'group' => 'beforeimage',
      'tab' => 'content',
			'label'  => esc_html__( 'Object position', 'bricks' ),
			'type'   => 'text',
			'inline' => true,
			'dd'     => false,
      'css' => [
        [
          'property' => 'object-position',
          'selector' => '.bc-before-after-image__content-image--before',
        ],
      ],
		];
    $this->controls['beforeimageFilters'] = [
      'group' => 'beforeimage',
      'tab' => 'content',
      'label' => esc_html__( 'Filters', 'bricks' ),
      'type' => 'filters',
      'inline' => true,
      'css' => [
        [
          'property' => 'filter',
          'selector' => '.bc-before-after-image__content-image--before',
        ],
      ],
    ];

    /*After image*/
    $this->controls['afterimage'] = [
        'group' => 'afterimage',
        'hasDynamicData' => true,
        'tab' => 'content',
        'label' => esc_html__( 'Image', 'bricks' ),
        'type' => 'image',
    ];
    $this->controls['afterimagealt'] = [
        'group' => 'afterimage',
        'hasDynamicData' => false,
        'tab' => 'content',
        'label' => esc_html__( 'Alt text', 'bricks' ),
        'type' => 'text',
        'inline' => true,
    ];
    $this->controls['_objectFitAfter'] = [
      'group' => 'afterimage',
			'label'   => esc_html__( 'Object fit', 'bricks' ),
			'type'    => 'select',
			'inline'  => true,
			'options' => $this->control_options['objectFit'],
      'css' => [
        [
          'property' => 'object-fit',
          'selector' => '.bc-before-after-image__content-image--after',
        ],
      ],
		];
    $this->controls['_objectPositionAfter'] = [
      'group' => 'afterimage',
      'tab' => 'content',
			'label'  => esc_html__( 'Object position', 'bricks' ),
			'type'   => 'text',
			'inline' => true,
			'dd'     => false,
      'css' => [
        [
          'property' => 'object-position',
          'selector' => '.bc-before-after-image__content-image--after',
        ],
      ],
		];
    $this->controls['afterimageFilters'] = [
      'group' => 'afterimage',
      'tab' => 'content',
      'label' => esc_html__( 'Filters', 'bricks' ),
      'type' => 'filters',
      'inline' => true,
      'css' => [
        [
          'property' => 'filter',
          'selector' => '.bc-before-after-image__content-image--after',
        ],
      ],
    ];
  }


  public function enqueue_scripts() {
    wp_enqueue_script( 'beforeafter-image-js', NEXTBRICKS_PLUGIN_URL . 'elements/js/bc_beforeafter_image.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
  }

  public function render() {
    $settings = $this->settings;
    $is_builder = bricks_is_builder();
    $showafter = !empty($settings['showafter']) ? $settings['showafter'] : 150;
    $icon = !empty($settings['icon']) ? $settings['icon'] : 'type1';

    // BEFORE IMAGE
    if (isset($settings['beforeimage']['useDynamicData'])) {
        $beforeimage = $this->render_dynamic_data_tag($settings['beforeimage']['useDynamicData'], 'image');
        if (!empty($beforeimage) && isset($beforeimage[0])) {
            $beforeimage_image = wp_get_attachment_url($beforeimage[0]);
            $attachment_id = attachment_url_to_postid($beforeimage_image);
            $beforeimage_metadata = wp_get_attachment_metadata($attachment_id);
            
            $beforeimage_image_width = isset($beforeimage_metadata['width']) ? $beforeimage_metadata['width'] : 1260;
            $beforeimage_image_height = isset($beforeimage_metadata['height']) ? $beforeimage_metadata['height'] : 750;
        }
    }
    else if (isset($settings['beforeimage']['url'])) {
        $beforeimage_image = $settings['beforeimage']['url'];
        $beforeimage_dimensions = @getimagesize($beforeimage_image);
        
        if ($beforeimage_dimensions !== false) {
            $beforeimage_image_width = $beforeimage_dimensions[0];
            $beforeimage_image_height = $beforeimage_dimensions[1];
        } else {
            $beforeimage_image_width = 1260;
            $beforeimage_image_height = 750;
        }
    }
    else {
        $beforeimage_image = 'https://images.pexels.com/photos/4091975/pexels-photo-4091975.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=1';
        $beforeimage_image_width = 1260;
        $beforeimage_image_height = 750;
    }

    // AFTER IMAGE
    if (isset($settings['afterimage']['useDynamicData'])) {
        $afterimage = $this->render_dynamic_data_tag($settings['afterimage']['useDynamicData'], 'image');
        if (!empty($afterimage) && isset($afterimage[0])) {
            $afterimage_image = wp_get_attachment_url($afterimage[0]);
            $attachment_id = attachment_url_to_postid($afterimage_image);
            $afterimage_metadata = wp_get_attachment_metadata($attachment_id);
            
            $afterimage_image_width = isset($afterimage_metadata['width']) ? $afterimage_metadata['width'] : 1260;
            $afterimage_image_height = isset($afterimage_metadata['height']) ? $afterimage_metadata['height'] : 750;
        }
    }
    else if (isset($settings['afterimage']['url'])) {
        $afterimage_image = $settings['afterimage']['url'];
        $afterimage_dimensions = @getimagesize($afterimage_image);
        
        if ($afterimage_dimensions !== false) {
            $afterimage_image_width = $afterimage_dimensions[0];
            $afterimage_image_height = $afterimage_dimensions[1];
        } else {
            $afterimage_image_width = 1260;
            $afterimage_image_height = 750;
        }
    }
    else {
        $afterimage_image = 'https://images.pexels.com/photos/1553963/pexels-photo-1553963.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=1';
        $afterimage_image_width = 1260;
        $afterimage_image_height = 750;
    }

    // Alt texts
    $beforeimagealt = !empty($settings['beforeimagealt']) ? "alt='{$settings['beforeimagealt']}'" : '';
    $afterimagealt = !empty($settings['afterimagealt']) ? "alt='{$settings['afterimagealt']}'" : '';

    if($icon == 'type1'){
      $iconshow = "
      <div class='bc-before-after-image__scroller--thumb'>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 320 512'>
          <path d='M9.4 233.4c-12.5 12.5-12.5 32.8 0 45.3l192 192c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L77.3 256 246.6 86.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-192 192z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 320 512'>
        <path d='M310.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-192 192c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L242.7 256 73.4 86.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l192 192z'/>
        </svg>
      </div>
      ";
    }
    if($icon == 'type2'){
      $iconshow = "
      <div class='bc-before-after-image__scroller--thumb'>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 256 512'>
          <path d='M9.4 278.6c-12.5-12.5-12.5-32.8 0-45.3l128-128c9.2-9.2 22.9-11.9 34.9-6.9s19.8 16.6 19.8 29.6l0 256c0 12.9-7.8 24.6-19.8 29.6s-25.7 2.2-34.9-6.9l-128-128z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 256 512'>
          <path d='M246.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-128-128c-9.2-9.2-22.9-11.9-34.9-6.9s-19.8 16.6-19.8 29.6l0 256c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l128-128z'/>
        </svg>
      </div>
      ";
    }
    if($icon == 'type3'){
      $iconshow = "
      <div class='bc-before-after-image__scroller--thumb'>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 512 512'>
          <path d='M41.4 233.4c-12.5 12.5-12.5 32.8 0 45.3l160 160c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L109.3 256 246.6 118.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-160 160zm352-160l-160 160c-12.5 12.5-12.5 32.8 0 45.3l160 160c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L301.3 256 438.6 118.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 512 512'>
          <path d='M470.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L402.7 256 265.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160zm-352 160l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L210.7 256 73.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0z'/>
        </svg>
      </div>
      ";
    }
    if($icon == 'type4'){
      $iconshow = "
      <div class='bc-before-after-image__scroller--thumb'>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 448 512'>
          <path d='M0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416zM128 256c0-6.7 2.8-13 7.7-17.6l112-104c7-6.5 17.2-8.2 25.9-4.4s14.4 12.5 14.4 22l0 208c0 9.5-5.7 18.2-14.4 22s-18.9 2.1-25.9-4.4l-112-104c-4.9-4.5-7.7-10.9-7.7-17.6z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 448 512'>
          <path d='M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM320 256c0 6.7-2.8 13-7.7 17.6l-112 104c-7 6.5-17.2 8.2-25.9 4.4s-14.4-12.5-14.4-22l0-208c0-9.5 5.7-18.2 14.4-22s18.9-2.1 25.9 4.4l112 104c4.9 4.5 7.7 10.9 7.7 17.6z'/>
        </svg>
      </div>
      ";
    }
    if($icon == 'type5'){
      $iconshow = "
      <div class='bc-before-after-image__scroller--thumb'>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 448 512'>
          <path d='M9.4 233.4c-12.5 12.5-12.5 32.8 0 45.3l160 160c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L109.2 288 416 288c17.7 0 32-14.3 32-32s-14.3-32-32-32l-306.7 0L214.6 118.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-160 160z'/>
        </svg>
        <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 448 512'>
          <path d='M438.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L338.8 224 32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l306.7 0L233.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160z'/>
        </svg>
      </div>
      ";
    }
    
    $this->set_attribute('_root', 'class', 'bc-before-after-image');

    if (strpos($beforeimage_image, 'cloudinary.com') !== false) {
        $beforeimage_decoding = 'decoding="async"';
    } else {
        $beforeimage_decoding = '';
    }

    if (strpos($afterimage_image, 'cloudinary.com') !== false) {
        $afterimage_decoding = 'decoding="async"';
    } else {
        $afterimage_decoding = '';
    }
    
    $flickering_attribute = $is_builder ? '' : "\r\n    data-flickering='1'";

    $output = "
    <div {$this->render_attributes('_root')}" . $flickering_attribute . "
    data-showafter='{$showafter}'>
        <div class='bc-before-after-image__before bc-before-after__div'>
            <img class='bc-before-after-image__content-image bc-before-after-image__content-image--before' 
                src='$beforeimage_image' 
                width='$beforeimage_image_width' 
                height='$beforeimage_image_height' 
                $beforeimagealt 
                $beforeimage_decoding
                draggable='false'>
        </div>
        <div class='bc-before-after-image__after bc-before-after__div'>
            <img class='bc-before-after-image__content-image bc-before-after-image__content-image--after' 
                src='$afterimage_image' 
                width='$afterimage_image_width' 
                height='$afterimage_image_height' 
                $afterimagealt 
                $afterimage_decoding
                draggable='false'>
        </div>
        <div class='bc-before-after-image__scroller'>
            $iconshow
        </div>
    </div>";

    echo $output;
  }
}
