<?php

namespace NextBricks;

class NextBricks_Elements{
  public function __construct(){
    $this->init();
    if(get_option('bc_back_to_top_enable', 'false') === 'true'){
      $this->handle_back_to_top_conflict();
    }
  }
  public function init(){
    //NEXTBRICKS_PLUGIN_DIR for php files
    //NEXTBRICKS_PLUGIN_URL for media, stylesheets, js
    //Load elements files on Wordpress initialization
    add_action( 'init', function() {
      $element_options = [
        'bc_blade_title' => 'bc_blade_title_enable',
        'bc_blended_title' => 'bc_blended_title_enable',
        'bc_circular_title' => 'bc_circular_title_enable',
        'bc_counter' => 'bc_counter_enable',
        'bc_decode_hover' => 'bc_decode_hover_enable',
        'bc_decode_reveal' => 'bc_decode_reveal_enable',
        'bc_exchange_title' => 'bc_exchange_title_enable',
        'bc_fluid_gradient_title' => 'bc_fluid_gradient_enable',
        'bc_highlight_title' => 'bc_highlight_title_enable',
        'bc_title_images' => 'bc_title_images_enable',
        'bc_letter_launcher' => 'bc_letter_launcher_enable',
        'bc_mask_hover' => 'bc_mask_hover_enable',
        'bc_mousefill_title' => 'bc_mousefill_title_enable',
        'bc_random_letters' => 'bc_random_letters_enable',
        'bc_scribble_child' => 'bc_scribble_title_enable',
        'bc_scribble_title' => 'bc_scribble_title_enable',
        'bc_scroll_cascading' => 'bc_scroll_cascading_enable',
        'bc_scroll_gradient' => 'bc_scroll_gradient_enable',
        'bc_scroll_reading' => 'bc_scroll_reading_enable',
        'bc_svg_title' => 'bc_svg_title_enable',
        'bc_swap_title' => 'bc_swap_title_enable',
        'bc_typed' => 'bc_typed_enable',
        'bc_twist_title' => 'bc_twist_title_enable',
        'bc_underline_title' => 'bc_underline_title_enable',
        'bc_unfold_hover' => 'bc_unfold_hover_enable',
        'bc_unfold_reveal' => 'bc_unfold_reveal_enable',
        'bc_3d_swap_title' => 'bc_3d_swap_title_enable',  
        'next_blur_reading' => 'bc_blur_reading_enable',  
        'next_blur_reveal' => 'bc_blur_reveal_enable',
        'next_counter_v2' => 'next_counter_v2_enable',
        'next_text_shimmer' => 'next_text_shimmer_enable',
        'next_countdown' => 'next_countdown_enable',
        'next_dynamic_copyright' => 'next_dynamic_copyright_enable',
        'next_proximity_hover' => 'next_proximity_hover_enable',
        'next_swap_reading' => 'next_swap_reading_enable',
        'next_variable_font_hover' => 'next_variable_font_hover_enable',
        'next_shading_lines_title' => 'next_shading_lines_title_enable',
        'next_exchange_title_v2' => 'next_exchange_title_v2_enable',
        'next_exchange_title_v3' => 'next_exchange_title_v3_enable',

        'bc_anyside_button' => 'bc_anyside_button_enable',
        'bc_arrow_button' => 'bc_arrow_button_enable',
        'next_arrow_icon' => 'next_arrow_icon_enable',
        'bc_crystal_button' => 'bc_crystal_button_enable',
        'bc_glowing_button' => 'bc_glowing_button_enable',
        'bc_layer_button' => 'bc_layer_button_enable',
        'bc_marquee_button' => 'bc_marquee_button_enable',
        'next_marquee_button_v2' => 'next_marquee_button_v2_enable',
        'bc_mask_button' => 'bc_mask_button_enable',
        'bc_microbox_button' => 'bc_microbox_button_enable',
        'bc_neumorphic_button' => 'bc_neumorphic_button_enable',
        'bc_prism_button' => 'bc_prism_button_enable',
        'bc_ripple_button' => 'bc_ripple_button_enable',
        'next_ripple_button_v2' => 'next_ripple_button_v2_enable',
        'next_ripple_button_v3' => 'next_ripple_button_v3_enable',   
        'bc_split_button' => 'bc_split_button_enable',
        'next_shiny_button' => 'next_shiny_button_enable',
        'next_arrow_button_v2' => 'next_arrow_button_v2_enable',
        'next_arrow_button_v3' => 'next_arrow_button_v3_enable',
        'next_rainbow_button' => 'next_rainbow_button_enable',

        'bc_core_burguer' => 'bc_core_burguer_enable',
        'bc_drawer' => 'bc_drawer_enable',
        'next_dropdown' => 'next_dropdown_enable',
        'next_dropdown_mega_menu' => 'next_dropdown_mega_menu_enable',
        'next_dropdown_wrapper' => 'next_dropdown_enable',    
        'bc_expanding_menu' => 'bc_expanding_menu_enable',
        'bc_morphing_menu' => 'bc_morphing_menu_enable',
        'bc_morphing_menu_item' => 'bc_morphing_menu_enable',
        'bc_multioffcanvas' => 'bc_multioffcanvas_enable',
        'bc_offcanvas_menu' => 'bc_offcanvas_menu_enable',
        'bc_simple_menu' => 'bc_simple_menu_enable',
        'bc_sticky_nav' => 'bc_sticky_nav_enable',
        'bc_stripe_megamenu' => 'bc_stripe_megamenu_enable',
        'bc_stripe_mm_contentlist' => 'bc_stripe_megamenu_enable',
        'bc_stripe_mm_item' => 'bc_stripe_megamenu_enable',
        'bc_suboffcanvas' => 'bc_multioffcanvas_enable',   
        'bc_overlay_menu' => 'bc_overlay_menu_enable',
        'next_circular_menu' => 'next_circular_menu_enable',
        'next_cta_nav' => 'next_cta_nav_enable',
        'next_dock_menu' => 'next_dock_menu_enable',
        'next_dynamic_island' => 'next_dynamic_island_enable',
        'next_gooey_nav' => 'next_gooey_nav_enable',
        'next_expanding_nav' => 'next_expanding_nav_enable',
        'next_focus_nav' => 'next_focus_nav_enable',

        'bc_back_to_top' => 'bc_back_to_top_enable',
        'bc_beforeafter_image' => 'bc_beforeafter_image_enable',
        'bc_bubble' => 'bc_bubbles_enable',
        'bc_bubbles' => 'bc_bubbles_enable',
        'bc_bubbles_wrapper' => 'bc_bubbles_enable',
        'bc_clickandcopy' => 'bc_clickandcopy_enable',
        'bc_codepen' => 'bc_codepen_enable',
        'bc_core_slider' => 'bc_core_slider_enable',
        'bc_core_tabs' => 'bc_core_tabs_enable',
        'bc_cursor' => 'bc_cursor_enable',
        'bc_dark_mode' => 'bc_dark_mode_enable',
        'bc_expander' => 'bc_expander_enable',
        'bc_flipbox' => 'bc_flipbox_enable',
        'bc_generatorism' => 'bc_generatorism_enable',
        'bc_glitchy' => 'bc_glitchy_enable',
        'bc_glowingcard' => 'bc_glowingcard_enable',
        'bc_grained' => 'bc_grained_enable',
        'bc_gradiently' => 'bc_gradiently_enable',
        'bc_marquee' => 'bc_marquee_enable',
        'next_horizontal_scroll' => 'next_horizontal_scroll_enable',
        'bc_image_hotspot' => 'bc_image_hotspots_enable',
        'bc_image_hotspots' => 'bc_image_hotspots_enable',
        'bc_image_reveal' => 'bc_image_reveal_enable',
        'next_lamp' => 'next_lamp_enable',
        'bc_lottie' => 'bc_lottie_enable',
        'bc_media' => 'bc_media_enable',
        'bc_divider' => 'bc_divider_enable',
        'bc_observer' => 'bc_observer_enable',
        'bc_parallax' => 'bc_parallax_enable',
        'bc_3dhover' => 'bc_3dhover_enable',
        'bc_3dhover_child' => 'bc_3dhover_enable',
        'next_particles' => 'next_particles_enable',
        'next_physics' => 'next_physics_enable',
        'next_physics_element' => 'next_physics_enable',
        'bc_scrollbar' => 'bc_scrollbar_enable',
        'bc_sharer' => 'bc_sharer_enable',
        'bc_smooth_scroll' => 'bc_smooth_scroll_enable',
        'bc_spotlight' => 'bc_spotlight_enable',
        'next_spotlight_v2' => 'next_spotlight_v2_enable',
        'next_spotlight_v2_wrapper' => 'next_spotlight_v2_enable',  
        'bc_spinner' => 'bc_spinner_enable',
        'next_table_of_contents' => 'next_table_of_contents_enable',
        'next_timeline' => 'next_timeline_enable',
        'bc_tippy' => 'bc_tippy_enable',
        'bc_infinite_title' => 'bc_infinite_title_enable',
        'bc_video_sequence' => 'bc_video_sequence_enable',
        'bc_zoom_lens' => 'bc_zoom_lens_enable',
        'next_border_beam' => 'next_border_beam_enable',
        'next_inverted_corners' => 'next_inverted_corners_enable',
        'next_tiles' => 'next_tiles_enable',
        'next_designer_cursor' => 'next_designer_cursor_enable',
        'next_stacking_cards' => 'next_stacking_cards_enable',
        'next_parallax_slider' => 'next_parallax_slider_enable',
        'next_parallax_slider_item' => 'next_parallax_slider_enable',
        'next_cursor_slide' => 'next_cursor_slide_enable',
        'next_qr_code' => 'next_qr_code_enable',
        'next_cookies' => 'next_cookies_enable',
        'next_interactive_divider' => 'next_interactive_divider_enable',
        'next_progress_bar' => 'next_progress_bar_enable',
        'next_meteors' => 'next_meteors_enable',
        'next_meteor' => 'next_meteors_enable',
        'next_fluids' => 'next_fluids_enable',
        'next_infinite_slider' => 'next_infinite_slider_enable',
        'next_pixels_shimmer_card' => 'next_pixels_shimmer_card_enable',
        'next_tiles_v2' => 'next_tiles_v2_enable',
        'next_interactive_lines' => 'next_interactive_lines_enable',
        'next_cursor_trail' => 'next_cursor_trail_enable',
        'next_mouse_parallax' => 'next_mouse_parallax_enable',
        'next_image_accordion' => 'next_image_accordion_enable',
        'next_progress_bar_v2' => 'next_progress_bar_v2_enable',
        'next_decode_card' => 'next_decode_card_enable',
        'next_distorsion_tabs' => 'next_distorsion_tabs_enable',
        'next_toolteam' => 'next_toolteam_enable',
        'next_toast' => 'next_toast_enable',
        'bc_smooth_scroll' => 'bc_smooth_scroll_enable',
        
        'next_arrow_button_v4' => 'next_arrow_button_v4_enable',
        'next_arrow_button_v5' => 'next_arrow_button_v5_enable',
        'next_arrow_button_v6' => 'next_arrow_button_v6_enable',
        'next_arrow_button_v7' => 'next_arrow_button_v7_enable',
        'next_arrow_button_v8' => 'next_arrow_button_v8_enable',
        'next_audio_player' => 'next_audio_player_enable',
        'next_beforeafter_image_v2' => 'next_beforeafter_image_v2_enable',
        'next_blurry_button' => 'next_blurry_button_enable',
        'next_bubbles_button' => 'next_bubbles_button_enable',
        'next_bubbles_button_bubble' => 'next_bubbles_button_enable',
        'next_crosshair' => 'next_crosshair_enable',
        'next_dot_button' => 'next_dot_button_enable',
        'next_dot_button_v2' => 'next_dot_button_v2_enable',
        'next_dot_button_v3' => 'next_dot_button_v3_enable',
        'next_figures' => 'next_figures_enable',
        'next_flipflop_button' => 'next_flipflop_button_enable',
        'next_flipflop_button_v2' => 'next_flipflop_button_v2_enable',
        'next_flipflop_button_v3' => 'next_flipflop_button_v3_enable',
        'next_highlight' => 'next_highlight_enable',
        'next_highlight_mark' => 'next_highlight_enable',
        'next_image_reveal_v2' => 'next_image_reveal_v2_enable',
        'next_image_reveal_v3' => 'next_image_reveal_v3_enable',
        'next_image_reveal_v4' => 'next_image_reveal_v4_enable',
        'next_interactive_lines_v2' => 'next_interactive_lines_v2_enable',
        'next_interactive_lines_v3' => 'next_interactive_lines_v3_enable',
        'next_interactive_lines_v4' => 'next_interactive_lines_v4_enable',
        'next_iridescence' => 'next_iridescence_enable',
        'next_lightbox' => 'next_lightbox_enable',
        'next_link_preview' => 'next_link_preview_enable',
        'next_looping_tabs' => 'next_looping_tabs_enable',
        'next_looping_nav_item' => 'next_looping_tabs_enable',
        'next_nudge_button' => 'next_nudge_button_enable',
        'next_overlay_shadows' => 'next_overlay_shadows_enable',
        'next_pixels_button' => 'next_pixels_button_enable',
        'next_prism_button_v2' => 'next_prism_button_v2_enable',
        'next_read_more' => 'next_read_more_enable',
        'next_reel_button' => 'next_reel_button_enable',
        'next_ripple_button_v4' => 'next_ripple_button_v4_enable',
        'next_ripple_button_v5' => 'next_ripple_button_v5_enable',
        'next_ripple_button_v6' => 'next_ripple_button_v6_enable',
        'next_ripple_button_v7' => 'next_ripple_button_v7_enable',
        'next_scrolling_background' => 'next_scrolling_background_enable',
        'next_scrolling_gallery' => 'next_scrolling_gallery_enable',
        'next_sticky_footer' => 'next_sticky_footer_enable',
        'next_site_loader' => 'next_site_loader_enable',
        'next_squeezy_radius_button' => 'next_squeezy_radius_button_enable',
        'next_stories' => 'next_stories_enable',
        'next_video_tabs' => 'next_video_tabs_enable',
        'next_stretchy_button' => 'next_stretchy_button_enable',
        'next_strip_button' => 'next_strip_button_enable',
        'next_stripes_button' => 'next_stripes_button_enable',
        'next_thumbnail_slider' => 'next_thumbnail_slider_enable',
      ];

      $features_options = [
        'nextui' => 'bc_core_ui_enable',
        'nextanimator' => 'bc_core_animator_enable',
        'nextpt' => 'bc_pagetransitions_enable',
      ];

      foreach ($element_options as $element_name => $option_name) { //Save elements choices by user
        $option_value = get_option($option_name, 'false');
        if ($option_value === 'true') {
          $element_files[] = NEXTBRICKS_PLUGIN_DIR . '/elements/' . $element_name . '.php';
        }
        if ($option_value === 'true' && $element_name === 'bc_media') {
          add_filter('script_loader_tag', array($this, 'add_attributes_to_script'), 10, 3); //Handle vidstack (media element) module type
        }
        if ($option_value === 'true' && $element_name === 'next_iridescence') {
          add_filter('script_loader_tag', array($this, 'add_attributes_to_script'), 10, 3); //Handle ogl (iridescence element) module type
        }

        if ($option_value === 'true' && $element_name === 'next_cookies') {
          wp_enqueue_script('next_cookies', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_cookies.min.js', array(), NEXTBRICKS_VERSION, false); //Load cookies at header to track all cookies
          wp_enqueue_style( 'next_cookieconsent', NEXTBRICKS_PLUGIN_URL . 'local_assets/next_cookieconsent.min.css', array(), NEXTBRICKS_VERSION, false );
        }
      }

      foreach ($features_options as $feature_name => $option_name) { //Save features choices by user
        $option_value = get_option($option_name, 'false');
        if ($option_value === 'true') {
          $feature_files[] = NEXTBRICKS_PLUGIN_DIR . '/features/' . $feature_name . '.php';
        }
      }

      //function exists is to prevent Plesk fatal errors at logs
      if ( function_exists('bricks_is_frontend') ) {
        if( bricks_is_frontend() ){ 
          if (get_option('bc_pagetransitions_enable', 'false') === 'true') { //Load enabled elements CSS if page transitions are enabled
            require_once 'elementsCSS.php';
            (new includeElementsCSS())->init();
          }else{ //Load conditional CSS at the front
            require_once 'elementsConditionalCSS.php';
            (new includeElementsConditionalCSS())->init();
          }
        }else if( bricks_is_builder() ){ //Load enabled elements CSS at the builder
          require_once 'elementsCSS.php';
          (new includeElementsCSS())->init();
        }
      }

      if (class_exists('\Bricks\Elements') && !empty($element_files)) { //Load Elements and check class(Child theme)
        foreach ($element_files as $file) {
          \Bricks\Elements::register_element($file);
        }
      }
      
      if(!empty($feature_files)){
        foreach ( $feature_files as $file ) { // Load Features
          if(basename($file) == 'nextanimator.php'){
            require_once $file;
            (new Next_Animator())->init();
          }
    
          if(basename($file) == 'nextui.php'){
            require_once $file;
            (new Next_UI())->init();
          }

          if(basename($file) == 'nextpt.php'){
            require_once $file;
            (new Next_PT())->init();

            //Include JS files manually (to call functions at page transitions hooks)
            require_once 'elementsJS.php';
            (new includeElementsJS())->init();
          }
        }
      }
    }, 11 );

    add_filter( 'bricks/builder/i18n', function( $i18n ) { //Translations
      $i18n['custom'] = esc_html__( 'Custom', 'bricks' );

      return $i18n;
    } );

    //Assets Loading
    add_action( 'wp_enqueue_scripts', function() {
      $cdn_options = [
        NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_gsap.min.js' => 'bc_gsap_enable',
        NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_scrolltrigger.min.js' => 'bc_scrolltrigger_enable',
        NEXTBRICKS_PLUGIN_URL . 'local_assets/bc_splittext.min.js' => 'bc_splittext_enable',
      ];

      foreach ($cdn_options as $cdn_name => $option_name) {
        $option_value = get_option($option_name, 'true');

        if ($option_value === 'true') {
          wp_enqueue_script($option_name, $cdn_name, array('bricks-scripts'), NEXTBRICKS_VERSION, true);
        }
      }
    }, 11 );
  }
  public function add_attributes_to_script( $tag, $handle, $src ) { //Handle modules
    if ( 'bc_vidstack-js' === $handle ) {
        $tag = '<script type="module" src="' . esc_url( $src ) . '" id="bc_vidstack-js" ></script>';
    } 
    if ( 'next_iridescence' === $handle ) {
      $tag = '<script type="module" src="' . esc_url( $src ) . '" id="next_iridescence" ></script>';
    }
    return $tag;
  }
  public function handle_back_to_top_conflict(){ //Replace back to top root class to avoid conflicts with Bricks back to top
    add_filter( 'bricks/element/set_root_attributes', function( $attributes, $element ) { //Replace back to top brxe root class
      if ( in_array( 'brxe-back-to-top', $attributes['class'] ) ) {
        $key = array_search('brxe-back-to-top', $attributes['class']);
        $attributes['class'][$key] = 'brxe-next-back-to-top';
      }
  
      return $attributes;
    }, 10, 2 );
  }
}
