<?php
   function mp3omatic_items_panel()
   {
   ?>
<div class="wp-header-end"></div>
<div class="wrap gs_popuptype_holder seo_pops">
   <div>
      <form id="myForm" method="post" action="admin.php?page=mp3omatic_items_panel">
         <?php
            wp_nonce_field('mp3omatic_save_rules', '_mp3omaticr_nonce');
            
            if (isset($_GET['settings-updated'])) {
            ?>
         <div>
            <p class="cr_saved_notif"><strong><?php echo esc_html__("Settings saved.", 'mp3omatic-free-music-post-generator');?></strong></p>
         </div>
         <?php
            }
            ?>
         <div>
            <div class="hideMain">
               <hr/>
               <div class="table-responsive">
                  <table id="mainRules" class="responsive table cr_main_table">
                     <thead>
                        <tr>
                           <th>
                              <?php echo esc_html__("ID", 'mp3omatic-free-music-post-generator');?>
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("This is the ID of the rule.", 'mp3omatic-free-music-post-generator');
                                       ?>
                                 </div>
                              </div>
                           </th>
                           <th>
                              <?php echo esc_html__("Search Query", 'mp3omatic-free-music-post-generator');?>
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("Search for tracks for a specific search query. To search for any track, please insert * in this settings field (star character). You can make manual searches here: ", 'mp3omatic-free-music-post-generator') . '<a href="https://freemusicarchive.org/" target="_blank">https://freemusicarchive.org/</a>';
                                       ?>
                                 </div>
                              </div>
                           </th>
                           <th>
                              <?php echo esc_html__("Schedule", 'mp3omatic-free-music-post-generator');?>
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("Select the interval in hours after which you want this rule to run. Defined in hours.", 'mp3omatic-free-music-post-generator');
                                       ?>
                                 </div>
                              </div>
                           </th>
                           <th>
                              <?php echo esc_html__("Max # Posts", 'mp3omatic-free-music-post-generator');?>
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("Select the maximum number of posts that this rule can create at once. 0-200 interval allowed.", 'mp3omatic-free-music-post-generator');
                                       ?>
                                 </div>
                              </div>
                           </th>
                           <th>
                              <?php echo esc_html__("More Options", 'mp3omatic-free-music-post-generator');?>
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("Shows advanced settings for this rule.", 'mp3omatic-free-music-post-generator');
                                       ?>
                                 </div>
                              </div>
                           </th>
                           <th class="cr_max_32">
                              <?php echo esc_html__("Del", 'mp3omatic-free-music-post-generator');?>
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("Do you want to delete this rule?", 'mp3omatic-free-music-post-generator');
                                       ?>
                                 </div>
                              </div>
                           </th>
                           <th class="cr_max_55">
                              <?php echo esc_html__("Active", 'mp3omatic-free-music-post-generator');?>
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("Do you want to enable this rule? You can deactivate any rule (you don't have to delete them to deactivate them).", 'mp3omatic-free-music-post-generator');
                                       ?>
                                 </div>
                              </div>
                              <br/>
                              <input type="checkbox" onchange="thisonChangeHandler(this)" id="exclusion">
                           </th>
                           <th class="cr_max_42">
                              <?php echo esc_html__("Info", 'mp3omatic-free-music-post-generator');?>
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("The number of items (posts, pages) this rule has generated so far.", 'mp3omatic-free-music-post-generator');
                                       ?>
                                 </div>
                              </div>
                           </th>
                           <th class="cr_actions">
                              <?php echo esc_html__("Actions", 'mp3omatic-free-music-post-generator');?>
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("Do you want to run this rule now? Note that only one instance of a rule is allowed at once.", 'mp3omatic-free-music-post-generator');
                                       ?>
                                 </div>
                              </div>
                           </th>
                        </tr>
                        
                     </thead>
                     <tbody>
                        <?php
                           echo mp3omatic_expand_rules_manual();
                           ?>
                        
                        <tr>
                           <td class="cr_align_middle cr_td_short">-</td>
                           <td class="cr_td_cust"><input type="text" name="mp3omatic_rules_list[game_keywords][]" placeholder="Search query" value="" class="cr_width_full"/></td>
                           <td class="cr_comm_td"><input type="number" step="1" min="1" name="mp3omatic_rules_list[schedule][]" max="8765812" class="cr_width_60" placeholder="Select the rule schedule interval" value="24"/></td>
                           <td class="cr_comm_td"><input type="number" step="1" min="0" max="200" name="mp3omatic_rules_list[max][]" placeholder="Select the max # of generated posts" value="10" class="cr_width_60"/></td>
                           <td class="cr_width_70">
                              <input type="button" id="mybtnfzr" value="Settings">
                              <div id="mymodalfzr" class="codemodalfzr">
                                 <div class="codemodalfzr-content">
                                    <div class="codemodalfzr-header">
                                       <span id="mp3omatic_close" class="codeclosefzr">&times;</span>
                                       <h2><span class="cr_color_white"><?php echo esc_html__("New Rule", 'mp3omatic-free-music-post-generator');?></span> <?php echo esc_html__("Advanced Settings", 'mp3omatic-free-music-post-generator');?></h2>
                                    </div>
                                    <div class="codemodalfzr-body">
                                       <div class="table-responsive">
                                          <table class="responsive table cr_main_table_nowr">
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Set the title of the generated posts for user rules. You can use the following shortcodes: %%random_sentence%%, %%random_sentence2%%, %%item_title%%, %%item_url%%, %%item_date%%, %%item_duration%%, %%item_playback_count%%", 'mp3omatic-free-music-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Generated Post Title:", 'mp3omatic-free-music-post-generator');?></b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                                                </td>
                                                <td>
                                                <input type="text" name="mp3omatic_rules_list[post_title][]" value="%%item_title%%" placeholder="Please insert your desired post title. Example: %%item_title%%" class="cr_width_full">
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Set the content of the generated posts for user rules. You can use the following shortcodes: %%item_cat%%, %%item_tags%%, %%random_sentence%%, %%random_sentence2%%, %%custom_html%%, %%custom_html2%%, %%item_playback_count%%, %%item_download_embed%%, %%item_download_path%%, %%item_duration%%, %%item_title%%, %%item_favoritings_count%%, %%item_song_tags%%, %%item_artist_name%%, %%item_artist_url%%, %%item_artist_website%%, %%item_url%%, %%item_date%%, %%item_duration%%, %%featured_image_url%%, %%item_show_image%%, %%item_genre%%, %%item_read_more_button%%, %%item_author%%, %%item_author_link%%, %%item_author_id%%, %%item_track_id%%, %%item_download_url%%, %%item_favoritings_count%%. You can also use this shortcode: %%item_title_first_X_characters%% - where X can be any number from 1 upwards.", 'mp3omatic-free-music-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Generated Post Content:", 'mp3omatic-free-music-post-generator');?></b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                                                </td>
                                                <td>
                                                <textarea rows="2" cols="70" name="mp3omatic_rules_list[post_content][]" placeholder="Please insert your desired post content. Example:%%item_title%%" class="cr_width_full">Track: %%item_title%%<br/>Artist: <a href="%%item_artist_url%%" target="_blank">%%item_artist_name%%</a><br/><br/>Preview:<br/>%%item_download_embed%%<br/><br/><a href="%%item_download_url%%" target="_blank">Download the track now</a></textarea>
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Do you want to remember last posted item and continue search from it the next time the importing rule runs? Please note that 'Playlist Search' and 'User Search' does not support this feature.", 'mp3omatic-free-music-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Cache Items For Continuous Posting (disable to get latest posts only):", 'mp3omatic-free-music-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="checkbox" id="continue_search" name="mp3omatic_rules_list[continue_search][]" checked>
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Please insert the track minimal length in seconds", 'mp3omatic-free-music-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Minimum Length:", 'mp3omatic-free-music-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="number" min="0" step="1" name="mp3omatic_rules_list[min_length][]" value="" placeholder="Min length (s)" class="cr_width_full">
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Please insert the track maximal length in seconds.", 'mp3omatic-free-music-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Maximum Length:", 'mp3omatic-free-music-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="number" min="0" step="1" name="mp3omatic_rules_list[max_length][]" value="" placeholder="Max length (s)" class="cr_width_full">
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Sort results. Possible values are: track_id, track_title, track_url, track_image_file, artist_id, artist_name, artist_url,artist_website,album_id,album_title,album_url,license_title,license_url,track_language_code,track_duration,track_number,track_disc_number,track_explicit,track_explicit_notes,track_copyright_c,track_copyright_p,track_composer,track_lyricist,track_publisher,track_instrumental,track_information,track_date_recorded,track_comments,track_favorites,track_listens,track_interest,track_bit_rate,track_date_created,track_file,license_image_file, license_image_file_large, license_parent_id", 'mp3omatic-free-music-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Sort Results By:", 'mp3omatic-free-music-post-generator');?></b>
                                                </td>
                                                <td>
                                                <select id="sort_results" name="mp3omatic_rules_list[sort_results][]" class="cr_width_full">
                                                <option value="_score"><?php echo esc_html__("Score", 'mp3omatic-free-music-post-generator');?></option>
                                                <option value="date"><?php echo esc_html__("Date Added", 'mp3omatic-free-music-post-generator');?></option>
                                                </select>    
                                                <input type="text" name="mp3omatic_rules_list[sort_results][]" value="" placeholder="Sort results" class="cr_width_full">
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Include only instrumental tracks", 'mp3omatic-free-music-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Only Instrumental:", 'mp3omatic-free-music-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="checkbox" id="only_instrumental" name="mp3omatic_rules_list[only_instrumental][]">
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Set the maximum number of posts you want this rule to publish per day.", 'mp3omatic-free-music-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Max Posts Per Day:", 'mp3omatic-free-music-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="number" min="1" step="1" id="max_posts" name="mp3omatic_rules_list[max_posts][]" placeholder="Max posts per day" class="cr_width_full"> 
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Select the status that you want for the automatically generated posts to have.", 'mp3omatic-free-music-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Post Status:", 'mp3omatic-free-music-post-generator');?></b>
                                                </td>
                                                <td>
                                                <select id="submit_status" name="mp3omatic_rules_list[submit_status][]" class="cr_width_full">
                                                <option value="pending"><?php echo esc_html__("Pending -> Moderate", 'mp3omatic-free-music-post-generator');?></option>
                                                <option value="draft"><?php echo esc_html__("Draft -> Moderate", 'mp3omatic-free-music-post-generator');?></option>
                                                <option value="publish" selected><?php echo esc_html__("Published", 'mp3omatic-free-music-post-generator');?></option>
                                                <option value="private"><?php echo esc_html__("Private", 'mp3omatic-free-music-post-generator');?></option>
                                                <option value="trash"><?php echo esc_html__("Trash", 'mp3omatic-free-music-post-generator');?></option>
                                                </select>    
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Do you want to to set the post published date as the date grabbed from the imported tracks? If you disable this feature, the date when the rule is run will be used.", 'mp3omatic-free-music-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Get Post Publish Date From Imported Track:", 'mp3omatic-free-music-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="checkbox" id="import_date" name="mp3omatic_rules_list[import_date][]">
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Select the type (post/page) for your automatically generated item.", 'mp3omatic-free-music-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Item Type:", 'mp3omatic-free-music-post-generator');?></b>
                                                </td>
                                                <td>
                                                <select id="default_type" name="mp3omatic_rules_list[default_type][]" class="cr_width_full">
                                                <?php
                                                   $is_first = true;
                                                   foreach ( get_post_types( '', 'names' ) as $post_type ) {
                                                      echo '<option value="' . esc_attr($post_type) . '"';
                                                      if($is_first === true)
                                                      {
                                                          echo ' selected';
                                                          $is_first = false;
                                                      }
                                                      echo '>' . esc_html($post_type) . '</option>';
                                                   }
                                                   ?>
                                                </select>     
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Select the author that you want to assign for the automatically generated posts.", 'mp3omatic-free-music-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Post Author:", 'mp3omatic-free-music-post-generator');?></b>
                                                </td>
                                                <td>
                                                <select id="post_author" name="mp3omatic_rules_list[post_author][]" class="cr_width_full">
                                                <?php
                                                   $blogusers = get_users( [ 'role__in' => [ 'contributor', 'author', 'editor', 'administrator' ] ] );
                                                   foreach ($blogusers as $user) {
                                                       echo '<option value="' . esc_html($user->ID) . '"';
                                                       echo '>' . esc_html($user->display_name) . '</option>';
                                                   }
                                                   ?>
                                                </select>    
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("If your template supports 'Post Formats', than you can select one here. If not, leave this at it's default value.", 'mp3omatic-free-music-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Generated Post Format:", 'mp3omatic-free-music-post-generator');?></b>   
                                                </td>
                                                <td class="cr_min_width_200">
                                                <select id="post_format" name="mp3omatic_rules_list[post_format][]" class="cr_width_full">
                                                <option value="post-format-standard"  selected><?php echo esc_html__("Standard", 'mp3omatic-free-music-post-generator');?></option>
                                                <option value="post-format-aside"><?php echo esc_html__("Aside", 'mp3omatic-free-music-post-generator');?></option>
                                                <option value="post-format-gallery"><?php echo esc_html__("Gallery", 'mp3omatic-free-music-post-generator');?></option>
                                                <option value="post-format-link"><?php echo esc_html__("Link", 'mp3omatic-free-music-post-generator');?></option>
                                                <option value="post-format-image"><?php echo esc_html__("Image", 'mp3omatic-free-music-post-generator');?></option>
                                                <option value="post-format-quote"><?php echo esc_html__("Quote", 'mp3omatic-free-music-post-generator');?></option>
                                                <option value="post-format-status"><?php echo esc_html__("Status", 'mp3omatic-free-music-post-generator');?></option>
                                                <option value="post-format-video"><?php echo esc_html__("Video", 'mp3omatic-free-music-post-generator');?></option>
                                                <option value="post-format-audio"><?php echo esc_html__("Audio", 'mp3omatic-free-music-post-generator');?></option>
                                                <option value="post-format-chat"><?php echo esc_html__("Chat", 'mp3omatic-free-music-post-generator');?></option>
                                                </select>     
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Select the post category that you want for the automatically generated posts to have. To select more categories, hold down the CTRL key.", 'mp3omatic-free-music-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Additional Post Category:", 'mp3omatic-free-music-post-generator');?></b>
                                                </td>
                                                <td>
                                                <select multiple id="default_category" name="mp3omatic_rules_list[default_category][]" class="cr_width_full">
                                                <option value="mp3omatic_no_category_12345678" selected><?php echo esc_html__("Do Not Add a Category", 'mp3omatic-free-music-post-generator');?></option>
                                                <?php
                                                   $cat_args   = array(
                                                       'orderby' => 'name',
                                                       'hide_empty' => 0,
                                                       'order' => 'ASC'
                                                   );
                                                   $categories = get_categories($cat_args);
                                                   foreach ($categories as $category) {
                                                   ?>
                                                <option value="<?php
                                                   echo esc_html($category->term_id);
                                                   ?>"><?php
                                                   echo esc_html(sanitize_text_field($category->name));
                                                   ?></option>
                                                <?php
                                                   }
                                                   ?>
                                                </select>     
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Do you want to automatically add post categories from the Free Music Archive items?", 'mp3omatic-free-music-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Auto Add Categories:", 'mp3omatic-free-music-post-generator');?></b>
                                                </td>
                                                <td>
                                                <select class="cr_width_full" id="auto_categories" name="mp3omatic_rules_list[auto_categories][]">
                                                <option value="disabled" selected><?php echo esc_html__("Disabled", 'mp3omatic-free-music-post-generator');?></option>
                                                <option value="video"><?php echo esc_html__("Track Tags", 'mp3omatic-free-music-post-generator');?></option>
                                                <option value="genre"><?php echo esc_html__("Track Genre", 'mp3omatic-free-music-post-generator');?></option>
                                                <option value="content"><?php echo esc_html__("Content", 'mp3omatic-free-music-post-generator');?></option>
                                                <option value="both"><?php echo esc_html__("Track Tags and Content", 'mp3omatic-free-music-post-generator');?></option>
                                                </select>   
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("This feature will try to remove the WordPress's default post category. This may fail in case no additional categories are added, because WordPress requires at least one post category for every post.", 'mp3omatic-free-music-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Remove WP Default Post Category:", 'mp3omatic-free-music-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="checkbox" id="remove_default" name="mp3omatic_rules_list[remove_default][]" checked>
                                                </div>
                                                </td>
                                             </tr>
                                             </td></tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Do you want to automatically add post tags from the Free Music Archive items?", 'mp3omatic-free-music-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Auto Add Tags:", 'mp3omatic-free-music-post-generator');?></b>
                                                </td>
                                                <td>
                                                <select class="cr_width_full" id="auto_tags" name="mp3omatic_rules_list[auto_tags][]">
                                                <option value="disabled" selected><?php echo esc_html__("Disabled", 'mp3omatic-free-music-post-generator');?></option>
                                                <option value="video"><?php echo esc_html__("Track Tags", 'mp3omatic-free-music-post-generator');?></option>
                                                <option value="genre"><?php echo esc_html__("Track Genre", 'mp3omatic-free-music-post-generator');?></option>
                                                <option value="content"><?php echo esc_html__("Content", 'mp3omatic-free-music-post-generator');?></option>
                                                <option value="both"><?php echo esc_html__("Track Tags and Content", 'mp3omatic-free-music-post-generator');?></option>
                                                </select> 
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Select the post tags that you want for the automatically generated posts to have.", 'mp3omatic-free-music-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Additional Post Tags:", 'mp3omatic-free-music-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="text" name="mp3omatic_rules_list[default_tags][]" value="" placeholder="Please insert your additional post tags here" class="cr_width_full">
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Do you want to enable comments for the generated posts?", 'mp3omatic-free-music-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Enable Comments For Posts:", 'mp3omatic-free-music-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="checkbox" id="enable_comments" name="mp3omatic_rules_list[enable_comments][]" checked>
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Do you want to enable pingbacks/trackbacks for the generated posts?", 'mp3omatic-free-music-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Enable Pingback/Trackback:", 'mp3omatic-free-music-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="checkbox" id="enable_pingback" name="mp3omatic_rules_list[enable_pingback][]" checked>
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                             <td class="cr_min_width_200">
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Set the custom fields that will be set for generated posts. The syntax for this field is the following: custom_field_name1 => custom_field_value1, custom_field_name2 => custom_field_value2, ... . In custom_field_valueX, you can use shortcodes, same like in post content. You can also assign the data to array custom fields, using this format: array_field[index_name1] => custom_field_value1, array_field[index_name2] => custom_field_value2. Example (without quotes): 'title_custom_field => %%item_title%%'. You can use the following shortcodes: %%item_cat%%, %%item_tags%%, %%random_sentence%%, %%random_sentence2%%, %%custom_html%%, %%custom_html2%%, %%item_playback_count%%, %%item_download_embed%%, %%item_download_path%%, %%item_duration%%, %%item_title%%, %%item_favoritings_count%%, %%item_song_tags%%, %%item_artist_name%%, %%item_artist_url%%, %%item_artist_website%%, %%item_url%%, %%item_date%%, %%item_duration%%, %%featured_image_url%%, %%item_show_image%%, %%item_genre%%, %%item_read_more_button%%, %%item_author%%, %%item_author_link%%, %%item_author_id%%, %%item_track_id%%, %%item_download_url%%, %%item_favoritings_count%% You can also use this shortcode: %%item_title_first_X_characters%% - where X can be any number from 1 upwards.", 'mp3omatic-free-music-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Post Custom Fields:", 'mp3omatic-free-music-post-generator');?></b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" cols="70" name="mp3omatic_rules_list[custom_fields][]" placeholder="Please insert your desired custom fields. Example: title_custom_field => %%item_title%%" class="cr_width_full"></textarea>
                                             </div>
                                             </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Do you want to set featured image for generated post (to the first image that was found in the post)?", 'mp3omatic-free-music-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Auto Get Featured Image:", 'mp3omatic-free-music-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="checkbox" id="featured_image" name="mp3omatic_rules_list[featured_image][]" checked>
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Insert a comma separated list of links to valid images that will be set randomly for the featured image for the posts that do not have a valid image attached or if you disabled automatical featured image generation. You can also use image numeric IDs from images found in the Media Gallery. To disable this feature, leave this field blank.", 'mp3omatic-free-music-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Default Featured Image List:", 'mp3omatic-free-music-post-generator');?></b>
                                                </td>
                                                <td>
                                                   <input class="cr_width_60p" type="text" name="mp3omatic_rules_list[image_url][]" placeholder="Please insert the link to a valid image" id="cr_input_box"  value=""/>
                                                   <input class="cr_width_33p mp3omatic_image_button" type="button" value=">>>"/>
                                                </td>
                                             </tr>
                                          </table>
                                       </div>
                                    </div>
                                    <div class="codemodalfzr-footer">
                                       <br/>
                                       <h3 class="cr_inline">Mp3omatic Automatic Post Generator</h3>
                                       <span id="mp3omatic_ok" class="codeokfzr cr_inline">OK&nbsp;</span>
                                       <br/><br/>
                                    </div>
                                 </div>
                              </div>
                           </td>
                           <td class="cr_td_short" ><span class="cr_color_gray cr_max_32" >X</span></td>
                           <td class="cr_align_middle cr_td_short"><input type="checkbox" name="mp3omatic_rules_list[active][]" value="1" checked />
                              <input type="hidden" name="mp3omatic_rules_list[last_run][]" value="1988-01-27 00:00:00"/>
                           </td>
                           <td class="cr_align_middle cr_td_short">
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("No info.", 'mp3omatic-free-music-post-generator');
                                       ?>
                                 </div>
                              </div>
                           </td>
                           <td class="cr_center">
                              <div>
                                 <img src="<?php
                                    echo esc_url(plugin_dir_url(dirname(__FILE__)) . 'images/running.gif');
                                    ?>" alt="Running" class="cr_running">
                                 <div class="codemainfzr cr_gray_back">
                                    <select id="actions" class="actions" name="actions" disabled>
                                       <option value="select" disabled selected><?php echo esc_html__("Select an Action", 'mp3omatic-free-music-post-generator');?></option>
                                       <option value="run" onclick=""><?php echo esc_html__("Run This Rule Now", 'mp3omatic-free-music-post-generator');?></option>
                                       <option value="trash" onclick=""><?php echo esc_html__("Move All Posts To Trash", 'mp3omatic-free-music-post-generator');?></option>
                                       <option value="delete" onclick=""><?php echo esc_html__("Permanently Delete All Posts", 'mp3omatic-free-music-post-generator');?></option>
                                    </select>
                                 </div>
                              </div>
                           </td>
                        </tr>
                     </tbody>
                  </table>
               </div>
            </div>
         </div>
         <hr/>
         <div>
            <p class="submit"><input type="submit" name="btnSubmit" id="btnSubmit" class="button button-primary" onclick="unsaved = false;" value="<?php echo esc_html__("Save Settings", 'mp3omatic-free-music-post-generator');?>"/></p>
         </div>
         <div>
            <a href="https://www.youtube.com/watch?v=5rbnu_uis7Y" target="_blank"><?php echo esc_html__("Nested Shortcodes also supported!", 'mp3omatic-free-music-post-generator');?></a><br/><?php echo esc_html__("Confused about rule running status icons?", 'mp3omatic-free-music-post-generator');?> <a href="http://coderevolution.ro/knowledge-base/faq/how-to-interpret-the-rule-running-visual-indicators-red-x-yellow-diamond-green-tick-from-inside-plugins/" target="_blank"><?php echo esc_html__("More info", 'mp3omatic-free-music-post-generator');?></a><br/>
            <div class="cr_none" id="midas_icons">
               <table>
                  <tr>
                     <td><img id="run_img" src="<?php echo esc_url(plugin_dir_url(dirname(__FILE__)) . 'images/running.gif');?>" alt="Running" title="status"></td>
                     <td><?php echo esc_html__("In Progress", 'mp3omatic-free-music-post-generator');?> - <b><?php echo esc_html__("Importing is Running", 'mp3omatic-free-music-post-generator');?></b></td>
                  </tr>
                  <tr>
                     <td><img id="ok_img" src="<?php echo esc_url(plugin_dir_url(dirname(__FILE__)) . 'images/ok.gif');?>" alt="OK"  title="status"></td>
                     <td><?php echo esc_html__("Success", 'mp3omatic-free-music-post-generator');?> - <b><?php echo esc_html__("New Posts Created", 'mp3omatic-free-music-post-generator');?></b></td>
                  </tr>
                  <tr>
                     <td><img id="fail_img" src="<?php echo esc_url(plugin_dir_url(dirname(__FILE__)) . 'images/failed.gif');?>" alt="Faield" title="status"></td>
                     <td><?php echo esc_html__("Failed", 'mp3omatic-free-music-post-generator');?> - <b><?php echo esc_html__("An Error Occurred.", 'mp3omatic-free-music-post-generator');?> <b><?php echo esc_html__("Please check 'Activity and Logging' plugin menu for details.", 'mp3omatic-free-music-post-generator');?></b></td>
                  </tr>
                  <tr>
                     <td><img id="nochange_img" src="<?php echo esc_url(plugin_dir_url(dirname(__FILE__)) . 'images/nochange.gif');?>" alt="NoChange" title="status"></td>
                     <td><?php echo esc_html__("No Change - No New Posts Created", 'mp3omatic-free-music-post-generator');?> - <b><?php echo esc_html__("Possible reasons:", 'mp3omatic-free-music-post-generator');?></b></td>
                  </tr>
                  <tr>
                     <td></td>
                     <td>
                        <ul>
                           <li>&#9658; <?php echo esc_html__("Already all posts are published that match your search and posts will be posted when new content will be available", 'mp3omatic-free-music-post-generator');?></li>
                           <li>&#9658; <?php echo esc_html__("Some restrictions you defined in the plugin's 'Main Settings'", 'mp3omatic-free-music-post-generator');?> <i>(<?php echo esc_html__("example: 'Minimum Content Word Count', 'Maximum Content Word Count', 'Minimum Title Word Count', 'Maximum Title Word Count', 'Banned Words List', 'Reuired Words List', 'Skip Posts Without Images'", 'mp3omatic-free-music-post-generator');?>)</i> <?php echo esc_html__("prevent posting of new posts.", 'mp3omatic-free-music-post-generator');?></li>
                        </ul>
                     </td>
                  </tr>
               </table>
            </div>
         </div>
      </form>
   </div>
</div>
<?php
   }
   if (isset($_POST['mp3omatic_rules_list'])) {
       add_action('admin_init', 'mp3omatic_save_rules_manual');
   }
   function mp3omatic_save_rules_manual($data2)
   {
       check_admin_referer('mp3omatic_save_rules', '_mp3omaticr_nonce');
       
       $data2 = $_POST['mp3omatic_rules_list'];
       $rules = array();
       $cont  = 0;
       $cat_cont = 0;
       if (isset($data2['game_keywords'][0])) {
           for ($i = 0; $i < sizeof($data2['game_keywords']); ++$i) {
               $bundle = array();
               if (isset($data2['schedule'][$i]) && $data2['schedule'][$i] != '' && $data2['game_keywords'][$i] != '') {
                   $bundle[]     = trim(sanitize_text_field($data2['game_keywords'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['schedule'][$i]));
                   if (isset($data2['active'][$i])) {
                       $bundle[] = trim(sanitize_text_field($data2['active'][$i]));
                   } else {
                       $bundle[] = '0';
                   }
                   $bundle[]     = trim(sanitize_text_field($data2['last_run'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['max'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['submit_status'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['default_type'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['post_author'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['default_tags'][$i]));
                   if($i == sizeof($data2['game_keywords']) - 1)
                   {
                       if(isset($data2['default_category']))
                       {
                           $bundle[]     = $data2['default_category'];
                       }
                       else
                       {
                           if(!isset($data2['default_category' . $cat_cont]))
                           {
                               $cat_cont++;
                           }
                           if(!isset($data2['default_category' . $cat_cont]))
                           {
                               $bundle[]     = array('mp3omatic_no_category_12345678');
                           }
                           else
                           {
                               $bundle[]     = $data2['default_category' . $cat_cont];
                           }
                       }
                   }
                   else
                   {
                       if(!isset($data2['default_category' . $cat_cont]))
                       {
                           $cat_cont++;
                       }
                       if(!isset($data2['default_category' . $cat_cont]))
                       {
                           $bundle[]     = array('mp3omatic_no_category_12345678');
                       }
                       else
                       {
                           $bundle[]     = $data2['default_category' . $cat_cont];
                       }
                   }
                   $bundle[]     = trim(sanitize_text_field($data2['auto_categories'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['auto_tags'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['enable_comments'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['featured_image'][$i]));
                   $bundle[]     = trim($data2['image_url'][$i]);
                   $bundle[]     = $data2['post_title'][$i];
                   $bundle[]     = $data2['post_content'][$i];
                   $bundle[]     = trim(sanitize_text_field($data2['enable_pingback'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['post_format'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['min_length'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['max_length'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['max_posts'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['remove_default'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['continue_search'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['import_date'][$i]));
                   $bundle[]     = trim($data2['custom_fields'][$i]);
                   $bundle[]     = trim(sanitize_text_field($data2['only_instrumental'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['sort_results'][$i]));
                   $rules[$cont] = $bundle;
                   $cont++;
                   $cat_cont++;
               }
           }
       }
       update_option('mp3omatic_rules_list', $rules, false);
   }
   function mp3omatic_expand_rules_manual()
   {
       if (!get_option('mp3omatic_running_list')) {
           $running = array();
       } else {
           $running = get_option('mp3omatic_running_list');
       }
       $GLOBALS['wp_object_cache']->delete('mp3omatic_rules_list', 'options');
       $rules  = get_option('mp3omatic_rules_list');
    if(!is_array($rules))
    {
       $rules = array();
    }
       $output = '';
       $cont   = 0;
       if (!empty($rules)) {
           $posted_items = array();
           $post_list = array();
           $postsPerPage = 50000;
           $paged = 0;
           do
           {
               $postOffset = $paged * $postsPerPage;
               $query = array(
                   'post_status' => array(
                       'publish',
                       'draft',
                       'pending',
                       'trash',
                       'private',
                       'future'
                   ),
                   'post_type' => array(
                       'any'
                   ),
                   'numberposts' => $postsPerPage,
                   'meta_key' => 'mp3omatic_parent_rule',
                   'fields' => 'ids',
                   'offset'  => $postOffset
               );
               $got_me = get_posts($query);
               $post_list = array_merge($post_list, $got_me);
               $paged++;
           }while(!empty($got_me));
           wp_suspend_cache_addition(true);
           foreach ($post_list as $post) {
               $rule_id = get_post_meta($post, 'mp3omatic_parent_rule', true);
               $rule_type = get_post_meta($post, 'mp3omatic_parent_type', true);
               if ($rule_id != '' && $rule_type == '0') {
                   $posted_items[] = $rule_id;
               }
           }
           wp_suspend_cache_addition(false);
           $counted_vals = array_count_values($posted_items);
           foreach ($rules as $request => $bundle[]) {
               if (isset($counted_vals[$cont])) {
                   $generated_posts = $counted_vals[$cont];
               } else {
                   $generated_posts = 0;
               }
               $bundle_values          = array_values($bundle);
               $myValues               = $bundle_values[$cont];
               $array_my_values        = array_values($myValues);for($iji=0;$iji<count($array_my_values);++$iji){if(is_string($array_my_values[$iji])){$array_my_values[$iji]=stripslashes($array_my_values[$iji]);}}
               $game_keywords          = $array_my_values[0];
               $schedule               = $array_my_values[1];
               $active                 = $array_my_values[2];
               $last_run               = $array_my_values[3];
               $max                    = $array_my_values[4];
               $status                 = $array_my_values[5];
               $def_type               = $array_my_values[6];
               $post_user_name         = $array_my_values[7];
               $default_tags           = $array_my_values[8];
               $default_category       = $array_my_values[9];
               $auto_categories        = $array_my_values[10];
               $auto_tags              = $array_my_values[11];
               $enable_comments        = $array_my_values[12];
               $featured_image         = $array_my_values[13];
               $image_url              = $array_my_values[14];
               $post_title             = $array_my_values[15];
               $post_content           = $array_my_values[16];
               $enable_pingback        = $array_my_values[17];
               $post_format            = $array_my_values[18];
               $min_length             = $array_my_values[19];
               $max_length             = $array_my_values[20]; 
               $max_posts              = $array_my_values[21];
               $remove_default         = $array_my_values[22];
               $continue_search        = $array_my_values[23];
               $import_date            = $array_my_values[24];
               $custom_fields          = $array_my_values[25];
               $only_instrumental      = $array_my_values[26];
               $sort_results           = $array_my_values[27];
               wp_add_inline_script('mp3omatic-footer-script', 'createAdmin(' . esc_html($cont) . ');', 'after');
               $output .= '<tr>
                           <td class="cr_align_middle cr_td_short">' . esc_html($cont) . '</td>
                           <td class="cr_td_cust"><input type="text" name="mp3omatic_rules_list[game_keywords][]" placeholder="Search query" value="' . esc_attr($game_keywords) . '" class="cr_width_full"/></td> </td>
                       <td class="cr_comm_td"><input type="number" step="1" min="1" placeholder="# h" name="mp3omatic_rules_list[schedule][]" max="8765812" value="' . esc_attr($schedule) . '" class="cr_width_60" required></td>
                           <td class="cr_comm_td"><input type="number" step="1" min="0" placeholder="# max" max="200" name="mp3omatic_rules_list[max][]" value="' . esc_attr($max) . '"  class="cr_width_60" required></td>
                       <td class="cr_width_70">
                       <input type="button" id="mybtnfzr' . esc_html($cont) . '" value="Settings">
                       <div id="mymodalfzr' . esc_html($cont) . '" class="codemodalfzr">
     <div class="codemodalfzr-content">
       <div class="codemodalfzr-header">
         <span id="mp3omatic_close' . esc_html($cont) . '" class="codeclosefzr">&times;</span>
         <h2>' . esc_html__('Rule', 'mp3omatic-free-music-post-generator') . ' <span class="cr_color_white">ID ' . esc_html($cont) . '</span> ' . esc_html__('Advanced Settings', 'mp3omatic-free-music-post-generator') . '</h2>
       </div>
       <div class="codemodalfzr-body">
       <div class="table-responsive">
         <table class="responsive table cr_main_table_nowr">
       <tr><td class="cr_min_width_200">
       <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set the title of the generated posts for user rules. You can use the following shortcodes:  %%random_sentence%%, %%random_sentence2%%, %%item_title%%, %%item_url%%, %%item_date%%, %%item_duration%%, %%item_playback_count%%", 'mp3omatic-free-music-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Generated Post Title", 'mp3omatic-free-music-post-generator') . ':</b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                       
                       </td><td>
                       <input type="text" name="mp3omatic_rules_list[post_title][]" value="' . esc_attr(htmlspecialchars($post_title)) . '" placeholder="Please insert your desired post title. Example: %%item_title%%" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set the content of the generated posts for user rules. You can use the following shortcodes: %%item_cat%%, %%item_tags%%, %%random_sentence%%, %%random_sentence2%%, %%custom_html%%, %%custom_html2%%, %%item_playback_count%%, %%item_download_embed%%, %%item_download_path%%, %%item_duration%%, %%item_title%%, %%item_favoritings_count%%, %%item_song_tags%%, %%item_artist_name%%, %%item_artist_url%%, %%item_artist_website%%, %%item_url%%, %%item_date%%, %%item_duration%%, %%featured_image_url%%, %%item_show_image%%, %%item_genre%%, %%item_read_more_button%%, %%item_author%%, %%item_author_link%%, %%item_author_id%%, %%item_track_id%%, %%item_download_url%%, %%item_favoritings_count%% You can also use this shortcode: %%item_title_first_X_characters%% - where X can be any number from 1 upwards.", 'mp3omatic-free-music-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Generated Post Content", 'mp3omatic-free-music-post-generator') . ':</b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                       
                       </td><td>
                       <textarea rows="2" cols="70" name="mp3omatic_rules_list[post_content][]" placeholder="Please insert your desired post content. Example: %%item_title%%" class="cr_width_full">' . htmlspecialchars($post_content) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to remember last posted item and continue search from it the next time the importing rule runs? Please note that \'Playlist Search\' and \'User Search\' does not support this feature.", 'mp3omatic-free-music-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Cache Items For Continuous Posting (disable to get latest posts only)", 'mp3omatic-free-music-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="continue_search" name="mp3omatic_rules_list[continue_search][]"';
               if ($continue_search == '1') {
                   $output .= ' checked';
               }
               $output .= '>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__('Set the minimum length of the returned tracks, in seconds', 'mp3omatic-free-music-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Minimum Length", 'mp3omatic-free-music-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="number" min="1" step="1" name="mp3omatic_rules_list[min_length][]" value="'.esc_attr($min_length).'" placeholder="Min length (s)" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__('Set the maximum length of the returned tracks, in seconds', 'mp3omatic-free-music-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Maximum Length", 'mp3omatic-free-music-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="number" min="1" step="1" name="mp3omatic_rules_list[max_length][]" value="'.esc_attr($max_length).'" placeholder="Max length (s)" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Sort results. Possible values are: track_id, track_title, track_url, track_image_file, artist_id, artist_name, artist_url,artist_website,album_id,album_title,album_url,license_title,license_url,track_language_code,track_duration,track_number,track_disc_number,track_explicit,track_explicit_notes,track_copyright_c,track_copyright_p,track_composer,track_lyricist,track_publisher,track_instrumental,track_information,track_date_recorded,track_comments,track_favorites,track_listens,track_interest,track_bit_rate,track_date_created,track_file,license_image_file, license_image_file_large, license_parent_id", 'mp3omatic-free-music-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Sort Results By", 'mp3omatic-free-music-post-generator') . ':</b>
                       
                       </td><td>
                       <select id="sort_results" name="mp3omatic_rules_list[sort_results][]" class="cr_width_full">
                                     <option value="_score"';
               if ($sort_results == '_score') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Score", 'mp3omatic-free-music-post-generator') . '</option>
                                     <option value="date"';
               if ($sort_results == 'date') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Date Added", 'mp3omatic-free-music-post-generator') . '</option>
                       </select>  
                       </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set the maximum number of posts you want this rule to publish per day.", 'mp3omatic-free-music-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Max Posts Per Day", 'mp3omatic-free-music-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="number" min="1" step="1" id="max_posts" name="mp3omatic_rules_list[max_posts][]" value="' . esc_attr($max_posts) . '" placeholder="Max posts per day" class="cr_width_full"> 
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Include only instrumental tracks", 'mp3omatic-free-music-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Only Instrumental", 'mp3omatic-free-music-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="only_instrumental" name="mp3omatic_rules_list[only_instrumental][]"';
           if($only_instrumental == '1')
           {
               $output .= ' checked';
           }
           $output .= '>
                           
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set the maximum number of posts you want this rule to publish per day.", 'mp3omatic-free-music-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Max Posts Per Day", 'mp3omatic-free-music-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="number" min="1" step="1" id="max_posts" name="mp3omatic_rules_list[max_posts][]" value="' . esc_attr($max_posts) . '" placeholder="Max posts per day" class="cr_width_full"> 
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select the status that you want for the automatically generated posts to have.", 'mp3omatic-free-music-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Post Status", 'mp3omatic-free-music-post-generator') . ':</b>
                       
                       </td><td>
                       <select id="submit_status" name="mp3omatic_rules_list[submit_status][]" class="cr_width_full">
                                     <option value="pending"';
               if ($status == 'pending') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Pending -> Moderate", 'mp3omatic-free-music-post-generator') . '</option>
                                     <option value="draft"';
               if ($status == 'draft') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Draft -> Moderate", 'mp3omatic-free-music-post-generator') . '</option>
                                     <option value="publish"';
               if ($status == 'publish') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Published", 'mp3omatic-free-music-post-generator') . '</option>
                                     <option value="private"';
               if ($status == 'private') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Private", 'mp3omatic-free-music-post-generator') . '</option>
                                     <option value="trash"';
               if ($status == 'trash') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Trash", 'mp3omatic-free-music-post-generator') . '</option>
                       </select>  
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to to set the post published date as the date grabbed from the feed article? If you disable this feature, the date when the rule is run will be used.", 'mp3omatic-free-music-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Get Post Publish Date From Feed", 'mp3omatic-free-music-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="import_date" name="mp3omatic_rules_list[import_date][]"';
           if($import_date == '1')
           {
               $output .= ' checked';
           }
           $output .= '>
                           
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select the type (post/page) for your automatically generated item.", 'mp3omatic-free-music-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Item Type", 'mp3omatic-free-music-post-generator') . ':</b>
                       
                       </td><td>
                       <select id="default_type" name="mp3omatic_rules_list[default_type][]" class="cr_width_full">';
               foreach ( get_post_types( '', 'names' ) as $post_type ) {
                  $output .= '<option value="' . esc_attr($post_type) . '"';
                  if ($def_type == $post_type) {
                       $output .= ' selected';
                   }
                  $output .= '>' . esc_html($post_type) . '</option>';
               }
                       $output .= '</select>    
           </div>
                   </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select the author that you want to assign for the automatically generated posts.", 'mp3omatic-free-music-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Post Author", 'mp3omatic-free-music-post-generator') . ':</b>
                       
                       </td><td>
                       <select id="post_author" name="mp3omatic_rules_list[post_author][]" class="cr_width_full">';
               $blogusers = get_users( [ 'role__in' => [ 'contributor', 'author', 'editor', 'administrator' ] ] );
               foreach ($blogusers as $user) {
                   $output .= '<option value="' . esc_html($user->ID) . '"';
                   if ($post_user_name == $user->ID) {
                       $output .= " selected";
                   }
                   $output .= '>' . esc_html($user->display_name) . '</option>';
               }
               $output .= '</select>
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__('If your template supports "Post Formats", than you can select one here. If not, leave this at it\'s default value.', 'mp3omatic-free-music-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Generated Post Format", 'mp3omatic-free-music-post-generator') . ':</b>   
                       </td><td>
                       <select id="post_format" name="mp3omatic_rules_list[post_format][]" class="cr_width_full">
                       <option value="post-format-standard"';
               if ($post_format == 'post-format-standard') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Standard", 'mp3omatic-free-music-post-generator') . '</option>
                       <option value="post-format-aside"';
               if ($post_format == 'post-format-aside') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Aside", 'mp3omatic-free-music-post-generator') . '</option>
                       <option value="post-format-gallery"';
               if ($post_format == 'post-format-gallery') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Gallery", 'mp3omatic-free-music-post-generator') . '</option>
                       <option value="post-format-link"';
               if ($post_format == 'post-format-link') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Link", 'mp3omatic-free-music-post-generator') . '</option>
                       <option value="post-format-image"';
               if ($post_format == 'post-format-image') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Image", 'mp3omatic-free-music-post-generator') . '</option>
                       <option value="post-format-quote"';
               if ($post_format == 'post-format-quote') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Quote", 'mp3omatic-free-music-post-generator') . '</option>
                       <option value="post-format-status"';
               if ($post_format == 'post-format-status') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Status", 'mp3omatic-free-music-post-generator') . '</option>
                       <option value="post-format-video"';
               if ($post_format == 'post-format-video') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Video", 'mp3omatic-free-music-post-generator') . '</option>
                       <option value="post-format-audio"';
               if ($post_format == 'post-format-audio') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Audio", 'mp3omatic-free-music-post-generator') . '</option>
                       <option value="post-format-chat"';
               if ($post_format == 'post-format-chat') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Chat", 'mp3omatic-free-music-post-generator') . '</option>
                   </select>     
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select the post category that you want for the automatically generated posts to have. To select more categories, hold down the CTRL key.", 'mp3omatic-free-music-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Additional Post Category", 'mp3omatic-free-music-post-generator') . ':</b>
                       
                       </td><td>
                       <select multiple class="cr_width_full" id="default_category" name="mp3omatic_rules_list[default_category' . esc_html($cont) . '][]">
                       <option value="mp3omatic_no_category_12345678"';
                       if(!is_array($default_category))
                       {
                           $default_category = array($default_category);
                       }
                       if(count($default_category) == 1)
                       {
                        foreach($default_category as $dc)
                        {
                              if ("mp3omatic_no_category_12345678" == $dc) {
                                 $output .= ' selected';
                              }
                        }
                     }
                       $output .= '>' . esc_html__("Do Not Add a Category", 'mp3omatic-free-music-post-generator') . '</option>';
               $cat_args   = array(
                   "orderby" => "name",
                   "hide_empty" => 0,
                   "order" => "ASC"
               );
               $categories = get_categories($cat_args);
               
               foreach ($categories as $category) {
                   $output .= '<option value="' . esc_attr($category->term_id) . '"';
                   foreach($default_category as $dc)
                   {
                       if ($category->term_id == $dc) {
                           $output .= ' selected';
                       }
                   }
                   
                   $output .= '>' . sanitize_text_field($category->name) . '</option>';
               }
               $output .= '</select>     
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to automatically add post categories from the feed items?", 'mp3omatic-free-music-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Auto Add Categories", 'mp3omatic-free-music-post-generator') . ':</b>
                       
                       </td><td>
                       <select class="cr_width_full" id="auto_categories" name="mp3omatic_rules_list[auto_categories][]">
                       <option value="disabled"';
               if ($auto_categories == 'disabled') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Disabled", 'mp3omatic-free-music-post-generator') . '</option>
                       <option value="video"';
               if ($auto_categories == 'video') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Track Tags", 'mp3omatic-free-music-post-generator') . '</option>
               <option value="genre"';
               if ($auto_categories == 'genre') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Track Genre", 'mp3omatic-free-music-post-generator') . '</option>
                       <option value="content"';
               if ($auto_categories == 'content') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Content", 'mp3omatic-free-music-post-generator') . '</option>
                       <option value="both"';
               if ($auto_categories == 'both') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Track Tags and Content", 'mp3omatic-free-music-post-generator') . '</option>
                       </select>                
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("This feature will try to remove the WordPress\'s default post category. This may fail in case no additional categories are added, because WordPress requires at least one post category for every post.", 'mp3omatic-free-music-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Remove WP Default Post Category", 'mp3omatic-free-music-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="remove_default" name="mp3omatic_rules_list[remove_default][]"';
           if($remove_default == '1')
           {
               $output .= ' checked';
           }
           $output .= '>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to automatically add post tags from the feed items?", 'mp3omatic-free-music-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Auto Add Tags", 'mp3omatic-free-music-post-generator') . ':</b>
                       
                       </td><td>
                       <select class="cr_width_full" id="auto_tags" name="mp3omatic_rules_list[auto_tags][]">
                       <option value="disabled"';
               if ($auto_tags == 'disabled') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Disabled", 'mp3omatic-free-music-post-generator') . '</option>
                       <option value="video"';
               if ($auto_tags == 'video') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Track Tags", 'mp3omatic-free-music-post-generator') . '</option>
               <option value="genre"';
               if ($auto_tags == 'genre') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Track Genre", 'mp3omatic-free-music-post-generator') . '</option>
                       <option value="content"';
               if ($auto_tags == 'content') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Content", 'mp3omatic-free-music-post-generator') . '</option>
                       <option value="both"';
               if ($auto_tags == 'both') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Track Tags and Content", 'mp3omatic-free-music-post-generator') . '</option>
                       </select>     
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select the post tags that you want for the automatically generated posts to have.", 'mp3omatic-free-music-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Additional Post Tags", 'mp3omatic-free-music-post-generator') . ':</b>
                       
                       </td><td>
                       <input class="cr_width_full" type="text" name="mp3omatic_rules_list[default_tags][]" value="' . esc_attr($default_tags) . '" placeholder="Please insert your additional post tags here" >
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to enable comments for the generated posts?", 'mp3omatic-free-music-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Enable Comments For Posts", 'mp3omatic-free-music-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="enable_comments" name="mp3omatic_rules_list[enable_comments][]"';
               if ($enable_comments == '1') {
                   $output .= ' checked';
               }
               $output .= '>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to enable pingbacks and trackbacks for the generated posts?", 'mp3omatic-free-music-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Enable Pingback/Trackback", 'mp3omatic-free-music-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="enable_pingback" name="mp3omatic_rules_list[enable_pingback][]"';
               if ($enable_pingback == '1') {
                   $output .= ' checked';
               }
               $output .= '>
                           
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set the custom fields that will be set for generated posts. The syntax for this field is the following: custom_field_name1 => custom_field_value1, custom_field_name2 => custom_field_value2, ... . In custom_field_valueX, you can use shortcodes, same like in post content. You can also assign the data to array custom fields, using this format: array_field[index_name1] => custom_field_value1, array_field[index_name2] => custom_field_value2. Example (without quotes): \'title_custom_field => %%item_title%%\'. You can use the following shortcodes: %%item_cat%%, %%item_tags%%, %%random_sentence%%, %%random_sentence2%%, %%custom_html%%, %%custom_html2%%, %%item_playback_count%%, %%item_download_embed%%, %%item_download_path%%, %%item_duration%%, %%item_title%%, %%item_favoritings_count%%, %%item_song_tags%%, %%item_artist_name%%, %%item_artist_url%%, %%item_artist_website%%, %%item_url%%, %%item_date%%, %%item_duration%%, %%featured_image_url%%, %%item_show_image%%, %%item_genre%%, %%item_read_more_button%%, %%item_author%%, %%item_author_link%%, %%item_author_id%%, %%item_track_id%%, %%item_download_url%%, %%item_favoritings_count%% You can also use this shortcode: %%item_title_first_X_characters%% - where X can be any number from 1 upwards.", 'mp3omatic-free-music-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Post Custom Fields", 'mp3omatic-free-music-post-generator') . ':</b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                       
                       </td><td>
                       <textarea rows="1" cols="70" name="mp3omatic_rules_list[custom_fields][]" placeholder="Please insert your desired custom fields. Example: title_custom_field => %%item_title%%" class="cr_width_full">' . esc_textarea($custom_fields) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to set featured image for generated post (to the first image that was found in the post)?", 'mp3omatic-free-music-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Auto Get Featured Image", 'mp3omatic-free-music-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="featured_image" name="mp3omatic_rules_list[featured_image][]"';
               if ($featured_image == '1') {
                   $output .= ' checked';
               }
               $output .= '>
                           
           </div>
           </td></tr><tr><td>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Insert a comma separated list of links to valid images that will be set randomly for the featured image for the posts that do not have a valid image attached or if you disabled automatical featured image generation. You can also use image numeric IDs from images found in the Media Gallery. To disable this feature, leave this field blank.", 'mp3omatic-free-music-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Default Featured Image List", 'mp3omatic-free-music-post-generator') . ':</b>
                       </td><td>
                       <input class="cr_width_full" type="text" name="mp3omatic_rules_list[image_url][]" placeholder="Please insert the link to a valid image" value="' . esc_attr($image_url) . '"/>
           </div>           
           </td></tr></table></div> 
       </div>
       <div class="codemodalfzr-footer">
         <br/>
         <h3 class="cr_inline">Mp3omatic Automatic Post Generator</h3><span id="mp3omatic_ok' . esc_html($cont) . '" class="codeokfzr cr_inline">OK&nbsp;</span>
         <br/><br/>
       </div>
     </div>
   
   </div>      
                       </td>
   						<td class="cr_td_short"><span class="wpmp3omatic-delete">X</span></td>
                           <td class="cr_align_middle cr_td_short"><input type="checkbox" name="mp3omatic_rules_list[active][]" class="activateDeactivateClass" value="1"';
               if (isset($active) && $active === '1') {
                   $output .= ' checked';
               }
               $output .= '/>
                           <input type="hidden" name="mp3omatic_rules_list[last_run][]" value="' . esc_attr($last_run) . '"/></td>
                           <td class="cr_td_short"><div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Shortcode for this rule<br/>(to cross-post from this plugin in other plugins):', 'mp3omatic-free-music-post-generator'), array(  'br' => array( ) ) ) ) . '<br/><b>%%mp3omatic_0_' . esc_html($cont) . '%%</b><br/>' . esc_html__('Posts Generated:', 'mp3omatic-free-music-post-generator') . ' ' . esc_html($generated_posts) . '<br/>';
               if ($generated_posts != 0) {
                   $output .= '<a href="' . get_admin_url() . 'edit.php?coderevolution_post_source=Mp3omatic_0_' . esc_html($cont) . '&post_type=' . esc_html($def_type) . '" target="_blank">' . esc_html__('View Generated Posts', 'mp3omatic-free-music-post-generator') . '</a><br/>';
               }
               $output .= esc_html__('Last Run: ', 'mp3omatic-free-music-post-generator');
               if ($last_run == '1988-01-27 00:00:00') {
                   $output .= 'Never';
               } else {
                   $output .= $last_run;
               }
               $output .= '<br/>' . esc_html__('Next Run: ', 'mp3omatic-free-music-post-generator');
               $nextrun = mp3omatic_add_hour($last_run, $schedule);
               $now     = mp3omatic_get_date_now();
               if ( defined( 'DISABLE_WP_CRON' ) && DISABLE_WP_CRON ) {
                   $output .= esc_html__('WP-CRON Disabled. Rules will not automatically run!', 'mp3omatic-free-music-post-generator');
               }
               else
               {
                   if (isset($active) && $active === '1') {
                       $mp3omatic_hour_diff = (int) mp3omatic_hour_diff($now, $nextrun);
                       if ($mp3omatic_hour_diff >= 0) {
                           $append = 'Now.';
                           $cron   = _get_cron_array();
                           if ($cron != FALSE) {
                               $date_format = _x('Y-m-d H:i:s', 'Date Time Format1', 'mp3omatic-free-music-post-generator');
                               foreach ($cron as $timestamp => $cronhooks) {
                                   foreach ((array) $cronhooks as $hook => $events) {
                                       if ($hook == 'mp3omaticaction') {
                                           foreach ((array) $events as $key => $event) {
                                               $append = date_i18n($date_format, $timestamp);
                                           }
                                       }
                                   }
                               }
                           }
                           $output .= $append;
                       } else {
                           $output .= $nextrun;
                       }
                   } else {
                       $output .= esc_html__('Rule Disabled', 'mp3omatic-free-music-post-generator');
                   }
               }
               $output .= '<br/>' . esc_html__('Local Time: ', 'mp3omatic-free-music-post-generator') . $now;
               $output .= '</div>
                       </div></td>
                           <td class="cr_center">
                           <div>
                           <img id="run_img' . esc_html($cont) . '" src="' . plugin_dir_url(dirname(__FILE__)) . 'images/running.gif' . '" alt="Running" class="cr_status_icon';
               if (!empty($running)) {
                   if (!in_array(array($cont => 0), $running)) {
                       $output .= ' cr_hidden';
                   }
                   else
                   {
                       $f = fopen(get_temp_dir() . 'mp3omatic_0_' . $cont, 'w');
                       if($f !== false)
                       {
                           if (!flock($f, LOCK_EX | LOCK_NB)) {
                           }
                           else
                           {
                               $output .= ' cr_hidden';
                               flock($f, LOCK_UN);
                               if (($xxkey = array_search(array($cont => 0), $running)) !== false) {
                                   unset($running[$xxkey]);
                                   update_option('mp3omatic_running_list', $running);
                               }
                           }
                       }
                   }
               } else {
                   $output .= ' cr_hidden';
               }
               $output .= '" title="status">
                           <div class="codemainfzr">
                           <select id="actions" class="actions" name="actions" onchange="actionsChangedManual(' . esc_html($cont) . ', this.value, 0);" onfocus="this.selectedIndex = 0;">
                               <option value="select" disabled selected>' . esc_html__("Select an Action", 'mp3omatic-free-music-post-generator') . '</option>
                               <option value="run">' . esc_html__("Run This Rule Now", 'mp3omatic-free-music-post-generator') . '</option>
                               <option value="trash">' . esc_html__("Move All Posts To Trash", 'mp3omatic-free-music-post-generator') . '</option>
                               <option value="delete">' . esc_html__("Permanently Delete All Posts", 'mp3omatic-free-music-post-generator') . '</option>
                           </select>
                           </div>
                           </div>
                           </td>
   					</tr>	
   					';
               $cont = $cont + 1;
           }
       }
       return $output;
   }
   ?>