<div class="content-box content-wpmf-google-drive">
    <?php
    if (isset($googleconfig['googleClientId']) && $googleconfig['googleClientId'] !== ''
        && isset($googleconfig['googleClientSecret']) && $googleconfig['googleClientSecret'] !== '') {
        if (!$googleDrive->checkAuth()) {
            $url = $googleDrive->getAuthorisationUrl();
            ?>
            <a id="ggconnect" class="button button-primary btndrive" href="#"
               onclick="window.location.assign('<?php echo esc_html($url); ?>','foo','width=600,height=600');return false;">
                <img class="wpmficon_gg_drop" src="<?php echo esc_html(WPMFAD_URL) . 'assets/images/drive-icon-colored.png'; ?>"
                     alt=""/>
                <?php esc_html_e('Connect Google Drive', 'wpmfAddon') ?></a>

            <?php
        } else {
            $url_logout = admin_url('options-general.php?page=option-folder&task=wpmf&function=wpmf_gglogout');
            ?>
            <a id="gg_disconnect" class="button btndrive"
               href="<?php echo esc_html($url_logout) ?>">
                <img class="wpmficon_gg_drop" src="<?php echo esc_html(WPMFAD_URL) . 'assets/images/drive-icon-colored.png'; ?>"
                     alt=""/>
                <?php esc_html_e('Disconnect Google Drive', 'wpmfAddon') ?></a>

            <?php
        }
    }
    ?>
    <table class="form-table" style="margin-left: 10px;">
        <tbody>
        <tr>
            <th scope="row"><label for="googleClientId"><?php esc_html_e('Google Client ID', 'wpmfAddon') ?></label>
            </th>
            <td>
                <input title name="googleClientId" type="text" class="regular-text"
                       value="<?php echo esc_attr($googleconfig['googleClientId']) ?>">
                <p class="description" id="tagline-description">
                    <?php esc_html_e('The Client ID for Web application available in your google Developers Console.
                     Click on documentation link below for more info', 'wpmfAddon') ?>
                </p>
            </td>
        </tr>
        <tr>
            <th scope="row"><label
                        for="googleClientSecret"><?php esc_html_e('Google Client Secret', 'wpmfAddon') ?></label>
            </th>
            <td>
                <input title name="googleClientSecret" type="text" class="regular-text"
                       value="<?php echo esc_attr($googleconfig['googleClientSecret']) ?>">
                <p class="description" id="tagline-description">
                    <?php esc_html_e('The Client secret for Web application available in your google Developers Console.
                     Click on documentation link below for more info', 'wpmfAddon') ?>
                </p>
            </td>
        </tr>
        <tr>
            <th scope="row"><label
                        for="javaScript_origins"><?php esc_html_e('JavaScript origins', 'wpmfAddon') ?></label></th>
            <td>
                <input title name="javaScript_origins" type="url" id="siteurl" readonly value="<?php echo esc_attr(site_url()); ?>"
                       class="regular-text">
            </td>
        </tr>
        <tr>
            <th scope="row"><label for="redirect_uris"><?php esc_html_e('Redirect URIs', 'wpmfAddon') ?></label></th>
            <td>
                <input title name="redirect_uris"
                       type="url" id="home" readonly
                       value="<?php echo esc_attr(admin_url('options-general.php?page=option-folder&task=wpmf&function=wpmf_authenticated')) ?>"
                       class="regular-text code">
            </td>
        </tr>

        </tbody>
    </table>

    <a style="margin: 10px;" target="_blank" class="button"
       href="https://www.joomunited.com/documentation/wp-media-folder-cloud-addon#toc-ii-connect-google-drive">
        <?php esc_html_e('Read the online documentation', 'wpmfAddon') ?>
    </a>
</div>