<?php
// getting rid of float
$class[] = 'gallery-masonry square_grid';
$class[] = 'galleryid-' . $id;
$class[] = 'gallery-columns-' . $columns;
$class[] = 'gallery-size-' . $size_class;
$class[] = 'wpmf-gallery-bottomspace-default';
$class[] = 'wpmf-gallery-clear';
$class   = implode(' ', $class);

$padding_masonry = get_option('wpmf_padding_masonry');
if (!isset($padding_masonry) && $padding_masonry === '') {
    $padding_masonry = 5;
}

$lists      = array();
$lists_full = array();
$j          = 0;

$current_theme = get_option('current_theme');
if (isset($current_theme) && $current_theme === 'Gleam') {
    $tclass = 'fancybox';
} else {
    $tclass = '';
}
foreach ($attachments as $id => $attachment) {
    $image_meta = wp_get_attachment_metadata($id);
    if (empty($image_meta['height']) || empty($image_meta['width'])) {
        continue;
    }
    $post_title   = esc_html($attachment->post_title);
    $post_excerpt = esc_html($attachment->post_excerpt);
    $link_target  = get_post_meta($attachment->ID, '_gallery_link_target', true);
    $img_tags     = get_post_meta($attachment->ID, 'wpmf_img_tags', true);
    $tg           = get_post_meta($attachment->ID, '_gallery_link_target', true);
    $icon         = "<span class='hover_img'></span>";
    if ($customlink) {
        $url = get_post_meta($id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true);
        if ($url === '') {
            $url = get_attachment_link($id);
        }
        $icon         = '<a href="' . $url . '" title="' . $post_title . '" class="hover_img ' . $tclass . '" target="' . $tg . '"></a>';
        $image_output = $this->galleryGetAttachmentLink($id, $size, false, $targetsize, $customlink, $link_target);
    } elseif (!empty($link) && 'file' === $link) {
        $image_output = $this->galleryGetAttachmentLink($id, $size, false, $targetsize, $customlink, $link_target);
        if (strpos($image_output, "data-swipe='0'")) {
            $url  = get_post_meta($id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true);
            $icon = '<a data-swipe="0" href="' . $url . '" title="' . $post_title . '"
 class="wpmfgalleryaddonswipe hover_img ' . $tclass . '" target="' . $tg . '"></a>';
        } else {
            $urls      = wp_get_attachment_image_src($id, $targetsize);
            $url       = $urls[0];
            $data_size = $urls[1] . 'x' . $urls[2];
            if (!empty($remote_video)) {
                $icon = '<a data-size="' . $data_size . '" data-swipe="1" href="' . $remote_video . '"
 title="' . $post_title . '" class="wpmfgalleryaddonswipe hover_img ' . $tclass . ' isvideo"></a>';
            } else {
                $icon = '<a data-size="' . $data_size . '" data-swipe="1" href="' . $url . '" title="' . $post_title . '"
 class="wpmfgalleryaddonswipe hover_img ' . $tclass . ' not_video"></a>';
            }
        }
    } elseif (!empty($link) && 'none' === $link) {
        if (get_post_meta($id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true) !== '') {
            $image_output = $this->galleryGetAttachmentLink($id, $size, false, $targetsize, $customlink, $link_target);
            $url          = get_post_meta($id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true);
            $icon         = '<a href="' . $url . '" title="' . $post_title . '" class="hover_img ' . $tclass . '" target="' . $tg . '"></a>';
        } else {
            $image_output = wp_get_attachment_image($id, $size, false, array('data-type' => 'wpmfgalleryimg'));
        }
    } else {
        $image_output = $this->galleryGetAttachmentLink($id, $size, true, 'large', false, $link_target);
    }

    $orientation = ($image_meta['height'] > $image_meta['width']) ? 'portrait' : 'landscape';
    $item        = '<div class="wpmf-gallery-item" data-tags="' . $img_tags . '">';
    $item        .= '<div class="gallery-icon ' . $orientation . '">';
    $item        .= $icon . $image_output;

    if ((int) $social_sharing === 1) {
        if (!empty($facebook) || !empty($twitter) || !empty($google) || !empty($instagram) || !empty($pinterest)) {
            $item .= '<div class="wpmfglr_social">';
            if (!empty($facebook)) {
                $item .= '<a href="' . $facebook . '"  target="_blank">
<span class="dashicons dashicons-facebook-alt"></span></a>';
            }

            if (!empty($twitter)) {
                $item .= '<a href="' . $twitter . '"  target="_blank">
<span class="dashicons dashicons-twitter"></span></a>';
            }

            if (!empty($google)) {
                $item .= '<a href="' . $google . '"  target="_blank">
<span class="dashicons dashicons-googleplus"></span></a>';
            }

            if (!empty($instagram)) {
                $item .= '<a href="' . $instagram . '"  target="_blank">
<img class="glrsocial_image" src="' . WPMF_GALLERY_ADDON_PLUGIN_URL . '/assets/images/instagram.png" /></a>';
            }

            if (!empty($pinterest)) {
                $item .= '<a href="' . $pinterest . '"  target="_blank">
<img class="glrsocial_image" src="' . WPMF_GALLERY_ADDON_PLUGIN_URL . '/assets/images/pinterest.png" /></a>';
            }

            $item .= '</div>';
        }
    }

    $item .= '<div class="flipster_infos">';
    $item .= '<div class="h5">' . wptexturize($post_title) . '</div>';
    $item .= '<span>' . wptexturize($post_excerpt) . '</span>';
    $item .= '<div class="gallery-icon ' . $orientation . '">';
    $item .= '</div></div></div></div>';

    if (isset($gallery_configs['progressive_loading']) && (int) $gallery_configs['progressive_loading'] === 0) {
        $lists[] = $item;
    } else {
        if ($j >= 10) {
            $lists[] = $item;
        }
        $j ++;
    }
    $lists_full[] = $item;
}

$json_lists = esc_html(json_encode($lists));
echo '<div class="wpmf-gallerys" data-id="' . esc_html($id) . '">';
echo '<div id="' . esc_html($id) . '" data-gutter-width="' . esc_html($padding_masonry) . '"
 data-wpmfcolumns="' . esc_html($columns) . '" data-item="' . esc_html($json_lists) . '" class="' . esc_html($class) . '">';
foreach ($lists_full as $i => $list) {
    if (isset($gallery_configs['progressive_loading']) && (int) $gallery_configs['progressive_loading'] === 0) {
        echo $list; // phpcs:ignore WordPress.XSS.EscapeOutput -- Content already escaped in the method
    } else {
        if ($i < 10) {
            echo $list; // phpcs:ignore WordPress.XSS.EscapeOutput -- Content already escaped in the method
        }
    }
}
echo "</div></div>\n";
