<?php
$class[] = 'gallery-masonry gallery-portfolio';
$class[] = 'galleryid-' . $id;
$class[] = 'gallery-columns-' . $columns;
$class[] = 'gallery-size-' . $size_class;
$class[] = 'wpmf-gallery-bottomspace-default';
$class[] = 'wpmf-gallery-clear';
$class   = implode(' ', $class);

$padding = get_option('wpmf_padding_portfolio');
if (!isset($padding) && $padding === '') {
    $padding = 10;
}

$current_theme = get_option('current_theme');
if (isset($current_theme) && $current_theme === 'Gleam') {
    $tclass = 'fancybox';
} else {
    $tclass = '';
}

$lists      = array();
$lists_full = array();
$j          = 0;

foreach ($attachments as $id => $attachment) {
    $image_meta = wp_get_attachment_metadata($id);
    if (empty($image_meta['height']) || empty($image_meta['width'])) {
        continue;
    }
    $title        = esc_html($attachment->post_title);
    $post_excerpt = esc_html($attachment->post_excerpt);
    $tg           = get_post_meta($attachment->ID, '_gallery_link_target', true);
    $img_tags     = get_post_meta($attachment->ID, 'wpmf_img_tags', true);
    $icon         = '';
    $social       = '';
    if ((int) $social_sharing === 1) {
        if (!empty($facebook) || !empty($twitter) || !empty($google) || !empty($instagram) || !empty($pinterest)) {
            $social .= '<div class="wpmfglr_social">';
            if (!empty($facebook)) {
                $social .= '<a href="' . $facebook . '"  target="_blank">
<span class="dashicons dashicons-facebook-alt"></span></a>';
            }

            if (!empty($twitter)) {
                $social .= '<a href="' . $twitter . '"  target="_blank">
<span class="dashicons dashicons-twitter"></span></a>';
            }

            if (!empty($google)) {
                $social .= '<a href="' . $google . '"  target="_blank">
<span class="dashicons dashicons-googleplus"></span></a>';
            }

            if (!empty($instagram)) {
                $social .= '<a href="' . $instagram . '"  target="_blank">
<img class="glrsocial_image" src="' . WPMF_GALLERY_ADDON_PLUGIN_URL . '/assets/images/instagram.png" /></a>';
            }

            if (!empty($pinterest)) {
                $social .= '<a href="' . $pinterest . '"  target="_blank">
<img class="glrsocial_image" src="' . WPMF_GALLERY_ADDON_PLUGIN_URL . '/assets/images/pinterest.png" /></a>';
            }

            $social .= '</div>';
        }
    }
    if ($customlink) {
        $image_output = $this->galleryGetAttachmentLink($id, $size, false, $targetsize, $customlink, $tg);
        $url          = get_post_meta($id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true);
        if ($url === '') {
            $url = get_attachment_link($id);
        }
        $icon = '<a href="' . $url . '" title="' . $title . '" class="hover_img ' . $tclass . '" target="' . $tg . '"></a>';
        $icon .= '<a class="portfolio_lightbox ' . $tclass . '" href="' . $url . '" title="' . $title . '" target="' . $tg . '">+</a>';
        $icon .= $social;
    } elseif (!empty($link) && 'file' === $link) {
        $remote_video = get_post_meta($id, 'wpmf_remote_video_link', true);
        $image_output = $this->galleryGetAttachmentLink($id, $size, false, $targetsize, $customlink, $tg);
        if (strpos($image_output, "data-swipe='0'")) {
            $url  = get_post_meta($id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true);
            $icon = '<a data-swipe="0" href="' . $url . '" title="' . $title . '" class="hover_img ' . $tclass . '" target="' . $tg . '"></a>';
            $icon .= '<a data-swipe="0" class="portfolio_lightbox ' . $tclass . '" href="' . $url . '" title="' . $title . '" target="' . $tg . '">';
            $icon .= '+</a>';
            $icon .= $social;
        } else {
            $urls      = wp_get_attachment_image_src($id, $targetsize);
            $url       = $urls[0];
            $data_size = $urls[1] . 'x' . $urls[2];
            if (!empty($remote_video)) {
                $icon = '<a data-size="' . $data_size . '" data-swipe="1" href="' . $remote_video . '"
 title="' . $title . '" class="wpmfgalleryaddonswipe hover_img ' . $tclass . ' isvideo"></a>';
                $icon .= '<a data-swipe="1" class="wpmfgalleryaddonswipe portfolio_lightbox ' . $tclass . ' isvideo"
 href="' . $remote_video . '" title="' . $title . '">';
                $icon .= '+</a>';
                $icon .= $social;
            } else {
                $icon = '<a data-size="' . $data_size . '" data-swipe="1" href="' . $url . '" title="' . $title . '"
 class="wpmfgalleryaddonswipe hover_img ' . $tclass . ' not_video"></a>';
                $icon .= '<a data-swipe=1 class="wpmfgalleryaddonswipe portfolio_lightbox ' . $tclass . ' not_video"
 href="' . $url . '" title="' . $title . '">';
                $icon .= '+</a>';
                $icon .= $social;
            }
        }
    } elseif (!empty($link) && 'none' === $link) {
        if (get_post_meta($id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true) !== '') {
            $image_output = $this->galleryGetAttachmentLink($id, $size, false, $targetsize, $customlink, $tg);
            $url          = get_post_meta($id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true);
            $icon         = '<a href="' . $url . '" title="' . $title . '" class="hover_img ' . $tclass . '" target="' . $tg . '"></a>';
            $icon         .= '<a class="portfolio_lightbox ' . $tclass . '" href="' . $url . '" title="' . $title . '" target="' . $tg . '">+</a>';
            $icon         .= $social;
        } else {
            $image_output = wp_get_attachment_image($id, $size, false, array('data-type' => 'wpmfgalleryimg'));
            $icon         = '<span class="hover_img"></span><span class="portfolio_lightbox" title="' . $title . '">+</span>';
            $icon         .= $social;
        }
    } else {
        $image_output = $this->galleryGetAttachmentLink($id, $size, true, 'large', false, $tg);
    }

    $orientation = ($image_meta['height'] > $image_meta['width']) ? 'portrait' : 'landscape';
    $item        = '<div class="wpmf-gallery-item" data-tags="' . $img_tags . '">';
    $item        .= '<div class="gallery-icon ' . $orientation . '">' . $icon . ' ' . $image_output . '</div>';
    if (trim($post_excerpt) || trim($title)) {
        $item .= "<div class='wpmf-caption-text wpmf-gallery-caption'>";
        $item .= "<span class='title'>" . wptexturize($title) . ' </span><br>';
        $item .= "<span class='excerpt'>" . wptexturize($post_excerpt) . '</span>';
        $item .= '</div>';
    }
    $item .= '</div>';

    if (isset($gallery_configs['progressive_loading']) && (int) $gallery_configs['progressive_loading'] === 0) {
        $lists[] = $item;
    } else {
        if ($j >= 10) {
            $lists[] = $item;
        }
        $j ++;
    }
    $lists_full[] = $item;
}

$json_lists = esc_html(json_encode($lists));
echo '<div class="wpmf-gallerys" data-id="' . esc_html($id) . '">';
echo '<div data-id="' . esc_html($id) . '" data-gutter-width="' . esc_html($padding) . '"
 data-wpmfcolumns="' . esc_html($columns) . '" data-item="' . esc_html($json_lists) . '" class="' . esc_html($class) . '">';
foreach ($lists_full as $i => $list) {
    if (isset($gallery_configs['progressive_loading']) && (int) $gallery_configs['progressive_loading'] === 0) {
        echo $list; // phpcs:ignore WordPress.XSS.EscapeOutput -- Content already escaped in the method
    } else {
        if ($i < 10) {
            echo $list; // phpcs:ignore WordPress.XSS.EscapeOutput -- Content already escaped in the method
        }
    }
}

echo '</div></div>\n';
