/**
 * Main WP Media Gallery addon script
 */
var wpmfGalleryModule;
(function ($) {
    if (typeof ajaxurl === "undefined") {
        ajaxurl = wpmf.vars.ajaxurl;
    }

    wpmfGalleryModule = {
        wpmf_current_gallery: 0, // current gallery selected
        current_page_nav: 1, // current page for images gallery selection
        gallery_details: {},
        events : [], // event handling
        init: function () {
            // show popup inline
            if ($().magnificPopup) {
                $('.new-gallery-popup').magnificPopup({
                    type: 'inline',
                    closeBtnInside: true,
                    midClick: true // allow opening popup on middle mouse click. Always set it to true if you don't provide alternative source.
                });
            }

            wpmfGalleryModule.grlUpload();
            /* Show tooltip for some icon */
            $('.wpmf_open_qtip').qtip({
                content: {
                    attr: 'data-for'
                },
                position: {
                    my: 'bottom center',
                    at: 'top center'
                },
                style: {
                    tip: {
                        corner: true
                    },
                    classes: 'wpmf-qtip qtip-rounded'
                },
                show: 'hover',
                hide: {
                    fixed: true,
                    delay: 10
                }

            });

            wpmfGalleryModule.bindEvent();
            wpmfGalleryModule.eventImages();

            var eventMethod = window.addEventListener ? "addEventListener" : "attachEvent";
            var eventer = window[eventMethod];
            var messageEvent = eventMethod === "attachEvent" ? "onmessage" : "message";

            // Listen to message from child window
            eventer(messageEvent, function (e) {
                var res = e.data;
                if (typeof res !== "undefined" && typeof res.type !== "undefined" && res.type === "wpmfglr_modal_import") {
                    wpmfGalleryModule.changeGallery(res.gallery_id);
                }
            }, false);
        },

        /**
         * Change gallery function
         * @param id id of gallery
         */
        changeGallery: function (id) {
            if (typeof id === 'undefined') {
                return;
            }
            $.ajax({
                type: "POST",
                url: ajaxurl,
                data: {
                    action: "wpmfgallery",
                    task: "change_gallery",
                    id: id,
                    wpmf_gallery_nonce: wpmf_glraddon.vars.wpmf_gallery_nonce
                },
                success: function (res) {
                    if ($('.btn_modal_import_image_fromwp').length > 0) {
                        var url_modal = $('.btn_modal_import_image_fromwp').attr('href');
                        var new_url = url_modal + '&gallery_id=' + id;
                        $('.btn_modal_import_image_fromwp').attr('href', new_url);
                    }

                    $('.current_theme_gallery').val(res.theme + '_theme');

                    wpmfGalleryModule.grlUpload();
                    $('.up_gallery_id').val(id);
                    $('.wpmf_gallery_selection').html(res.images_html);
                    /* Show hide message if no file selected */
                    if ($('.wpmf_gallery_selection .attachment').length > 0) {
                        $('.msg_no_files').hide();
                    } else {
                        $('.msg_no_files').show();
                    }

                    /* Load image template */
                    wpmfGalleryModule.resetFormGallery('edit');
                    wpmfGalleryModule.gallery_details[id] = res.glr;
                    $('.gallery_name').val(wpmfGalleryModule.gallery_details[id].name);
                    $('.gallery_theme option[value="' + wpmfGalleryModule.gallery_details[id].theme + '"]').prop('selected', true).change();
                    $('.wpmf-gallery-categories option[value="' + wpmfGalleryModule.gallery_details[id].parent + '"]').prop('selected', true).change();
                    $('.id_gallery').val(id);
                    $('#new-gallery-popup').removeClass('wpmf_mfp-hide').addClass('form_edit_gallery').removeClass('form_add_gallery');
                    wpmfGalleryModule.updateNav(res);
                    wpmfGalleryModule.bindEvent();
                    wpmfGalleryModule.eventImages();
                    // init sortable images
                    wpmfGalleryModule.sortAbleImages('.wpmf_gallery_selection');
                }
            });
        },

        /**
         * sortable image in gallery
         */
        sortAbleImages: function (selector) {
            $(selector).sortable({
                revert: true,
                helper: function(e, item){
                    return $(item).clone();
                },
                /** Prevent firefox bug positionnement **/
                start: function (event, ui) {
                },
                stop: function (event, ui) {
                },
                beforeStop: function (event, ui) {
                    var userAgent = navigator.userAgent.toLowerCase();
                    if (ui.offset !== "undefined" && userAgent.match(/firefox/)) {
                        ui.helper.css('margin-top', 0);
                    }
                },
                update: function () {
                    var order = '';
                    $.each($(selector + ' .attachment'), function (i, val) {
                        if (order !== '') {
                            order += ',';
                        }
                        order += '"' + i + '":' + $(val).data('id');
                    });
                    order = '{' + order + '}';

                    // do re-order file
                    $.ajax({
                        type: "POST",
                        url: ajaxurl,
                        data: {
                            action: "wpmfgallery",
                            task: "reorder_image_gallery",
                            order: order,
                            wpmf_gallery_nonce: wpmf_glraddon.vars.wpmf_gallery_nonce
                        },
                        success: function () {
                            /* display notification */
                            wpmfSnackbarModule.show({
                                content : wpmf_glraddon.l18n.save_glr,
                                auto_close_delay: 2000
                            });
                        }
                    });
                }
            });

            $(selector).disableSelection();
        },

        /**
         * Escape string
         * @param s string
         */
        wpmfescapeScripts: function (s) {
            return s
                .replace(/&/g, "&amp;")
                .replace(/</g, "&lt;")
                .replace(/>/g, "&gt;")
                .replace(/"/g, "&quot;")
                .replace(/'/g, "&#039;");
        },

        /**
         * action edit and remove image
         */
        eventImages: function () {
            $('.edit_image_selection').unbind('click').bind('click', function () {
                var id = $(this).data('id');
                $.ajax({
                    url: ajaxurl,
                    method: "POST",
                    dataType: 'json',
                    data: {
                        action: "wpmfgallery",
                        task: "image_details",
                        id: id,
                        wpmf_gallery_nonce: wpmf_glraddon.vars.wpmf_gallery_nonce
                    },
                    success: function (res) {
                        if (res.status) {
                            showDialog({
                                text: res.html,
                                closeicon: true,
                                negative: {
                                    title: wpmf_glraddon.l18n.cancel
                                },
                                positive: {
                                    title: wpmf_glraddon.l18n.save,
                                    onClick: function () {
                                        var title = wpmfGalleryModule.wpmfescapeScripts($('.form_image_details_popup .img_title').val());
                                        var excerpt = wpmfGalleryModule.wpmfescapeScripts($('.form_image_details_popup .img_excerpt').val());
                                        var alt = wpmfGalleryModule.wpmfescapeScripts($('.form_image_details_popup .img_alt').val());
                                        var content = wpmfGalleryModule.wpmfescapeScripts($('.form_image_details_popup .img_content').val());
                                        var link_to = wpmfGalleryModule.wpmfescapeScripts($('.form_image_details_popup .custom_image_link').val());
                                        var link_target = $('.form_image_details_popup .image_link_target').val();
                                        var img_tags = wpmfGalleryModule.wpmfescapeScripts($('.form_image_details_popup .img_tags').val());

                                        /* Run ajax update image */
                                        $.ajax({
                                            url: ajaxurl,
                                            method: "POST",
                                            dataType: 'json',
                                            data: {
                                                action: "wpmfgallery",
                                                task: "update_image",
                                                id: id,
                                                title: title,
                                                excerpt: excerpt,
                                                alt: alt,
                                                content: content,
                                                link_to: link_to,
                                                link_target: link_target,
                                                img_tags: img_tags,
                                                wpmf_gallery_nonce: wpmf_glraddon.vars.wpmf_gallery_nonce
                                            },
                                            success: function (res) {
                                                if (res.status) {
                                                    $('.wpmf_gallery_attachments .attachment[data-id="' + id + '"] .image_title').html(title);
                                                    /* display notification */
                                                    wpmfSnackbarModule.show({
                                                        content : wpmf_glraddon.l18n.save_img,
                                                        auto_close_delay: 2000
                                                    });
                                                }
                                            }
                                        });
                                    }
                                }
                            });

                            wpmfGalleryModule.linkAction('form_image_details_popup');
                        }
                    }
                });
            });

            /* Delete image gallery selection */
            $('.delete_image_selection').unbind('click').bind('click', function () {
                var id = $(this).data('id');
                showDialog({
                    title: wpmf_glraddon.l18n.delete_image_gallery,
                    negative: {
                        title: wpmf_glraddon.l18n.cancel
                    },
                    positive: {
                        title: wpmf_glraddon.l18n.delete,
                        onClick: function () {
                            $.ajax({
                                url: ajaxurl,
                                method: "POST",
                                dataType: 'json',
                                data: {
                                    action: "wpmfgallery",
                                    task: "image_selection_delete",
                                    id: id,
                                    id_gallery: $('.id_gallery').val(),
                                    wpmf_gallery_nonce: wpmf_glraddon.vars.wpmf_gallery_nonce
                                },
                                success: function (res) {
                                    if (res.status) {
                                        wpmfGalleryModule.updateNav(res);
                                        $('.attachment[data-id="' + id + '"]').remove();
                                        /* Show hide message if no file selected */
                                        if ($('.wpmf_gallery_selection .attachment').length === 0) {
                                            $('.msg_no_files').show();
                                        } else {
                                            $('.msg_no_files').hide();
                                        }

                                        wpmfGalleryModule.updateNav(res);
                                        /* display notification */
                                        wpmfSnackbarModule.show({
                                            content : wpmf_glraddon.l18n.delete_img,
                                            auto_close_delay: 2000
                                        });
                                    }
                                }
                            });
                        }
                    }
                });
            });
        },

        /**
         * import gallery from media library
         */
        importFromWp: function () {
            wpmfSnackbarModule.show({
                id : 'gallery_import',
                content : wpmf_glraddon.l18n.import_gallery,
                auto_close : false,
                is_progress : true
            });

            var gallerylists = {};
            $('.wpmf_checkbox_tree').each(function (i, v) {
                if ($(v).is(':checked')) {
                    var term_id = $(v).data('id');
                    var parent = $(v).closest('li.checked').data('parent_id');
                    if ($('li.checked[data-id="' + parent + '"]').length === 0) {
                        parent = 0;
                    }
                    if (typeof parent === "undefined") parent = 0;
                    var name = $(v).closest('li').find('.title-folder').html();
                    gallerylists[term_id] = {'term_id': term_id, 'parent': parent, 'name': name};
                }
            });

            /* Run ajax import gallery from wp media folder */
            $.ajax({
                url: ajaxurl,
                method: 'POST',
                dataType: 'json',
                data: {
                    action: 'wpmfgallery',
                    task: 'import_fromwp',
                    gallerylists: JSON.stringify(gallerylists),
                    theme: $('.gallery_theme_ip').val(),
                    wpmf_gallery_nonce: wpmf_glraddon.vars.wpmf_gallery_nonce
                },
                success: function (res) {
                    let $snack = wpmfSnackbarModule.getFromId('gallery_import');

                    // Is the import finished
                    wpmfSnackbarModule.close($snack);
                    wpmfSnackbarModule.show({
                        content : wpmf_glraddon.l18n.gallery_imported
                    });

                    if (res.status) {
                        // update dropdown list gallery
                        $('#wpmf-gallery-categories').remove();
                        $('.gallery_theme').after(res.dropdown_gallery);
                        // Update the categories variables
                        wpmfGalleryModule.renderListstree(res,0,true);
                    }
                }
            });
        },

        /**
         * render lists galleries tree
         * @param res
         * @param open_id
         * @param type
         */
        renderListstree: function (res,open_id,type) {
            wpmfGalleryTreeModule.categories = res.categories;
            wpmfGalleryTreeModule.categories_order = res.categories_order;
            wpmfGalleryTreeModule.importCategories();
            wpmfGalleryTreeModule.getTreeElement().html(wpmfGalleryTreeModule.getRendering());
            wpmfGalleryTreeModule.dragGallery();
            wpmfGalleryTreeModule.dropGallery();
            if (type) {
                open_id = $('#gallerylist').find('.tree_view ul li:nth-child(2)').data('id');
            }
            wpmfGalleryTreeModule.glrTitleopengallery(open_id);
        },
        /**
         * Open link dialog
         * @param selector
         */
        linkAction: function (selector) {
            $('.link-btn').on('click', function () {
                if (typeof wpLink !== "undefined") {
                    wpLink.open('link-btn');
                    /* Bind to open link editor! */
                    $('#wp-link-backdrop').show();
                    $('#wp-link-wrap').show();
                    $('#url-field,#wp-link-url').closest('div').find('span').html('Link To');
                    $('#link-title-field').closest('div').hide();
                    $('.wp-link-text-field').hide();

                    $('#url-field,#wp-link-url').val($('.compat-field-wpmf_gallery_custom_image_link input.text').val());
                    if ($('.compat-field-gallery_link_target select').val() === '_blank') {
                        $('#link-target-checkbox,#wp-link-target').prop('checked', true);
                    } else {
                        $('#link-target-checkbox,#wp-link-target').prop('checked', false);
                    }
                }
            });

            /* Update link  */
            $('#wp-link-submit').on('click', function () {
                var link = $('#url-field').val();
                if (typeof link === "undefined") {
                    link = $('#wp-link-url').val();
                } // version 4.2+

                var link_target = $('#link-target-checkbox:checked').val();
                if (typeof link_target === "undefined") {
                    link_target = $('#wp-link-target:checked').val();
                } // version 4.2+

                if (link_target === 'on') {
                    link_target = '_blank';
                } else {
                    link_target = '';
                }

                $('.' + selector + ' .custom_image_link').val(link);
                $('.' + selector + ' .image_link_target option[value="' + link_target + '"]').prop('selected', true).change();
            });
        },

        /* update nav */
        updateNav: function (res) {
            $('#new-gallery-popup .tablenav-pages, #new-gallery-popup .screen-options').remove();
            $('#new-gallery-popup').find('.wpmf_gallery_selection').after(res.nav);
            wpmfGalleryModule.bindEvent();
        },

        /* action for gallery */
        galleryEvent: function () {
            var themes_select = '<div class="div_gallery_theme_ip">';
            themes_select += '<select class="gallery_theme_ip" name="gallery_theme_ip">';
            themes_select += '<option disabled value="default">' + wpmf_glraddon.l18n.theme_label + '</option>';
            $.each(wpmf_glraddon.vars.themes, function (key, label) {
                themes_select += '<option value="' + key + '">' + label + '</option>';
            });
            themes_select += '</select></div>';

            /* Show dialog import gallery */
            $('.btn_import_fromwp').unbind('click').bind('click', function () {
                showDialog({
                    title: wpmf_glraddon.l18n.create_gallery_desc,
                    text: '<span id="librarytree"></span>' + themes_select,
                    negative: {
                        title: wpmf_glraddon.l18n.cancel
                    },
                    positive: {
                        title: wpmf_glraddon.l18n.create,
                        onClick: function () {
                            wpmfGalleryModule.importFromWp();
                        }
                    }
                });

                $('#librarytree').librarytree();
            });

            /* import image from wordpress */
            $('.btn_import_image_fromwp').unbind('click').bind('click', function () {
                var id_gallery = $('.id_gallery').val();

                if (typeof frame !== "undefined") {
                    frame.open();
                    return;
                }
                // Create the media frame.
                var frame = wp.media({
                    // Tell the modal to show only images.
                    library: {
                        type: 'image'
                    },
                    title: wpmf_glraddon.l18n.iframe_import_label,
                    button: {
                        text: wpmf_glraddon.l18n.import
                    },
                    multiple: true
                });

                // When an image is selected, run a callback.
                frame.on('select', function () {
                    // Grab the selected attachment.
                    var attachments = frame.state().get('selection').toJSON();
                    var percent = Math.ceil(100 / (attachments.length));
                    $('.wpmf_process').data('w', 0).css('width', '0%');
                    $('.wpmf_process_full').show();
                    $.each(attachments, function (i, v) {
                        $.ajax({
                            url: ajaxurl,
                            method: "POST",
                            dataType: 'json',
                            data: {
                                action: "wpmfgallery",
                                task: "import_images_from_wp",
                                id: v.id,
                                gallery_id: id_gallery,
                                mime: v.mime,
                                title: v.title,
                                filename: v.filename,
                                wpmf_gallery_nonce: wpmf_glraddon.vars.wpmf_gallery_nonce
                            },
                            success: function (res) {
                                var w = $('.wpmf_process').data('w');
                                var new_w = parseFloat(w) + parseFloat(percent);
                                if (new_w > 100)
                                    new_w = 100;
                                $('.wpmf_process').data('w', new_w).css('width', new_w + '%');
                                if (parseInt(new_w) === 100) {
                                    $('.wpmf_process_full').fadeOut(3000);
                                }

                                $('.wpmf_gallery_selection').prepend(res.html);
                                $('.wpmf_gallery_newselection').prepend(res.html);

                                /* Show hide message if no file selected */
                                $('.msg_no_files').hide();

                                wpmfGalleryModule.updateNav(res);
                                wpmfGalleryModule.bindEvent();
                                wpmfGalleryModule.eventImages();
                            }
                        });
                    });
                });

                // let's open up the frame.
                frame.open();
            });

            /* when click new gallery button */
            $('.new-gallery-popup').bind('click', function () {
                wpmfGalleryModule.resetFormGallery('new');
                $('.layout_edit_left').removeClass('wpmf_small');
                $('#new-gallery-popup').removeClass('form_edit_gallery').addClass('form_add_gallery');
            });
        },

        /**
         * reset form create gallery
         * @param type
         */
        resetFormGallery: function (type) {
            $('.gallery_name').val('');
            $('.gallery_theme option[value="default"]').prop('selected', true).change();
            $('.wpmf-gallery-categories option[value="0"]').prop('selected', true).change();
            $('.wpmf_gallery_selection .attachment').removeClass('selected');
            if (type === 'edit') {
                $('.btn_create_gallery').hide();
                $('.btn_edit_gallery').show();
            } else {
                $('.btn_create_gallery').show();
                $('.btn_edit_gallery').hide();
                $('.wpmf_gallery_newselection').html('');
                $('.up_gallery_id').val(0);
                $('.id_gallery').val(0);
            }
        },

        /**
         * Get images selection
         */
        getImgSelection: function () {
            var id_gallery = $('.form_edit_gallery .id_gallery').val();
            $('.WpmfGalleryList #current-page-selector').val(wpmfGalleryModule.current_page_nav);
            $.ajax({
                url: ajaxurl,
                method: "POST",
                dataType: 'json',
                data: {
                    action: "wpmfgallery",
                    task: "get_imgselection",
                    id_gallery: id_gallery,
                    current_page_nav: wpmfGalleryModule.current_page_nav,
                    wpmf_gallery_nonce: wpmf_glraddon.vars.wpmf_gallery_nonce
                },
                success: function (res) {
                    if (res.status) {
                        $('.wpmf_gallery_selection').html(res.html);
                        wpmfGalleryModule.updateNav(res);
                        wpmfGalleryModule.bindEvent();
                        wpmfGalleryModule.eventImages();
                    }
                }
            });
        },

        /**
         * search key by value
         * @param arr
         * @param val
         * @returns {*}
         */
        arraySearch: function (arr, val) {
            for (var i = 0; i < arr.length; i++)
                if (arr[i] === val)
                    return i;
            return false;
        },

        /**
         * Upload function
         */
        grlUpload: function () {
            /* Upload image */
            $('#wpmf_gallery_file').unbind('change').bind('change', function () {
                jQuery('#wpmf_progress_upload').hide();
                $('#wpmf_result').html(null);
                $('#wpmf_bar').width(0);
                $('#wpmf_percent').html('0%');
                $('#wpmfglr_form_upload').submit();
            });

            $('.btn_upload_from_pc').unbind('click').bind('click', function () {
                $('#wpmf_gallery_file').click();
            });

            var wpmf_bar = jQuery('#wpmf_bar');
            var wpmf_percent = jQuery('#wpmf_percent');
            var wpmf_result = jQuery('#wpmf_result');
            var wpmf_percentValue = '0%';
            jQuery('#wpmfglr_form_upload').ajaxForm({
                beforeSend: function () {
                    wpmf_result.empty();
                    wpmf_percentValue = '0%';
                    wpmf_bar.width(wpmf_percentValue);
                    wpmf_percent.html(wpmf_percentValue);
                },
                uploadProgress: function (event, position, total, percentComplete) {
                    jQuery('#wpmf_progress_upload').show();
                    var wpmf_percentValue = percentComplete + '%';
                    wpmf_bar.width(wpmf_percentValue);
                    wpmf_percent.html(wpmf_percentValue);
                },
                success: function () {
                    var wpmf_percentValue = '100%';
                    wpmf_bar.width(wpmf_percentValue);
                    wpmf_percent.html(wpmf_percentValue);
                },
                complete: function (xhr) {
                    jQuery('#wpmf_progress_upload').hide();
                    var ob = JSON.parse(xhr.responseText);
                    if (typeof xhr.responseText !== "undefined") {
                        if (ob.status) {
                            $('.wpmf_gallery_selection').prepend(ob.html);
                            $('.wpmf_gallery_newselection').prepend(ob.html);
                            /* Show hide message if no file selected */
                            if ($('.wpmf_gallery_selection .attachment').length > 0) {
                                $('.msg_no_files').hide();
                            } else {
                                $('.msg_no_files').show();
                            }
                            wpmfGalleryModule.eventImages();
                            wpmfGalleryModule.bindEvent();
                            wpmfGalleryModule.updateNav(ob);
                            // init sortable images
                            wpmfGalleryModule.sortAbleImages('.wpmf_gallery_newselection');
                            /* display notification */
                            wpmfSnackbarModule.show({
                                content : wpmf_glraddon.l18n.upload_img,
                                auto_close_delay: 2000
                            });
                        } else {
                            alert(ob.msg);
                        }
                    }
                }
            });
        },

        /**
         * all event
         */
        bindEvent: function () {
            $('.glr-next-page').unbind('click').bind('click', function () {
                wpmfGalleryModule.current_page_nav++;
                var page_count = $(this).data('page_count');
                if (wpmfGalleryModule.current_page_nav > parseInt(page_count)) wpmfGalleryModule.current_page_nav = page_count;
                wpmfGalleryModule.getImgSelection();
            });

            $('.glr-prev-page').unbind('click').bind('click', function () {
                wpmfGalleryModule.current_page_nav--;
                if (wpmfGalleryModule.current_page_nav < 1) wpmfGalleryModule.current_page_nav = 1;
                wpmfGalleryModule.getImgSelection();
            });

            $('.glr-first-page').unbind('click').bind('click', function () {
                wpmfGalleryModule.current_page_nav = 1;
                wpmfGalleryModule.getImgSelection();
            });

            $('.glr-last-page').unbind('click').bind('click', function () {
                wpmfGalleryModule.current_page_nav = $(this).data('page_count');
                wpmfGalleryModule.getImgSelection();
            });

            $('.glr-current-page').unbind('change').bind('change', function () {
                var page_count = $('.glr-next-page').data('page_count');
                if ($(this).val() > parseInt(page_count)) {
                    wpmfGalleryModule.current_page_nav = page_count;
                    $(this).val(wpmfGalleryModule.current_page_nav);
                } else if ($(this).val() < 1) {
                    wpmfGalleryModule.current_page_nav = 1;
                    $(this).val(wpmfGalleryModule.current_page_nav);
                } else {
                    wpmfGalleryModule.current_page_nav = $(this).val();
                }

                wpmfGalleryModule.getImgSelection();
            });

            $('.img_per_page').unbind('change').bind('change', function () {
                var img_per_page = $(this).val();
                $.ajax({
                    url: ajaxurl,
                    method: "POST",
                    dataType: 'json',
                    data: {
                        action: "wpmfgallery",
                        task: "update_img_per_page",
                        img_per_page: img_per_page,
                        wpmf_gallery_nonce: wpmf_glraddon.vars.wpmf_gallery_nonce
                    },
                    success: function (res) {
                        if (res.status) {
                            wpmfGalleryModule.getImgSelection();
                        }
                    }
                });

            });

            /* insert shortcode gallery */
            $('.a_btn_insert_gallery').unbind('click').bind('click', function () {
                var gallery_shortcode = '[wpmfgallery';
                gallery_shortcode += ' gallery_id="' + wpmfGalleryModule.wpmf_current_gallery + '"';
                gallery_shortcode += ' customlink="0"';
                gallery_shortcode += ' bottomspace="default"';

                if ($('.gallery_display_tree').is(':checked')) {
                    gallery_shortcode += ' display_tree="1"';
                } else {
                    gallery_shortcode += ' display_tree="0"';
                }

                if ($('.gallery_display_tag').is(':checked')) {
                    gallery_shortcode += ' display_tag="1"';
                } else {
                    gallery_shortcode += ' display_tag="0"';
                }

                gallery_shortcode += ']';
                var win = window.dialogArguments || opener || parent || top;
                win.send_to_editor(gallery_shortcode);
                // Refocus in window
                var ed = parent.tinymce.editors[0];
                ed.windowManager.windows[0].close();
            });

            /* add style when select images */
            var singleIndex;
            $('.wpmf_gallery_selection .attachment, .wpmf_gallery_newselection .attachment').unbind('click').bind('click', function (e) {
                var $this = $(this);
                if ($(e.target).hasClass('dashicons-edit') || $(e.target).hasClass('dashicons-trash')) {
                } else {
                    var nodes = Array.prototype.slice.call( document.getElementById('wpmf_gallery_selection').children );
                    if (!$('.attachment.selected').length) {
                        singleIndex = nodes.indexOf( this );
                    }

                    // select multiple image use ctrl key or shift key
                    if ( e.ctrlKey || e.shiftKey ) {
                        if (!$('.attachment.selected').length) {
                            $this.addClass('selected');
                        } else {
                            var modelIndex  = nodes.indexOf( this ), i;
                            if ( singleIndex < modelIndex ) {
                                for (i = singleIndex; i<= (modelIndex + 1); i++) {
                                    $('.attachment:nth-child('+ i +')').addClass('selected');
                                }
                            } else {
                                for (i = modelIndex; i <= (singleIndex + 1); i++) {
                                    $('.attachment:nth-child('+ (i + 1) +')').addClass('selected');
                                }
                            }
                        }
                    } else {
                        if ($this.hasClass('selected')) {
                            $this.removeClass('selected');
                        } else {
                            $this.addClass('selected');
                        }
                    }
                }
            });

            /* Create gallery */
            $('.btn_create_gallery').unbind('click').bind('click', function () {
                var $this = $(this);
                var title = $('.gallery_name').val();
                var theme = $('.gallery_theme').val();
                var parent = $('.wpmf-gallery-categories').val();
                var ids = [];
                $('.wpmf_gallery_newselection .attachment').each(function (i, v) {
                    var id = $(v).data('id');
                    ids.push(id);
                });

                $.ajax({
                    url: ajaxurl,
                    method: "POST",
                    dataType: 'json',
                    data: {
                        action: "wpmfgallery",
                        task: "create_gallery",
                        title: title,
                        theme: theme,
                        parent: parent,
                        ids: ids.join(),
                        wpmf_gallery_nonce: wpmf_glraddon.vars.wpmf_gallery_nonce
                    },
                    beforeSend: function () {
                        $this.closest('.fieldsrow').find('.spinner').css('visibility', 'visible').show();
                    },
                    success: function (res) {
                        if (res.status) {
                            wpmfGalleryModule.gallery_details[res.items.term_id] = res.items;
                            $this.closest('.fieldsrow').find('.spinner').hide();
                            wpmfGalleryModule.resetFormGallery('new');
                            $.magnificPopup.close();

                            /* update dropdown gallery */
                            $('#wpmf-gallery-categories').remove();
                            $('.gallery_theme').after(res.dropdown_gallery);

                            var ret = '<li class="closed row_jao ui-draggable ui-draggable-handle ui-droppable" data-id="' + res.items.term_id + '" data-parent_id="' + res.items.parent + '">';
                            ret += '<a class="title-folder" onclick="wpmfGalleryTreeModule.glrTitleopengallery(' + res.items.term_id + ')" data-id="' + res.items.term_id + '">';
                            ret += '<i class="material-icons grlfolder wpmf-no-arrow">photo_album</i>';
                            ret += '<span data-id="' + res.items.term_id + '" data-parent_id="' + res.items.parent + '">' + res.items.name + '</span>';
                            ret += '</a>';
                            ret += '<i onclick="wpmfGalleryTreeModule.deleteGallery(' + res.items.term_id + ')" data-id="' + res.items.term_id + '" data-parent_id="' + res.items.parent + '" class="wpmficon-delete-gallery zmdi zmdi-delete"></i>';
                            ret += '</li>';

                            if (res.items.parent === 0) {
                                $('#gallerylist').find('.tree_view > ul').append(ret);
                            } else {
                                $('#gallerylist').find('li[data-id="' + res.items.parent + '"] > ul').append(ret);
                            }

                            // Update the categories variables
                            wpmfGalleryModule.renderListstree(res,res.items.term_id,false);

                            /* display notification */
                            wpmfSnackbarModule.show({
                                content : wpmf_glraddon.l18n.add_gallery,
                                auto_close_delay: 2000
                            });
                        }
                    }
                });
            });

            /* Delete selected images gallery */
            $('.btn_remove_img_gallery').unbind('click').bind('click', function () {
                var ids = [];
                if ($(this).closest('.form_add_gallery').length) {
                    $('.wpmf_gallery_newselection .attachment.selected').each(function (i, v) {
                        var id = $(v).data('id');
                        ids.push(id);
                    });
                } else {
                    $('.wpmf_gallery_selection .attachment.selected').each(function (i, v) {
                        var id = $(v).data('id');
                        ids.push(id);
                    });
                }

                showDialog({
                    title: wpmf_glraddon.l18n.delete_selected_image,
                    negative: {
                        title: wpmf_glraddon.l18n.cancel
                    },
                    positive: {
                        title: wpmf_glraddon.l18n.delete,
                        onClick: function () {
                            $.ajax({
                                url: ajaxurl,
                                method: "POST",
                                dataType: 'json',
                                data: {
                                    action: "wpmfgallery",
                                    task: "delete_imgs_selected",
                                    ids: ids.join(),
                                    id_gallery: $('.id_gallery').val(),
                                    wpmf_gallery_nonce: wpmf_glraddon.vars.wpmf_gallery_nonce
                                },
                                success: function (res) {
                                    if (res.status) {
                                        $.each(ids, function (i, id) {
                                            $('.attachment[data-id="' + id + '"]').remove();
                                        });

                                        wpmfGalleryModule.updateNav(res);
                                        /* Show hide message if no file selected */
                                        if ($('.wpmf_gallery_selection .attachment').length === 0) {
                                            $('.msg_no_files').show();
                                        } else {
                                            $('.msg_no_files').hide();
                                        }

                                        /* display notification */
                                        wpmfSnackbarModule.show({
                                            content : wpmf_glraddon.l18n.delete_img,
                                            auto_close_delay: 2000
                                        });
                                    }
                                }
                            });
                        }
                    }
                });
            });

            /* Create gallery */
            $('.btn_edit_gallery').unbind('click').bind('click', function () {
                var $this = $(this);
                var id = $('.id_gallery').val();
                var title = $('.gallery_name').val();
                var theme = $('.gallery_theme').val();
                var parent = $('.wpmf-gallery-categories').val();
                /* Ajax edit gallery */
                $.ajax({
                    url: ajaxurl,
                    method: "POST",
                    dataType: 'json',
                    data: {
                        action: "wpmfgallery",
                        task: "edit_gallery",
                        id: id,
                        title: title,
                        theme: theme,
                        parent: parent,
                        wpmf_gallery_nonce: wpmf_glraddon.vars.wpmf_gallery_nonce
                    },
                    beforeSend: function () {
                        $this.closest('.fieldsrow').find('.spinner').css('visibility', 'visible').show();
                    },
                    success: function (res) {
                        if (res.status) {
                            wpmfGalleryModule.gallery_details[res.items.term_id] = res.items;
                            $this.closest('.fieldsrow').find('.spinner').hide();
                            $.magnificPopup.close();

                            // update dropdown lists gallery
                            $('#wpmf-gallery-categories').remove();
                            $('.gallery_theme').after(res.dropdown_gallery);
                            // Update the categories variables
                            wpmfGalleryModule.renderListstree(res,id,false);
                            /* display notification */
                            wpmfSnackbarModule.show({
                                content : wpmf_glraddon.l18n.save_glr,
                                auto_close_delay: 2000
                            });
                        }
                    }
                });

            });
        },

        /**
         * change status of arrow on tree
         * @param id
         * @param status
         */
        changeOpenStatus: function (id, status) {
            if (status) {
                $('li.directory[data-id="' + id + '"] .row_jao').find('.icon-open-close').css({'opacity': 1});
            } else {
                $('li.directory[data-id="' + id + '"] .row_jao').find('.icon-open-close').css({'opacity': 0});
            }

        }
    };

    // initialize WPMF gallery features
    $(document).ready(function () {
        wpmfGalleryModule.init();
    });
})(jQuery);