jQuery(document).ready(function ($) {
    if (typeof ajaxurl === "undefined") {
        ajaxurl = wpmf.vars.ajaxurl;
    }

    if (typeof frame !== "undefined") {
        frame.open();
        return;
    }
    // Create the media frame.
    var frame = wp.media({
        // Tell the modal to show only images.
        library: {
            type: 'image'
        },
        title: wpmf_glraddon.l18n.iframe_import_label,
        button: {
            text: wpmf_glraddon.l18n.import
        },
        multiple: true
    });

    // When an image is selected, run a callback.
    frame.on('select', function () {
        // Grab the selected attachment.
        var attachments = frame.state().get('selection').toJSON();
        $.each(attachments, function (i, v) {
            $.ajax({
                url: ajaxurl,
                method: "POST",
                dataType: 'json',
                data: {
                    action: "wpmfgallery",
                    task: "import_images_from_wp",
                    id: v.id,
                    gallery_id: wpmfmd_import.gallery_id,
                    mime: v.mime,
                    title: v.title,
                    filename: v.filename,
                    wpmf_gallery_nonce: wpmf_glraddon.vars.wpmf_gallery_nonce
                },
                success: function (res) {
                    res.current_site = wpmfmd_import.current_site;
                    res.gallery_id = wpmfmd_import.gallery_id;
                    res.type = 'wpmfglr_modal_import';
                    window.postMessage(res, wpmfmd_import.current_site);
                }
            });
        });
        frame.close();
        tb_remove();
    });

    // let's open up the frame.
    frame.open();
});