(function ($) {
    "use strict";

    var wpmf_img_tags = '*';
    var gallery_items = [];
    /**
     * get column width, gutter width, count columns
     * @param $container
     * @returns {{columnWidth: number, gutterWidth, columns: Number}}
     */
    var calculateGrid = function ($container) {
        var columns = parseInt($container.data('wpmfcolumns'));
        var gutterWidth = $container.data('gutter-width');
        var containerWidth = $container.width();

        if (isNaN(gutterWidth)) {
            gutterWidth = 5;
        } else if (gutterWidth > 30 || gutterWidth < 0) {
            gutterWidth = 5;
        }

        if(parseInt(columns) < 2) columns = 2;
        gutterWidth = parseInt(gutterWidth);

        var allGutters = gutterWidth * (columns - 1);
        var contentWidth = containerWidth - allGutters;

        var columnWidth = Math.floor(contentWidth / columns);

        return {columnWidth: columnWidth, gutterWidth: gutterWidth, columns: columns};
    };

    /**
     * Run masonry gallery
     * @param duration
     * @param $container
     * @param id
     */
    var galleryRunMasonry = function (duration, $container, id) {
        var container = $container.find('.gallery-masonry');
        var $postBox = container.children('.wpmf-gallery-item');
        var o = calculateGrid($(container));
        var column_width = o.columnWidth - o.gutterWidth;
        var padding = o.gutterWidth*2;
        $postBox.css({'width': o.columnWidth - o.gutterWidth + 'px', 'margin-bottom': o.gutterWidth + 'px'});
        $(container).masonry({
            itemSelector: '.wpmf-gallery-item',
            columnWidth: column_width,
            gutter: padding,
            isAnimated : true,
            animationOptions: {
                duration: duration,
                easing: 'linear',
                queue: false
            },
            isFitWidth: true
        });

        if ($(container).hasClass('gallery-portfolio')) {
            var w = $(container).find('.attachment-thumbnail').width();
            $(container).find('.wpmf-caption-text.wpmf-gallery-caption , .gallery-icon').css('max-width', w + 'px');
        }
        $(container).css({'width': o.columns * o.columnWidth - o.gutterWidth + 'px', 'margin': '0px auto'});
        wpmfAutobrowse(id,container,'masonry',column_width,padding);

    };

    var wpmfGetMaxHeight = function (a) {
        let m = -Infinity, i = 0, n = a.length;

        for (; i !== n; ++i) {
            if (a[i] > m) {
                m = a[i];
            }
        }
        return m + 1;
    };

    /**
     * lazy load images in gallery
     * @param id theme id
     * @param container container parent of items
     * @param theme_type theme type
     * @param column_width item width
     * @param padding item padding
     */
    var wpmfAutobrowse = function (id,container,theme_type,column_width,padding) {
        if (parseInt(wpmfgallery.progressive_loading) === 0) {
            return;
        }

        gallery_items[id] = $(container).data('item');
        var number = 5;
        var offset = 5;
        var current = 0;
        container.autobrowse(
            {
                url: false,
                template: function (response)
                {
                    var markup=[],elems=[];
                    for (var i=0; i<number && i+current<gallery_items[id].length; i++)
                    {
                        var el = $(gallery_items[id][i+current]);
                        markup[i]=el;
                        elems[i]=$(el).get(0);
                        if (theme_type !== 'masonry') {
                            $($(el).get(0)).hide().appendTo(container).fadeIn(800);
                        }
                    }

                    current += number;

                    if (theme_type === 'masonry') {
                        $(container).append(markup);
                    }

                    if (theme_type === 'masonry') {
                        $(elems).imagesLoaded(function(){
                            $(container).find('.wpmf-gallery-item').css({'width': column_width + 'px', 'margin-bottom': padding + 'px'});
                            $(container).masonry( 'appended', $(elems));
                        });
                    }

                },
                itemsReturned: function (response) {
                    if(current>=gallery_items[id].length){
                        return 0;
                    }
                    return number;
                },
                offset: offset
            }
        );
    };
    /* Init gallery */
    var initGallery = function () {
        $('.wpmf_gallery_wrap .flipster').each(function () {
            var $flip = $(this);
            imagesLoaded($flip, function () {
                var enableNavButtons = wpmfgallery.gallery_configs.theme.flowslide_theme.show_buttons;
                if (typeof enableNavButtons !== "undefined" && parseInt(enableNavButtons) === 1) {
                    $flip.flipster({
                        style: 'carousel',
                        enableNavButtons: true
                    });
                } else {
                    $flip.flipster({
                        style: 'carousel'
                    });
                }
            });
        });

        /* re-call event with tags */
        wpmfEventGalleryTags();

        $('.wpmf-gallerys').each(function () {
            var id = $(this).data('id');
            var $container = $(this);

            if ($container.find('.gallery-masonry').length) {
                if ($container.find('.gallery').is(':hidden')) {
                    return;
                }

                if ($container.find('.gallery').hasClass('masonry')) {
                    return;
                }
                imagesLoaded($container.find('.gallery'), function () {
                    galleryRunMasonry(400, $container, id);
                    $container.find('.gallery').css('visibility', 'visible');
                });
            } else {
                // make image same line
                var columns = $container.find('.glrdefault').data('wpmfcolumns');
                imagesLoaded($container.find('.glrdefault'), function () {
                    $container.find('figure').each(function(j,v) {
                        if ((j+1) % columns === 0){
                            $container.find('figure:nth('+ (j) +')').after('<hr class="wpmfglr-line-break" />');
                        }
                    });
                    wpmfAutobrowse(id,$container.find('.glrdefault'),'default');
                });
            }
        });

        /* window load */
        $(window).load(function () {
            $('.flex-viewport').each(function () {
                var first_image_height = $(this).find('ul.slides li:first-child img').css('height');
                $(this).css('height', first_image_height + ' !important');
            });
        });

        /* init flexslider theme */
        if (jQuery().flexslider) {
            $('.icon-chevron-right').on('click', function () {
                $(this).parent().find('.flex-next').click();
            });

            $('.icon-chevron-left').on('click', function () {
                $(this).parent().find('.flex-prev').click();
            });

            $('.gallery_addon_flexslider').each(function () {
                var $this = $(this);
                var id = $(this).data('id');
                if ($this.is(':hidden')) {
                    return;
                }

                if ($this.hasClass('flexslider-is-active')) {
                    return;
                }
                var columns = parseInt($this.data('wpmfcolumns'));
                var animation = $this.data('animation');
                var duration = parseInt($this.data('duration'));
                var auto_animation = parseInt($this.data('auto_animation'));
                var columns_width = ($this.width() - ((columns - 1) * 15)) / columns;
                var columns_height = $('#' + id + ' li.wpmf-gallery-item').height();
                if (animation === 'slide') {
                    $this.addClass('wpmfslide');
                    if (columns > 1) {
                        $('#' + id + ' .wpmf-gallery-item .gallery-icon img').each(function () {
                            var w = $(this).width();
                            var h = columns_width / $(this).data('ratio');
                            $(this).css({'position': 'absolute', 'left': '-' + (w - columns_width) / 2 + 'px', 'top': '-' + (h - columns_height) / 2 + 'px', 'min-width': columns_width + 'px'});
                        });
                    }
                } else {
                    $this.addClass('wpmffade');
                }

                $this.addClass('flexslider-is-active');
                if (columns > 1) {
                    $('#' + id + '').flexslider({
                        animation: animation,
                        animationLoop: (auto_animation === 1),
                        smoothHeight: (animation === 'fade'),
                        itemWidth: (animation === 'fade') ? 0 : columns_width,
                        itemMargin: 15,
                        pauseOnHover: true,
                        slideshowSpeed: duration,
                        prevText: "",
                        nextText: "",
                        start: function () {
                            $('.entry-content').removeClass('loading');
                        }
                    });
                } else {
                    $('#' + id + '').flexslider({
                        animation: animation,
                        animationLoop: (auto_animation === 1),
                        smoothHeight: true,
                        itemMargin: 5,
                        pauseOnHover: true,
                        slideshowSpeed: duration,
                        prevText: "",
                        nextText: "",
                        start: function () {
                            $('.entry-content').removeClass('loading');
                        }
                    });
                }
            });
        }
    };

    /* init tags event */
    var wpmfEventGalleryTags = function () {
        $('.filter-all-control a').unbind('click').bind('click', function () {
            var $this = $(this);
            var gallery_id = $(this).closest('.wpmf-gridblock-filters').data('gallery_id');
            var img_tags = $(this).data('filter');
            if (typeof img_tags !== "undefined") {
                wpmf_img_tags = img_tags;
            }

            var current_size = $(this).closest('.wpmf-gridblock-filters').data('size');
            /* Load gallery */
            var data = {
                action: "wpmf_load_gallery",
                gallery_id: gallery_id,
                keep_tabs: 1,
                tags: wpmf_img_tags,
                current_size: current_size,
                wpmf_gallery_nonce: wpmfgallery.wpmf_gallery_nonce
            };
            $.ajax({
                url: wpmfgallery.ajaxurl,
                method: "POST",
                dataType: 'json',
                data: data,
                beforeSend: function () {
                    $this.closest('.wpmf_gallery_box').find('.gallery').remove();
                    $this.closest('.wpmf_gallery_box').find('.loading_gallery').show();
                },
                success: function (res) {
                    if (res.status) {
                        $this.closest('.wpmf_gallery_box').find('.loading_gallery').hide();
                        $this.closest('.wpmf_gallery_box').find('.wpmf-gridblock-filters').after(res.html);
                        initGallery();
                    }
                }
            });
        });
    };

    $(document).ready(function () {
        // ---------  folder tree --------------------------------
        var $glrtreethis;
        /**
         * options
         * @type {{root: string, showroot: boolean, onclick: onclick, oncheck: oncheck, usecheckboxes: boolean, expandSpeed: number, collapseSpeed: number, expandEasing: null, collapseEasing: null, canselect: boolean}}
         */
        var options = {
            'root': '/',
            'showroot': false,
            'onclick': function (elem, type, file) {
            },
            'oncheck': function (elem, checked, type, file) {
            },
            'usecheckboxes': true, //can be true files dirs or false
            'expandSpeed': 500,
            'collapseSpeed': 500,
            'expandEasing': null,
            'collapseEasing': null,
            'canselect': true
        };

        var wpmfgallery_hashid = 0;
        /**
         * Main folder tree function
         * @type {{init: init, openfolder: openfolder, closedir: closedir, setevents: setevents}}
         */
        var methods = {
            /**
             * Folder tree init
             */
            init: function (current) {
                $glrtreethis = $(current);
                if ($glrtreethis.length === 0) {
                    return;
                }

                var tree_init = '';
                tree_init += '<ul class="jaofiletree">';
                tree_init += '<li data-id="0" class="directory wpmftree_closed selected"><a class="title-folder title-root" data-id="' + $glrtreethis.data('id') + '" data-file="' + $glrtreethis.data('file') + '" data-type="dir">' + $glrtreethis.data('file') + '</a>';
                tree_init += '</li>';
                tree_init += '</ul>';
                $glrtreethis.html(tree_init);
                methods.openfolder($glrtreethis.data('file'));

                var tree_hash = window.location.hash;
                tree_hash = tree_hash.replace('#', '');
                if (tree_hash !== '') {
                    var hasha = tree_hash.split('-');
                    if (hasha[1] === 'wpmfgallery') {
                        wpmfgallery_hashid = parseInt(hasha[0]);
                        if (wpmfgallery_hashid !== 0) {
                            setTimeout(function () {
                                $.ajax({
                                    url: wpmfgallery.ajaxurl,
                                    method: "POST",
                                    dataType: 'json',
                                    data: {
                                        action: "wpmf_load_gallery", gallery_id: wpmfgallery_hashid
                                    },
                                    success: function (res) {
                                        if (res.status) {
                                            $glrtreethis.closest('.wpmf_gallery_wrap').find('.wpmf_gallery_box').html(res.html);
                                            $('.wpmf-gridblock-filters[data-gallery_id="' + wpmfgallery_hashid + '"] .tabs').tabs();
                                            initGallery();
                                        }
                                    }
                                });

                                $.ajax({
                                    url: wpmfgallery.ajaxurl,
                                    method: "POST",
                                    dataType: 'json',
                                    data: {
                                        action: "getParentsCats",
                                        id: wpmfgallery_hashid,
                                        wpmf_gallery_nonce: wpmfgallery.wpmf_gallery_nonce
                                    },
                                    success: function (res) {
                                        var initTree = false;
                                        if( !initTree) {
                                            methods.openfolders(res,wpmfgallery_hashid);
                                            initTree = true;
                                        }
                                    }
                                });

                            }, 100);
                        }
                    }
                }
            },

            /**
             * open folder by dir
             * @param dir dir name of the folders parent
             * @param callback
             */
            openfolder: function (dir, callback) {
                if (typeof $glrtreethis === "undefined")
                    return;
                var id = $glrtreethis.find('a[data-file="' + dir + '"]').data('id');
                if ($glrtreethis.find('a[data-file="' + dir + '"]').parent().hasClass('wpmftree_opened') || $glrtreethis.find('a[data-file="' + dir + '"]').parent().hasClass('wait')) {
                    if (typeof callback === 'function')
                        callback();
                    return;
                }

                var ret;
                ret = $.ajax({
                    method: 'POST',
                    url: wpmfgallery.ajaxurl,
                    data: {
                        dir: dir,
                        id: id,
                        action: 'get_galleries',
                        wpmf_gallery_nonce: wpmfgallery.wpmf_gallery_nonce
                    },
                    context: $glrtreethis,
                    dataType: 'json',
                    beforeSend: function () {
                        this.find('a[data-file="' + dir + '"]').parent().addClass('wait');
                    }
                }).done(function (datas) {
                    ret = '<ul class="jaofiletree">';
                    if (datas.status) {
                        $.each(datas.dirs, function (i, v) {
                            if (v.type === 'dir') {
                                var classe = 'directory wpmftree_closed';
                            } else {
                                classe = 'file ext_' + v.ext;
                            }


                            ret += '<li class="' + classe + '" data-id="' + v.id + '" data-parent_id="' + v.parent_id + '" data-group="' + v.term_group + '">';
                            if (v.count_child > 0) {
                                ret += '<a class="a_wpmf_arrow"><i class="material-icons wpmf-arrow icon-open-close" data-id="' + v.id + '" data-parent_id="' + v.parent_id + '" data-file="' + dir + v.file + '/" data-type="' + v.type + '">keyboard_arrow_down</i></a>';
                            }

                            ret += '<i class="zmdi zmdi-folder"></i>';
                            ret += '<a class="title-folder" data-id="' + v.id + '" data-parent_id="' + v.parent_id + '" data-file="' + dir + v.file + '/" data-type="' + v.type + '">' + v.file + '</a>';
                            ret += '</li>';
                        });
                    }
                    ret += '</ul>';

                    this.find('a[data-file="' + dir + '"]').parent().removeClass('wait').removeClass('wpmftree_closed').addClass('wpmftree_opened');
                    this.find('a[data-file="' + dir + '"]').closest('li').append(ret);
                    this.find('a[data-file="' + dir + '"]').parent().children('.jaofiletree').slideDown(options.expandSpeed, options.expandEasing,
                        function () {
                            $glrtreethis.trigger('afteropen');
                            $glrtreethis.trigger('afterupdate');
                            if (typeof callback === 'function')
                                callback();
                        });

                    methods.setevents();

                }).done(function () {
                    $glrtreethis.trigger('afteropen');
                    $glrtreethis.trigger('afterupdate');
                });
            },

            /**
             * Get selected gallery
             * @param selectedId
             * @returns {boolean}
             */
            setSelectedFolder: function(selectedId) {
                var $currentFolder = $glrtreethis.find('li.directory[data-id="'+ selectedId +'"] > a');
                $glrtreethis.find('li').removeClass('selected');
                $glrtreethis.find('i.zmdi').removeClass('wpmf-zmdi-folder-open').addClass("zmdi-folder");
                $currentFolder.parent().addClass("selected");
                $currentFolder.parent().find(' > i.zmdi').removeClass("zmdi-folder").addClass("wpmf-zmdi-folder-open");
                return true;
            },

            /**
             * Loop open gallery
             * @param dirs
             * @param selectedId
             * @returns {boolean}
             */
            openfolders: function (dirs, selectedId) {
                if (dirs.length === 1 && dirs[0] === 0) {
                    methods.setSelectedFolder(0);
                    return true;
                }

                var parent_id = dirs.shift();
                if (!$glrtreethis.find('.title-folder[data-id="' + parent_id + '"]').length) {
                    parent_id = dirs.shift();
                }

                var cdir = $glrtreethis.find('.title-folder[data-id="' + parent_id + '"]').data('file');
                if (dirs.length === 0) {
                    methods.openfolder(cdir, function () {
                        methods.setSelectedFolder(selectedId);
                    });
                    return true;
                }

                methods.openfolder(cdir, function () {
                    methods.openfolders(dirs, selectedId);
                });
                return true;
            },

            /**
             * close folder tree by dir name
             * @param dir
             */
            closedir: function (dir) {

                if (typeof $glrtreethis === "undefined")
                    return;
                $glrtreethis.find('a[data-file="' + dir + '"]').parent().children('.jaofiletree').slideUp(options.collapseSpeed, options.collapseEasing, function () {
                    $(this).remove();
                });

                $glrtreethis.find('a[data-file="' + dir + '"]').parent().removeClass('wpmftree_opened').addClass('wpmftree_closed');
                methods.setevents();

                //Trigger custom event
                $glrtreethis.trigger('afterclose');
                $glrtreethis.trigger('afterupdate');
            },

            /**
             * init event click to open/close folder tree
             */
            setevents: function () {
                $glrtreethis = $('.wpmf_gallery_tree');
                $glrtreethis.find('li a.title-folder,li .icon-open-close, .wpmf-arrow').unbind('click');

                //Bind for collapse or expand elements
                $glrtreethis.find('li.directory a.title-folder').bind('click', function (e) {
                    e.preventDefault();
                    var id = $(this).data('id');
                    var $current = $(this);
                    $(this).closest('.wpmf_gallery_tree').find('li').removeClass('selected');
                    $(this).closest('.wpmf_gallery_tree').find('i.zmdi').removeClass('wpmf-zmdi-folder-open').addClass("zmdi-folder");
                    $(this).parent().addClass("selected");
                    $(this).parent().find(' > i.zmdi').removeClass("zmdi-folder").addClass("wpmf-zmdi-folder-open");
                    methods.openfolder($(this).attr('data-file'));

                    wpmf_img_tags = '*';
                    $.ajax({
                        url: wpmfgallery.ajaxurl,
                        method: "POST",
                        dataType: 'json',
                        data: {
                            action: "wpmf_load_gallery",
                            gallery_id: id,
                            wpmf_gallery_nonce: wpmfgallery.wpmf_gallery_nonce
                        },
                        success: function (res) {
                            if (res.status) {
                                $current.closest('.wpmf_gallery_wrap').find('.wpmf_gallery_box').html(res.html);
                                $('.wpmf-gridblock-filters[data-gallery_id="' + id + '"] .tabs').tabs();
                                initGallery();
                                window.location.hash = '#' + id + '-wpmfgallery';
                            }
                        }
                    });
                });

                //Bind for collapse or expand elements
                $glrtreethis.find('.wpmf-arrow').bind('click', function () {
                    methods.openfolder($(this).attr('data-file'));
                });

                /* open folder tree use icon */
                $glrtreethis.find('li.directory.wpmftree_closed .icon-open-close').bind('click', function () {
                    methods.openfolder($(this).attr('data-file'));
                });

                /* close folder tree use icon */
                $glrtreethis.find('li.directory.wpmftree_opened .icon-open-close').bind('click', function () {
                    methods.closedir($(this).attr('data-file'));
                });
            }
        };

        /**
         * Init folder tree
         */
        $('.wpmf_gallery_tree').each(function () {
            methods.init(this);
        });

        if (wpmfgallery.wpmf_current_theme === 'Gleam') {
            setTimeout(function () {
                initGallery();
            }, 1000);
        } else {
            initGallery();
        }

        /* auto play */
        var flipsterAutoplay = function(){
            $('.flipto-next').click();
            setTimeout(flipsterAutoplay,3000);
        };

        setTimeout(flipsterAutoplay,3000);
    });

    $(document.body).on('post-load', function () {
        initGallery();
    });

    $(document.body).on('wpmfs-toggled', function () {
        initGallery();
    });

})(jQuery);
