<?php
/* Prohibit direct script loading */
defined('ABSPATH') || die('No direct script access allowed!');
?>
<div class="cboption">
    <h3><?php esc_html_e('WP Media Folder Galleries settings', 'wp-media-folder-gallery-addon'); ?></h3>
    <div class="wpmf_row_full">
        <input type="hidden" name="wpmf_gallery_settings[progressive_loading]" value="0">
        <label data-alt="<?php esc_html_e('Load your images on page scroll, recommended for better
         performance to a large amount of images on the same page', 'wp-media-folder-gallery-addon'); ?>" class="text">
            <?php esc_html_e('Progressive loading', 'wp-media-folder-gallery-addon') ?>
        </label>
        <div class="switch-optimization">
            <label class="switch switch-optimization">
                <?php
                if (isset($gallery_configs['progressive_loading']) && (int) $gallery_configs['progressive_loading'] === 0) :
                    ?>
                    <input type="checkbox" name="wpmf_gallery_settings[progressive_loading]" value="1">
                <?php else : ?>
                    <input type="checkbox" name="wpmf_gallery_settings[progressive_loading]" checked value="1">
                <?php endif; ?>
                <span class="slider round"></span>
            </label>
        </div>
    </div>

    <?php
    // phpcs:disable WordPress.XSS.EscapeOutput -- Content already escaped in the method
    // For setting default theme
    echo $default_theme;
    // For setting portfolio theme
    echo $portfolio_theme;
    // For setting masonry theme
    echo $masonry_theme;
    // For setting slider theme
    echo $slider_theme;
    // For setting flow slide theme
    echo $flowslide_theme;
    // For setting square grid theme
    echo $square_grid_theme;
    // For setting material theme
    echo $material_theme;
    // phpcs:enable
    ?>
</div>