<?php namespace MasterPopups\Includes;

class ContactForm extends FormSubmission {
    public $to = '';

    /*
    |---------------------------------------------------------------------------------------------------
    | Constructor
    |---------------------------------------------------------------------------------------------------
    */
    public function __construct( $plugin, $post_data = array() ){
        parent::__construct( $plugin, $post_data, 'ContactForm' );
    }

    /*
    |---------------------------------------------------------------------------------------------------
    | Realiza la suscripción
    |---------------------------------------------------------------------------------------------------
    */
    public function execute(){
        if( isset( $this->fields['email'] ) && $this->fields['email']['required'] == 'on' ){
            if( ! parent::validate_email() ){
                return $this->result;
            }
        }

        if( $this->popup->option( 'contact-form-admin-notif' ) == 'off' ){
            $this->actions_on_success();
            $this->result['error'] = false;
            return $this->result;
        }

        $this->to = $this->popup->option( 'contact-form-mail-to' );
        $this->to = $this->validate_emails( explode( ',', $this->to ) );
        if( Functions::is_empty( $this->to ) ){
            $this->result['message'] = $this->cannot . __( 'The recipient email has not been established.', 'masterpopups' );
            return $this->result;
        }

        $this->set_additional_data_to_save();
        $this->set_render_fields();
        $this->result['error'] = false;
        $this->send();

        return $this->result;
    }

    /*
    |---------------------------------------------------------------------------------------------------
    | Envía el formulario de contacto
    |---------------------------------------------------------------------------------------------------
    */
    public function send(){
        $subject = $this->popup->option( 'contact-form-mail-subject' );
        $message = $this->popup->option( 'contact-form-mail-message' );

        $headers = array();
        $headers[] = 'Content-Type: text/html; charset=UTF-8';
        $from = $this->popup->option( 'contact-form-mail-from' );
        if( stripos( $from, '{render' ) !== false ){
            $from = strtr( $from, $this->render_fields );
        }
        $headers[] = "From: $from";

        if( isset( $this->fields['email'] ) ){
            $user_name = '';
            if( isset( $this->fields['first_name'] ) ){
                $user_name = $this->fields['first_name']['value'];
            }
            $headers[] = "Reply-To: $user_name <{$this->fields['email']['value']}>";
        }

        $body = strtr( $message, $this->render_fields );
        $body = wpautop( $body );

        if( wp_mail( $this->to, $subject, $body, $headers ) ){
            $this->actions_on_success();
        } else{
            $this->actions_on_error();
        }
    }

    /*
    |---------------------------------------------------------------------------------------------------
    | Acciones cuando el proceso se realizó con éxito
    |---------------------------------------------------------------------------------------------------
    */
    private function actions_on_success(){
        $this->result['success'] = true;
        $this->result['actions'] = $this->get_actions_on_success();
    }

    /*
    |---------------------------------------------------------------------------------------------------
    | Acciones cuando el email no fue enviado
    |---------------------------------------------------------------------------------------------------
    */
    private function actions_on_error(){
        $this->result['success'] = false;
        $message = $this->popup->option( 'contact-form-error-message' );
        if( ! mail( 'testing_email@example.com', '[WordPress] PHP Mail Test', 'This is a test to check the PHP Mail functionality' ) ){
            $message .= '<br><strong>Error: PHP mail() functionality is OFF.</strong> Your wordpress installation does not allow sending emails, please contact to your Hosting.';
        }
        $this->result['actions'] = array(
            'message' => $message,
        );
    }


}
