<?php namespace MasterPopups\Includes\ServiceIntegration;

abstract class ServiceIntegration {
    public $service = null;
    protected $ironman = null;
    protected $api_key = '';
    protected $list_id = '';
    protected $list_fields = array();
    public $error = '';
    public $response = null;
    public $messages = array(
        'subscription_ok' => 'Thank you, you have been added to our mailing list',
        'subscriber_exists' => 'Sorry, user already registered',
    );
    public $debug = array();


    /*
    |---------------------------------------------------------------------------------------------------
    | Retorna el api key
    |---------------------------------------------------------------------------------------------------
    */
    public function get_api_key(){
        return $this->api_key;
    }

    /*
    |---------------------------------------------------------------------------------------------------
    | Establece el id de una lista
    |---------------------------------------------------------------------------------------------------
    */
    public function set_list_id( $list_id, $allow_get_lists = true, $list_fields = array() ){
        $list_id = trim( $list_id );
        $this->set_list_fields( $list_fields );

        if( ! $allow_get_lists ){
            $this->list_id = $list_id;
            return true;
        }
        if( $this->is_valid_list_id( $list_id, $list_fields ) ){
            $this->list_id = $list_id;
            return true;
        } else{
            $this->error = "List ID '$list_id' is not valid.";
            return false;
        }
    }

    /*
    |---------------------------------------------------------------------------------------------------
    | Establece campos adicionales para la suscripción
    |---------------------------------------------------------------------------------------------------
    */
    public function set_list_fields( $list_fields = array() ){
        $this->list_fields = $list_fields;
    }

    /*
    |---------------------------------------------------------------------------------------------------
    | Retorna el id de la lista establecida
    |---------------------------------------------------------------------------------------------------
    */
    public function get_list_id(){
        return $this->list_id;
    }

    /*
    |---------------------------------------------------------------------------------------------------
    | Comprueba si un id de lista es válida
    |---------------------------------------------------------------------------------------------------
    */
    public function is_valid_list_id( $list_id, $list_fields = array() ){
        return in_array( $list_id, array_keys( $this->get_lists( $list_fields ) ) );
    }

    /*
    |---------------------------------------------------------------------------------------------------
    | Comprueba si un email es válido
    |---------------------------------------------------------------------------------------------------
    */
    public function is_valid_email( $email ){
        return filter_var( $email, FILTER_VALIDATE_EMAIL );
    }

    /*
    |---------------------------------------------------------------------------------------------------
    | Comprueba si la conexión con el servicio es exitosa
    |---------------------------------------------------------------------------------------------------
    */
    abstract public function is_connect();

    /*
    |---------------------------------------------------------------------------------------------------
    | Retorna todas las listas
    |---------------------------------------------------------------------------------------------------
    */
    abstract public function get_lists();

    /*
    |---------------------------------------------------------------------------------------------------
    | Agrega un suscriptor a una lista
    |---------------------------------------------------------------------------------------------------
    */
    abstract public function add_subscriber( $email, $data = array() );

    /*
    |---------------------------------------------------------------------------------------------------
    | Retorna todos los campos por defecto
    |---------------------------------------------------------------------------------------------------
    */
    public function get_default_fields(){
        return array();
    }

    /*
    |---------------------------------------------------------------------------------------------------
    | Retorna todos los campos personalizados
    |---------------------------------------------------------------------------------------------------
    */
    public function get_custom_fields(){
        return array();
    }

    /*
    |---------------------------------------------------------------------------------------------------
    | Realiza una nueva petición usando IronMan HTTP Client
    |---------------------------------------------------------------------------------------------------
    */
    public function new_request( $method, $url, $body = array(), $headers = array(), $options = array() ){
        $this->error = '';//reset error
        if( ! $this->ironman ){
            return false;
        }
        $this->response = $this->ironman->request( $method, $url, $headers, $body, $options );
        //true si ( $ironman->response_code >= 200 && $ironman->response_code < 300 )
        if( ! $this->ironman->success() ){
            $this->error = $this->ironman->get_error_message();
            return false;
        }
        return true;
    }

    /*
    |---------------------------------------------------------------------------------------------------
    | Get response code
    |---------------------------------------------------------------------------------------------------
    */
    public function get_response_code(){
        return $this->ironman->response_code;
    }

    /*
    |---------------------------------------------------------------------------------------------------
    | Get response body
    |---------------------------------------------------------------------------------------------------
    */
    public function get_response_body( $array = true ){
        if( is_null( $array ) ){
            return $this->ironman->get_response_body();
        }
        return json_decode( $this->ironman->get_response_body(), $array );
    }

    /*
    |---------------------------------------------------------------------------------------------------
    | Get error message
    |---------------------------------------------------------------------------------------------------
    */
    public function get_error_message( $error_message = '' ){
        if( $error_message ){
            if( is_array( $error_message ) && ! empty( $error_message ) ){
                $this->error = $this->error ?  rtrim( $this->error, '.') . ". " : $this->error;
                foreach( $error_message as $error ){
                    $this->error .= ! empty( $error['message'] ) ? $error['message'] .'. ' : '';
                }
            } else {
                $this->error = $this->error ?  rtrim( $this->error, '.') . ". $error_message" : $error_message;
            }
        }
        return $this->error;
    }

    /*
    |---------------------------------------------------------------------------------------------------
    | Verifica si un valor existe en un array
    |---------------------------------------------------------------------------------------------------
    */
    public function isset_field( $field, $array, $case_sensitive = false ){
        $array = array_values( $array );
        if( $case_sensitive ){
            return in_array( $field, $array );
        }
        $field = strtolower( $field );
        $array = array_map( 'strtolower', $array );
        return in_array( $field, $array );
    }


}
