import yargs from "yargs"
import { hideBin } from "yargs/helpers"
import path from "path"
import { fileURLToPath } from "url"

const __filename = fileURLToPath(import.meta.url)
const __dirname = path.dirname(__filename)

export const DIST_PATH = path.resolve(process.env.HOME, "WebstormProjects/mapsvg-dist")
export const BASE_PLUGIN_PATH = path.resolve(__dirname, "../../")
export const BUILDS_PATH = path.resolve(DIST_PATH, "builds")
export const RELEASES_PATH = path.resolve(DIST_PATH, "releases")
export const SVN_PATH = path.resolve(DIST_PATH, "mapsvg-lite-svn")
export const SVN_TRUNK_PATH = path.join(SVN_PATH, "trunk")

export const DEMO_WP_PATH = path.resolve(
  process.env.HOME,
  "WebstormProjects/demo.mapsvg.com/wp-content/plugins/mapsvg",
)

const config = {
  common: {
    DIST_PATH,
    BASE_PLUGIN_PATH,
    BUILDS_PATH,
    RELEASES_PATH,
    SVN_PATH,
    SVN_TRUNK_PATH,
    DEMO_WP_PATH,
  },
  production: {
    MAPSVG_API_URL: "https://mapsvg.com/dashboard/api",
    DEPLOY_TOKEN: "5493c3910808809251e099e131681a00439e335a8fed8feb18110fb36062dffb",
  },
  staging: {
    MAPSVG_API_URL: "https://staging.mapsvg.com/dashboard/api",
    DEPLOY_TOKEN: "5493c3910808809251e099e131681a00439e335a8fed8feb18110fb36062dffb",
  },
}

export const getConfig = () => {
  const argv = yargs(hideBin(process.argv)).option("env", {
    alias: "e",
    default: "staging",
    choices: ["production", "staging"],
  }).argv

  if (!config[argv.env]) {
    throw new Error(`Invalid environment: ${argv.env}`)
  }
  return { ...config.common, ...config[argv.env] }
}
