<?php
/**
 * SCREETS © 2018
 *
 * SCREETS, d.o.o. Sarajevo. All rights reserved.
 * This  is  commercial  software,  only  users  who have purchased a valid
 * license  and  accept  to the terms of the  License Agreement can install
 * and use this program.
 *
 * @package LiveChatX
 * @author Screets
 *
 */
if ( ! defined( 'ABSPATH' ) ) { exit; } 

/**
 * Actions before console template.
 */
do_action( 'lcx_tpl_before_console' );

include 'win.chat.php';
?>

<div class="lcx">
	
	<?php
	/**
	 * Notifications.
	 */
	?>
	<div id="nbird-ntfs" class="nbird-ntfs">
		
		<!-- Notification templates -->
		<div id="nbird-ntf-success" class="d-hide">
			<div class="toast toast-success fadeindown"><button class="btn close-btn btn-sm btn-clear float-right"></button> {__msg}</div>
		</div>
		<div id="nbird-ntf-warning" class="d-hide">
			<div class="toast toast-warning fadeindown"><button class="btn close-btn btn-sm btn-clear float-right"></button> {__msg}</div>
		</div>
		<div id="nbird-ntf-error" class="d-hide">
			<div class="toast toast-error fadeindown"><button class="btn close-btn btn-sm btn-clear float-right"></button> {__msg}</div>
		</div>
		<div id="nbird-ntf-info" class="d-hide">
			<div class="toast toast-info fadeindown"><button class="btn close-btn btn-sm btn-clear float-right"></button> {__msg}</div>
		</div>

	</div>
	

	<div class="container grid-xl">

		<?php
		/**
		 * Chat console layout.
		 */
		?>
		<div id="nbird-console" class="nbird-console nbird-main">
			<header class="navbar">
				<section class="navbar-section">
					
					<!-- Operator info -->
					<div class="nbird-op-info">
						<img id="currentUser-photoURL" class="currentUser-photoURL" src="<?php echo fn_lcx_get_anonymous_img(); ?>" alt="">
						<div class="nbird-is-content">
							<a href="<?php echo admin_url( 'admin.php?page=options-general.php%3Fpage%3Dlcx_opts#tab-site' ); ?>" id="lcx-sitename" class="lcx-sitename" title="Site name" target="_blank"><?php echo $site['info_name']; ?></a><span class="lcx-sep">&rsaquo;</span><span id="currentUser-name" class="currentUser-name">&nbsp;</span>
						</div>
					</div>
				</section>
				<section class="navbar-center">
					<img src="<?php echo $logoURL; ?>" alt="" class="logo">
				</section>
				<section class="navbar-section">
					<!-- Online/offline buttons -->
					<div class="form-group">
						<label id="nbird-toggle-online" class="nbird-toggle-online form-switch is-error c-hand d-hide">
							<input type="checkbox" id="nbird-switcher-online" class="nbird-switcher-online">
							<i class="form-icon"></i> 
							
							<span class="nbird-online-status text-gray-light c-hand" data-online="<?php echo $_online; ?>" data-offline="<?php echo $_offline; ?>"></span>
						</label>

					</div>
					
					<?php
					/**
					 * Sign-in button.
					 */
					?>
					<button id="nbird-signin" class="btn btn-sm btn-narrow nbird-signin" disabled data-signin="<?php echo $_signin; ?>" data-signout="<?php echo $_signout; ?>"><i class="icon icon-shutdown"></i></button>
					&nbsp; &nbsp;

					<a href="#nbird-modal-profile" id="nbird-profile" class="nbird-settings btn btn-primary btn-narrow btn-sm d-hide"><i class="icon icon-people"></i></a>

					<!-- &nbsp; -->

					<!-- <a href="#nbird-modal-profile" id="nbird-settings" class="nbird-settings btn btn-primary btn-narrow btn-sm"><?php echo file_get_contents( LCX_PATH . '/assets/icons/admin/flash.svg' ); ?></a> -->
				</section>
			</header>

			<!--
			 - Waiting section.
			 -->
			<section id="nbird-wait-section" class="nbird-section nbird-wait-section main installation d-hide">
				
				<div class="lcx-subtitle blink"><?php _e( 'Please wait until the current process is finished...', 'lcx' ); ?></div>

			</section>

			<!--
			 - Welcome section.
			 -->
			<section id="nbird-welcome-section" class="nbird-section nbird-welcome-section main welcome">
				<!-- Welcome loader -->
				<div class="nbird-welcome-loader">
					<div class="wrapper">
						<div class="content">
							<div class="loading loading-lg"></div>
						</div>
					</div>
				</div>

				<!-- Welcome message -->
				<div class="nbird-welcome-conn d-hide">
					<div class="wrapper">						
						<div class="content is-vMiddle">
							<div class="lcx-title">
								Screets <br><?php echo LCX_SNAME; ?>
							</div>

							<div class="lcx-subtitle">
								Night Bird <?php echo LCX_VERSION; ?>
							</div>

							<p class="lcx-desc">
								Now, Live Chat is faster, smarter and more beautiful.
							</p>

							<h3>New features:</h3>

							<ul>
								<li>New Design</li>
								<li>Conversations</li>
								<li>Random visitor names</li>
								<li>Case numbers</li>
								<li>Send email transcript from back-end</li>
								<li>No need pre-chat or offline forms.</li>
							</ul>
						</div>
					</div>
				</div>
			</section>
			
			<!--
			 - Installation section.
			 -->
			<section id="nbird-install-section" class="nbird-section nbird-install-section main install d-hide">
				<div class="wrapper">
					<div class="content">
						<div class="lcx-title">
							<?php _e( 'New update is available.', 'lcx' ); ?>
						</div>

						<p class="lcx-desc">⚠️ <?php _e( 'Login to your Firebase account to complete installation.', 'lcx' ); ?></p>

						<p><a href="" id="lcx-signin-google" class="btn btn-lg has-icon"><img src="<?php echo LCX_URL; ?>/assets/img/console/google-logo-400x.png" alt=""> <?php _e( 'Login', 'lcx' ); ?></a></p>
					</div>
				</div>
			</section>
			
			<!--
			 - Chat section.
			 -->
			<section id="nbird-chat-section" class="nbird-chat-section main columns col-gapless d-hide">
				<div class="side column col-2">

					<!-- Desktop notifications -->
					<div id="lcx-ntf-alert" class="toast toast-primary d-hide" style="border-radius: 0">
						<p>
							<strong><?php _e( 'Get notified of chat notifications.', 'lcx' ); ?></strong>
						</p>

						<a href="#" id="lcx-activate-ntfs">
							<?php _e( 'Turn on', 'lcx' ); ?>
						</a>
					</div>

					<ul class="side-title list-tabs">
						<li class="active">
							<a href="#chats-list-wrap"><?php _e( 'Chats', 'lcx' ); ?></a>
						</li>
						<li>
							<a href="#archived-chats-list-wrap"><?php _e( 'Archive', 'lcx' ); ?></a>
						</li>
					</ul>

					<?php
					/**
					 * Chats list template.
					 */
					?>
					<div id="chats-list-wrap" class="chats-list-wrap list-tab-content active">
						<ul id="chats-list" class="chats-list side-list">
							<?php
							/**
							 * "No chats found" filter.
							 */
							echo apply_filters( 'lcx_tpl_no_chats_found', '<li class="_no-item text-gray-light"><small>' . __( 'No chats found.', 'lcx' ) . '</small></li>' );
							?>
						</ul>
					</div>

					<?php
					/**
					 * Archived chats list template.
					 */
					?>
					<div id="archived-chats-list-wrap" class="archived-chats-list-wrap list-tab-content">
						<ul id="archived-chats-list" class="archived-chats-list side-list">
							<?php
							/**
							 * "No chats found" filter.
							 */
							echo apply_filters( 'lcx_tpl_no_archvied_chats_found', '<li class="_no-item text-gray-light"><small>' . __( 'No archived chats found.', 'lcx' ) . '</small></li>' );
							?>
						</ul>
					</div>

					<div class="d-hide">
						<?php
						/**
						 * Chat list item template filter.
						 */
						echo apply_filters( 'lcx_tpl_chat_item', '<li id="chats-list-tpl"><a href="" class="d-block itemLink"><span class="lcx-timeago itemTime" datetime=""></span><span class="name text-ellipsis"></span></a></li>' );
						?>

						<?php
						/**
						 * Archived chat list item template filter.
						 */
						echo apply_filters( 'lcx_tpl_archived_chat_item', '<li id="archived-chats-list-tpl"><span class="d-block itemLink"><span class="lcx-timeago itemTime" datetime=""></span><span class="name text-ellipsis"></span><span class="msg text-ellipsis"><a href="#" class="undoLink btn btn-primary">' . __( 'Undo', 'lcx' ) . '</a><span class="caseNo"></span></span></span></li>' );
						?>
					</div>


					<!-- Plugin info -->
					<div class="lcx-info">

						<span class="lcx-logo"><img src="<?php echo LCX_URL; ?>/assets/img/nb-logo-200x.png" alt="<?php echo LCX_NAME; ?>"></span>
						<span class="lcx-version">
							<strong><?php echo LCX_SNAME; ?></strong>
							<?php echo LCX_VERSION; ?>		
						</span>
					</div>
					
				</div>

				<div id="win-0" class="win-0 column col-7"></div>
				<div id="win-1" class="win-1 column col-3"></div>
			</section>
		</div>
	</div>
	
	<?php
	/**
	 * End chat popup.
	 */
	?>
	<div id="nbird-modal-endChat" class="modal modal-sm nbird-modal-endChat">
		<a href="#close" class="modal-overlay" aria-label="Close"></a>
		<div class="modal-container">
			<div class="modal-body">
				<form id="form-joinChat" action="" class="form-joinChat">
					<div class="form-group">
						<label class="form-label" for="f-closing-msg"><strong><?php _e( 'Closing message', 'lcx' ); ?></strong>:</label>
						<textarea class="form-input" id="f-closing-msg" class="f-closing-msg" rows="5"><?php echo $closingMsg; ?></textarea>
					</div>
					<div class="form-group">
						<label class="form-switch">
							<input type="checkbox" checked="true" class="cb-sendChatLogs" id="cb-sendChatLogs">
							<i class="form-icon"></i> <?php _e( 'Send chat transcript to visitor\'s email', 'lcx' ); ?>
						</label>
					</div>
					<br>
					<div class="form-group">
						<span id="loader-endChat" class="loading d-hide"></span>
						<a href="#" id="btn-endChat" class="btn-endChat btn btn-primary btn-sm"><?php _e( 'End chat', 'lcx' ); ?></a>
						<a href="#" id="btn-endChatWoMsg" class="btn-endChatWoMsg btn btn-sm"><?php _e( 'End chat without message', 'lcx' ); ?></a>
					</div>
				</form>
			</div>
		</div>
	</div>
	
	<?php
	/**
	 * Profile modal.
	 */
	?>
	<div id="nbird-modal-profile" class="modal nbird-modal-profile">
		<a href="#modals" class="modal-overlay"></a>
		<div class="modal-container">
			<div class="modal-header">
				<a href="#modals" class="btn btn-clear float-right"></a>
				<div class="modal-title h5"><?php _e( 'Profile', 'lcx' ); ?></div>
			</div>

			<div class="modal-body">
				<div class="content">
					<form id="form-settings" action="" class="form-settings form-horizontal">
						<div class="form-group">
							<div class="col-3">
								<label class="form-label label-sm" for="field-user-name"><?php echo $_name; ?></label>
							</div>
							<div class="col-9">
								<input class="form-input input-sm" type="text" id="field-user-name" name="name" placeholder="<?php echo $_name; ?>">
							</div>
						</div>
						<div class="form-group">
							<div class="col-3">
								<label class="form-label label-sm" for="field-user-email"><?php echo $_email; ?></label>
							</div>
							<div class="col-9">
								<input class="form-input input-sm" type="email" name="email" id="field-user-email" placeholder="<?php echo $_email; ?>" value="<?php echo $user->user_email; ?>" disabled>
							</div>
						</div>

						<div class="form-group">
							<div class="col-3">
								<label class="form-label label-sm" for="field-user-photo-url"><?php echo $_profileImg; ?></label>
							</div>
							<div class="col-9">
								<input class="form-input input-sm" type="url" name="photoURL" id="field-user-photo-url" placeholder="i.e. https://yourdomain.com/avatar.png">
							</div>
						</div>

						<div class="gap gap-lg"></div>

						<div><strong>Email notifications</strong></div>

						<div class="form-group">
						  <label class="form-switch">
							<input type="checkbox" name="subscribeChatReqs" <?php echo ( !empty( $emailNtfs['chatReqs']['u'.$user->ID] ) ) ? 'checked=""' : ''; ?>>
							<i class="form-icon"></i> Subscribe new chat requests <br><small class="text-gray"><?php _e( 'Only works if any operator doesn\'t accept new chats automatically at that moment.', 'lcx' ); ?></small>
						  </label>
						</div>


					</form>
				</div>
			</div>
			<div class="modal-footer">
				<a href="#modals" class="btn btn-link"><?php _e( 'Close', 'lcx' ); ?></a> &nbsp;
				<button class="btn btn-primary btn-save-profile" id="btn-save-profile"><?php _e( 'Save', 'lcx' ); ?></button>
			</div>
		</div>
	</div>

	<script>
		document.addEventListener( 'DOMContentLoaded', function() {
			var lcx_nightBird = new nightBird( <?php echo json_encode( $appOpts ); ?>, <?php echo json_encode( $appStrings ); ?>);
		}, false);
	</script>
</div>

<?php
/**
 * Actions after console template.
 */
do_action( 'lcx_tpl_after_console' );

?>
