<?php
/**
 * SCREETS © 2018
 *
 * SCREETS, d.o.o. Sarajevo. All rights reserved.
 * This  is  commercial  software,  only  users  who have purchased a valid
 * license  and  accept  to the terms of the  License Agreement can install
 * and use this program.
 *
 * @package LiveChatX
 *
 */

add_filter( LCX_SLUG . '_register_options', '_fn_lcx_options_data' );

function _fn_lcx_options_data( $opts ) {
	global $wpdb;

	// Get pure domain
	$domain = fn_lcx_get_pure_domain( fn_lcx_get_current_url() );

	// Get users
	$users = get_users( array(
		'fields' => array( 'ID', 'user_login', 'user_email', 'display_name' )
	));

	// Get usernames
	$usernames = array();
	foreach( $users as $user ) {
		$usernames[$user->ID] = $user->user_login;
	}

	// Tabs
	$opts['tabs'][] = array(
		'id' => 'general',
		'title' => __( 'General', 'lcx' )
	);
	$opts['tabs'][] = array(
		'id' => 'chats',
		'title' => __( 'Chats', 'lcx' ),
	);
	$opts['tabs'][] = array(
		'id' => 'site',
		'title' => __( 'Site', 'lcx' ),
	);
	$opts['tabs'][] = array(
		'id' => 'design',
		'title' => __( 'Design', 'lcx' ),
	);
	$opts['tabs'][] = array(
		'id' => 'users',
		'title' => __( 'Users', 'lcx' ),
	);
	$opts['tabs'][] = array(
		'id' => 'msgs',
		'title' => __( 'Messages', 'lcx' )
	);
	$opts['tabs'][] = array(
		'id' => 'realtime',
		'title' => __( 'Real-time', 'lcx' ),
	);
	$opts['tabs'][] = array(
		'id' => 'advanced',
		'title' => __( 'Advanced', 'lcx' ),
	);

	// General -> Display
	$opts['sections'][] = array(
		'tab_id' => 'general',
		'section_id' => 'display',
		'section_title' => __( 'Display', 'lcx' ),
		'section_description' => 'You don’t have to offer chat everywhere to every customer. Consider carefully where the unique benefits of live chat will make the most impact.',
		'section_order' => 10,
		'fields' => array(
			array(
				'id' => 'basics',
				'title' => '',
				'choices' => array(
					'hideMobile' => '📱 ' .__( 'Disable on mobile devices', 'lcx' ),
					'hideSSL' => '🔑 ' .__( 'Hide from pages that uses SSL', 'lcx' ),
				),
				'req' => array(),
				'type' => 'checkboxes'
			),
			array(
				'id' => 'type',
				'title' => __( 'Where to show up?', 'lcx' ),
				'choices' => array(
					'show' => '✔ ' . __( 'Show everywhere', 'lcx' ),
					'hide' => '✖️ ' . __( 'Hide everywhere', 'lcx' )
				),
				'std' => 'show',
				'type' => 'radio'
			),
			array(
				'id' => 'except_pages',
				'title' => '',
				'desc' => __( 'Except those pages', 'lcx' ) . ':',
				'value' => true,
				'req' => array(),
				'type' => 'multi_pages'
			),
			array(
				'id' => 'home',
				'title' => __( 'Display on specific pages', 'lcx' ),
				'desc' => __( 'Homepage', 'lcx' ). ':',
				'choices' => array(
					'show' => __( 'Always show', 'lcx' ),
					'hide' => __( 'Always hide', 'lcx' )
				),
				'req' => array(),
				'type' => 'radio'
			),
			array(
				'id' => 'blog',
				'title' => '',
				'desc' => __( 'Blog-related pages', 'lcx' ) . ':',
				'choices' => array(
					'show' => __( 'Always show', 'lcx' ),
					'hide' => __( 'Always hide', 'lcx' )
				),
				'req' => array(),
				'type' => 'radio'
			)
		)
	);
	
	// General -> Screets API
	$opts['sections'][] = array(
		'tab_id' => 'general',
		'section_id' => 'license',
		'section_title' => __( 'Licensing', 'lcx' ),
		'section_description' => '',
		'section_order' => 30,
		'fields' => array(
			array(
				'id' => 'api',
				'title' => '<span class="dashicons dashicons-post-status"></span> Screets API key <span class="lcx-req">*</span>',
				'desc' => '<strong><a href="https://support.screets.io/api/?domain=' . $domain .'" target="_blank">Get your API key</a></strong> <span class="lcx-ico-new-win"></span><br>' . __( 'It is required to activate the plugin and get <strong>free updates</strong>.', 'lcx' ) . '<br><small>* ' . __( 'Note that you might need to re-login WordPress after updating your API key.', 'lcx' ) . '</small>',
				'placeholder' => 'Screets API Key',
				'type' => 'text'
			)
		)
	);

	// Chats -> Response info
	$opts['sections'][] = array(
		'tab_id' => 'chats',
		'section_id' => 'response',
		'section_title' => __( 'Response Info', 'lcx' ),
		'section_description' => 'Set your live chat hours to an <strong>achievable level</strong>. Because for customers, “live chat” implies an almost instant response, so a delayed reply to a chat is a much poorer experience than a slow email reply.',
		'section_order' => 10,
		'fields' => array(
			array(
				'id' => 'replies_online',
				'title' => __( 'Typically replies within...', 'lcx' ),
				'desc' => __( 'Online', 'lcx' ) . ' (' . __( 'At least one operator is online', 'lcx' ) . ')',
				'choices' => array(
					'none' => __( 'Not specified', 'lcx' ),
					'aFewMins' => __( 'a few minutes', 'lcx' ),
					'in15min' => __( '15 minutes', 'lcx' ),
					'in30min' => __( '30 minutes', 'lcx' ),
					'in1hour' => __( 'an hour', 'lcx' ),
					'inFewHours' => __( 'a few hours', 'lcx' ),
					'inDay' => __( 'a day', 'lcx' ),
					'1BDay' => __( '1 business day', 'lcx' ),
					'2BDay' => __( '2 business days', 'lcx' ),
					'3BDay' => __( '3 business days', 'lcx' )
				),
				'std' => 'aFewMins',
				'type' => 'select'
			),
			array(
				'id' => 'replies_offline',
				'title' => '',
				'desc' => __( 'Offline', 'lcx' ) . ' (' .__( 'No operators online', 'lcx' ) . ')',
				'choices' => array(
					'none' => __( 'Not specified', 'lcx' ),
					'aFewMins' => __( 'a few minutes', 'lcx' ),
					'in15min' => __( '15 minutes', 'lcx' ),
					'in30min' => __( '30 minutes', 'lcx' ),
					'in1hour' => __( 'an hour', 'lcx' ),
					'inFewHours' => __( 'a few hours', 'lcx' ),
					'inDay' => __( 'a day', 'lcx' ),
					'1BDay' => __( '1 business day', 'lcx' ),
					'2BDay' => __( '2 business days', 'lcx' ),
					'3BDay' => __( '3 business days', 'lcx' )
				),
				'std' => '1BDay',
				'type' => 'select'
			)
		)
	);
	
	// Site -> Info
	$opts['sections'][] = array(
		'tab_id' => 'site',
		'section_id' => 'info',
		'section_title' => __( 'Site info', 'lcx' ),
		'section_order' => 10,
		'fields' => array(
			array(
				'id' => 'name',
				'title' => __( 'Site name', 'lcx' ) . '<span class="lcx-req">*</span>',
				'desc' => __( 'We will show this name as your site/company name when needed', 'lcx' ),
				'placeholder' => __( 'Site name', 'lcx' ),
				'std' => get_bloginfo(), // site title
				'type' => 'text'
			),
			array(
				'id' => 'url',
				'title' => __( 'Site url', 'lcx' ) . '<span class="lcx-req">*</span>',
				'std' => 'http://' . fn_lcx_get_pure_domain( get_bloginfo( 'url' ) ),
				'placeholder' => __( 'Site url', 'lcx' ),
				'type' => 'text'
			),
			array(
				'id' => 'logo',
				'title' => __( 'Site logo', 'lcx' ) . '<span class="lcx-req">*</span>',
				'type' => 'file'
			),
			array(
				'id' => 'email',
				'title' => __( 'Site email', 'lcx' ) . '<span class="lcx-req">*</span>',
				'std' => '',
				'placeholder' => 'FROM',
				'desc' => __( '"FROM" part of all emails sending to your visitors' ) . '.',
				'type' => 'text'
			),
			array(
				'id' => 'reply_to',
				'title' => '',
				'placeholder' => 'REPLY-TO (' . __( 'Optional', 'lcx' ) . ')',
				'desc' => 'REPLY-TO (' . __( 'Optional', 'lcx' ) . '): ' . __( 'Your visitors will reply to this email.', 'lcx' ),
				'type' => 'text'
			),
			array(
				'id' => 'email_logo_width',
				'title' => __( 'Logo width', 'lcx' ) . ' (' . __( 'Email', 'lcx' ) . ')',
				'desc' => __( 'If original size 100px, we recommend you to set 50px for retina displays', 'lcx' ),
				'std' => 50,
				'atts' => array(
					'min' => 0,
					'max' => 200
				),
				'type' => 'number'
			)
		)
	);

	// Site -> Social
	/*$opts['sections'][] = array(
		'tab_id' => 'site',
		'section_id' => 'social',
		'section_title' => __( 'Social network', 'lcx' ),
		'section_description' => 'Need more icons? Send a request to <a href="mailto:support@screets.io">support@screets.io</a>.',
		'section_order' => 20,
		'fields' => array(
			array(
				'id'				=> 'twitter',
				'title'      	 	=> '<span class="lcx-ico-twitter"></span> - Twitter',
				'placeholder'       => 'Twitter',
				'type'              => 'text'
			),
			array(
				'id'				=> 'facebook',
				'title'      	 	=> '<span class="lcx-ico-facebook"></span> - Facebook',
				'placeholder'       => 'Facebook',
				'type'              => 'text'
			),
			array(
				'id'				=> 'instagram',
				'title'      	 	=> '<span class="lcx-ico-instagram"></span> - Instagram',
				'placeholder'       => 'Instagram',
				'type'              => 'text'
			),
			array(
				'id'				=> 'tumblr',
				'title'      	 	=> '<span class="lcx-ico-tumblr"></span> - Tumblr',
				'placeholder'       => 'Tumblr',
				'type'              => 'text'
			),
			array(
				'id'				=> 'airbnb',
				'title'      	 	=> '<span class="lcx-ico-airbnb"></span> - Airbnb',
				'placeholder'       => 'Airbnb',
				'type'              => 'text'
			),
			array(
				'id'				=> 'tripadvisor',
				'title'      	 	=> '<span class="lcx-ico-tripadvisor"></span> - TripAdvisor',
				'placeholder'       => 'TripAdvisor',
				'type'              => 'text'
			),
			array(
				'id'				=> 'yelp',
				'title'      	 	=> '<span class="lcx-ico-yelp"></span> - Yelp',
				'placeholder'       => 'Yelp',
				'type'              => 'text'
			),
			array(
				'id'				=> 'pinterest',
				'title'      	 	=> '<span class="lcx-ico-pinterest"></span> - Pinterest',
				'placeholder'       => 'Pinterest',
				'type'              => 'text'
			),
			array(
				'id'				=> 'foursquare',
				'title'      	 	=> '<span class="lcx-ico-foursquare"></span> - Foursquare',
				'placeholder'       => 'Foursquare',
				'type'              => 'text'
			),
			array(
				'id'				=> 'linkedin',
				'title'      	 	=> '<span class="lcx-ico-linkedin"></span> - LinkedIn',
				'placeholder'       => 'LinkedIn',
				'type'              => 'text'
			),
			array(
				'id'				=> 'skype',
				'title'      	 	=> '<span class="lcx-ico-skype"></span> - Skype',
				'placeholder'       => 'Skype',
				'type'              => 'text'
			),
			array(
				'id'				=> 'medium',
				'title'      	 	=> '<span class="lcx-ico-medium"></span> - Medium',
				'placeholder'       => 'Medium',
				'type'              => 'text'
			),
			array(
				'id'				=> 'viadeo',
				'title'      	 	=> '<span class="lcx-ico-viadeo"></span> - Viadeo',
				'placeholder'       => 'Viadeo',
				'type'              => 'text'
			),
			array(
				'id'				=> 'youtube',
				'title'      	 	=> '<span class="lcx-ico-youtube"></span> - YouTube',
				'placeholder'       => 'YouTube',
				'type'              => 'text'
			),
			array(
				'id'				=> 'vimeo',
				'title'      	 	=> '<span class="lcx-ico-vimeo"></span> - Vimeo',
				'placeholder'       => 'Vimeo',
				'type'              => 'text'
			),
			array(
				'id'				=> 'dailymotion',
				'title'      	 	=> '<span class="lcx-ico-dailymotion"></span> - Dailymotion',
				'placeholder'       => 'Dailymotion',
				'type'              => 'text'
			),
			array(
				'id'				=> 'vine',
				'title'      	 	=> '<span class="lcx-ico-vine"></span> - Vine',
				'placeholder'       => 'Vine',
				'type'              => 'text'
			),
			array(
				'id'				=> 'flickr',
				'title'      	 	=> '<span class="lcx-ico-flickr"></span> - Flickr',
				'placeholder'       => 'Flickr',
				'type'              => 'text'
			),
			array(
				'id'				=> 'periscope',
				'title'      	 	=> '<span class="lcx-ico-periscope"></span> - Periscope',
				'placeholder'       => 'Periscope',
				'type'              => 'text'
			),
			array(
				'id'				=> 'etsy',
				'title'      	 	=> '<span class="lcx-ico-etsy"></span> - Etsy',
				'placeholder'       => 'Etsy',
				'type'              => 'text'
			),
			array(
				'id'				=> 'wordpress',
				'title'      	 	=> '<span class="lcx-ico-wordpress"></span> - WordPress',
				'placeholder'       => 'WordPress',
				'type'              => 'text'
			),
			array(
				'id'				=> 'envato',
				'title'      	 	=> '<span class="lcx-ico-envato"></span> - Envato',
				'placeholder'       => 'Envato (i.e. https://themeforest.net/user/screets)',
				'type'              => 'text'
			),
			array(
				'id'				=> 'amazon',
				'title'      	 	=> '<span class="lcx-ico-amazon"></span> - Amazon',
				'placeholder'       => 'Amazon',
				'type'              => 'text'
			),
			array(
				'id'				=> 'ebay',
				'title'      	 	=> '<span class="lcx-ico-ebay"></span> - eBay',
				'placeholder'       => 'eBay',
				'type'              => 'text'
			),
			array(
				'id'				=> 'meetup',
				'title'      	 	=> '<span class="lcx-ico-meetup"></span> - Meetup',
				'placeholder'       => 'Meetup',
				'type'              => 'text'
			),
			array(
				'id'				=> 'header_social_game',
				'title'				=> '<h3>Game</h3>',
				'default'       	=> '',
				'type'              => 'custom'
			),
			array(
				'id'				=> 'twitch',
				'title'      	 	=> '<span class="lcx-ico-twitch"></span> - Twitch',
				'placeholder'       => 'Twitch',
				'type'              => 'text'
			),
			array(
				'id'				=> 'battlenet',
				'title'      	 	=> '<span class="lcx-ico-battlenet"></span> - Battle.net',
				'placeholder'       => 'Battle.net',
				'type'              => 'text'
			),
		)
	);*/

	// Design -> Colors
	$opts['sections'][] = array(
		'tab_id' => 'design',
		'section_id' => 'colors',
		'section_title' => __( 'Colors', 'lcx' ),
		'section_order' => 10,
		'fields' => array(
			array(
				'id' => 'primary',
				'title' => __( 'Primary color', 'lcx' ),
				'std' => '#ea3c3b',
				'placeholder' => '#ea3c3b',
				'type' => 'color'
			),
			array(
				'id' => 'secondary',
				'title' => __( 'Secondary color', 'lcx' ),
				'std' => '#7e8bfe',
				'placeholder' => '#7e8bfe',
				'type' => 'color'
			),
			array(
				'id' => 'highlight',
				'title' => __( 'Highlight color', 'lcx' ),
				'std' => '#fffc79',
				'placeholder' => '#fffc79',
				'type' => 'color'
			),
		)
	);

	// Design -> Appearance
	$opts['sections'][] = array(
		'tab_id' => 'design',
		'section_id' => 'ui',
		'section_title' => __( 'Appearance', 'lcx' ),
		'section_order' => 20,
		'fields' => array(
			array(
				'id' => 'position',
				'title' => __( 'Widget position', 'lcx' ) . ' (px)',
				'std' => 'bottom-right',
				'choices' => array(
					'bottom-left' => __( 'Bottom Left', 'lcx' ),
					'bottom-right' => __( 'Bottom Right', 'lcx' )
				),
				'type' => 'select'
			),
			array(
				'id' => 'starter_width',
				'title' => __( 'Starter width', 'lcx' ),
				'desc' => __( 'Desktop view', 'lcx' ) . ' (px)',
				'std' => 160,
				'atts' => array(
					'min' => 32,
					'max' => 500
				),
				'type' => 'number'
			),
			array(
				'id' => 'starter_width_mobile',
				'title' => '',
				'desc' => __( 'Mobile view', 'lcx' ) . ' (px)',
				'std' => 50,
				'atts' => array(
					'min' => 20,
					'max' => 500
				),
				'type' => 'number'
			),
			array(
				'id' => 'starter_height',
				'title' => __( 'Starter height', 'lcx' ) . ' (px)',
				'std' => 30,
				'atts' => array(
					'min' => 20,
					'max' => 100
				),
				'type' => 'number'
			),
			array(
				'id' => 'popup_width',
				'title' => __( 'Popup width', 'lcx' ) . ' (px)',
				'std' => 300,
				'atts' => array(
					'min' => 100,
					'max' => 500
				),
				'type' => 'number'
			),
			array(
				'id' => 'popup_height_default',
				'title' => __( 'Popup heights', 'lcx' ),
				'desc' => __( 'Default', 'lcx' ) . ' (px)',
				'std' => 380,
				'atts' => array(
					'min' => 100,
					'max' => 500
				),
				'type' => 'number'
			),
			array(
				'id' => 'popup_height_online',
				'title' => '',
				'desc' => __( 'Online chat', 'lcx' ) . ' (px)',
				'std' => 420,
				'atts' => array(
					'min' => 100,
					'max' => 500
				),
				'type' => 'number'
			),
			array(
				'id' => 'radius',
				'title' => __( 'Radius', 'lcx' ) . ' (px)',
				'desc' => __( 'Normal', 'lcx' ),
				'std' => 4,
				'atts' => array(
					'min' => 0,
					'max' => 20
				),
				'type' => 'number'
			),
			array(
				'id' => 'radius_big',
				'title' => '',
				'desc' => __( 'Big', 'lcx' ),
				'std' => 8,
				'atts' => array(
					'min' => 0,
					'max' => 20
				),
				'type' => 'number'
			),
			array(
				'id' => 'offset',
				'title' => __( 'Offset', 'lcx' ) . ' (px)',
				'desc' => __( 'Sets the distance between the page corner and the chat widget', 'lcx' ),
				'std' => 30,
				'atts' => array(
					'min' => 0,
					'max' => 60
				),
				'type' => 'number'
			),
		)
	);

	// Users -> Operator Capabilities
	$opts['sections'][] = array(
		'tab_id' => 'users',
		'section_id' => 'ops',
		'section_title' => __( 'Operators', 'lcx' ),
		'section_order' => 10,
		'fields' => array(
			array(
				'id' => 'caps',
				'title' => __( 'User capabilities', 'lcx' ),
				'default' => __fn_lcx_render_caps(),
				'type' => 'custom'
			),
		)
	);

	// Messages -> Intro
	$opts['sections'][] = array(
		'tab_id' => 'msgs',
		'section_id' => 'intro',
		'section_title' => '',
		'section_order' => 10,
		'fields' => array()
	);

	// Messages -> Chat button
	$opts['sections'][] = array(
		'tab_id' => 'msgs',
		'section_id' => 'btn',
		'section_title' => __( 'Chat button', 'lcx' ),
		'section_order' => 20,
		'fields' => array(
			array(
				'id' => 'title',
				'title' => __( 'Title', 'lcx' ),
				'std' => 'Chat with us',
				'placeholder' => 'Chat with us',
				'type' => 'text'
			)
		)
	);

	// Messages -> Operators
	$opts['sections'][] = array(
		'tab_id' => 'msgs',
		'section_id' => 'ops',
		'section_title' => file_get_contents( LCX_URL. '/assets/icons/admin/chatbox-working.svg' ) . ' &nbsp;' . __( 'Operators', 'lcx' ),
		'section_order' => 40,
		'fields' => array(
			array(
				'id' => 'online_welc_single',
				'title' => __( 'Online status', 'lcx' ) . '<p class="description">' . __( 'The plugin gets latest online operators list on page load. That\'s why it uses past tense.', 'lcx' ) . '</p>',
				'desc' => __( 'Single operator', 'lcx' ) . '. (' .__( 'Example preview', 'lcx' ) . ': Tom was online recently)',
				'std' => '%s was online recently.',
				'placeholder' => '%s was online recently.',
				'type' => 'text'
			),
			array(
				'id' => 'online_welc_multi',
				'title' => '',
				'desc' => __( 'Multiple operators', 'lcx' ) . '. (' .__( 'Example preview', 'lcx' ) . ': Tom, Diva and Joe were online recently)',
				'std' => '%s1 and %s2 were online recently.',
				'placeholder' => '%s1 and %s2 were online recently.',
				'type' => 'text'
			),
		)
	);

	// Messages -> Chat popup
	$opts['sections'][] = array(
		'tab_id' => 'msgs',
		'section_id' => 'popup',
		'section_title' => __( 'Chat popup', 'lcx' ),
		'section_order' => 50,
		'fields' => array(
			/*array(
				'id' => 'header_popup',
				'title' => __( 'Popup header', 'lcx' ),
				'std' => '{site_name} Support',
				'placeholder' => '{site_name} Support',
				'type' => 'text'
			),*/
			array(
				'id' => 'prechat_greeting_new',
				'title' => __( 'Greetings', 'lcx' ) . ' 📣',
				'desc' => '<strong>' . __( 'Pre-chat', 'lcx' ) . '</strong> (' . __( 'New visitors', 'lcx' ) . ') <br><small>' . __( 'Custom variables', 'lcx' ) . ': {siteName}</small>',
				'std' => 'Welcome to {siteName} Support! Start a chat session now and ask us anything!',
				'placeholder' => 'Welcome to {siteName} Support! Start a chat session now and ask us anything!',
				'type' => 'textarea'
			),
			array(
				'id' => 'prechat_greeting_returning',
				'title' => '',
				'desc' => '<strong>' . __( 'Pre-chat', 'lcx' ) . '</strong> (' . __( 'Returning visitors who has started chat before', 'lcx' ) . ') <br><small>' . __( 'Custom variables', 'lcx' ) . ': {siteName}</small>',
				'std' => 'Feel free to start a <strong>new conversation</strong>! We will be happy to assist you.',
				'placeholder' => 'Feel free to start a <strong>new conversation</strong>! We will be happy to assist you.',
				'type' => 'textarea'
			),
			array(
				'id' => 'pending_greeting',
				'title' => '',
				'desc' => __( 'In chat', 'lcx' ) . ' (' .__( 'When the visitor is pending an operator to accept chat.', 'lcx' ) . ') <br><small>' . __( 'Custom variables', 'lcx' ) . ': {time}</small>',
				'std' => 'An advisor will be with you in {time}.',
				'placeholder' => 'An advisor will be with you in {time}.',
				'type' => 'textarea'
			),
			array(
				'id' => 'inchat_greeting',
				'title' => '',
				'desc' => __( 'In chat', 'lcx' ) . ' (' .__( 'When the visitor is talking with an operator.', 'lcx' ) . ') <br><small>' .__( 'Custom variables', 'lcx' ) . ': {operatorName}</small>',
				'std' => 'Now you are talking with {operatorName}.',
				'placeholder' => 'Now you are talking with {operatorName}.',
				'type' => 'textarea'
			),
			array(
				'id' => 'welcome_msg',
				'title' => __( 'Welcome message', 'lcx' ) . '<br><p class="description">' . __( 'This message is sent for the first conversation of visitors automatically.', 'lcx' ) .'</p>',
				'desc' => '<small>' .__( 'Custom variables', 'lcx' ) . ': {operatorName}</small>',
				'std' => "Hi, my name is {operatorName}. It'll be just a moment while I review the comments you provided. Can you please provide your name so I can address you properly?",
				'placeholder' => "Hi, my name is {operatorName}. It'll be just a moment while I review the comments you provided. Can you please provide your name so I can address you properly?",
				'type' => 'textarea'
			),
			array(
				'id' => 'closing_msg',
				'title' => __( 'Closing message', 'lcx' ) . '<br><p class="description">' . __( 'Operators might choose to send this message while ending a chat.', 'lcx' ) . '</p>',
				'std' => 'Thank you for contacting us today. Now that the conversation ended, you will receive the chat transcript in your email shortly. Have a nice day 😌',
				'placeholder' => 'Thank you for contacting us today. Now that the conversation ended, you will receive the chat transcript in your email shortly. Have a nice day 😌',
				'type' => 'textarea'
			),

			array(
				'id' => 'ask_contact',
				'title' => __( 'Ask contact info after starting chat', 'lcx' ),
				'std' => 'Get notified when we send you messages.',
				'placeholder' => 'Get notified when we send you messages.',
				'type' => 'textarea'
			),

			array(
				'id' => 'ask_contact_ntf_1',
				'title' => __( 'Chat messages after user provides contact info', 'lcx' ),
				'desc' => 'First message. <br><small>' . __( 'Custom variables', 'lcx' ) . ': {time}</small>',
				'std' => 'Awesome! We usually reply in {time}...',
				'placeholder' => 'Awesome! We usually reply in {time}...',
				'type' => 'textarea'
			),

			array(
				'id' => 'ask_contact_ntf_2',
				'title' => '',
				'desc' => 'Second message. <br><small>' . __( 'Custom variables', 'lcx' ) . ': {time}</small>',
				'placeholder' => 'p.s. Don\'t worry about missing our reply – if you\'re not here, we\'ll send it to your email.',
				'std' => 'p.s. Don\'t worry about missing our reply – if you\'re not here, we\'ll send it to your email.',
				'type' => 'textarea'
			),
			array(
				'id' => 'replies_in',
				'title' => __( 'Response time', 'lcx' ),
				'desc' => '<small>' .__( 'Custom variables', 'lcx' ) . ': {time}</small>',
				'std' => 'Typically replies in {time}.',
				'placeholder' => 'Typically replies in {time}.',
				'type' => 'textarea'
			),
			array(
				'id' => 'case_no',
				'title' => __( 'Case No.', 'lcx' ),
				'desc' => '<small>' . __( 'Custom variables', 'lcx' ) . ': {caseNo}</small>',
				'std' => 'Your case number is {caseNo}.',
				'placeholder' => 'Your case number is {caseNo}.',
				'type' => 'textarea'
			),
			array(
				'id' => 'chatStatus_init',
				'title' => __( 'Chat statuses', 'lcx' ),
				'desc' => 'Pending',
				'std' => 'Pending',
				'placeholder' => 'Pending',
				'type' => 'text'
			),
			array(
				'id' => 'chatStatus_open',
				'title' => '',
				'desc' => 'In chat',
				'std' => 'In chat',
				'placeholder' => 'In chat',
				'type' => 'text'
			),
			array(
				'id' => 'chatStatus_close',
				'title' => '',
				'desc' => 'Closed',
				'std' => 'Closed',
				'placeholder' => 'Closed',
				'type' => 'text'
			),
			array(
				'id' => 'chatStatusMsgs_close',
				'title' => __( 'Chat status messages', 'lcx' ),
				'desc' => __( 'Closed chat', 'lcx' ),
				'std' => 'This chat has ended.',
				'placeholder' => 'This chat has ended.',
				'type' => 'text'
			),
			/*array(
				'id' => 'transfer_info',
				'title' => __( 'Transferring info', 'lcx' ),
				'std' => 'I\'m going to introduce you to {operatorName} who will be better able to answer your question!',
				'placeholder' => 'I\'m going to introduce you to {operatorName} who will be better able to answer your question!',
				'type' => 'textarea'
			),*/
			/*array(
				'id' => 'offline_note',
				'title' => __( 'Offline note', 'lcx' ),
				'std' => 'Feel free to keep update conversation.',
				'placeholder' => 'Feel free to keep update conversation.',
				'type' => 'textarea'
			),*/
		)
	);

	// Messages -> Notifications
	$opts['sections'][] = array(
		'tab_id' => 'msgs',
		'section_id' => 'ntf',
		'section_title' => __( 'Notifications', 'lcx' ),
		'section_order' => 60,
		'fields' => array(
			array(
				'id' => 'newMsg_wtitle',
				'title' => __( 'Window title', 'lcx' ),
				'std' => '%s replied your message...',
				'desc' => __( 'It appears on visitor\'s window title when operator replies.', 'lcx' ),
				'placeholder' => '%s replied your message...',
				'type' => 'text'
			),
			array(
				'id' => 'conn',
				'title' => __( 'Connection', 'lcx' ),
				'std' => 'Connecting...',
				'placeholder' => 'Connecting...',
				'type' => 'text'
			),
			array(
				'id' => 'reconn',
				'title' => '',
				'std' => 'Reconnecting. Please wait...',
				'placeholder' => 'Reconnecting. Please wait...',
				'type' => 'text'
			),
			array(
				'id' => 'no_conn',
				'title' => '',
				'std' => 'No internet connection!',
				'placeholder' => 'No internet connection!',
				'type' => 'text'
			),
			array(
				'id' => 'reqFields',
				'title' => __( 'Forms', 'lcx' ),
				'std' => 'Please fill out all required fields!',
				'placeholder' => 'Please fill out all required fields!',
				'type' => 'text'
			),
			array(
				'id' => 'invEmail',
				'title' => '',
				'std' => 'Email is invalid!',
				'placeholder' => 'Email is invalid!',
				'type' => 'text'
			),
			array(
				'id' => 'you',
				'title' => __( 'Others', 'lcx' ),
				'std' => 'You',
				'placeholder' => 'You',
				'type' => 'text'
			),
		)
	);

	// Messages -> Email
	$opts['sections'][] = array(
		'tab_id' => 'msgs',
		'section_id' => 'email',
		'section_title' => __( 'Emails', 'lcx' ),
		'section_order' => 70,
		'fields' => array(
			array(
				'id' => 'notify_visitor_subject',
				'title' => __( 'Notify visitor email', 'lcx' ),
				'desc' => __( 'Subject', 'lcx' ),
				'std' => '%s replied your message.',
				'placeholder' => '%s replied your message.',
				'type' => 'text'
			),
			array(
				'id' => 'notify_visitor_title',
				'title' => '',
				'std' => '%s replied',
				'placeholder' => '%s replied',
				'type' => 'text'
			),
			array(
				'id' => 'chat_logs_subject',
				'title' => __( 'Chat logs email', 'lcx' ),
				'desc' => __( 'Subject', 'lcx' ) .'<br><small>' .__( 'Custom variables', 'lcx' ) . ': {caseNo} {siteName}</small>',
				'std' => '[{siteName}] Your chat transcript - {caseNo}.',
				'placeholder' => '[{siteName}] Your chat transcript - {caseNo}.',
				'type' => 'text'
			),
		)
	);

	// Messages -> Forms
	$opts['sections'][] = array(
		'tab_id' => 'msgs',
		'section_id' => 'forms',
		'section_title' => __( 'Forms', 'lcx' ),
		'section_order' => 80,
		'fields' => array(
			array(
				'id' => 'name',
				'title' => __( 'Name field', 'lcx' ),
				'std' => 'Your name',
				'placeholder' => 'Your name',
				'type' => 'text'
			),
			array(
				'id' => 'email',
				'title' => __( 'Email field', 'lcx' ),
				'std' => 'Your email',
				'placeholder' => 'Your email',
				'type' => 'text'
			),
			array(
				'id' => 'phone',
				'title' => __( 'Phone field', 'lcx' ),
				'std' => 'Phone number',
				'placeholder' => 'Phone number',
				'type' => 'text'
			),
			array(
				'id' => 'reply',
				'title' => __( 'Reply box placeholder', 'lcx' ),
				'std' => 'Type your message',
				'placeholder' => 'Type your message',
				'type' => 'text'
			),
			array(
				'id' => 'subs_footnote',
				'title' => __( 'Subscription footnote', 'lcx' ),
				'std' => 'No spam. It is only for notifications.',
				'placeholder' => 'No spam. It is only for notifications.',
				'type' => 'text'
			),
			array(
				'id' => 'ask_question',
				'title' => __( 'Ask question', 'lcx' ),
				'std' => 'Please describe your issue...',
				'placeholder' => 'Please describe your issue...',
				'type' => 'text'
			),
			array(
				'id' => 'save_btn',
				'title' => __( 'Save button', 'lcx' ),
				'std' => 'Save',
				'placeholder' => 'Save',
				'type' => 'text'
			),
			array(
				'id' => 'send_btn',
				'title' => __( 'Send button', 'lcx' ),
				'std' => 'Send',
				'placeholder' => 'Send',
				'type' => 'text'
			),
			array(
				'id' => 'start_chat_btn',
				'title' => __( 'Start chat button', 'lcx' ),
				'std' => 'Start chat',
				'placeholder' => 'Start chat',
				'type' => 'text'
			),
		)
	);

	// Messages -> Others
	$opts['sections'][] = array(
		'tab_id' => 'msgs',
		'section_id' => 'others',
		'section_title' => __( 'Others', 'lcx' ),
		'section_order' => 100,
		'fields' => array(
			array(
				'id' => 'cnv',
				'title' => 'Conversations',
				'std' => 'Conversations',
				'placeholder' => 'Conversations',
				'type' => 'text'
			),
			array(
				'id' => 'new_cnv',
				'title' => 'New conversation',
				'std' => 'New conversation',
				'placeholder' => 'New conversation',
				'type' => 'text'
			),
			array(
				'id' => 'chat_logs',
				'title' => 'Chat logs',
				'std' => 'Chat logs',
				'placeholder' => 'Chat logs',
				'type' => 'text'
			),
			array(
				'id' => 'case_no',
				'title' => 'Case no.',
				'std' => 'Case no.',
				'placeholder' => 'Case no.',
				'type' => 'text'
			),
		)
	);

	// Messages -> Date & Time
	$opts['sections'][] = array(
		'tab_id' => 'msgs',
		'section_id' => 'date',
		'section_title' => __( 'Date &amp; Time', 'lcx' ),
		'section_order' => 110,
		'fields' => array(
			array(
				'id' => 'prefix',
				'title' => __( 'Time ago strings', 'lcx' ),
				'desc' => 'Prefix (' . __( 'Optional', 'lcx' ) . ')',
				'std' => '',
				'placeholder' => '',
				'type' => 'text'
			),
			array(
				'id' => 'suffix',
				'title' => '',
				'desc' => 'Suffix (' . __( 'Optional', 'lcx' ) . ')',
				'std' => ' ago',
				'placeholder' => ' ago',
				'type' => 'text'
			),
			array(
				'id' => 'seconds',
				'title' => '',
				'std' => 'Just now',
				'desc' => 'Just now',
				'placeholder' => 'Just now',
				'type' => 'text'
			),
			array(
				'id' => 'minute',
				'title' => '',
				'desc' => 'About a minute',
				'std' => 'About a minute',
				'placeholder' => 'About a minute',
				'type' => 'text'
			),
			array(
				'id' => 'minutes',
				'title' => '',
				'desc' => '%d minutes',
				'std' => '%d minutes',
				'placeholder' => '%d minutes',
				'type' => 'text'
			),
			array(
				'id' => 'hour',
				'title' => '',
				'desc' => 'about an hour',
				'std' => 'about an hour',
				'placeholder' => 'about an hour',
				'type' => 'text'
			),
			array(
				'id' => 'hours',
				'title' => '',
				'desc' => '%d hours',
				'std' => '%d hours',
				'placeholder' => '%d hours',
				'type' => 'text'
			),
			array(
				'id' => 'day',
				'title' => '',
				'desc' => 'a day',
				'std' => 'a day',
				'placeholder' => 'a day',
				'type' => 'text'
			),
			array(
				'id' => 'days',
				'title' => '',
				'desc' => '%d days',
				'std' => '%d days',
				'placeholder' => '%d days',
				'type' => 'text'
			),
			array(
				'id' => 'month',
				'title' => '',
				'desc' => 'about a month',
				'std' => 'about a month',
				'placeholder' => 'about a month',
				'type' => 'text'
			),
			array(
				'id' => 'months',
				'title' => '',
				'desc' => '%d months',
				'std' => '%d months',
				'placeholder' => '%d months',
				'type' => 'text'
			),
			array(
				'id' => 'year',
				'title' => '',
				'desc' => 'about a year',
				'std' => 'about a year',
				'placeholder' => 'about a year',
				'type' => 'text'
			),
			array(
				'id' => 'years',
				'title' => '',
				'desc' => '%d years',
				'std' => '%d years',
				'placeholder' => '%d years',
				'type' => 'text'
			),
		)
	);

	// Messages -> Response Time
	$opts['sections'][] = array(
		'tab_id' => 'msgs',
		'section_id' => 'response_time',
		'section_title' => __( 'Response Time', 'lcx' ),
		'section_order' => 120,
		'fields' => array(
			array(
				'id' => 'aFewMins',
				'title' => __( 'Typically replies within...', 'lcx' ),
				'std' => 'a few minutes',
				'placeholder' => 'a few minutes',
				'type' => 'text'
			),
			array(
				'id' => 'in15min',
				'title' => '',
				'std' => '15 minutes',
				'placeholder' => '15 minutes',
				'type' => 'text'
			),
			array(
				'id' => 'in30min',
				'title' => '',
				'std' => '30 minutes',
				'placeholder' => '30 minutes',
				'type' => 'text'
			),
			array(
				'id' => 'in1hour',
				'title' => '',
				'std' => 'an hour',
				'placeholder' => 'an hour',
				'type' => 'text'
			),
			array(
				'id' => 'inFewHours',
				'title' => '',
				'std' => 'a few hour',
				'placeholder' => 'a few hour',
				'type' => 'text'
			),
			array(
				'id' => 'inDay',
				'title' => '',
				'std' => 'a day',
				'placeholder' => 'a day',
				'type' => 'text'
			),
			array(
				'id' => '1BDay',
				'title' => '',
				'std' => '1 business day',
				'placeholder' => '1 business day',
				'type' => 'text'
			),
			array(
				'id' => '2BDay',
				'title' => '',
				'std' => '2 business days',
				'placeholder' => '2 business days',
				'type' => 'text'
			),
			array(
				'id' => '3BDay',
				'title' => '',
				'std' => '3 business days',
				'placeholder' => '3 business days',
				'type' => 'text'
			),
		)
	);

	// Real-time -> Database
	/*$opts['sections'][] = array(
		'tab_id' => 'realtime',
		'section_id' => 'db',
		'section_title' => '',
		'section_order' => 10,
		'fields' => array(
			array(
				'id' => 'platform',
				'title' => __( 'Real-time database', 'lcx' ),
				'std' => 'firebase',
				'choices' => array(
					'firebase' => 'Firebase'
				),
				'type' => 'select'
			)
		)
	);*/

	// Real-time -> Firebase
	$opts['sections'][] = array(
		'tab_id' => 'realtime',
		'section_id' => 'firebase',
		'section_title' => 'Firebase',
		'section_description' => '<table style="width:100%;"><tr><td style="width:100%; font-size: 15px; line-height: 1.4em; padding-right: 30px" valign="top"><ol style="margin:0 0 30px 15px;">
						<li>' . sprintf( 'Create new <a href="%s" target="_blank">Firebase</a> project', 'https://console.firebase.google.com' ) . '</li>
						<li>Click <span class="dashicons dashicons-admin-generic"></span> and select <strong>Project Settings</strong></li>
						<li>Change "Public-facing name" as "Screets Live Chat" (optional, but its useful for later.)</li> 
						<li>Find <strong>Project ID</strong> and <strong>Web API key</strong> and copy/paste to related fields on this page below.</li>
						<li>Go to "Service accounts" tab.</li>
						<li>Click "Generate New Private key" button and download JSON file.</li>
						<li>Open downloaded JSON file and copy/paste the content into <strong>Private Key</strong> field on this page below.</li>
						<li>Go to Authentication > Sign-in Methods tab.</li>
						<li>Enable:
							<ul style="margin: 5px 0 10px 15px; list-style-type: disc; list-style-position: inside;">
								<li>Email/Password</li>
								<li>Anonymous</li>
								<li>Google</li>
							</ul>
						</li>
						<li>Find <strong>Authorized domains</strong>  on the same page and add <code class="lcx-red">' . $domain . '</code>.</li>
						<li>Now go to Chat Console and click <strong>Sign-in</strong> to complete installation ✔️. LC might ask you to login your Google account to update security rules and required data.</li>
					</ol></td><td valign="top"><iframe width="390" height="219" src="https://www.youtube.com/embed/xLopjuX-U4w?rel=0&amp;showinfo=0" frameborder="0" gesture="media" allow="encrypted-media" allowfullscreen></iframe><p><a href="https://youtu.be/xLopjuX-U4w" target="_blank">View video</a> <span class="dashicons dashicons-external"></span></p><div class="lcx-ntf lcx-warn">For some reason, if you ever want to stop using this plugin or do a <strong>fresh authorization</strong>, you can revoke access by visiting: <a href="https://security.google.com/settings/security/permissions" target="_blank">your Google account settings</a>.</div></td></tr></table>
					',
		'section_order' => 20,
		'fields' => array(
			array(
				'id' => 'email',
				'title' => 'Your Google Email <span class="lcx-req">*</span>',
				'desc' => __( 'Which email do you use to login your Firebase account?', 'lcx' ),
				'placeholder' => '',
				'type' => 'text'
			),
			array(
				'id' => 'projectId',
				'title' => 'Project ID <span class="lcx-req">*</span>',
				'placeholder' => 'i.e. my-project-3-4d23a',
				'type' => 'text'
			),
			array(
				'id' => 'apiKey',
				'title' => 'Web API Key <span class="lcx-req">*</span>',
				'placeholder' => 'xxxxxxxxxxxxxxxxxxxxxxx-xxxxxxxxxxxxxxx',
				'type' => 'text'
			),
			array(
				'id' => 'private_key',
				'title' => 'Private Key <span class="lcx-req">*</span>',
				'class' => 'is-full',
				'desc' => 'To find your Private Key: <br>
						* Go to <a href="https://console.firebase.google.com/project/_/settings/serviceaccounts/adminsdk" target="_blank">Service Accounts</a><br> 
						* Click <strong>Generate New Private Key</strong><br>
						* Open JSON file you downloaded in any text editor <br>
						* Copy/paste the content of file to "Private Key" field above.',
				'placeholder' => '',
				'type' => 'textarea'
			)
		)
	);

	// Advanced -> Server info
	$opts['sections'][] = array(
		'tab_id' => 'advanced',
		'section_id' => 'server',
		'section_title' => 'Server Info',
		'section_order' => 10,
		'fields' => array(
			array(
				'id' => '_phpinfo',
				'title' => 'PHP version',
				'default' => phpversion(),
				'type' => 'custom'
			),
			array(
				'id' => '_mysqlinfo',
				'title' => 'MySQL version',
				'default' => $wpdb->get_var( 'select version()' ),
				'type' => 'custom'
			),
			array(
				'id' => '_upldirinfo',
				'title' => 'Upload dir',
				'default' => fn_lcx_get_upload_dir_var( 'baseurl', '/lcx' ),
				'type' => 'custom'
			),
		)
	);

	// Advanced -> Security
	$opts['sections'][] = array(
		'tab_id' => 'advanced',
		'section_id' => 'secure',
		'section_title' => 'Security',
		'section_order' => 20,
		'fields' => array(
			array(
				'id' => 'dev_mode',
				'title' => 'Developer Mode',
				'placeholder' => 'Developer Mode',
				'desc' => 'Active <p class="description">Uses original JS/CSS files instead of compiled ones.</p>',
				'type' => 'checkbox'
			),
			array(
				'id' => 'proxy',
				'title' => 'Reverse proxy IPs',
				'placeholder' => 'Reverse proxy IPs',
				'desc' => 'If your server is behind a reverse proxy, you must whitelist the proxy IP addresses from which WordPress should trust the HTTP_X_FORWARDED_FOR header in order to properly identify the visitor\'s IP address. Comma-delimited, e.g. \'10.0.1.200,10.0.1.201\'',
				'type' => 'text'
			),
		)
	);

	return $opts;
}

/**
 * Render capabilities
 */
function __fn_lcx_render_caps() {
	$output = '';
	$lcx_caps = fn_lcx_get_capabilities();

	if ( ! function_exists( 'get_editable_roles' ) ) {
	    require_once ABSPATH . 'wp-admin/includes/user.php';
	}
	$roles = get_editable_roles();

	foreach( $roles as $role_name => $role ) {
		$output .= '<strong>' . $role['name'] . '</strong><ul>';

		$i=0;
		foreach( $lcx_caps as $cap => $cap_name ) {
			$checked = ( array_key_exists( $cap, $role['capabilities'] ) );
			$field_id = 'lcx_role_'.$role_name . '_' . $cap;
			$disabled = ( $role_name == 'administrator' && $cap == 'lcx_admin' ) ? 'disabled':'';

			$output .= '<li>'
							.'<label for="'.$field_id.'">'
					 		.'<input type="checkbox" name="op_caps['.$role_name.'][]" id="' . $field_id . '" ' . checked( true, $checked, 0 ) . ' value="'.$cap.'" ' . $disabled . '> '. $cap_name
					 		.'</label> <small style="display:inline-block; background: #efefef; border-radius:2px; color: #999; padding:2px 5px; margin-left: 5px;">' . $cap . '</small>'
					 . '</li>';

			$i++;
		}

		$output .= '</ul>';
	}
	return $output;
}