<?php
/**
 * SCREETS © 2018
 *
 * SCREETS, d.o.o. Sarajevo. All rights reserved.
 * This  is  commercial  software,  only  users  who have purchased a valid
 * license  and  accept  to the terms of the  License Agreement can install
 * and use this program.
 *
 * @package LiveChatX
 * @author Screets
 *
 */

if ( ! defined( 'ABSPATH' ) ) { exit; }

/**
 * Get embedding JavaScript code.
 *
 * @since Live Chat X (2.4.0)
 * @return string
 */
function fn_lcx_get_snippet( $crossDomain, $opts = null )
{	
	$opts_json = '';
	$siteurl = get_site_url();

	$apiDefaults = array(
		'root' => esc_url_raw( rest_url() ),
		'v' => LCX_API_VERSION,
		'js' => apply_filters( 'lcx_skin_loader_js', esc_url_raw( LCX_URL . '/assets/js/loader.min.js' ) )
	);

	if( !$crossDomain ) {
		$apiDefaults['nonce'] = wp_create_nonce( 'wp_rest' );
	}

	$apiOpts = json_encode( $apiDefaults );

	if( isset( $opts ) ) {
		$opts_json = 'var lcxOpts = ' . json_encode( $opts ) . ";\n";
	}

	$js = <<<EOT
var lcxAPI = $apiOpts;
(function() {
	var d = document;
	window.addEventListener( "load", function() {
		var b = d.createElement("script");
		b.src = lcxAPI.js;
		b.async = !0;
		d.head.appendChild(b);
	}, !1);
})();
EOT;

	$js = str_replace( 
		array( "\n","\t", ' = ' ),	
		array( '', '', '=' ), 
		$js
	);
	
	return "<script>$opts_json $js </script>\n";
	
}