<?php
/**
 * SCREETS © 2018
 *
 * SCREETS, d.o.o. Sarajevo. All rights reserved.
 * This  is  commercial  software,  only  users  who have purchased a valid
 * license  and  accept  to the terms of the  License Agreement can install
 * and use this program.
 *
 * @package LiveChatX
 * @author Screets
 *
 */
 
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * LiveChatX_Install Class.
 */
class LiveChatX_Install {

	/**
	 * Hook in tabs.
	 */
	public static function init() {
		add_action( 'init', array( __CLASS__, 'check_version' ), 100 );
	}


	/**
	 * Check the plugin version and run the updater if it is required.
	 *
	 */
	public static function check_version() {

		$current = get_option( 'lcx_version' );

		// -1: downgrade, 0: nothing, 1: update, 2: new install
		$compare = ( empty( $current ) ) ? 2 : version_compare( LCX_VERSION, $current );
		
		if ( ! defined( 'IFRAME_REQUEST' ) && $compare > 0 ) {
			self::install( $compare );
			do_action( 'lcx_updated' );
		}

	}

	/**
	 * Install and update the plugin.
	 */
	public static function install( $compare ) {
		global $wpdb;

		if ( ! defined( 'LCX_INSTALLING' ) ) {
			define( 'LCX_INSTALLING', true );
		}

		$app = new LiveChatX_App();
		$app->register_post_types();
		$app->register_taxonomies();

		// Create database tables
		// self::create_tables();

		// Update options
		self::update_options();

		// Setup the plugin basics
		self::setup();

		// Compile application CSS file
		fn_lcx_compile_app_css();

		// Queue upgrades/setup wizard
		$current_version = get_option( 'lcx_version', null );

		// Update the plugin version
		self::update_version();

		// Flush rules after install
		flush_rewrite_rules();

		// Trigger action
		do_action( 'lcx_installed' );

	}

	/**
	 * Setup the plugin.
	 */
	private static function setup() {

		// Remove old roles
		remove_role( 'cx_op' );

		// Get roles
		$admin_role = get_role( 'administrator' );

		// Add capabilities to administrators
		$admin_role->add_cap( 'lcx_admin' );
		$admin_role->add_cap( 'lcx_chat_with_visitors' );
		
		// Insert default widget pages
		/*if( !term_exists( 'contact', 'lcx_page' ) ) {
			$id = wp_insert_term( 
				'Contact Form', 
				'lcx_page', 
				array( 'slug' => 'contact' )
			);
		}*/
	}

	/**
	 * Update the plugin version to the current one.
	 */
	private static function update_version() {
		delete_option( 'lcx_version' );
		add_option( 'lcx_version', LCX_VERSION );
	}
	
	/**
	 * Create/update options.
	 */
	private static function update_options() {

		$defaults = _fn_lcx_options_data( array() );
		$opts = get_option( LCX_SLUG . '_options' );

		$data = array();
		foreach( $defaults['sections'] as $section ) {

			if( !empty( $section['fields'] ) ) {
				foreach( $section['fields'] as $field ) {
					$name = $section['tab_id'] . '_' . $section['section_id'] . '_';

					if( isset( $field['id'] ) ) {
						$name .= $field['id'];

						$std = ( isset( $field['std'] ) ) ? $field['std'] : '';

						// Set default if there is no current value
						$data[$name] = ( !empty( $opts[$name] ) ) ? $opts[$name] : $std;
					}
				}
			}
		}

		// Update option
		update_option( LCX_SLUG . '_options', $data );

	}

	/**
	 * Set up the database tables which the plugin needs to function.
	 */
	private static function create_tables() {
		global $wpdb;

		$wpdb->hide_errors();

		require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

		dbDelta( self::get_schema() );

	}

	/**
	 * Get database table schema.
	 */
	private static function get_schema() {
		global $wpdb;

		$collate = '';

		if ( $wpdb->has_cap( 'collation' ) ) {
			if ( ! empty( $wpdb->charset ) ) {
				$collate .= "DEFAULT CHARACTER SET $wpdb->charset";
			}
			if ( ! empty( $wpdb->collate ) ) {
				$collate .= " COLLATE $wpdb->collate";
			}
		}
		return "
";
	}

}

LiveChatX_Install::init();