/**
 * Live Chat X, by Screets.
 *
 * SCREETS, d.o.o. Sarajevo. All rights reserved.
 * This  is  commercial  software,  only  users  who have purchased a valid
 * license  and  accept  to the terms of the  License Agreement can install
 * and use this program.
 */

'use strict';

const lcxReq = function( url, cb ) {
	const xhr = new XMLHttpRequest();

	xhr.open( 'POST', url );
	xhr.setRequestHeader( 'Content-Type', 'application/x-www-form-urlencoded' );
	xhr.responseType = 'json';

	// Include WP nonce for logged in users
	if( lcxAPI.nonce ) {
		xhr.setRequestHeader( 'X-WP-Nonce', lcxAPI.nonce );
	}

	xhr.onload = function() {
		if (xhr.status === 200 ) {
			cb( null, xhr.response );
		}
		else if (xhr.status !== 200) {
			cb( xhr.status );
		}
	};
	xhr.send();
};

lcxReq( lcxAPI.root + 'screetslcx/v' + lcxAPI.v + '/widget/render', function( err, data ) {

	if( err !== null ) {
		console.error(err);
		
	} else {

		if( !data ) return;

		let obj, total, link;

		// Load scripts
		if( data.js ) {
			total = data.js.length;
			for( let i=0; i<total; i++ ) {
				obj = document.createElement( 'script' );
				obj.src = data.js[i];
				obj.async = false;
				document.head.appendChild( obj );

				if( i+1 === total ) { // last file
					obj.addEventListener( 'load', function() {
						lcxInit( data );
					});
				}
			}
		}

		// Load CSS files
		if( data.css ) {
			total = data.css.length;
			const head  = document.getElementsByTagName( 'head' )[0];

			for( let i=0; i<total; i++ ) {
				link = document.createElement( 'link' );
				link.rel  = 'stylesheet';
				link.type = 'text/css';
				link.href = data.css[i];
				link.media = 'all';
				head.appendChild( link );
			}
		}
	}
});

const lcxInit = function( data ) {
	// Create widget object
	var widget = document.createElement( 'div' );
	widget.id = 'lcx-widget';
	widget.className = 'lcx lcx-widget';
	document.body.appendChild( widget );

	// Create an iframe
	var iframe = document.createElement( 'iframe' );
	iframe.setAttribute( 'allowfullscreen', '' );
	document.getElementById( 'lcx-widget' ).appendChild( iframe );

	// Get iframe content
	var iframeBody = iframe.contentWindow.document;
	iframeBody.open();
	iframeBody.write( data.html );
	iframeBody.close();

	let opts = data.opts;

	// Merge options with global ones
	if( typeof lcxOpts !== 'undefined' ) {
		for( const k in lcxOpts ) {
			opts[k] = lcxOpts[k]; 
		}
	}

	// Add iframe as an option
	opts._iframe = iframe;

	// Run application
	const app = new lcxFrontend( opts );
};