<?php
if ( ! defined( 'ABSPATH' ) ) {
    die( 'Page not found' );
}

$table = $wpdb->prefix . 'lhf_logs';

if ( isset( $_GET['delete-id'] ) ) {
    $id = (int) sanitize_text_field( $_GET['delete-id'] );

    $wpdb->delete( $table, [ 'id' => $id ], [ '%d' ] );
}

if ( isset( $_GET['delete-all'] ) ) {
    $wpdb->query( "TRUNCATE TABLE `$table`" );
}
?>

<h3><?php echo esc_html__( 'Logs', 'lighthouse' ); ?></h3>

<p>
    <a href="<?php echo admin_url( 'admin.php?page=lighthouse-firewall&tab=logs' ); ?>&delete-all" class="button button-secondary"><?php echo __( 'Delete All Logs', 'lighthouse' ); ?></a>
</p>

<table id="dt-basic" class="stripe hover order-column row-border" cellspacing="0" width="100%">
    <thead>
        <tr>
            <th><?php echo __( 'IP Address', 'lighthouse' ); ?></th>
            <th><?php echo __( 'Type', 'lighthouse' ); ?></th>
            <th><?php echo __( 'Date', 'lighthouse' ); ?></th>
            <th><?php echo __( 'Browser', 'lighthouse' ); ?></th>
            <th><?php echo __( 'OS', 'lighthouse' ); ?></th>
            <th><?php echo __( 'Country', 'lighthouse' ); ?></th>
        </tr>
    </thead>
    <tbody>
        <?php
        $query = $wpdb->get_results( "SELECT id, ip, date, time, browser, os, country, type FROM `$table` ORDER BY id DESC" );

        foreach ( $query as $row ) {
            $icons = [
                'SQLi'    => 'fas fa-code',
                'default' => 'fas fa-user-secret',
            ];

            $icon_class = isset( $icons[ $row->type ] ) ? $icons[ $row->type ] : $icons['default'];

            echo '<tr>
                <td>
                    <a href="' . esc_url( add_query_arg( 'id', $row->id, admin_url( 'admin.php?page=lighthouse-firewall&tab=log' ) ) ) . '"><code>' . esc_html( $row->ip ) . '</code></a>
                </td>
                <td><i class="' . esc_attr( $icon_class ) . '"></i> ' . esc_html( $row->type ) . '</td>
                <td data-sort="' . esc_html( $row->date ) . ', ' . $row->time . '">' . $row->date . ', ' . $row->time . '</td>
                <td>' . esc_html( $row->browser ) . '</td>
                <td>' . esc_html( $row->os ) . '</td>
                <td>' . esc_html( $row->country ) . '</td>
            </tr>';
        }
        ?>
    </tbody>
</table>
