<?php
if ( ! defined( 'ABSPATH' ) ) {
    die( 'Page not found' );
}

$table = $wpdb->prefix . 'lhf_loginhistory';

// Fetch all relevant data in a single query
$query = $wpdb->get_results(
    "SELECT lh.id, lh.username, lh.ip, lh.date, lh.time, lh.successful, u.ID as user_id, u.user_login, u.display_name
    FROM `$table` lh
    LEFT JOIN `{$wpdb->users}` u ON lh.username COLLATE utf8mb4_unicode_ci = u.user_login COLLATE utf8mb4_unicode_ci
    ORDER BY lh.date DESC"
);
?>

<h2><?php echo __( 'Login History', 'lighthouse' ); ?></h2>

<form method="post">
    <table id="dt-basic" class="stripe hover order-column row-border" cellspacing="0" width="100%">
        <thead>
            <tr>
                <th><?php echo __( 'Username', 'lighthouse' ); ?></th>
                <th><?php echo __( 'IP Address', 'lighthouse' ); ?></th>
                <th><?php echo __( 'Date', 'lighthouse' ); ?></th>
                <th><?php echo __( 'Time', 'lighthouse' ); ?></th>
                <th><?php echo __( 'Login Status', 'lighthouse' ); ?></th>
            </tr>
        </thead>
        <tbody>

        <?php
        foreach ( $query as $row ) {
            $profile_link = '#';
            $user_roles   = 'n/a';

            if ( ! empty( $row->user_id ) ) {
                $profile_link = get_edit_user_link( $row->user_id );
                $user         = get_userdata( $row->user_id );

                $user_roles = ( $user && ! empty( $user->roles ) )
                    ? implode(
                        ', ',
                        array_map(
                            function ( $role ) {
                                return ucfirst( esc_html( $role ) ); },
                            $user->roles
                        )
                    )
                    : 'n/a';
            }

            echo '<tr>
                <td><a href="' . esc_url( $profile_link ) . '">' . esc_html( $row->username ) . '</a> (' . $user_roles . ')</td>
                <td><code>' . $row->ip . '</code></td>
                <td data-order="' . strtotime( $row->date ) . '">' . esc_html( $row->date ) . '</td>
                <td>' . esc_html( $row->time ) . '</td>
                <td>';

                echo ( (int) $row->successful === 1 ) ? esc_html__( 'Success', 'lighthouse' ) : esc_html__( 'Fail', 'lighthouse' );

                echo '</td>
            </tr>';
        }
        ?>
        </tbody>
    </table>
</form>
