if (!HTMLScriptElement.supports || !HTMLScriptElement.supports('speculationrules')) {
    const preloadedUrls = {};

    function pointerenterHandler() {
        if (!preloadedUrls[this.href]) {
            preloadedUrls[this.href] = true;

            const prefetcher = document.createElement('link');

            prefetcher.as = prefetcher.relList.supports('prefetch') ? 'document' : 'fetch';
            prefetcher.rel = prefetcher.relList.supports('prefetch') ? 'prefetch' : 'preload';
            prefetcher.href = this.href;

            document.head.appendChild(prefetcher);
        }
    }

    document.querySelectorAll('a[href^="/"]').forEach(item => {
        item.addEventListener('pointerenter', pointerenterHandler);
    });
}
