<?php 
namespace ProApp\filters ;
use App\baseClasses\KCBase; 
use App\models\KCClinic;
use App\models\KCDoctorClinicMapping;
use App\models\KCReceptionistClinicMapping;
use App\models\KCClinicSession;
use WP_User;

class KCProMultiClinicFilters extends KCBase {

    public function __construct() {
        global $wpdb;
        $this->db = $wpdb;
        add_filter('kcpro_save_clinic', [$this, 'saveClinicData']);
        add_filter('kcpro_edit_clinic', [$this, 'editClinicData']);
        add_filter('kcpro_get_all_clinic', [$this, 'getClinicList']);
        add_filter('kcpro_get_clinic_data', [$this, 'getClinicData']);
    }
    public function saveClinicData($data) {

        $rules = [
            'name' => 'required',
            'email' => 'required',
            'telephone_no' => 'required',
        ];

        $errors = kcValidateRequest($rules, $data['clinicData']);

        $rules=[
            'first_name' => 'required',
            'last_name'   => 'required',
            'user_email' => 'required',
            'mobile_number' => 'required',
            'gender' => 'required',
        ];

        $errors = kcValidateRequest($rules, $data['clinicAdminData']);
    
        if (count($errors)) {

            echo json_encode([
                'status' => false,
                'message' => esc_html__($errors[0], 'kiviCare-clinic-&-patient-management-system-pro')
            ]);
            die;

        }


        if(!empty($data['id'])) {
            global $wpdb;
            $count = $wpdb->get_var('select * from '.$wpdb->base_prefix.'users where id='.(int)$data['id'].' and user_email="'.$data['clinicAdminData']['user_email'].'"');
            
            if(!empty($count)){
                return [
                    'status' => false,
                    'message' => esc_html__('Clinic admin email is already exist.', 'kiviCare-clinic-&-patient-management-system-pro')
                ]; 
                die;
            }
        }else{
            if(email_exists($data['clinicAdminData']['user_email'])) {
                return [
                    'status' => false,
                    'message' => esc_html__('Clinic admin email is already exist.', 'kiviCare-clinic-&-patient-management-system-pro')
                ]; die;
            }
        }
         
        $clinic = new KCClinic;

        if (empty($data['id'])) {

            $data['clinicData']['created_at'] = current_time('Y-m-d H:i:s');
            $status = $clinic->insert($data['clinicData']);

        }else{
            
            if(is_string($data['clinicData']['profile_image']) || !is_int($data['clinicData']['profile_image']) || $data['clinicData']['profile_image'] === false) { 
                unset($data['clinicData']['profile_image']);
            }
            $status = $clinic->update($data['clinicData'], array( 'id' => (int)$data['id'] ));
        }

        

        if (!empty($data['clinicData']['id'])) {
            $clinic_id = (int)$data['clinicData']['id'];
        } else {
            $clinic_id = $status;
        }

        
        if (empty( $data['clinicAdminData']['ID']) && empty($data['id'])) {

            $data['clinicAdminData']['username'] = kcGenerateUsername( $data['clinicAdminData']['first_name']) ;
            $data['clinicAdminData']['user_pass'] = kcGenerateString(12);
            $user = wp_create_user( $data['clinicAdminData']['username'],  $data['clinicAdminData']['user_pass'],  $data['clinicAdminData']['user_email']);
            $u    = new WP_User( $user );
            $u->display_name =  $data['clinicAdminData']['first_name'] . ' ' .   $data['clinicAdminData']['last_name'];
            $u->set_role($this->getClinicAdminRole());
            wp_insert_user($u);
            if(!empty($user)) {
                $new_temp = [
                    'clinic_admin_id' => $user,
                    'created_at'=> current_time('Y-m-d H:i:s')
                ];
                $clinic->update($new_temp,array( 'id' => (int)$clinic_id ));
                $user_email_param =  kcCommonNotificationUserData($u->ID,$data['clinicAdminData']['user_pass']);
                kcSendEmail($user_email_param);
                if(kcCheckSmsOptionEnable()){
                    $sms = apply_filters('kcpro_send_sms', [
                        'type' => 'clinic_admin_registration',
                        'user_data' => $user_email_param,
                    ]);
                }
            }
            update_user_meta( $user, 'first_name', $data['clinicAdminData']['first_name'] );
            update_user_meta( $user, 'last_name', $data['clinicAdminData']['last_name'] );
            update_user_meta( $user, 'basic_data', json_encode( $data['clinicAdminData'] ) );

            if(is_int($data['clinicAdminData']['profile_image']) && $data['clinicAdminData']['profile_image'] !== false) {
                update_user_meta( (int)$u->ID, 'clinic_admin_profile_image', $data['clinicAdminData']['profile_image'] );
            }

        }
        else 
        {

            $clinicData  = $clinic->get_by(['id' => (int)$data['id']], '=',true);
            $clinicAdmin = WP_User::get_data_by('ID', (int)$clinicData->clinic_admin_id);

            wp_update_user(
                array(
                    'ID'         => (int)$clinicAdmin->ID,
                    'user_email' => $data['clinicAdminData']['user_email'],
                    'display_name' =>  $data['clinicAdminData']['first_name'] . ' ' . $data['clinicAdminData']['last_name']
                )
            );

            update_user_meta( (int)$clinicAdmin->ID, 'first_name', $data['clinicAdminData']['first_name'] );
            update_user_meta( (int)$clinicAdmin->ID, 'last_name', $data['clinicAdminData']['last_name'] );
            update_user_meta( (int)$clinicAdmin->ID, 'basic_data', json_encode( $data['clinicAdminData'] ) );

            if(is_int($data['clinicAdminData']['profile_image']) && $data['clinicAdminData']['profile_image'] !== false) {
                update_user_meta( (int)$clinicAdmin->ID, 'clinic_admin_profile_image', $data['clinicAdminData']['profile_image'] );
            }

            $status = 1 ;
        }

        if ($status) {
            return [
                'status' => true,
                'message' => esc_html__('Clinic has been saved successfully', 'kiviCare-clinic-&-patient-management-system-pro')
            ];
        } else {
            return [
                'status' => false,
                'message' => esc_html__('Clinic has not been saved successfully', 'kiviCare-clinic-&-patient-management-system-pro')
            ];
        }
    }
    public function editClinicData($data) {

        $id = (int)$data['clinic_id'];

        $clinic = new KCClinic;
        
        if($this->getLoginUserRole() == 'kiviCare_clinic_admin'){
            $clinicadmin = $clinic->get_by(['clinic_admin_id' => get_current_user_id()], '=',true);
            $results = $clinic->get_by(['id' => (int)$clinicadmin->id], '=',true);
        }else{
            $results = $clinic->get_by(['id' => (int)$id], '=',true);
        }

        if( !empty($results->clinic_admin_id) ){
            $clinicAdmin = WP_User::get_data_by('ID', (int)$results->clinic_admin_id);
            $fname = get_user_meta( (int)$clinicAdmin->ID, 'first_name' );
            $lname=get_user_meta( (int)$clinicAdmin->ID, 'last_name');
            $basic_data = get_user_meta( (int)$clinicAdmin->ID, 'basic_data',true );
            $basic_data = json_decode($basic_data);
        }

        if ($results) {

            $results->specialties = json_decode($results->specialties);
            $extra = json_decode($results->extra);
            $results->currency_prefix = $extra->currency_prefix;
            $results->currency_postfix = $extra->currency_postfix;
            // $decimal_point=json_decode( stripslashes($extra->decimal_point));
            // $results->decimal_point = [
            //     'id'=>$decimal_point->id,
            //     'label'=>$decimal_point->label
            // ];
            $results->first_name = $fname[0];
            $results->last_name = $lname[0];
            $results->user_email = $basic_data->user_email;
            $results->mobile_number = $basic_data->mobile_number;
            $results->dob =$basic_data->dob;
            $results->gender =$basic_data->gender;
            $results->clinic_profile = wp_get_attachment_url($results->profile_image);
            $results->profile_image = wp_get_attachment_url(get_user_meta((int)$results->clinic_admin_id, 'clinic_admin_profile_image', true));
            $doctor_mapping = (new KCDoctorClinicMapping())->get_by([ 'clinic_id' => (int)$results->id]);
            $doctors = [];

            if (count($doctor_mapping)) {
                $inactive_doctors = [] ;
                foreach ($doctor_mapping as $key => $doctor) {
                    if((int) $doctor->doctor_id !== 0 ) {

                        $doctor_ids[$key] = $doctor->doctor_id;

                        $doctor = WP_User::get_data_by('ID', (int)$doctor->doctor_id);

                        if((int)$doctor->user_status === 0) {

                            $user_data  = get_user_meta( (int)$doctor->ID, 'basic_data', true );
                            $user_data = json_decode($user_data);

                            $specialties = collect($user_data->specialties)->pluck('label')->toArray();

                            $temp = [
                                'id' => $doctor->ID,
                                'label' => $doctor->display_name ."(". implode( ',',$specialties).")"
                            ];

                            $temp['timeSlot'] = isset($user_data->time_slot) ? $user_data->time_slot : "";

                            array_push($doctors, $temp);
                        } else {
                            array_push($inactive_doctors, $doctor->ID);
                        }
                    }
                }

            }

            if(count($doctors) > 0) {
                $results->doctors = $doctors;
            } else {
                $results->clinic_sessions = [];
                echo json_encode([
                    'status' => true,
                    'message' => esc_html__('Clinic data', 'kiviCare-clinic-&-patient-management-system-pro'),
                    'data' => $results
                ]);
                wp_die();
            }

            $user = new WP_User( get_current_user_id() );

            if ($user->roles[0] === 'administrator' ) {
                $clinic_sessions = (new KCClinicSession())->get_all();
            } else {
                $clinic_sessions = (new KCClinicSession())->get_by([ 'clinic_id' => (int)$results->id]);
            }

          
            $clinic_sessions = collect($clinic_sessions);

            $clinic_sessions = $clinic_sessions->map(function ($session) {
                $session->day = substr($session->day, 0, 3);
                return  $session ;
            });

            $sessions = [];

            if (count($clinic_sessions)) {
                foreach ($clinic_sessions as $session) {
                    if(!in_array($session->doctor_id, $inactive_doctors)) {
                        if ($session->parent_id === null || $session->parent_id === "" ) {
                        $days = [];
                        $session_doctors = [];
                        $sec_start_time = "";
                        $sec_end_time = "";

                        array_push($days, substr($session->day, 0, 3));

                        $all_clinic_sessions  = collect($clinic_sessions);

                        $child_session = $all_clinic_sessions->where('parent_id', (int)$session->id);

                        $child_session->all();

                        if(count($child_session) > 0) {

                            foreach ($clinic_sessions as $child_session) {

                                if ($child_session->parent_id !== null && (int) $session->id === (int) $child_session->parent_id) {

                                    array_push($session_doctors, $child_session->doctor_id);
                                    array_push($days, substr($child_session->day, 0, 3));

                                    if ($session->start_time !== $child_session->start_time || $session->start_time == $session->end_time) {
                                        $sec_start_time = $child_session->start_time;
                                        $sec_end_time = $child_session->end_time;
                                    }

                                }

                            }

                        } else {

                            array_push($session_doctors, $session->doctor_id);
                            array_push($days, substr($session->day, 0, 3));

                        }

                            if($session->start_time == $session->end_time){
                                $start_time = ['',''];
                            }else{

                                $start_time = explode(":",date('H:i',strtotime($session->start_time)));
                            }

                            if($session->start_time == $session->end_time){

                                $end_time = ['',''];

                            }else{

                                $end_time = explode(":",date('H:i',strtotime($session->end_time)));
                            }

                        $session_doctors = array_unique($session_doctors);

                        if (count($session_doctors) === 0 && count($days) === 0) {
                            $session_doctors[] = $session->doctor_id;
                            $days[] = substr($session->day, 0, 3);
                        } else {
                            $sec_start_time = $sec_start_time !== "" ? explode(":",date('H:i',strtotime($sec_start_time))) : "";
                            $sec_end_time = $sec_end_time !== "" ?explode(":",date('H:i',strtotime($sec_end_time))) : "";
                        }

                        $new_doctors = [];

                        foreach ($session_doctors as $doctor_id) {
                            foreach ($doctors as $doctor) {
                                if ((int) $doctor['id'] === (int) $doctor_id) {
                                    $new_doctors = $doctor;
                                }
                            }
                        }

                        $new_session = [
                            'id' => $session->id,
                            'clinic_id' => $session->clinic_id,
                            'doctor_id' => $session->doctor_id,
                            'days' => array_values(array_unique($days)),
                            'doctors' => $new_doctors,
                            'time_slot' => $session->time_slot,
                            's_one_start_time' => [
                                "HH" => $start_time[0],
                                "mm" => $start_time[1],
                            ],
                            's_one_end_time' => [
                                "HH" => $end_time[0],
                                "mm" => $end_time[1],
                            ],
                            's_two_start_time' => [
                                "HH" => isset($sec_start_time[0]) ? $sec_start_time[0] : "",
                                "mm" => isset($sec_start_time[1]) ? $sec_start_time[1] : "",
                            ],
                            's_two_end_time' => [
                                "HH" => isset($sec_end_time[0]) ? $sec_end_time[0] : "",
                                "mm" => isset($sec_end_time[1]) ? $sec_end_time[1] : "",
                            ],
                            'clinic_name' => $this->db->get_var("SELECT name FROM {$this->db->prefix}kc_clinics WHERE id={$session->clinic_id}")
                        ];

                        array_push($sessions, $new_session);

                    }
                    }
                }
            }

            $results->clinic_sessions = $sessions;
       

        } else {
            
            // multiclinic session condition
            $doctor_mapping = (new KCDoctorClinicMapping())->get_all();

            $doctors = [];

            if (count($doctor_mapping)) {
                $inactive_doctors = [] ;
                foreach ($doctor_mapping as $key => $doctor) {
                    if((int) $doctor->doctor_id !== 0 ) {

                        $doctor_ids[$key] = $doctor->doctor_id;

                        $doctor = WP_User::get_data_by('ID', (int)$doctor->doctor_id);

                        if((int)$doctor->user_status === 0) {

                            $user_data  = get_user_meta( (int)$doctor->ID, 'basic_data', true );
                            $user_data = json_decode($user_data);

                            $specialties = collect($user_data->specialties)->pluck('label')->toArray();

                            $temp = [
                                'id' => $doctor->ID,
                                'label' => $doctor->display_name ."(". implode( ',',$specialties).")"
                            ];

                            $temp['timeSlot'] = isset($user_data->time_slot) ? $user_data->time_slot : "";

                            array_push($doctors, $temp);
                        } else {
                            array_push($inactive_doctors, $doctor->ID);
                        }
                    }
                }
            }
           
            $newvar = new \stdClass();
            $newvar->doctors = $doctors;
            $user_id = get_current_user_id();

            $user = new WP_User( get_current_user_id() );
            
            switch ($this->getLoginUserRole()) {
                case 'kiviCare_doctor':
                    $clinic_sessions = (new KCClinicSession())->get_by(['doctor_id' => (int)$user_id]);
                    break;
                case 'administrator':
                    $clinic_sessions = (new KCClinicSession())->get_all();
                    break;
                case 'kiviCare_clinic_admin':
                    $clinic = (new KCClinic())->get_by([ 'clinic_admin_id' => (int)$user_id]);
					$clinic_id = $clinic[0]->id;
                    $clinic_sessions = (new KCClinicSession())->get_by([ 'clinic_id' => (int)$clinic_id]);
                    break;
                case 'kiviCare_receptionist':
                    $clinic_id =  (new KCReceptionistClinicMapping())->get_by([ 'receptionist_id' => (int)$user_id]);
					$clinic_id = $clinic_id[0]->clinic_id;
                    $clinic_sessions = (new KCClinicSession())->get_by([ 'clinic_id' => (int)$clinic_id]);
                    break;
                default:
                    $clinic_id = 1;
                    $clinic_sessions = (new KCClinicSession())->get_by([ 'clinic_id' => (int)$clinic_id]);
                    break;
            }

            $clinic_sessions = collect($clinic_sessions);

            $clinic_sessions = $clinic_sessions->map(function ($session) {
                $session->day = substr($session->day, 0, 3);
                return  $session ;
            });

            $sessions = [];

            if (count($clinic_sessions)) {
                foreach ($clinic_sessions as $session) {
                    $table_clinic = $this->db->prefix . 'kc_' . 'clinics';
                    $clinic = "SELECT name FROM {$table_clinic} WHERE id =". (int)$session->clinic_id;
                    $clinics = $this->db->get_results( $clinic);

                    if(!in_array($session->doctor_id, $inactive_doctors)) {
                        if ($session->parent_id === null || $session->parent_id === "" ) {
                        $days = [];
                        $session_doctors = [];
                        $sec_start_time = "";
                        $sec_end_time = "";

                        array_push($days, substr($session->day, 0, 3));

                        $all_clinic_sessions  = collect($clinic_sessions);

                        $child_session = $all_clinic_sessions->where('parent_id', (int)$session->id);

                        $child_session->all();

                        if(count($child_session) > 0) {

                            foreach ($clinic_sessions as $child_session) {

                                if ($child_session->parent_id !== null && (int) $session->id === (int) $child_session->parent_id) {

                                    array_push($session_doctors, $child_session->doctor_id);
                                    array_push($days, substr($child_session->day, 0, 3));

                                    if ($session->start_time !== $child_session->start_time || $session->start_time == $session->end_time ) {
                                        $sec_start_time = $child_session->start_time;
                                        $sec_end_time = $child_session->end_time;
                                    }

                                }

                            }

                        } else {

                            array_push($session_doctors, $session->doctor_id);
                            array_push($days, substr($session->day, 0, 3));

                        }

                        if($session->start_time == $session->end_time){
                            $start_time = ['',''];
                        }else{

                            $start_time = explode(":",date('H:i',strtotime($session->start_time)));
                        }

                        if($session->start_time == $session->end_time){

                            $end_time = ['',''];

                        }else{

                            $end_time = explode(":",date('H:i',strtotime($session->end_time)));
                        }

                        $session_doctors = array_unique($session_doctors);

                        if (count($session_doctors) === 0 && count($days) === 0) {
                            $session_doctors[] = $session->doctor_id;
                            $days[] = substr($session->day, 0, 3);
                        } else {
                            $sec_start_time = $sec_start_time !== "" ? explode(":",date('H:i',strtotime($sec_start_time))) : "";
                            $sec_end_time = $sec_end_time !== "" ?explode(":",date('H:i',strtotime($sec_end_time))) : "";
                        }

                        $new_doctors = [];

                        foreach ($session_doctors as $doctor_id) {
                            foreach ($doctors as $doctor) {
                                if ((int) $doctor['id'] === (int) $doctor_id) {
                                    $new_doctors = $doctor;
                                }
                            }
                        }

                        $new_session = [
                            'id' => $session->id,
                            'clinic_id' => [
                               'id'=> $session->clinic_id,
                               'label'=>$clinics[0]->name,
                            ],
                            'clinic_name'=>$clinics[0]->name,
                            'doctor_id' => $session->doctor_id,
                            'days' => array_values(array_unique($days)),
                            'doctors' => $new_doctors,
                            'time_slot' => $session->time_slot,
                            's_one_start_time' => [
                                "HH" => $start_time[0],
                                "mm" => $start_time[1],
                            ],
                            's_one_end_time' => [
                                "HH" => $end_time[0],
                                "mm" => $end_time[1],
                            ],
                            's_two_start_time' => [
                                "HH" => isset($sec_start_time[0]) ? $sec_start_time[0] : "",
                                "mm" => isset($sec_start_time[1]) ? $sec_start_time[1] : "",
                            ],
                            's_two_end_time' => [
                                "HH" => isset($sec_end_time[0]) ? $sec_end_time[0] : "",
                                "mm" => isset($sec_end_time[1]) ? $sec_end_time[1] : "",
                            ]
                        ];

                        array_push($sessions, $new_session);

                    }

                    }
                }
            }

            $newvar->clinic_sessions = $sessions;

            return [
                'status' => true,
                'message' => esc_html__('Clinic data', 'kiviCare-clinic-&-patient-management-system-pro'),
                'data' => $newvar
            ];
            die();

        }

        return [
            'status' => true,
            'message' => esc_html__('Clinic data', 'kiviCare-clinic-&-patient-management-system-pro'),
            'data' => $results
        ];

    }
    public function getClinicList($clinic){
        $data = [];
        $clinics_table           = $this->db->prefix . 'kc_' . 'clinics';
        $table = $this->db->prefix . 'kc_' . 'doctor_clinic_mappings';
        if($this->getLoginUserRole() === 'kiviCare_doctor'){
            $user_id = get_current_user_id();
            $query = "SELECT clinic_id AS id,(SELECT name FROM {$clinics_table} WHERE id= doctor.clinic_id ) as name FROM {$table} as `doctor` 
            WHERE doctor_id =". (int)$user_id;

        }else if($this->getLoginUserRole() === 'kiviCare_patient'){
            $patienttable =  $this->db->prefix . 'kc_' . 'patient_clinic_mappings';
            $user_id = get_current_user_id();
            $clinicCount = $this->db->get_row('select clinic_id from '.$patienttable.' where patient_id='.$user_id);
            if($clinicCount != null){
                $query = "SELECT clinic_id AS id,(SELECT name FROM {$clinics_table} WHERE id= patient.clinic_id ) as name FROM {$patienttable} as patient 
                WHERE patient_id =". (int)$user_id;
            }else{
                $query = "SELECT * FROM {$clinics_table} WHERE status='1'";
            }
        }else{
            $query = "SELECT * FROM {$clinics_table} WHERE status='1'";
        }
        $clinicList = collect( $this->db->get_results( $query, OBJECT ) )->toArray();
        foreach ($clinicList as $clinic) {
            $data[] = [
                'id'    => $clinic->id,
                'label' => $clinic->name
            ];
        }
        return [
            'data'=> $data,
            'status' =>true,
        ];
        
    }
    public function getClinicData($data){
        $clinic_condition = ' ';
        if(!empty($data['data']['props_clinic_id']) && !in_array($data['data']['props_clinic_id'],['0',0]) ){
            $clinic_condition = " AND id={$data['data']['props_clinic_id']} ";
        }
        $clinics_table           = $this->db->prefix . 'kc_' . 'clinics';
        $query = "SELECT * FROM {$clinics_table} WHERE status='1' {$clinic_condition}";
        $clinicList = collect( $this->db->get_results( $query, OBJECT ) );
        $results = [];
        foreach($clinicList as $key=> $clinic){
            $results[$key]['id'] = $clinic->id;
            $results[$key]['name'] = $clinic->name;
            $results[$key]['telephone_no'] = $clinic->telephone_no;
            $results[$key]['specialties'] = json_decode($clinic->specialties);
            $results[$key]['address'] = $clinic->address;
            $results[$key]['city'] = $clinic->city;
            $results[$key]['postal_code'] = $clinic->postal_code;
            $results[$key]['country'] = $clinic->country;
            $results[$key]['profile_image'] = wp_get_attachment_url($clinic->profile_image);
        }
        return [
            'data'=> $results,
            'status' =>true,
        ];
    }
    
}
