<?php

namespace ProApp\filters;

use function Clue\StreamFilter\fun;

class KCProRolePermissionFilters extends \App\baseClasses\KCBase{
    public $db;
    public function __construct() {
        global $wpdb;
        $this->db = $wpdb;
        add_filter('kcpro_get_all_permission', [$this, 'getAllPermission']);
        add_filter('kcpro_save_permission_list', [$this, 'savePermissionList']);

    }

    public function getAllPermission($data){
        $allRole = ['administrator',$this->getPatientRole(),
            $this->getDoctorRole(),
            $this->getReceptionistRole(),
            $this->getClinicAdminRole()];

        return [
            'data' => collect(get_editable_roles())->filter(function ($v,$key)use($allRole){
                return in_array($key,$allRole);
            })->map(function ($k){
                $k['capabilities'] = collect($k['capabilities'])->map(function ($j,$key){
                    return in_array($j,['1',1,'true',true]);
                })->sortKeys()->toArray();
                return $k;
            })->sortKeys(),
            'status' => true
        ];
    }

    public function savePermissionList($data){

        if(!empty($data['data']) && is_array($data['data']) && !empty($data['type']) && !empty(!empty($data['data'][$data['type']]['capabilities']))){
            $capabilities = $data['data'][$data['type']]['capabilities'];

            if(is_array($capabilities)){
                $subscriber = get_role($data['type']);
                if(!empty($subscriber)){
                    foreach($capabilities as $key => $cap){
                        if(!empty($key)){
                            $subscriber->remove_cap($key);
                            $subscriber->add_cap($key,in_array($cap,['1',1,true,'true']));
                        }
                    }
                    return [
                        'status' => true,
                        'message' => 'Permission update successfuly'
                    ];
                }

            }
        }
        return [
            'status' => false,
            'message' => 'Data not found'
        ];
    }
}