<?php

namespace ProApp\filters;

use App\baseClasses\KCBase;

class KCProDoctorReviewFilters extends KCBase{
    public $db;
    public function __construct() {
        global $wpdb;

        $this->db = $wpdb;

        add_filter('kcpro_calculate_doctor_review', [$this, 'calculateDoctorReview'],10,2);
        add_filter('kcpro_save_doctor_review', [$this, 'saveReview']);
        add_filter('kcpro_get_doctor_review', [$this, 'getReview']);
    }

    public function calculateDoctorReview($id,$type){
        $id = (int)$id;
        global $wpdb;
        $allReview = $wpdb->get_row("SELECT sum(review) as total_review,count(*) as count FROM {$wpdb->prefix}kc_patient_review WHERE doctor_id={$id}");
        $max = 0;
        if(!empty($allReview->count)){
            $max = $allReview->total_review / $allReview->count;
        }
        if($type === 'list'){
            return [
                "star" => $max,
                'total_rating' => !empty($allReview->count) ? $allReview->count : 0
            ];
        }
        if($max > 0){
            ob_start();
            ?>
            <i class="kivi-star" data-star="<?php echo esc_html($max); ?>"></i>
            <?php
            return [ 'star' => ob_get_clean()] ;
        }
        return [
            "star" => '',
            'total_rating' => 0
        ];
    }

    public function getReview($request_data){

        $doctor_id = (int)$request_data["doctor_id"];
        $patient_id = (int)$request_data["patient_id"];

        $allAppointments = $this->db->get_row("SELECT * FROM {$this->db->prefix}kc_patient_review WHERE  patient_id={$patient_id} and doctor_id={$doctor_id}");

        if(!empty($allAppointments)){
           return [
               'data' => $allAppointments,
               'status'  => true,
               'message' => __('Data Founded','kc-lang')
           ];
        }else{
            return [
                'data' => [],
                'status'  => false,
                'message' => __('Date Not Found','kc-lang')
            ];
        }
    }

    public function addNewReview($request_data){
        $this->db->insert($this->db->prefix.'kc_patient_review', array(
            'review' => $request_data['star'],
            'patient_id' => $request_data['patient_id'],
            'doctor_id' => $request_data['doctor_id'],
        ));
    }

    public function saveReview($request_data){

        if(empty($request_data["id"])){

            $this->addNewReview($request_data);

        }else{
            $id = (int)$request_data["id"];
            $this->db->update($this->db->prefix.'kc_patient_review',
                array(
                    'review'=>$request_data['star']
                ),
                array('id'=>$id));
        }

       return [
           'data' => [],
           'status'  => true,
           'message' => __('Thank you for your review','kc-lang')
       ];
    }
}